/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/result_set.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * Partial results from a streaming read or SQL query. Streaming reads and
 * SQL queries better tolerate large result sets, large rows, and large
 * values, but are a little trickier to consume.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.PartialResultSet}
 */
public final class PartialResultSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.PartialResultSet)
    PartialResultSetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartialResultSet.newBuilder() to construct.
  private PartialResultSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartialResultSet() {
    values_ = java.util.Collections.emptyList();
    resumeToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartialResultSet();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PartialResultSet(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.spanner.v1.ResultSetMetadata.Builder subBuilder = null;
              if (metadata_ != null) {
                subBuilder = metadata_.toBuilder();
              }
              metadata_ =
                  input.readMessage(
                      com.google.spanner.v1.ResultSetMetadata.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metadata_);
                metadata_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                values_ = new java.util.ArrayList<com.google.protobuf.Value>();
                mutable_bitField0_ |= 0x00000001;
              }
              values_.add(input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry));
              break;
            }
          case 24:
            {
              chunkedValue_ = input.readBool();
              break;
            }
          case 34:
            {
              resumeToken_ = input.readBytes();
              break;
            }
          case 42:
            {
              com.google.spanner.v1.ResultSetStats.Builder subBuilder = null;
              if (stats_ != null) {
                subBuilder = stats_.toBuilder();
              }
              stats_ =
                  input.readMessage(
                      com.google.spanner.v1.ResultSetStats.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(stats_);
                stats_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        values_ = java.util.Collections.unmodifiableList(values_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.ResultSetProto
        .internal_static_google_spanner_v1_PartialResultSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.ResultSetProto
        .internal_static_google_spanner_v1_PartialResultSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.PartialResultSet.class,
            com.google.spanner.v1.PartialResultSet.Builder.class);
  }

  public static final int METADATA_FIELD_NUMBER = 1;
  private com.google.spanner.v1.ResultSetMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Metadata about the result set, such as row type information.
   * Only present in the first response.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Metadata about the result set, such as row type information.
   * Only present in the first response.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetMetadata getMetadata() {
    return metadata_ == null
        ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata about the result set, such as row type information.
   * Only present in the first response.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetMetadataOrBuilder getMetadataOrBuilder() {
    return getMetadata();
  }

  public static final int VALUES_FIELD_NUMBER = 2;
  private java.util.List<com.google.protobuf.Value> values_;
  /**
   *
   *
   * <pre>
   * A streamed result set consists of a stream of values, which might
   * be split into many `PartialResultSet` messages to accommodate
   * large rows and/or large values. Every N complete values defines a
   * row, where N is equal to the number of entries in
   * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
   * Most values are encoded based on type as described
   * [here][google.spanner.v1.TypeCode].
   * It is possible that the last value in values is "chunked",
   * meaning that the rest of the value is sent in subsequent
   * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
   * field. Two or more chunked values can be merged to form a
   * complete value as follows:
   *   * `bool/number/null`: cannot be chunked
   *   * `string`: concatenate the strings
   *   * `list`: concatenate the lists. If the last element in a list is a
   *     `string`, `list`, or `object`, merge it with the first element in
   *     the next list by applying these rules recursively.
   *   * `object`: concatenate the (field name, field value) pairs. If a
   *     field name is duplicated, then apply these rules recursively
   *     to merge the field values.
   * Some examples of merging:
   *     # Strings are concatenated.
   *     "foo", "bar" =&gt; "foobar"
   *     # Lists of non-strings are concatenated.
   *     [2, 3], [4] =&gt; [2, 3, 4]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are strings.
   *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are lists. Recursively, the last and first elements
   *     # of the inner lists are merged because they are strings.
   *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
   *     # Non-overlapping object fields are combined.
   *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
   *     # Overlapping object fields are merged.
   *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
   *     # Examples of merging objects containing lists of strings.
   *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
   * For a more complete example, suppose a streaming SQL query is
   * yielding a result set whose rows contain a single string
   * field. The following `PartialResultSet`s might be yielded:
   *     {
   *       "metadata": { ... }
   *       "values": ["Hello", "W"]
   *       "chunked_value": true
   *       "resume_token": "Af65..."
   *     }
   *     {
   *       "values": ["orl"]
   *       "chunked_value": true
   *       "resume_token": "Bqp2..."
   *     }
   *     {
   *       "values": ["d"]
   *       "resume_token": "Zx1B..."
   *     }
   * This sequence of `PartialResultSet`s encodes two rows, one
   * containing the field value `"Hello"`, and a second containing the
   * field value `"World" = "W" + "orl" + "d"`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getValuesList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * A streamed result set consists of a stream of values, which might
   * be split into many `PartialResultSet` messages to accommodate
   * large rows and/or large values. Every N complete values defines a
   * row, where N is equal to the number of entries in
   * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
   * Most values are encoded based on type as described
   * [here][google.spanner.v1.TypeCode].
   * It is possible that the last value in values is "chunked",
   * meaning that the rest of the value is sent in subsequent
   * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
   * field. Two or more chunked values can be merged to form a
   * complete value as follows:
   *   * `bool/number/null`: cannot be chunked
   *   * `string`: concatenate the strings
   *   * `list`: concatenate the lists. If the last element in a list is a
   *     `string`, `list`, or `object`, merge it with the first element in
   *     the next list by applying these rules recursively.
   *   * `object`: concatenate the (field name, field value) pairs. If a
   *     field name is duplicated, then apply these rules recursively
   *     to merge the field values.
   * Some examples of merging:
   *     # Strings are concatenated.
   *     "foo", "bar" =&gt; "foobar"
   *     # Lists of non-strings are concatenated.
   *     [2, 3], [4] =&gt; [2, 3, 4]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are strings.
   *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are lists. Recursively, the last and first elements
   *     # of the inner lists are merged because they are strings.
   *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
   *     # Non-overlapping object fields are combined.
   *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
   *     # Overlapping object fields are merged.
   *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
   *     # Examples of merging objects containing lists of strings.
   *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
   * For a more complete example, suppose a streaming SQL query is
   * yielding a result set whose rows contain a single string
   * field. The following `PartialResultSet`s might be yielded:
   *     {
   *       "metadata": { ... }
   *       "values": ["Hello", "W"]
   *       "chunked_value": true
   *       "resume_token": "Af65..."
   *     }
   *     {
   *       "values": ["orl"]
   *       "chunked_value": true
   *       "resume_token": "Bqp2..."
   *     }
   *     {
   *       "values": ["d"]
   *       "resume_token": "Zx1B..."
   *     }
   * This sequence of `PartialResultSet`s encodes two rows, one
   * containing the field value `"Hello"`, and a second containing the
   * field value `"World" = "W" + "orl" + "d"`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder> getValuesOrBuilderList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * A streamed result set consists of a stream of values, which might
   * be split into many `PartialResultSet` messages to accommodate
   * large rows and/or large values. Every N complete values defines a
   * row, where N is equal to the number of entries in
   * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
   * Most values are encoded based on type as described
   * [here][google.spanner.v1.TypeCode].
   * It is possible that the last value in values is "chunked",
   * meaning that the rest of the value is sent in subsequent
   * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
   * field. Two or more chunked values can be merged to form a
   * complete value as follows:
   *   * `bool/number/null`: cannot be chunked
   *   * `string`: concatenate the strings
   *   * `list`: concatenate the lists. If the last element in a list is a
   *     `string`, `list`, or `object`, merge it with the first element in
   *     the next list by applying these rules recursively.
   *   * `object`: concatenate the (field name, field value) pairs. If a
   *     field name is duplicated, then apply these rules recursively
   *     to merge the field values.
   * Some examples of merging:
   *     # Strings are concatenated.
   *     "foo", "bar" =&gt; "foobar"
   *     # Lists of non-strings are concatenated.
   *     [2, 3], [4] =&gt; [2, 3, 4]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are strings.
   *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are lists. Recursively, the last and first elements
   *     # of the inner lists are merged because they are strings.
   *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
   *     # Non-overlapping object fields are combined.
   *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
   *     # Overlapping object fields are merged.
   *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
   *     # Examples of merging objects containing lists of strings.
   *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
   * For a more complete example, suppose a streaming SQL query is
   * yielding a result set whose rows contain a single string
   * field. The following `PartialResultSet`s might be yielded:
   *     {
   *       "metadata": { ... }
   *       "values": ["Hello", "W"]
   *       "chunked_value": true
   *       "resume_token": "Af65..."
   *     }
   *     {
   *       "values": ["orl"]
   *       "chunked_value": true
   *       "resume_token": "Bqp2..."
   *     }
   *     {
   *       "values": ["d"]
   *       "resume_token": "Zx1B..."
   *     }
   * This sequence of `PartialResultSet`s encodes two rows, one
   * containing the field value `"Hello"`, and a second containing the
   * field value `"World" = "W" + "orl" + "d"`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 2;</code>
   */
  @java.lang.Override
  public int getValuesCount() {
    return values_.size();
  }
  /**
   *
   *
   * <pre>
   * A streamed result set consists of a stream of values, which might
   * be split into many `PartialResultSet` messages to accommodate
   * large rows and/or large values. Every N complete values defines a
   * row, where N is equal to the number of entries in
   * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
   * Most values are encoded based on type as described
   * [here][google.spanner.v1.TypeCode].
   * It is possible that the last value in values is "chunked",
   * meaning that the rest of the value is sent in subsequent
   * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
   * field. Two or more chunked values can be merged to form a
   * complete value as follows:
   *   * `bool/number/null`: cannot be chunked
   *   * `string`: concatenate the strings
   *   * `list`: concatenate the lists. If the last element in a list is a
   *     `string`, `list`, or `object`, merge it with the first element in
   *     the next list by applying these rules recursively.
   *   * `object`: concatenate the (field name, field value) pairs. If a
   *     field name is duplicated, then apply these rules recursively
   *     to merge the field values.
   * Some examples of merging:
   *     # Strings are concatenated.
   *     "foo", "bar" =&gt; "foobar"
   *     # Lists of non-strings are concatenated.
   *     [2, 3], [4] =&gt; [2, 3, 4]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are strings.
   *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are lists. Recursively, the last and first elements
   *     # of the inner lists are merged because they are strings.
   *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
   *     # Non-overlapping object fields are combined.
   *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
   *     # Overlapping object fields are merged.
   *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
   *     # Examples of merging objects containing lists of strings.
   *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
   * For a more complete example, suppose a streaming SQL query is
   * yielding a result set whose rows contain a single string
   * field. The following `PartialResultSet`s might be yielded:
   *     {
   *       "metadata": { ... }
   *       "values": ["Hello", "W"]
   *       "chunked_value": true
   *       "resume_token": "Af65..."
   *     }
   *     {
   *       "values": ["orl"]
   *       "chunked_value": true
   *       "resume_token": "Bqp2..."
   *     }
   *     {
   *       "values": ["d"]
   *       "resume_token": "Zx1B..."
   *     }
   * This sequence of `PartialResultSet`s encodes two rows, one
   * containing the field value `"Hello"`, and a second containing the
   * field value `"World" = "W" + "orl" + "d"`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getValues(int index) {
    return values_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A streamed result set consists of a stream of values, which might
   * be split into many `PartialResultSet` messages to accommodate
   * large rows and/or large values. Every N complete values defines a
   * row, where N is equal to the number of entries in
   * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
   * Most values are encoded based on type as described
   * [here][google.spanner.v1.TypeCode].
   * It is possible that the last value in values is "chunked",
   * meaning that the rest of the value is sent in subsequent
   * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
   * field. Two or more chunked values can be merged to form a
   * complete value as follows:
   *   * `bool/number/null`: cannot be chunked
   *   * `string`: concatenate the strings
   *   * `list`: concatenate the lists. If the last element in a list is a
   *     `string`, `list`, or `object`, merge it with the first element in
   *     the next list by applying these rules recursively.
   *   * `object`: concatenate the (field name, field value) pairs. If a
   *     field name is duplicated, then apply these rules recursively
   *     to merge the field values.
   * Some examples of merging:
   *     # Strings are concatenated.
   *     "foo", "bar" =&gt; "foobar"
   *     # Lists of non-strings are concatenated.
   *     [2, 3], [4] =&gt; [2, 3, 4]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are strings.
   *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
   *     # Lists are concatenated, but the last and first elements are merged
   *     # because they are lists. Recursively, the last and first elements
   *     # of the inner lists are merged because they are strings.
   *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
   *     # Non-overlapping object fields are combined.
   *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
   *     # Overlapping object fields are merged.
   *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
   *     # Examples of merging objects containing lists of strings.
   *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
   * For a more complete example, suppose a streaming SQL query is
   * yielding a result set whose rows contain a single string
   * field. The following `PartialResultSet`s might be yielded:
   *     {
   *       "metadata": { ... }
   *       "values": ["Hello", "W"]
   *       "chunked_value": true
   *       "resume_token": "Af65..."
   *     }
   *     {
   *       "values": ["orl"]
   *       "chunked_value": true
   *       "resume_token": "Bqp2..."
   *     }
   *     {
   *       "values": ["d"]
   *       "resume_token": "Zx1B..."
   *     }
   * This sequence of `PartialResultSet`s encodes two rows, one
   * containing the field value `"Hello"`, and a second containing the
   * field value `"World" = "W" + "orl" + "d"`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Value values = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getValuesOrBuilder(int index) {
    return values_.get(index);
  }

  public static final int CHUNKED_VALUE_FIELD_NUMBER = 3;
  private boolean chunkedValue_;
  /**
   *
   *
   * <pre>
   * If true, then the final value in [values][google.spanner.v1.PartialResultSet.values] is chunked, and must
   * be combined with more values from subsequent `PartialResultSet`s
   * to obtain a complete field value.
   * </pre>
   *
   * <code>bool chunked_value = 3;</code>
   *
   * @return The chunkedValue.
   */
  @java.lang.Override
  public boolean getChunkedValue() {
    return chunkedValue_;
  }

  public static final int RESUME_TOKEN_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString resumeToken_;
  /**
   *
   *
   * <pre>
   * Streaming calls might be interrupted for a variety of reasons, such
   * as TCP connection loss. If this occurs, the stream of results can
   * be resumed by re-sending the original request and including
   * `resume_token`. Note that executing any other transaction in the
   * same session invalidates the token.
   * </pre>
   *
   * <code>bytes resume_token = 4;</code>
   *
   * @return The resumeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeToken() {
    return resumeToken_;
  }

  public static final int STATS_FIELD_NUMBER = 5;
  private com.google.spanner.v1.ResultSetStats stats_;
  /**
   *
   *
   * <pre>
   * Query plan and execution statistics for the statement that produced this
   * streaming result set. These can be requested by setting
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
   * only once with the last response in the stream.
   * This field will also be present in the last response for DML
   * statements.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
   *
   * @return Whether the stats field is set.
   */
  @java.lang.Override
  public boolean hasStats() {
    return stats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Query plan and execution statistics for the statement that produced this
   * streaming result set. These can be requested by setting
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
   * only once with the last response in the stream.
   * This field will also be present in the last response for DML
   * statements.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
   *
   * @return The stats.
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetStats getStats() {
    return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
  }
  /**
   *
   *
   * <pre>
   * Query plan and execution statistics for the statement that produced this
   * streaming result set. These can be requested by setting
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
   * only once with the last response in the stream.
   * This field will also be present in the last response for DML
   * statements.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetStatsOrBuilder getStatsOrBuilder() {
    return getStats();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (metadata_ != null) {
      output.writeMessage(1, getMetadata());
    }
    for (int i = 0; i < values_.size(); i++) {
      output.writeMessage(2, values_.get(i));
    }
    if (chunkedValue_ != false) {
      output.writeBool(3, chunkedValue_);
    }
    if (!resumeToken_.isEmpty()) {
      output.writeBytes(4, resumeToken_);
    }
    if (stats_ != null) {
      output.writeMessage(5, getStats());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
    }
    for (int i = 0; i < values_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, values_.get(i));
    }
    if (chunkedValue_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, chunkedValue_);
    }
    if (!resumeToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, resumeToken_);
    }
    if (stats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStats());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.PartialResultSet)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.PartialResultSet other = (com.google.spanner.v1.PartialResultSet) obj;

    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getValuesList().equals(other.getValuesList())) return false;
    if (getChunkedValue() != other.getChunkedValue()) return false;
    if (!getResumeToken().equals(other.getResumeToken())) return false;
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (getValuesCount() > 0) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getValuesList().hashCode();
    }
    hash = (37 * hash) + CHUNKED_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getChunkedValue());
    hash = (37 * hash) + RESUME_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getResumeToken().hashCode();
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.PartialResultSet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.PartialResultSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.PartialResultSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.PartialResultSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Partial results from a streaming read or SQL query. Streaming reads and
   * SQL queries better tolerate large result sets, large rows, and large
   * values, but are a little trickier to consume.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.PartialResultSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.PartialResultSet)
      com.google.spanner.v1.PartialResultSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ResultSetProto
          .internal_static_google_spanner_v1_PartialResultSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ResultSetProto
          .internal_static_google_spanner_v1_PartialResultSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.PartialResultSet.class,
              com.google.spanner.v1.PartialResultSet.Builder.class);
    }

    // Construct using com.google.spanner.v1.PartialResultSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getValuesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (metadataBuilder_ == null) {
        metadata_ = null;
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }
      if (valuesBuilder_ == null) {
        values_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        valuesBuilder_.clear();
      }
      chunkedValue_ = false;

      resumeToken_ = com.google.protobuf.ByteString.EMPTY;

      if (statsBuilder_ == null) {
        stats_ = null;
      } else {
        stats_ = null;
        statsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.ResultSetProto
          .internal_static_google_spanner_v1_PartialResultSet_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.PartialResultSet getDefaultInstanceForType() {
      return com.google.spanner.v1.PartialResultSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.PartialResultSet build() {
      com.google.spanner.v1.PartialResultSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.PartialResultSet buildPartial() {
      com.google.spanner.v1.PartialResultSet result =
          new com.google.spanner.v1.PartialResultSet(this);
      int from_bitField0_ = bitField0_;
      if (metadataBuilder_ == null) {
        result.metadata_ = metadata_;
      } else {
        result.metadata_ = metadataBuilder_.build();
      }
      if (valuesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          values_ = java.util.Collections.unmodifiableList(values_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.values_ = values_;
      } else {
        result.values_ = valuesBuilder_.build();
      }
      result.chunkedValue_ = chunkedValue_;
      result.resumeToken_ = resumeToken_;
      if (statsBuilder_ == null) {
        result.stats_ = stats_;
      } else {
        result.stats_ = statsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.PartialResultSet) {
        return mergeFrom((com.google.spanner.v1.PartialResultSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.PartialResultSet other) {
      if (other == com.google.spanner.v1.PartialResultSet.getDefaultInstance()) return this;
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (valuesBuilder_ == null) {
        if (!other.values_.isEmpty()) {
          if (values_.isEmpty()) {
            values_ = other.values_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureValuesIsMutable();
            values_.addAll(other.values_);
          }
          onChanged();
        }
      } else {
        if (!other.values_.isEmpty()) {
          if (valuesBuilder_.isEmpty()) {
            valuesBuilder_.dispose();
            valuesBuilder_ = null;
            values_ = other.values_;
            bitField0_ = (bitField0_ & ~0x00000001);
            valuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getValuesFieldBuilder()
                    : null;
          } else {
            valuesBuilder_.addAllMessages(other.values_);
          }
        }
      }
      if (other.getChunkedValue() != false) {
        setChunkedValue(other.getChunkedValue());
      }
      if (other.getResumeToken() != com.google.protobuf.ByteString.EMPTY) {
        setResumeToken(other.getResumeToken());
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.v1.PartialResultSet parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.spanner.v1.PartialResultSet) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.spanner.v1.ResultSetMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetMetadata,
            com.google.spanner.v1.ResultSetMetadata.Builder,
            com.google.spanner.v1.ResultSetMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return metadataBuilder_ != null || metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     *
     * @return The metadata.
     */
    public com.google.spanner.v1.ResultSetMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder setMetadata(com.google.spanner.v1.ResultSetMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        metadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder setMetadata(com.google.spanner.v1.ResultSetMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder mergeMetadata(com.google.spanner.v1.ResultSetMetadata value) {
      if (metadataBuilder_ == null) {
        if (metadata_ != null) {
          metadata_ =
              com.google.spanner.v1.ResultSetMetadata.newBuilder(metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        metadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        metadata_ = null;
        onChanged();
      } else {
        metadata_ = null;
        metadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public com.google.spanner.v1.ResultSetMetadata.Builder getMetadataBuilder() {

      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public com.google.spanner.v1.ResultSetMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * Only present in the first response.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetMetadata,
            com.google.spanner.v1.ResultSetMetadata.Builder,
            com.google.spanner.v1.ResultSetMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ResultSetMetadata,
                com.google.spanner.v1.ResultSetMetadata.Builder,
                com.google.spanner.v1.ResultSetMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.util.List<com.google.protobuf.Value> values_ = java.util.Collections.emptyList();

    private void ensureValuesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        values_ = new java.util.ArrayList<com.google.protobuf.Value>(values_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        valuesBuilder_;

    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public java.util.List<com.google.protobuf.Value> getValuesList() {
      if (valuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(values_);
      } else {
        return valuesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public int getValuesCount() {
      if (valuesBuilder_ == null) {
        return values_.size();
      } else {
        return valuesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public com.google.protobuf.Value getValues(int index) {
      if (valuesBuilder_ == null) {
        return values_.get(index);
      } else {
        return valuesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder setValues(int index, com.google.protobuf.Value value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.set(index, value);
        onChanged();
      } else {
        valuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder setValues(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.set(index, builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder addValues(com.google.protobuf.Value value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(value);
        onChanged();
      } else {
        valuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder addValues(int index, com.google.protobuf.Value value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(index, value);
        onChanged();
      } else {
        valuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder addValues(com.google.protobuf.Value.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.add(builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder addValues(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.add(index, builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder addAllValues(java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
        onChanged();
      } else {
        valuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder clearValues() {
      if (valuesBuilder_ == null) {
        values_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        valuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public Builder removeValues(int index) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.remove(index);
        onChanged();
      } else {
        valuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public com.google.protobuf.Value.Builder getValuesBuilder(int index) {
      return getValuesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public com.google.protobuf.ValueOrBuilder getValuesOrBuilder(int index) {
      if (valuesBuilder_ == null) {
        return values_.get(index);
      } else {
        return valuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder> getValuesOrBuilderList() {
      if (valuesBuilder_ != null) {
        return valuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(values_);
      }
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public com.google.protobuf.Value.Builder addValuesBuilder() {
      return getValuesFieldBuilder().addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public com.google.protobuf.Value.Builder addValuesBuilder(int index) {
      return getValuesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A streamed result set consists of a stream of values, which might
     * be split into many `PartialResultSet` messages to accommodate
     * large rows and/or large values. Every N complete values defines a
     * row, where N is equal to the number of entries in
     * [metadata.row_type.fields][google.spanner.v1.StructType.fields].
     * Most values are encoded based on type as described
     * [here][google.spanner.v1.TypeCode].
     * It is possible that the last value in values is "chunked",
     * meaning that the rest of the value is sent in subsequent
     * `PartialResultSet`(s). This is denoted by the [chunked_value][google.spanner.v1.PartialResultSet.chunked_value]
     * field. Two or more chunked values can be merged to form a
     * complete value as follows:
     *   * `bool/number/null`: cannot be chunked
     *   * `string`: concatenate the strings
     *   * `list`: concatenate the lists. If the last element in a list is a
     *     `string`, `list`, or `object`, merge it with the first element in
     *     the next list by applying these rules recursively.
     *   * `object`: concatenate the (field name, field value) pairs. If a
     *     field name is duplicated, then apply these rules recursively
     *     to merge the field values.
     * Some examples of merging:
     *     # Strings are concatenated.
     *     "foo", "bar" =&gt; "foobar"
     *     # Lists of non-strings are concatenated.
     *     [2, 3], [4] =&gt; [2, 3, 4]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are strings.
     *     ["a", "b"], ["c", "d"] =&gt; ["a", "bc", "d"]
     *     # Lists are concatenated, but the last and first elements are merged
     *     # because they are lists. Recursively, the last and first elements
     *     # of the inner lists are merged because they are strings.
     *     ["a", ["b", "c"]], [["d"], "e"] =&gt; ["a", ["b", "cd"], "e"]
     *     # Non-overlapping object fields are combined.
     *     {"a": "1"}, {"b": "2"} =&gt; {"a": "1", "b": 2"}
     *     # Overlapping object fields are merged.
     *     {"a": "1"}, {"a": "2"} =&gt; {"a": "12"}
     *     # Examples of merging objects containing lists of strings.
     *     {"a": ["1"]}, {"a": ["2"]} =&gt; {"a": ["12"]}
     * For a more complete example, suppose a streaming SQL query is
     * yielding a result set whose rows contain a single string
     * field. The following `PartialResultSet`s might be yielded:
     *     {
     *       "metadata": { ... }
     *       "values": ["Hello", "W"]
     *       "chunked_value": true
     *       "resume_token": "Af65..."
     *     }
     *     {
     *       "values": ["orl"]
     *       "chunked_value": true
     *       "resume_token": "Bqp2..."
     *     }
     *     {
     *       "values": ["d"]
     *       "resume_token": "Zx1B..."
     *     }
     * This sequence of `PartialResultSet`s encodes two rows, one
     * containing the field value `"Hello"`, and a second containing the
     * field value `"World" = "W" + "orl" + "d"`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value values = 2;</code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getValuesBuilderList() {
      return getValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getValuesFieldBuilder() {
      if (valuesBuilder_ == null) {
        valuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                values_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        values_ = null;
      }
      return valuesBuilder_;
    }

    private boolean chunkedValue_;
    /**
     *
     *
     * <pre>
     * If true, then the final value in [values][google.spanner.v1.PartialResultSet.values] is chunked, and must
     * be combined with more values from subsequent `PartialResultSet`s
     * to obtain a complete field value.
     * </pre>
     *
     * <code>bool chunked_value = 3;</code>
     *
     * @return The chunkedValue.
     */
    @java.lang.Override
    public boolean getChunkedValue() {
      return chunkedValue_;
    }
    /**
     *
     *
     * <pre>
     * If true, then the final value in [values][google.spanner.v1.PartialResultSet.values] is chunked, and must
     * be combined with more values from subsequent `PartialResultSet`s
     * to obtain a complete field value.
     * </pre>
     *
     * <code>bool chunked_value = 3;</code>
     *
     * @param value The chunkedValue to set.
     * @return This builder for chaining.
     */
    public Builder setChunkedValue(boolean value) {

      chunkedValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, then the final value in [values][google.spanner.v1.PartialResultSet.values] is chunked, and must
     * be combined with more values from subsequent `PartialResultSet`s
     * to obtain a complete field value.
     * </pre>
     *
     * <code>bool chunked_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChunkedValue() {

      chunkedValue_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString resumeToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Streaming calls might be interrupted for a variety of reasons, such
     * as TCP connection loss. If this occurs, the stream of results can
     * be resumed by re-sending the original request and including
     * `resume_token`. Note that executing any other transaction in the
     * same session invalidates the token.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return The resumeToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResumeToken() {
      return resumeToken_;
    }
    /**
     *
     *
     * <pre>
     * Streaming calls might be interrupted for a variety of reasons, such
     * as TCP connection loss. If this occurs, the stream of results can
     * be resumed by re-sending the original request and including
     * `resume_token`. Note that executing any other transaction in the
     * same session invalidates the token.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @param value The resumeToken to set.
     * @return This builder for chaining.
     */
    public Builder setResumeToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resumeToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Streaming calls might be interrupted for a variety of reasons, such
     * as TCP connection loss. If this occurs, the stream of results can
     * be resumed by re-sending the original request and including
     * `resume_token`. Note that executing any other transaction in the
     * same session invalidates the token.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeToken() {

      resumeToken_ = getDefaultInstance().getResumeToken();
      onChanged();
      return this;
    }

    private com.google.spanner.v1.ResultSetStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetStats,
            com.google.spanner.v1.ResultSetStats.Builder,
            com.google.spanner.v1.ResultSetStatsOrBuilder>
        statsBuilder_;
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return statsBuilder_ != null || stats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     *
     * @return The stats.
     */
    public com.google.spanner.v1.ResultSetStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    public Builder setStats(com.google.spanner.v1.ResultSetStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
        onChanged();
      } else {
        statsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    public Builder setStats(com.google.spanner.v1.ResultSetStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
        onChanged();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    public Builder mergeStats(com.google.spanner.v1.ResultSetStats value) {
      if (statsBuilder_ == null) {
        if (stats_ != null) {
          stats_ =
              com.google.spanner.v1.ResultSetStats.newBuilder(stats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stats_ = value;
        }
        onChanged();
      } else {
        statsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    public Builder clearStats() {
      if (statsBuilder_ == null) {
        stats_ = null;
        onChanged();
      } else {
        stats_ = null;
        statsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    public com.google.spanner.v1.ResultSetStats.Builder getStatsBuilder() {

      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    public com.google.spanner.v1.ResultSetStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the statement that produced this
     * streaming result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] and are sent
     * only once with the last response in the stream.
     * This field will also be present in the last response for DML
     * statements.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetStats,
            com.google.spanner.v1.ResultSetStats.Builder,
            com.google.spanner.v1.ResultSetStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ResultSetStats,
                com.google.spanner.v1.ResultSetStats.Builder,
                com.google.spanner.v1.ResultSetStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.PartialResultSet)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.PartialResultSet)
  private static final com.google.spanner.v1.PartialResultSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.PartialResultSet();
  }

  public static com.google.spanner.v1.PartialResultSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartialResultSet> PARSER =
      new com.google.protobuf.AbstractParser<PartialResultSet>() {
        @java.lang.Override
        public PartialResultSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PartialResultSet(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PartialResultSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartialResultSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.PartialResultSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
