/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Action that updates a Cloud Spanner instance.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.UpdateCloudInstanceAction}
 */
public final class UpdateCloudInstanceAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.UpdateCloudInstanceAction)
    UpdateCloudInstanceActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateCloudInstanceAction.newBuilder() to construct.
  private UpdateCloudInstanceAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateCloudInstanceAction() {
    instanceId_ = "";
    projectId_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateCloudInstanceAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_UpdateCloudInstanceAction_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_UpdateCloudInstanceAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.UpdateCloudInstanceAction.class,
            com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder.class);
  }

  private int bitField0_;
  public static final int INSTANCE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path), e.g. "test-instance".
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The instanceId.
   */
  @java.lang.Override
  public java.lang.String getInstanceId() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path), e.g. "test-instance".
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The bytes for instanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceIdBytes() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The descriptive name for this instance as it appears in UIs.
   * Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>optional string display_name = 3;</code>
   *
   * @return Whether the displayName field is set.
   */
  @java.lang.Override
  public boolean hasDisplayName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The descriptive name for this instance as it appears in UIs.
   * Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>optional string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The descriptive name for this instance as it appears in UIs.
   * Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>optional string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 4;
  private int nodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance. At most one of either
   * node_count or processing_units should be present in the message.
   * </pre>
   *
   * <code>optional int32 node_count = 4;</code>
   *
   * @return Whether the nodeCount field is set.
   */
  @java.lang.Override
  public boolean hasNodeCount() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance. At most one of either
   * node_count or processing_units should be present in the message.
   * </pre>
   *
   * <code>optional int32 node_count = 4;</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    return nodeCount_;
  }

  public static final int PROCESSING_UNITS_FIELD_NUMBER = 5;
  private int processingUnits_ = 0;
  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance. At most one of
   * processing_units or node_count should be present in the message.
   * </pre>
   *
   * <code>optional int32 processing_units = 5;</code>
   *
   * @return Whether the processingUnits field is set.
   */
  @java.lang.Override
  public boolean hasProcessingUnits() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance. At most one of
   * processing_units or node_count should be present in the message.
   * </pre>
   *
   * <code>optional int32 processing_units = 5;</code>
   *
   * @return The processingUnits.
   */
  @java.lang.Override
  public int getProcessingUnits() {
    return processingUnits_;
  }

  public static final int AUTOSCALING_CONFIG_FIELD_NUMBER = 7;
  private com.google.spanner.admin.instance.v1.AutoscalingConfig autoscalingConfig_;
  /**
   *
   *
   * <pre>
   * The autoscaling config for this instance. If non-empty, this instance is
   * using autoscaling (processing_units and node_count should be set to
   * 0 if used).
   * </pre>
   *
   * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
   * </code>
   *
   * @return Whether the autoscalingConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The autoscaling config for this instance. If non-empty, this instance is
   * using autoscaling (processing_units and node_count should be set to
   * 0 if used).
   * </pre>
   *
   * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
   * </code>
   *
   * @return The autoscalingConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig getAutoscalingConfig() {
    return autoscalingConfig_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
        : autoscalingConfig_;
  }
  /**
   *
   *
   * <pre>
   * The autoscaling config for this instance. If non-empty, this instance is
   * using autoscaling (processing_units and node_count should be set to
   * 0 if used).
   * </pre>
   *
   * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder
      getAutoscalingConfigOrBuilder() {
    return autoscalingConfig_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
        : autoscalingConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.spanner.executor.v1.CloudExecutorProto
                .internal_static_google_spanner_executor_v1_UpdateCloudInstanceAction_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(4, nodeCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(5, processingUnits_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getAutoscalingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, nodeCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, processingUnits_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAutoscalingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.UpdateCloudInstanceAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.UpdateCloudInstanceAction other =
        (com.google.spanner.executor.v1.UpdateCloudInstanceAction) obj;

    if (!getInstanceId().equals(other.getInstanceId())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (hasDisplayName() != other.hasDisplayName()) return false;
    if (hasDisplayName()) {
      if (!getDisplayName().equals(other.getDisplayName())) return false;
    }
    if (hasNodeCount() != other.hasNodeCount()) return false;
    if (hasNodeCount()) {
      if (getNodeCount() != other.getNodeCount()) return false;
    }
    if (hasProcessingUnits() != other.hasProcessingUnits()) return false;
    if (hasProcessingUnits()) {
      if (getProcessingUnits() != other.getProcessingUnits()) return false;
    }
    if (hasAutoscalingConfig() != other.hasAutoscalingConfig()) return false;
    if (hasAutoscalingConfig()) {
      if (!getAutoscalingConfig().equals(other.getAutoscalingConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceId().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    if (hasDisplayName()) {
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
    }
    if (hasNodeCount()) {
      hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getNodeCount();
    }
    if (hasProcessingUnits()) {
      hash = (37 * hash) + PROCESSING_UNITS_FIELD_NUMBER;
      hash = (53 * hash) + getProcessingUnits();
    }
    if (hasAutoscalingConfig()) {
      hash = (37 * hash) + AUTOSCALING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.UpdateCloudInstanceAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Action that updates a Cloud Spanner instance.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.UpdateCloudInstanceAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.UpdateCloudInstanceAction)
      com.google.spanner.executor.v1.UpdateCloudInstanceActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_UpdateCloudInstanceAction_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_UpdateCloudInstanceAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.UpdateCloudInstanceAction.class,
              com.google.spanner.executor.v1.UpdateCloudInstanceAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.UpdateCloudInstanceAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAutoscalingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceId_ = "";
      projectId_ = "";
      displayName_ = "";
      nodeCount_ = 0;
      processingUnits_ = 0;
      autoscalingConfig_ = null;
      if (autoscalingConfigBuilder_ != null) {
        autoscalingConfigBuilder_.dispose();
        autoscalingConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_UpdateCloudInstanceAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudInstanceAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudInstanceAction build() {
      com.google.spanner.executor.v1.UpdateCloudInstanceAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudInstanceAction buildPartial() {
      com.google.spanner.executor.v1.UpdateCloudInstanceAction result =
          new com.google.spanner.executor.v1.UpdateCloudInstanceAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.UpdateCloudInstanceAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceId_ = instanceId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nodeCount_ = nodeCount_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.processingUnits_ = processingUnits_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.autoscalingConfig_ =
            autoscalingConfigBuilder_ == null
                ? autoscalingConfig_
                : autoscalingConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.UpdateCloudInstanceAction) {
        return mergeFrom((com.google.spanner.executor.v1.UpdateCloudInstanceAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.UpdateCloudInstanceAction other) {
      if (other == com.google.spanner.executor.v1.UpdateCloudInstanceAction.getDefaultInstance())
        return this;
      if (!other.getInstanceId().isEmpty()) {
        instanceId_ = other.instanceId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDisplayName()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasNodeCount()) {
        setNodeCount(other.getNodeCount());
      }
      if (other.hasProcessingUnits()) {
        setProcessingUnits(other.getProcessingUnits());
      }
      if (other.hasAutoscalingConfig()) {
        mergeAutoscalingConfig(other.getAutoscalingConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                instanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                nodeCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                processingUnits_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getAutoscalingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The instanceId.
     */
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The bytes for instanceId.
     */
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceId() {
      instanceId_ = getDefaultInstance().getInstanceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The bytes for instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>optional string display_name = 3;</code>
     *
     * @return Whether the displayName field is set.
     */
    public boolean hasDisplayName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>optional string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>optional string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>optional string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>optional string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The descriptive name for this instance as it appears in UIs.
     * Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>optional string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int nodeCount_;
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     * </pre>
     *
     * <code>optional int32 node_count = 4;</code>
     *
     * @return Whether the nodeCount field is set.
     */
    @java.lang.Override
    public boolean hasNodeCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     * </pre>
     *
     * <code>optional int32 node_count = 4;</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public int getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     * </pre>
     *
     * <code>optional int32 node_count = 4;</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      nodeCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance. At most one of either
     * node_count or processing_units should be present in the message.
     * </pre>
     *
     * <code>optional int32 node_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nodeCount_ = 0;
      onChanged();
      return this;
    }

    private int processingUnits_;
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     * </pre>
     *
     * <code>optional int32 processing_units = 5;</code>
     *
     * @return Whether the processingUnits field is set.
     */
    @java.lang.Override
    public boolean hasProcessingUnits() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     * </pre>
     *
     * <code>optional int32 processing_units = 5;</code>
     *
     * @return The processingUnits.
     */
    @java.lang.Override
    public int getProcessingUnits() {
      return processingUnits_;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     * </pre>
     *
     * <code>optional int32 processing_units = 5;</code>
     *
     * @param value The processingUnits to set.
     * @return This builder for chaining.
     */
    public Builder setProcessingUnits(int value) {

      processingUnits_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance. At most one of
     * processing_units or node_count should be present in the message.
     * </pre>
     *
     * <code>optional int32 processing_units = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessingUnits() {
      bitField0_ = (bitField0_ & ~0x00000010);
      processingUnits_ = 0;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.instance.v1.AutoscalingConfig autoscalingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder>
        autoscalingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     *
     * @return Whether the autoscalingConfig field is set.
     */
    public boolean hasAutoscalingConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     *
     * @return The autoscalingConfig.
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig getAutoscalingConfig() {
      if (autoscalingConfigBuilder_ == null) {
        return autoscalingConfig_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
            : autoscalingConfig_;
      } else {
        return autoscalingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    public Builder setAutoscalingConfig(
        com.google.spanner.admin.instance.v1.AutoscalingConfig value) {
      if (autoscalingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingConfig_ = value;
      } else {
        autoscalingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    public Builder setAutoscalingConfig(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder builderForValue) {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfig_ = builderForValue.build();
      } else {
        autoscalingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    public Builder mergeAutoscalingConfig(
        com.google.spanner.admin.instance.v1.AutoscalingConfig value) {
      if (autoscalingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && autoscalingConfig_ != null
            && autoscalingConfig_
                != com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()) {
          getAutoscalingConfigBuilder().mergeFrom(value);
        } else {
          autoscalingConfig_ = value;
        }
      } else {
        autoscalingConfigBuilder_.mergeFrom(value);
      }
      if (autoscalingConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    public Builder clearAutoscalingConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      autoscalingConfig_ = null;
      if (autoscalingConfigBuilder_ != null) {
        autoscalingConfigBuilder_.dispose();
        autoscalingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder
        getAutoscalingConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAutoscalingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder
        getAutoscalingConfigOrBuilder() {
      if (autoscalingConfigBuilder_ != null) {
        return autoscalingConfigBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingConfig_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance()
            : autoscalingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The autoscaling config for this instance. If non-empty, this instance is
     * using autoscaling (processing_units and node_count should be set to
     * 0 if used).
     * </pre>
     *
     * <code>optional .google.spanner.admin.instance.v1.AutoscalingConfig autoscaling_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder>
        getAutoscalingConfigFieldBuilder() {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder>(
                getAutoscalingConfig(), getParentForChildren(), isClean());
        autoscalingConfig_ = null;
      }
      return autoscalingConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.UpdateCloudInstanceAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.UpdateCloudInstanceAction)
  private static final com.google.spanner.executor.v1.UpdateCloudInstanceAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.UpdateCloudInstanceAction();
  }

  public static com.google.spanner.executor.v1.UpdateCloudInstanceAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateCloudInstanceAction> PARSER =
      new com.google.protobuf.AbstractParser<UpdateCloudInstanceAction>() {
        @java.lang.Override
        public UpdateCloudInstanceAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateCloudInstanceAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateCloudInstanceAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudInstanceAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
