/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * SpannerAction defines a primitive action that can be performed against
 * Spanner, such as begin or commit a transaction, or perform a read or
 * mutation.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.SpannerAction}
 */
public final class SpannerAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.SpannerAction)
    SpannerActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpannerAction.newBuilder() to construct.
  private SpannerAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpannerAction() {
    databasePath_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpannerAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_SpannerAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_SpannerAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.SpannerAction.class,
            com.google.spanner.executor.v1.SpannerAction.Builder.class);
  }

  private int bitField0_;
  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    START(10),
    FINISH(11),
    READ(20),
    QUERY(21),
    MUTATION(22),
    DML(23),
    BATCH_DML(24),
    WRITE(25),
    PARTITIONED_UPDATE(27),
    ADMIN(30),
    START_BATCH_TXN(40),
    CLOSE_BATCH_TXN(41),
    GENERATE_DB_PARTITIONS_READ(42),
    GENERATE_DB_PARTITIONS_QUERY(43),
    EXECUTE_PARTITION(44),
    EXECUTE_CHANGE_STREAM_QUERY(50),
    QUERY_CANCELLATION(51),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 10:
          return START;
        case 11:
          return FINISH;
        case 20:
          return READ;
        case 21:
          return QUERY;
        case 22:
          return MUTATION;
        case 23:
          return DML;
        case 24:
          return BATCH_DML;
        case 25:
          return WRITE;
        case 27:
          return PARTITIONED_UPDATE;
        case 30:
          return ADMIN;
        case 40:
          return START_BATCH_TXN;
        case 41:
          return CLOSE_BATCH_TXN;
        case 42:
          return GENERATE_DB_PARTITIONS_READ;
        case 43:
          return GENERATE_DB_PARTITIONS_QUERY;
        case 44:
          return EXECUTE_PARTITION;
        case 50:
          return EXECUTE_CHANGE_STREAM_QUERY;
        case 51:
          return QUERY_CANCELLATION;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int DATABASE_PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databasePath_ = "";
  /**
   *
   *
   * <pre>
   * Database against which to perform action.
   * In a context where a series of actions take place, an action may omit
   * database path if it applies to the same database as the previous action.
   * </pre>
   *
   * <code>string database_path = 1;</code>
   *
   * @return The databasePath.
   */
  @java.lang.Override
  public java.lang.String getDatabasePath() {
    java.lang.Object ref = databasePath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databasePath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Database against which to perform action.
   * In a context where a series of actions take place, an action may omit
   * database path if it applies to the same database as the previous action.
   * </pre>
   *
   * <code>string database_path = 1;</code>
   *
   * @return The bytes for databasePath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabasePathBytes() {
    java.lang.Object ref = databasePath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databasePath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPANNER_OPTIONS_FIELD_NUMBER = 2;
  private com.google.spanner.executor.v1.SpannerOptions spannerOptions_;
  /**
   *
   *
   * <pre>
   * Configuration options for Spanner backend
   * </pre>
   *
   * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
   *
   * @return Whether the spannerOptions field is set.
   */
  @java.lang.Override
  public boolean hasSpannerOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration options for Spanner backend
   * </pre>
   *
   * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
   *
   * @return The spannerOptions.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.SpannerOptions getSpannerOptions() {
    return spannerOptions_ == null
        ? com.google.spanner.executor.v1.SpannerOptions.getDefaultInstance()
        : spannerOptions_;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for Spanner backend
   * </pre>
   *
   * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.SpannerOptionsOrBuilder getSpannerOptionsOrBuilder() {
    return spannerOptions_ == null
        ? com.google.spanner.executor.v1.SpannerOptions.getDefaultInstance()
        : spannerOptions_;
  }

  public static final int START_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Action to start a transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
   *
   * @return Whether the start field is set.
   */
  @java.lang.Override
  public boolean hasStart() {
    return actionCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Action to start a transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
   *
   * @return The start.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.StartTransactionAction getStart() {
    if (actionCase_ == 10) {
      return (com.google.spanner.executor.v1.StartTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to start a transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.StartTransactionActionOrBuilder getStartOrBuilder() {
    if (actionCase_ == 10) {
      return (com.google.spanner.executor.v1.StartTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
  }

  public static final int FINISH_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Action to finish a transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
   *
   * @return Whether the finish field is set.
   */
  @java.lang.Override
  public boolean hasFinish() {
    return actionCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Action to finish a transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
   *
   * @return The finish.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.FinishTransactionAction getFinish() {
    if (actionCase_ == 11) {
      return (com.google.spanner.executor.v1.FinishTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to finish a transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.FinishTransactionActionOrBuilder getFinishOrBuilder() {
    if (actionCase_ == 11) {
      return (com.google.spanner.executor.v1.FinishTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance();
  }

  public static final int READ_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Action to do a normal read.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
   *
   * @return Whether the read field is set.
   */
  @java.lang.Override
  public boolean hasRead() {
    return actionCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Action to do a normal read.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
   *
   * @return The read.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ReadAction getRead() {
    if (actionCase_ == 20) {
      return (com.google.spanner.executor.v1.ReadAction) action_;
    }
    return com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to do a normal read.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ReadActionOrBuilder getReadOrBuilder() {
    if (actionCase_ == 20) {
      return (com.google.spanner.executor.v1.ReadAction) action_;
    }
    return com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
  }

  public static final int QUERY_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Action to do a query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return actionCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Action to do a query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryAction getQuery() {
    if (actionCase_ == 21) {
      return (com.google.spanner.executor.v1.QueryAction) action_;
    }
    return com.google.spanner.executor.v1.QueryAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to do a query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryActionOrBuilder getQueryOrBuilder() {
    if (actionCase_ == 21) {
      return (com.google.spanner.executor.v1.QueryAction) action_;
    }
    return com.google.spanner.executor.v1.QueryAction.getDefaultInstance();
  }

  public static final int MUTATION_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Action to buffer a mutation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
   *
   * @return Whether the mutation field is set.
   */
  @java.lang.Override
  public boolean hasMutation() {
    return actionCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Action to buffer a mutation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
   *
   * @return The mutation.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.MutationAction getMutation() {
    if (actionCase_ == 22) {
      return (com.google.spanner.executor.v1.MutationAction) action_;
    }
    return com.google.spanner.executor.v1.MutationAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to buffer a mutation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.MutationActionOrBuilder getMutationOrBuilder() {
    if (actionCase_ == 22) {
      return (com.google.spanner.executor.v1.MutationAction) action_;
    }
    return com.google.spanner.executor.v1.MutationAction.getDefaultInstance();
  }

  public static final int DML_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Action to a DML.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
   *
   * @return Whether the dml field is set.
   */
  @java.lang.Override
  public boolean hasDml() {
    return actionCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Action to a DML.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
   *
   * @return The dml.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DmlAction getDml() {
    if (actionCase_ == 23) {
      return (com.google.spanner.executor.v1.DmlAction) action_;
    }
    return com.google.spanner.executor.v1.DmlAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to a DML.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.DmlActionOrBuilder getDmlOrBuilder() {
    if (actionCase_ == 23) {
      return (com.google.spanner.executor.v1.DmlAction) action_;
    }
    return com.google.spanner.executor.v1.DmlAction.getDefaultInstance();
  }

  public static final int BATCH_DML_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Action to a batch DML.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
   *
   * @return Whether the batchDml field is set.
   */
  @java.lang.Override
  public boolean hasBatchDml() {
    return actionCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Action to a batch DML.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
   *
   * @return The batchDml.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.BatchDmlAction getBatchDml() {
    if (actionCase_ == 24) {
      return (com.google.spanner.executor.v1.BatchDmlAction) action_;
    }
    return com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to a batch DML.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.BatchDmlActionOrBuilder getBatchDmlOrBuilder() {
    if (actionCase_ == 24) {
      return (com.google.spanner.executor.v1.BatchDmlAction) action_;
    }
    return com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance();
  }

  public static final int WRITE_FIELD_NUMBER = 25;
  /**
   *
   *
   * <pre>
   * Action to write a mutation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
   *
   * @return Whether the write field is set.
   */
  @java.lang.Override
  public boolean hasWrite() {
    return actionCase_ == 25;
  }
  /**
   *
   *
   * <pre>
   * Action to write a mutation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
   *
   * @return The write.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.WriteMutationsAction getWrite() {
    if (actionCase_ == 25) {
      return (com.google.spanner.executor.v1.WriteMutationsAction) action_;
    }
    return com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to write a mutation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.WriteMutationsActionOrBuilder getWriteOrBuilder() {
    if (actionCase_ == 25) {
      return (com.google.spanner.executor.v1.WriteMutationsAction) action_;
    }
    return com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance();
  }

  public static final int PARTITIONED_UPDATE_FIELD_NUMBER = 27;
  /**
   *
   *
   * <pre>
   * Action to a partitioned update.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
   *
   * @return Whether the partitionedUpdate field is set.
   */
  @java.lang.Override
  public boolean hasPartitionedUpdate() {
    return actionCase_ == 27;
  }
  /**
   *
   *
   * <pre>
   * Action to a partitioned update.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
   *
   * @return The partitionedUpdate.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.PartitionedUpdateAction getPartitionedUpdate() {
    if (actionCase_ == 27) {
      return (com.google.spanner.executor.v1.PartitionedUpdateAction) action_;
    }
    return com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to a partitioned update.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.PartitionedUpdateActionOrBuilder
      getPartitionedUpdateOrBuilder() {
    if (actionCase_ == 27) {
      return (com.google.spanner.executor.v1.PartitionedUpdateAction) action_;
    }
    return com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
  }

  public static final int ADMIN_FIELD_NUMBER = 30;
  /**
   *
   *
   * <pre>
   * Action that contains any administrative operation, like database,
   * instance manipulation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
   *
   * @return Whether the admin field is set.
   */
  @java.lang.Override
  public boolean hasAdmin() {
    return actionCase_ == 30;
  }
  /**
   *
   *
   * <pre>
   * Action that contains any administrative operation, like database,
   * instance manipulation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
   *
   * @return The admin.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.AdminAction getAdmin() {
    if (actionCase_ == 30) {
      return (com.google.spanner.executor.v1.AdminAction) action_;
    }
    return com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action that contains any administrative operation, like database,
   * instance manipulation.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.AdminActionOrBuilder getAdminOrBuilder() {
    if (actionCase_ == 30) {
      return (com.google.spanner.executor.v1.AdminAction) action_;
    }
    return com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
  }

  public static final int START_BATCH_TXN_FIELD_NUMBER = 40;
  /**
   *
   *
   * <pre>
   * Action to start a batch transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
   *
   * @return Whether the startBatchTxn field is set.
   */
  @java.lang.Override
  public boolean hasStartBatchTxn() {
    return actionCase_ == 40;
  }
  /**
   *
   *
   * <pre>
   * Action to start a batch transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
   *
   * @return The startBatchTxn.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.StartBatchTransactionAction getStartBatchTxn() {
    if (actionCase_ == 40) {
      return (com.google.spanner.executor.v1.StartBatchTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to start a batch transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.StartBatchTransactionActionOrBuilder
      getStartBatchTxnOrBuilder() {
    if (actionCase_ == 40) {
      return (com.google.spanner.executor.v1.StartBatchTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
  }

  public static final int CLOSE_BATCH_TXN_FIELD_NUMBER = 41;
  /**
   *
   *
   * <pre>
   * Action to close a batch transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
   *
   * @return Whether the closeBatchTxn field is set.
   */
  @java.lang.Override
  public boolean hasCloseBatchTxn() {
    return actionCase_ == 41;
  }
  /**
   *
   *
   * <pre>
   * Action to close a batch transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
   *
   * @return The closeBatchTxn.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CloseBatchTransactionAction getCloseBatchTxn() {
    if (actionCase_ == 41) {
      return (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.CloseBatchTransactionAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to close a batch transaction.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.CloseBatchTransactionActionOrBuilder
      getCloseBatchTxnOrBuilder() {
    if (actionCase_ == 41) {
      return (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_;
    }
    return com.google.spanner.executor.v1.CloseBatchTransactionAction.getDefaultInstance();
  }

  public static final int GENERATE_DB_PARTITIONS_READ_FIELD_NUMBER = 42;
  /**
   *
   *
   * <pre>
   * Action to generate database partitions for batch read.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
   * </code>
   *
   * @return Whether the generateDbPartitionsRead field is set.
   */
  @java.lang.Override
  public boolean hasGenerateDbPartitionsRead() {
    return actionCase_ == 42;
  }
  /**
   *
   *
   * <pre>
   * Action to generate database partitions for batch read.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
   * </code>
   *
   * @return The generateDbPartitionsRead.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
      getGenerateDbPartitionsRead() {
    if (actionCase_ == 42) {
      return (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_;
    }
    return com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to generate database partitions for batch read.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GenerateDbPartitionsForReadActionOrBuilder
      getGenerateDbPartitionsReadOrBuilder() {
    if (actionCase_ == 42) {
      return (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_;
    }
    return com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.getDefaultInstance();
  }

  public static final int GENERATE_DB_PARTITIONS_QUERY_FIELD_NUMBER = 43;
  /**
   *
   *
   * <pre>
   * Action to generate database partitions for batch query.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
   * </code>
   *
   * @return Whether the generateDbPartitionsQuery field is set.
   */
  @java.lang.Override
  public boolean hasGenerateDbPartitionsQuery() {
    return actionCase_ == 43;
  }
  /**
   *
   *
   * <pre>
   * Action to generate database partitions for batch query.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
   * </code>
   *
   * @return The generateDbPartitionsQuery.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
      getGenerateDbPartitionsQuery() {
    if (actionCase_ == 43) {
      return (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_;
    }
    return com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to generate database partitions for batch query.
   * </pre>
   *
   * <code>
   * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.GenerateDbPartitionsForQueryActionOrBuilder
      getGenerateDbPartitionsQueryOrBuilder() {
    if (actionCase_ == 43) {
      return (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_;
    }
    return com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.getDefaultInstance();
  }

  public static final int EXECUTE_PARTITION_FIELD_NUMBER = 44;
  /**
   *
   *
   * <pre>
   * Action to execute batch actions on generated partitions.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
   *
   * @return Whether the executePartition field is set.
   */
  @java.lang.Override
  public boolean hasExecutePartition() {
    return actionCase_ == 44;
  }
  /**
   *
   *
   * <pre>
   * Action to execute batch actions on generated partitions.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
   *
   * @return The executePartition.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ExecutePartitionAction getExecutePartition() {
    if (actionCase_ == 44) {
      return (com.google.spanner.executor.v1.ExecutePartitionAction) action_;
    }
    return com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to execute batch actions on generated partitions.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ExecutePartitionActionOrBuilder
      getExecutePartitionOrBuilder() {
    if (actionCase_ == 44) {
      return (com.google.spanner.executor.v1.ExecutePartitionAction) action_;
    }
    return com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance();
  }

  public static final int EXECUTE_CHANGE_STREAM_QUERY_FIELD_NUMBER = 50;
  /**
   *
   *
   * <pre>
   * Action to execute change stream query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
   * </code>
   *
   * @return Whether the executeChangeStreamQuery field is set.
   */
  @java.lang.Override
  public boolean hasExecuteChangeStreamQuery() {
    return actionCase_ == 50;
  }
  /**
   *
   *
   * <pre>
   * Action to execute change stream query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
   * </code>
   *
   * @return The executeChangeStreamQuery.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ExecuteChangeStreamQuery getExecuteChangeStreamQuery() {
    if (actionCase_ == 50) {
      return (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_;
    }
    return com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Action to execute change stream query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ExecuteChangeStreamQueryOrBuilder
      getExecuteChangeStreamQueryOrBuilder() {
    if (actionCase_ == 50) {
      return (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_;
    }
    return com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
  }

  public static final int QUERY_CANCELLATION_FIELD_NUMBER = 51;
  /**
   *
   *
   * <pre>
   * Query cancellation action for testing the cancellation of a query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
   *
   * @return Whether the queryCancellation field is set.
   */
  @java.lang.Override
  public boolean hasQueryCancellation() {
    return actionCase_ == 51;
  }
  /**
   *
   *
   * <pre>
   * Query cancellation action for testing the cancellation of a query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
   *
   * @return The queryCancellation.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryCancellationAction getQueryCancellation() {
    if (actionCase_ == 51) {
      return (com.google.spanner.executor.v1.QueryCancellationAction) action_;
    }
    return com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Query cancellation action for testing the cancellation of a query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryCancellationActionOrBuilder
      getQueryCancellationOrBuilder() {
    if (actionCase_ == 51) {
      return (com.google.spanner.executor.v1.QueryCancellationAction) action_;
    }
    return com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databasePath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, databasePath_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSpannerOptions());
    }
    if (actionCase_ == 10) {
      output.writeMessage(10, (com.google.spanner.executor.v1.StartTransactionAction) action_);
    }
    if (actionCase_ == 11) {
      output.writeMessage(11, (com.google.spanner.executor.v1.FinishTransactionAction) action_);
    }
    if (actionCase_ == 20) {
      output.writeMessage(20, (com.google.spanner.executor.v1.ReadAction) action_);
    }
    if (actionCase_ == 21) {
      output.writeMessage(21, (com.google.spanner.executor.v1.QueryAction) action_);
    }
    if (actionCase_ == 22) {
      output.writeMessage(22, (com.google.spanner.executor.v1.MutationAction) action_);
    }
    if (actionCase_ == 23) {
      output.writeMessage(23, (com.google.spanner.executor.v1.DmlAction) action_);
    }
    if (actionCase_ == 24) {
      output.writeMessage(24, (com.google.spanner.executor.v1.BatchDmlAction) action_);
    }
    if (actionCase_ == 25) {
      output.writeMessage(25, (com.google.spanner.executor.v1.WriteMutationsAction) action_);
    }
    if (actionCase_ == 27) {
      output.writeMessage(27, (com.google.spanner.executor.v1.PartitionedUpdateAction) action_);
    }
    if (actionCase_ == 30) {
      output.writeMessage(30, (com.google.spanner.executor.v1.AdminAction) action_);
    }
    if (actionCase_ == 40) {
      output.writeMessage(40, (com.google.spanner.executor.v1.StartBatchTransactionAction) action_);
    }
    if (actionCase_ == 41) {
      output.writeMessage(41, (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_);
    }
    if (actionCase_ == 42) {
      output.writeMessage(
          42, (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_);
    }
    if (actionCase_ == 43) {
      output.writeMessage(
          43, (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_);
    }
    if (actionCase_ == 44) {
      output.writeMessage(44, (com.google.spanner.executor.v1.ExecutePartitionAction) action_);
    }
    if (actionCase_ == 50) {
      output.writeMessage(50, (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_);
    }
    if (actionCase_ == 51) {
      output.writeMessage(51, (com.google.spanner.executor.v1.QueryCancellationAction) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databasePath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, databasePath_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpannerOptions());
    }
    if (actionCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.spanner.executor.v1.StartTransactionAction) action_);
    }
    if (actionCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.spanner.executor.v1.FinishTransactionAction) action_);
    }
    if (actionCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.spanner.executor.v1.ReadAction) action_);
    }
    if (actionCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.spanner.executor.v1.QueryAction) action_);
    }
    if (actionCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.spanner.executor.v1.MutationAction) action_);
    }
    if (actionCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.spanner.executor.v1.DmlAction) action_);
    }
    if (actionCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.spanner.executor.v1.BatchDmlAction) action_);
    }
    if (actionCase_ == 25) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25, (com.google.spanner.executor.v1.WriteMutationsAction) action_);
    }
    if (actionCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.spanner.executor.v1.PartitionedUpdateAction) action_);
    }
    if (actionCase_ == 30) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              30, (com.google.spanner.executor.v1.AdminAction) action_);
    }
    if (actionCase_ == 40) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              40, (com.google.spanner.executor.v1.StartBatchTransactionAction) action_);
    }
    if (actionCase_ == 41) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              41, (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_);
    }
    if (actionCase_ == 42) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              42, (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_);
    }
    if (actionCase_ == 43) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              43, (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_);
    }
    if (actionCase_ == 44) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              44, (com.google.spanner.executor.v1.ExecutePartitionAction) action_);
    }
    if (actionCase_ == 50) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              50, (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_);
    }
    if (actionCase_ == 51) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              51, (com.google.spanner.executor.v1.QueryCancellationAction) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.SpannerAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.SpannerAction other =
        (com.google.spanner.executor.v1.SpannerAction) obj;

    if (!getDatabasePath().equals(other.getDatabasePath())) return false;
    if (hasSpannerOptions() != other.hasSpannerOptions()) return false;
    if (hasSpannerOptions()) {
      if (!getSpannerOptions().equals(other.getSpannerOptions())) return false;
    }
    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 10:
        if (!getStart().equals(other.getStart())) return false;
        break;
      case 11:
        if (!getFinish().equals(other.getFinish())) return false;
        break;
      case 20:
        if (!getRead().equals(other.getRead())) return false;
        break;
      case 21:
        if (!getQuery().equals(other.getQuery())) return false;
        break;
      case 22:
        if (!getMutation().equals(other.getMutation())) return false;
        break;
      case 23:
        if (!getDml().equals(other.getDml())) return false;
        break;
      case 24:
        if (!getBatchDml().equals(other.getBatchDml())) return false;
        break;
      case 25:
        if (!getWrite().equals(other.getWrite())) return false;
        break;
      case 27:
        if (!getPartitionedUpdate().equals(other.getPartitionedUpdate())) return false;
        break;
      case 30:
        if (!getAdmin().equals(other.getAdmin())) return false;
        break;
      case 40:
        if (!getStartBatchTxn().equals(other.getStartBatchTxn())) return false;
        break;
      case 41:
        if (!getCloseBatchTxn().equals(other.getCloseBatchTxn())) return false;
        break;
      case 42:
        if (!getGenerateDbPartitionsRead().equals(other.getGenerateDbPartitionsRead()))
          return false;
        break;
      case 43:
        if (!getGenerateDbPartitionsQuery().equals(other.getGenerateDbPartitionsQuery()))
          return false;
        break;
      case 44:
        if (!getExecutePartition().equals(other.getExecutePartition())) return false;
        break;
      case 50:
        if (!getExecuteChangeStreamQuery().equals(other.getExecuteChangeStreamQuery()))
          return false;
        break;
      case 51:
        if (!getQueryCancellation().equals(other.getQueryCancellation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getDatabasePath().hashCode();
    if (hasSpannerOptions()) {
      hash = (37 * hash) + SPANNER_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSpannerOptions().hashCode();
    }
    switch (actionCase_) {
      case 10:
        hash = (37 * hash) + START_FIELD_NUMBER;
        hash = (53 * hash) + getStart().hashCode();
        break;
      case 11:
        hash = (37 * hash) + FINISH_FIELD_NUMBER;
        hash = (53 * hash) + getFinish().hashCode();
        break;
      case 20:
        hash = (37 * hash) + READ_FIELD_NUMBER;
        hash = (53 * hash) + getRead().hashCode();
        break;
      case 21:
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        break;
      case 22:
        hash = (37 * hash) + MUTATION_FIELD_NUMBER;
        hash = (53 * hash) + getMutation().hashCode();
        break;
      case 23:
        hash = (37 * hash) + DML_FIELD_NUMBER;
        hash = (53 * hash) + getDml().hashCode();
        break;
      case 24:
        hash = (37 * hash) + BATCH_DML_FIELD_NUMBER;
        hash = (53 * hash) + getBatchDml().hashCode();
        break;
      case 25:
        hash = (37 * hash) + WRITE_FIELD_NUMBER;
        hash = (53 * hash) + getWrite().hashCode();
        break;
      case 27:
        hash = (37 * hash) + PARTITIONED_UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionedUpdate().hashCode();
        break;
      case 30:
        hash = (37 * hash) + ADMIN_FIELD_NUMBER;
        hash = (53 * hash) + getAdmin().hashCode();
        break;
      case 40:
        hash = (37 * hash) + START_BATCH_TXN_FIELD_NUMBER;
        hash = (53 * hash) + getStartBatchTxn().hashCode();
        break;
      case 41:
        hash = (37 * hash) + CLOSE_BATCH_TXN_FIELD_NUMBER;
        hash = (53 * hash) + getCloseBatchTxn().hashCode();
        break;
      case 42:
        hash = (37 * hash) + GENERATE_DB_PARTITIONS_READ_FIELD_NUMBER;
        hash = (53 * hash) + getGenerateDbPartitionsRead().hashCode();
        break;
      case 43:
        hash = (37 * hash) + GENERATE_DB_PARTITIONS_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getGenerateDbPartitionsQuery().hashCode();
        break;
      case 44:
        hash = (37 * hash) + EXECUTE_PARTITION_FIELD_NUMBER;
        hash = (53 * hash) + getExecutePartition().hashCode();
        break;
      case 50:
        hash = (37 * hash) + EXECUTE_CHANGE_STREAM_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getExecuteChangeStreamQuery().hashCode();
        break;
      case 51:
        hash = (37 * hash) + QUERY_CANCELLATION_FIELD_NUMBER;
        hash = (53 * hash) + getQueryCancellation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.SpannerAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.SpannerAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SpannerAction defines a primitive action that can be performed against
   * Spanner, such as begin or commit a transaction, or perform a read or
   * mutation.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.SpannerAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.SpannerAction)
      com.google.spanner.executor.v1.SpannerActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_SpannerAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_SpannerAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.SpannerAction.class,
              com.google.spanner.executor.v1.SpannerAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.SpannerAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpannerOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      databasePath_ = "";
      spannerOptions_ = null;
      if (spannerOptionsBuilder_ != null) {
        spannerOptionsBuilder_.dispose();
        spannerOptionsBuilder_ = null;
      }
      if (startBuilder_ != null) {
        startBuilder_.clear();
      }
      if (finishBuilder_ != null) {
        finishBuilder_.clear();
      }
      if (readBuilder_ != null) {
        readBuilder_.clear();
      }
      if (queryBuilder_ != null) {
        queryBuilder_.clear();
      }
      if (mutationBuilder_ != null) {
        mutationBuilder_.clear();
      }
      if (dmlBuilder_ != null) {
        dmlBuilder_.clear();
      }
      if (batchDmlBuilder_ != null) {
        batchDmlBuilder_.clear();
      }
      if (writeBuilder_ != null) {
        writeBuilder_.clear();
      }
      if (partitionedUpdateBuilder_ != null) {
        partitionedUpdateBuilder_.clear();
      }
      if (adminBuilder_ != null) {
        adminBuilder_.clear();
      }
      if (startBatchTxnBuilder_ != null) {
        startBatchTxnBuilder_.clear();
      }
      if (closeBatchTxnBuilder_ != null) {
        closeBatchTxnBuilder_.clear();
      }
      if (generateDbPartitionsReadBuilder_ != null) {
        generateDbPartitionsReadBuilder_.clear();
      }
      if (generateDbPartitionsQueryBuilder_ != null) {
        generateDbPartitionsQueryBuilder_.clear();
      }
      if (executePartitionBuilder_ != null) {
        executePartitionBuilder_.clear();
      }
      if (executeChangeStreamQueryBuilder_ != null) {
        executeChangeStreamQueryBuilder_.clear();
      }
      if (queryCancellationBuilder_ != null) {
        queryCancellationBuilder_.clear();
      }
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_SpannerAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.SpannerAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.SpannerAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.SpannerAction build() {
      com.google.spanner.executor.v1.SpannerAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.SpannerAction buildPartial() {
      com.google.spanner.executor.v1.SpannerAction result =
          new com.google.spanner.executor.v1.SpannerAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.SpannerAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.databasePath_ = databasePath_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.spannerOptions_ =
            spannerOptionsBuilder_ == null ? spannerOptions_ : spannerOptionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.executor.v1.SpannerAction result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 10 && startBuilder_ != null) {
        result.action_ = startBuilder_.build();
      }
      if (actionCase_ == 11 && finishBuilder_ != null) {
        result.action_ = finishBuilder_.build();
      }
      if (actionCase_ == 20 && readBuilder_ != null) {
        result.action_ = readBuilder_.build();
      }
      if (actionCase_ == 21 && queryBuilder_ != null) {
        result.action_ = queryBuilder_.build();
      }
      if (actionCase_ == 22 && mutationBuilder_ != null) {
        result.action_ = mutationBuilder_.build();
      }
      if (actionCase_ == 23 && dmlBuilder_ != null) {
        result.action_ = dmlBuilder_.build();
      }
      if (actionCase_ == 24 && batchDmlBuilder_ != null) {
        result.action_ = batchDmlBuilder_.build();
      }
      if (actionCase_ == 25 && writeBuilder_ != null) {
        result.action_ = writeBuilder_.build();
      }
      if (actionCase_ == 27 && partitionedUpdateBuilder_ != null) {
        result.action_ = partitionedUpdateBuilder_.build();
      }
      if (actionCase_ == 30 && adminBuilder_ != null) {
        result.action_ = adminBuilder_.build();
      }
      if (actionCase_ == 40 && startBatchTxnBuilder_ != null) {
        result.action_ = startBatchTxnBuilder_.build();
      }
      if (actionCase_ == 41 && closeBatchTxnBuilder_ != null) {
        result.action_ = closeBatchTxnBuilder_.build();
      }
      if (actionCase_ == 42 && generateDbPartitionsReadBuilder_ != null) {
        result.action_ = generateDbPartitionsReadBuilder_.build();
      }
      if (actionCase_ == 43 && generateDbPartitionsQueryBuilder_ != null) {
        result.action_ = generateDbPartitionsQueryBuilder_.build();
      }
      if (actionCase_ == 44 && executePartitionBuilder_ != null) {
        result.action_ = executePartitionBuilder_.build();
      }
      if (actionCase_ == 50 && executeChangeStreamQueryBuilder_ != null) {
        result.action_ = executeChangeStreamQueryBuilder_.build();
      }
      if (actionCase_ == 51 && queryCancellationBuilder_ != null) {
        result.action_ = queryCancellationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.SpannerAction) {
        return mergeFrom((com.google.spanner.executor.v1.SpannerAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.SpannerAction other) {
      if (other == com.google.spanner.executor.v1.SpannerAction.getDefaultInstance()) return this;
      if (!other.getDatabasePath().isEmpty()) {
        databasePath_ = other.databasePath_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSpannerOptions()) {
        mergeSpannerOptions(other.getSpannerOptions());
      }
      switch (other.getActionCase()) {
        case START:
          {
            mergeStart(other.getStart());
            break;
          }
        case FINISH:
          {
            mergeFinish(other.getFinish());
            break;
          }
        case READ:
          {
            mergeRead(other.getRead());
            break;
          }
        case QUERY:
          {
            mergeQuery(other.getQuery());
            break;
          }
        case MUTATION:
          {
            mergeMutation(other.getMutation());
            break;
          }
        case DML:
          {
            mergeDml(other.getDml());
            break;
          }
        case BATCH_DML:
          {
            mergeBatchDml(other.getBatchDml());
            break;
          }
        case WRITE:
          {
            mergeWrite(other.getWrite());
            break;
          }
        case PARTITIONED_UPDATE:
          {
            mergePartitionedUpdate(other.getPartitionedUpdate());
            break;
          }
        case ADMIN:
          {
            mergeAdmin(other.getAdmin());
            break;
          }
        case START_BATCH_TXN:
          {
            mergeStartBatchTxn(other.getStartBatchTxn());
            break;
          }
        case CLOSE_BATCH_TXN:
          {
            mergeCloseBatchTxn(other.getCloseBatchTxn());
            break;
          }
        case GENERATE_DB_PARTITIONS_READ:
          {
            mergeGenerateDbPartitionsRead(other.getGenerateDbPartitionsRead());
            break;
          }
        case GENERATE_DB_PARTITIONS_QUERY:
          {
            mergeGenerateDbPartitionsQuery(other.getGenerateDbPartitionsQuery());
            break;
          }
        case EXECUTE_PARTITION:
          {
            mergeExecutePartition(other.getExecutePartition());
            break;
          }
        case EXECUTE_CHANGE_STREAM_QUERY:
          {
            mergeExecuteChangeStreamQuery(other.getExecuteChangeStreamQuery());
            break;
          }
        case QUERY_CANCELLATION:
          {
            mergeQueryCancellation(other.getQueryCancellation());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                databasePath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSpannerOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 82:
              {
                input.readMessage(getStartFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getFinishFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 11;
                break;
              } // case 90
            case 162:
              {
                input.readMessage(getReadFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getQueryFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getMutationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getDmlFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 23;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getBatchDmlFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 24;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(getWriteFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 25;
                break;
              } // case 202
            case 218:
              {
                input.readMessage(
                    getPartitionedUpdateFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 27;
                break;
              } // case 218
            case 242:
              {
                input.readMessage(getAdminFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 30;
                break;
              } // case 242
            case 322:
              {
                input.readMessage(getStartBatchTxnFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 40;
                break;
              } // case 322
            case 330:
              {
                input.readMessage(getCloseBatchTxnFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 41;
                break;
              } // case 330
            case 338:
              {
                input.readMessage(
                    getGenerateDbPartitionsReadFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 42;
                break;
              } // case 338
            case 346:
              {
                input.readMessage(
                    getGenerateDbPartitionsQueryFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 43;
                break;
              } // case 346
            case 354:
              {
                input.readMessage(
                    getExecutePartitionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 44;
                break;
              } // case 354
            case 402:
              {
                input.readMessage(
                    getExecuteChangeStreamQueryFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 50;
                break;
              } // case 402
            case 410:
              {
                input.readMessage(
                    getQueryCancellationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 51;
                break;
              } // case 410
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object databasePath_ = "";
    /**
     *
     *
     * <pre>
     * Database against which to perform action.
     * In a context where a series of actions take place, an action may omit
     * database path if it applies to the same database as the previous action.
     * </pre>
     *
     * <code>string database_path = 1;</code>
     *
     * @return The databasePath.
     */
    public java.lang.String getDatabasePath() {
      java.lang.Object ref = databasePath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databasePath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Database against which to perform action.
     * In a context where a series of actions take place, an action may omit
     * database path if it applies to the same database as the previous action.
     * </pre>
     *
     * <code>string database_path = 1;</code>
     *
     * @return The bytes for databasePath.
     */
    public com.google.protobuf.ByteString getDatabasePathBytes() {
      java.lang.Object ref = databasePath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databasePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Database against which to perform action.
     * In a context where a series of actions take place, an action may omit
     * database path if it applies to the same database as the previous action.
     * </pre>
     *
     * <code>string database_path = 1;</code>
     *
     * @param value The databasePath to set.
     * @return This builder for chaining.
     */
    public Builder setDatabasePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databasePath_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database against which to perform action.
     * In a context where a series of actions take place, an action may omit
     * database path if it applies to the same database as the previous action.
     * </pre>
     *
     * <code>string database_path = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabasePath() {
      databasePath_ = getDefaultInstance().getDatabasePath();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database against which to perform action.
     * In a context where a series of actions take place, an action may omit
     * database path if it applies to the same database as the previous action.
     * </pre>
     *
     * <code>string database_path = 1;</code>
     *
     * @param value The bytes for databasePath to set.
     * @return This builder for chaining.
     */
    public Builder setDatabasePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databasePath_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.spanner.executor.v1.SpannerOptions spannerOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.SpannerOptions,
            com.google.spanner.executor.v1.SpannerOptions.Builder,
            com.google.spanner.executor.v1.SpannerOptionsOrBuilder>
        spannerOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     *
     * @return Whether the spannerOptions field is set.
     */
    public boolean hasSpannerOptions() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     *
     * @return The spannerOptions.
     */
    public com.google.spanner.executor.v1.SpannerOptions getSpannerOptions() {
      if (spannerOptionsBuilder_ == null) {
        return spannerOptions_ == null
            ? com.google.spanner.executor.v1.SpannerOptions.getDefaultInstance()
            : spannerOptions_;
      } else {
        return spannerOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    public Builder setSpannerOptions(com.google.spanner.executor.v1.SpannerOptions value) {
      if (spannerOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spannerOptions_ = value;
      } else {
        spannerOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    public Builder setSpannerOptions(
        com.google.spanner.executor.v1.SpannerOptions.Builder builderForValue) {
      if (spannerOptionsBuilder_ == null) {
        spannerOptions_ = builderForValue.build();
      } else {
        spannerOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    public Builder mergeSpannerOptions(com.google.spanner.executor.v1.SpannerOptions value) {
      if (spannerOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && spannerOptions_ != null
            && spannerOptions_
                != com.google.spanner.executor.v1.SpannerOptions.getDefaultInstance()) {
          getSpannerOptionsBuilder().mergeFrom(value);
        } else {
          spannerOptions_ = value;
        }
      } else {
        spannerOptionsBuilder_.mergeFrom(value);
      }
      if (spannerOptions_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    public Builder clearSpannerOptions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      spannerOptions_ = null;
      if (spannerOptionsBuilder_ != null) {
        spannerOptionsBuilder_.dispose();
        spannerOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    public com.google.spanner.executor.v1.SpannerOptions.Builder getSpannerOptionsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSpannerOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    public com.google.spanner.executor.v1.SpannerOptionsOrBuilder getSpannerOptionsOrBuilder() {
      if (spannerOptionsBuilder_ != null) {
        return spannerOptionsBuilder_.getMessageOrBuilder();
      } else {
        return spannerOptions_ == null
            ? com.google.spanner.executor.v1.SpannerOptions.getDefaultInstance()
            : spannerOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for Spanner backend
     * </pre>
     *
     * <code>.google.spanner.executor.v1.SpannerOptions spanner_options = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.SpannerOptions,
            com.google.spanner.executor.v1.SpannerOptions.Builder,
            com.google.spanner.executor.v1.SpannerOptionsOrBuilder>
        getSpannerOptionsFieldBuilder() {
      if (spannerOptionsBuilder_ == null) {
        spannerOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.SpannerOptions,
                com.google.spanner.executor.v1.SpannerOptions.Builder,
                com.google.spanner.executor.v1.SpannerOptionsOrBuilder>(
                getSpannerOptions(), getParentForChildren(), isClean());
        spannerOptions_ = null;
      }
      return spannerOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.StartTransactionAction,
            com.google.spanner.executor.v1.StartTransactionAction.Builder,
            com.google.spanner.executor.v1.StartTransactionActionOrBuilder>
        startBuilder_;
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     *
     * @return Whether the start field is set.
     */
    @java.lang.Override
    public boolean hasStart() {
      return actionCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     *
     * @return The start.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.StartTransactionAction getStart() {
      if (startBuilder_ == null) {
        if (actionCase_ == 10) {
          return (com.google.spanner.executor.v1.StartTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
      } else {
        if (actionCase_ == 10) {
          return startBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    public Builder setStart(com.google.spanner.executor.v1.StartTransactionAction value) {
      if (startBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        startBuilder_.setMessage(value);
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    public Builder setStart(
        com.google.spanner.executor.v1.StartTransactionAction.Builder builderForValue) {
      if (startBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        startBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    public Builder mergeStart(com.google.spanner.executor.v1.StartTransactionAction value) {
      if (startBuilder_ == null) {
        if (actionCase_ == 10
            && action_
                != com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.StartTransactionAction.newBuilder(
                      (com.google.spanner.executor.v1.StartTransactionAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 10) {
          startBuilder_.mergeFrom(value);
        } else {
          startBuilder_.setMessage(value);
        }
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    public Builder clearStart() {
      if (startBuilder_ == null) {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
        }
        startBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    public com.google.spanner.executor.v1.StartTransactionAction.Builder getStartBuilder() {
      return getStartFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.StartTransactionActionOrBuilder getStartOrBuilder() {
      if ((actionCase_ == 10) && (startBuilder_ != null)) {
        return startBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 10) {
          return (com.google.spanner.executor.v1.StartTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to start a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartTransactionAction start = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.StartTransactionAction,
            com.google.spanner.executor.v1.StartTransactionAction.Builder,
            com.google.spanner.executor.v1.StartTransactionActionOrBuilder>
        getStartFieldBuilder() {
      if (startBuilder_ == null) {
        if (!(actionCase_ == 10)) {
          action_ = com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
        }
        startBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.StartTransactionAction,
                com.google.spanner.executor.v1.StartTransactionAction.Builder,
                com.google.spanner.executor.v1.StartTransactionActionOrBuilder>(
                (com.google.spanner.executor.v1.StartTransactionAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 10;
      onChanged();
      return startBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.FinishTransactionAction,
            com.google.spanner.executor.v1.FinishTransactionAction.Builder,
            com.google.spanner.executor.v1.FinishTransactionActionOrBuilder>
        finishBuilder_;
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     *
     * @return Whether the finish field is set.
     */
    @java.lang.Override
    public boolean hasFinish() {
      return actionCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     *
     * @return The finish.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.FinishTransactionAction getFinish() {
      if (finishBuilder_ == null) {
        if (actionCase_ == 11) {
          return (com.google.spanner.executor.v1.FinishTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance();
      } else {
        if (actionCase_ == 11) {
          return finishBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    public Builder setFinish(com.google.spanner.executor.v1.FinishTransactionAction value) {
      if (finishBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        finishBuilder_.setMessage(value);
      }
      actionCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    public Builder setFinish(
        com.google.spanner.executor.v1.FinishTransactionAction.Builder builderForValue) {
      if (finishBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        finishBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    public Builder mergeFinish(com.google.spanner.executor.v1.FinishTransactionAction value) {
      if (finishBuilder_ == null) {
        if (actionCase_ == 11
            && action_
                != com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.FinishTransactionAction.newBuilder(
                      (com.google.spanner.executor.v1.FinishTransactionAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 11) {
          finishBuilder_.mergeFrom(value);
        } else {
          finishBuilder_.setMessage(value);
        }
      }
      actionCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    public Builder clearFinish() {
      if (finishBuilder_ == null) {
        if (actionCase_ == 11) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 11) {
          actionCase_ = 0;
          action_ = null;
        }
        finishBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    public com.google.spanner.executor.v1.FinishTransactionAction.Builder getFinishBuilder() {
      return getFinishFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.FinishTransactionActionOrBuilder getFinishOrBuilder() {
      if ((actionCase_ == 11) && (finishBuilder_ != null)) {
        return finishBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 11) {
          return (com.google.spanner.executor.v1.FinishTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to finish a transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.FinishTransactionAction finish = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.FinishTransactionAction,
            com.google.spanner.executor.v1.FinishTransactionAction.Builder,
            com.google.spanner.executor.v1.FinishTransactionActionOrBuilder>
        getFinishFieldBuilder() {
      if (finishBuilder_ == null) {
        if (!(actionCase_ == 11)) {
          action_ = com.google.spanner.executor.v1.FinishTransactionAction.getDefaultInstance();
        }
        finishBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.FinishTransactionAction,
                com.google.spanner.executor.v1.FinishTransactionAction.Builder,
                com.google.spanner.executor.v1.FinishTransactionActionOrBuilder>(
                (com.google.spanner.executor.v1.FinishTransactionAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 11;
      onChanged();
      return finishBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ReadAction,
            com.google.spanner.executor.v1.ReadAction.Builder,
            com.google.spanner.executor.v1.ReadActionOrBuilder>
        readBuilder_;
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     *
     * @return Whether the read field is set.
     */
    @java.lang.Override
    public boolean hasRead() {
      return actionCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     *
     * @return The read.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ReadAction getRead() {
      if (readBuilder_ == null) {
        if (actionCase_ == 20) {
          return (com.google.spanner.executor.v1.ReadAction) action_;
        }
        return com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
      } else {
        if (actionCase_ == 20) {
          return readBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    public Builder setRead(com.google.spanner.executor.v1.ReadAction value) {
      if (readBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        readBuilder_.setMessage(value);
      }
      actionCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    public Builder setRead(com.google.spanner.executor.v1.ReadAction.Builder builderForValue) {
      if (readBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        readBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    public Builder mergeRead(com.google.spanner.executor.v1.ReadAction value) {
      if (readBuilder_ == null) {
        if (actionCase_ == 20
            && action_ != com.google.spanner.executor.v1.ReadAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ReadAction.newBuilder(
                      (com.google.spanner.executor.v1.ReadAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 20) {
          readBuilder_.mergeFrom(value);
        } else {
          readBuilder_.setMessage(value);
        }
      }
      actionCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    public Builder clearRead() {
      if (readBuilder_ == null) {
        if (actionCase_ == 20) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 20) {
          actionCase_ = 0;
          action_ = null;
        }
        readBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    public com.google.spanner.executor.v1.ReadAction.Builder getReadBuilder() {
      return getReadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ReadActionOrBuilder getReadOrBuilder() {
      if ((actionCase_ == 20) && (readBuilder_ != null)) {
        return readBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 20) {
          return (com.google.spanner.executor.v1.ReadAction) action_;
        }
        return com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to do a normal read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ReadAction read = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ReadAction,
            com.google.spanner.executor.v1.ReadAction.Builder,
            com.google.spanner.executor.v1.ReadActionOrBuilder>
        getReadFieldBuilder() {
      if (readBuilder_ == null) {
        if (!(actionCase_ == 20)) {
          action_ = com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
        }
        readBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ReadAction,
                com.google.spanner.executor.v1.ReadAction.Builder,
                com.google.spanner.executor.v1.ReadActionOrBuilder>(
                (com.google.spanner.executor.v1.ReadAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 20;
      onChanged();
      return readBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryAction,
            com.google.spanner.executor.v1.QueryAction.Builder,
            com.google.spanner.executor.v1.QueryActionOrBuilder>
        queryBuilder_;
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     *
     * @return Whether the query field is set.
     */
    @java.lang.Override
    public boolean hasQuery() {
      return actionCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.QueryAction getQuery() {
      if (queryBuilder_ == null) {
        if (actionCase_ == 21) {
          return (com.google.spanner.executor.v1.QueryAction) action_;
        }
        return com.google.spanner.executor.v1.QueryAction.getDefaultInstance();
      } else {
        if (actionCase_ == 21) {
          return queryBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.QueryAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    public Builder setQuery(com.google.spanner.executor.v1.QueryAction value) {
      if (queryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        queryBuilder_.setMessage(value);
      }
      actionCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    public Builder setQuery(com.google.spanner.executor.v1.QueryAction.Builder builderForValue) {
      if (queryBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        queryBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    public Builder mergeQuery(com.google.spanner.executor.v1.QueryAction value) {
      if (queryBuilder_ == null) {
        if (actionCase_ == 21
            && action_ != com.google.spanner.executor.v1.QueryAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.QueryAction.newBuilder(
                      (com.google.spanner.executor.v1.QueryAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 21) {
          queryBuilder_.mergeFrom(value);
        } else {
          queryBuilder_.setMessage(value);
        }
      }
      actionCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    public Builder clearQuery() {
      if (queryBuilder_ == null) {
        if (actionCase_ == 21) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 21) {
          actionCase_ = 0;
          action_ = null;
        }
        queryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    public com.google.spanner.executor.v1.QueryAction.Builder getQueryBuilder() {
      return getQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.QueryActionOrBuilder getQueryOrBuilder() {
      if ((actionCase_ == 21) && (queryBuilder_ != null)) {
        return queryBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 21) {
          return (com.google.spanner.executor.v1.QueryAction) action_;
        }
        return com.google.spanner.executor.v1.QueryAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to do a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction query = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryAction,
            com.google.spanner.executor.v1.QueryAction.Builder,
            com.google.spanner.executor.v1.QueryActionOrBuilder>
        getQueryFieldBuilder() {
      if (queryBuilder_ == null) {
        if (!(actionCase_ == 21)) {
          action_ = com.google.spanner.executor.v1.QueryAction.getDefaultInstance();
        }
        queryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.QueryAction,
                com.google.spanner.executor.v1.QueryAction.Builder,
                com.google.spanner.executor.v1.QueryActionOrBuilder>(
                (com.google.spanner.executor.v1.QueryAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 21;
      onChanged();
      return queryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.MutationAction,
            com.google.spanner.executor.v1.MutationAction.Builder,
            com.google.spanner.executor.v1.MutationActionOrBuilder>
        mutationBuilder_;
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     *
     * @return Whether the mutation field is set.
     */
    @java.lang.Override
    public boolean hasMutation() {
      return actionCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     *
     * @return The mutation.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.MutationAction getMutation() {
      if (mutationBuilder_ == null) {
        if (actionCase_ == 22) {
          return (com.google.spanner.executor.v1.MutationAction) action_;
        }
        return com.google.spanner.executor.v1.MutationAction.getDefaultInstance();
      } else {
        if (actionCase_ == 22) {
          return mutationBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.MutationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    public Builder setMutation(com.google.spanner.executor.v1.MutationAction value) {
      if (mutationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        mutationBuilder_.setMessage(value);
      }
      actionCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    public Builder setMutation(
        com.google.spanner.executor.v1.MutationAction.Builder builderForValue) {
      if (mutationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        mutationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    public Builder mergeMutation(com.google.spanner.executor.v1.MutationAction value) {
      if (mutationBuilder_ == null) {
        if (actionCase_ == 22
            && action_ != com.google.spanner.executor.v1.MutationAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.MutationAction.newBuilder(
                      (com.google.spanner.executor.v1.MutationAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 22) {
          mutationBuilder_.mergeFrom(value);
        } else {
          mutationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    public Builder clearMutation() {
      if (mutationBuilder_ == null) {
        if (actionCase_ == 22) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 22) {
          actionCase_ = 0;
          action_ = null;
        }
        mutationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    public com.google.spanner.executor.v1.MutationAction.Builder getMutationBuilder() {
      return getMutationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.MutationActionOrBuilder getMutationOrBuilder() {
      if ((actionCase_ == 22) && (mutationBuilder_ != null)) {
        return mutationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 22) {
          return (com.google.spanner.executor.v1.MutationAction) action_;
        }
        return com.google.spanner.executor.v1.MutationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to buffer a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.MutationAction mutation = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.MutationAction,
            com.google.spanner.executor.v1.MutationAction.Builder,
            com.google.spanner.executor.v1.MutationActionOrBuilder>
        getMutationFieldBuilder() {
      if (mutationBuilder_ == null) {
        if (!(actionCase_ == 22)) {
          action_ = com.google.spanner.executor.v1.MutationAction.getDefaultInstance();
        }
        mutationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.MutationAction,
                com.google.spanner.executor.v1.MutationAction.Builder,
                com.google.spanner.executor.v1.MutationActionOrBuilder>(
                (com.google.spanner.executor.v1.MutationAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 22;
      onChanged();
      return mutationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DmlAction,
            com.google.spanner.executor.v1.DmlAction.Builder,
            com.google.spanner.executor.v1.DmlActionOrBuilder>
        dmlBuilder_;
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     *
     * @return Whether the dml field is set.
     */
    @java.lang.Override
    public boolean hasDml() {
      return actionCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     *
     * @return The dml.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DmlAction getDml() {
      if (dmlBuilder_ == null) {
        if (actionCase_ == 23) {
          return (com.google.spanner.executor.v1.DmlAction) action_;
        }
        return com.google.spanner.executor.v1.DmlAction.getDefaultInstance();
      } else {
        if (actionCase_ == 23) {
          return dmlBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.DmlAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    public Builder setDml(com.google.spanner.executor.v1.DmlAction value) {
      if (dmlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        dmlBuilder_.setMessage(value);
      }
      actionCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    public Builder setDml(com.google.spanner.executor.v1.DmlAction.Builder builderForValue) {
      if (dmlBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        dmlBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    public Builder mergeDml(com.google.spanner.executor.v1.DmlAction value) {
      if (dmlBuilder_ == null) {
        if (actionCase_ == 23
            && action_ != com.google.spanner.executor.v1.DmlAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.DmlAction.newBuilder(
                      (com.google.spanner.executor.v1.DmlAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 23) {
          dmlBuilder_.mergeFrom(value);
        } else {
          dmlBuilder_.setMessage(value);
        }
      }
      actionCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    public Builder clearDml() {
      if (dmlBuilder_ == null) {
        if (actionCase_ == 23) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 23) {
          actionCase_ = 0;
          action_ = null;
        }
        dmlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    public com.google.spanner.executor.v1.DmlAction.Builder getDmlBuilder() {
      return getDmlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.DmlActionOrBuilder getDmlOrBuilder() {
      if ((actionCase_ == 23) && (dmlBuilder_ != null)) {
        return dmlBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 23) {
          return (com.google.spanner.executor.v1.DmlAction) action_;
        }
        return com.google.spanner.executor.v1.DmlAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to a DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.DmlAction dml = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.DmlAction,
            com.google.spanner.executor.v1.DmlAction.Builder,
            com.google.spanner.executor.v1.DmlActionOrBuilder>
        getDmlFieldBuilder() {
      if (dmlBuilder_ == null) {
        if (!(actionCase_ == 23)) {
          action_ = com.google.spanner.executor.v1.DmlAction.getDefaultInstance();
        }
        dmlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.DmlAction,
                com.google.spanner.executor.v1.DmlAction.Builder,
                com.google.spanner.executor.v1.DmlActionOrBuilder>(
                (com.google.spanner.executor.v1.DmlAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 23;
      onChanged();
      return dmlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.BatchDmlAction,
            com.google.spanner.executor.v1.BatchDmlAction.Builder,
            com.google.spanner.executor.v1.BatchDmlActionOrBuilder>
        batchDmlBuilder_;
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     *
     * @return Whether the batchDml field is set.
     */
    @java.lang.Override
    public boolean hasBatchDml() {
      return actionCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     *
     * @return The batchDml.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.BatchDmlAction getBatchDml() {
      if (batchDmlBuilder_ == null) {
        if (actionCase_ == 24) {
          return (com.google.spanner.executor.v1.BatchDmlAction) action_;
        }
        return com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance();
      } else {
        if (actionCase_ == 24) {
          return batchDmlBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    public Builder setBatchDml(com.google.spanner.executor.v1.BatchDmlAction value) {
      if (batchDmlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        batchDmlBuilder_.setMessage(value);
      }
      actionCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    public Builder setBatchDml(
        com.google.spanner.executor.v1.BatchDmlAction.Builder builderForValue) {
      if (batchDmlBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        batchDmlBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    public Builder mergeBatchDml(com.google.spanner.executor.v1.BatchDmlAction value) {
      if (batchDmlBuilder_ == null) {
        if (actionCase_ == 24
            && action_ != com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.BatchDmlAction.newBuilder(
                      (com.google.spanner.executor.v1.BatchDmlAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 24) {
          batchDmlBuilder_.mergeFrom(value);
        } else {
          batchDmlBuilder_.setMessage(value);
        }
      }
      actionCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    public Builder clearBatchDml() {
      if (batchDmlBuilder_ == null) {
        if (actionCase_ == 24) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 24) {
          actionCase_ = 0;
          action_ = null;
        }
        batchDmlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    public com.google.spanner.executor.v1.BatchDmlAction.Builder getBatchDmlBuilder() {
      return getBatchDmlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.BatchDmlActionOrBuilder getBatchDmlOrBuilder() {
      if ((actionCase_ == 24) && (batchDmlBuilder_ != null)) {
        return batchDmlBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 24) {
          return (com.google.spanner.executor.v1.BatchDmlAction) action_;
        }
        return com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to a batch DML.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.BatchDmlAction batch_dml = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.BatchDmlAction,
            com.google.spanner.executor.v1.BatchDmlAction.Builder,
            com.google.spanner.executor.v1.BatchDmlActionOrBuilder>
        getBatchDmlFieldBuilder() {
      if (batchDmlBuilder_ == null) {
        if (!(actionCase_ == 24)) {
          action_ = com.google.spanner.executor.v1.BatchDmlAction.getDefaultInstance();
        }
        batchDmlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.BatchDmlAction,
                com.google.spanner.executor.v1.BatchDmlAction.Builder,
                com.google.spanner.executor.v1.BatchDmlActionOrBuilder>(
                (com.google.spanner.executor.v1.BatchDmlAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 24;
      onChanged();
      return batchDmlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.WriteMutationsAction,
            com.google.spanner.executor.v1.WriteMutationsAction.Builder,
            com.google.spanner.executor.v1.WriteMutationsActionOrBuilder>
        writeBuilder_;
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     *
     * @return Whether the write field is set.
     */
    @java.lang.Override
    public boolean hasWrite() {
      return actionCase_ == 25;
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     *
     * @return The write.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.WriteMutationsAction getWrite() {
      if (writeBuilder_ == null) {
        if (actionCase_ == 25) {
          return (com.google.spanner.executor.v1.WriteMutationsAction) action_;
        }
        return com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance();
      } else {
        if (actionCase_ == 25) {
          return writeBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    public Builder setWrite(com.google.spanner.executor.v1.WriteMutationsAction value) {
      if (writeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        writeBuilder_.setMessage(value);
      }
      actionCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    public Builder setWrite(
        com.google.spanner.executor.v1.WriteMutationsAction.Builder builderForValue) {
      if (writeBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        writeBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    public Builder mergeWrite(com.google.spanner.executor.v1.WriteMutationsAction value) {
      if (writeBuilder_ == null) {
        if (actionCase_ == 25
            && action_
                != com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.WriteMutationsAction.newBuilder(
                      (com.google.spanner.executor.v1.WriteMutationsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 25) {
          writeBuilder_.mergeFrom(value);
        } else {
          writeBuilder_.setMessage(value);
        }
      }
      actionCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    public Builder clearWrite() {
      if (writeBuilder_ == null) {
        if (actionCase_ == 25) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 25) {
          actionCase_ = 0;
          action_ = null;
        }
        writeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    public com.google.spanner.executor.v1.WriteMutationsAction.Builder getWriteBuilder() {
      return getWriteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.WriteMutationsActionOrBuilder getWriteOrBuilder() {
      if ((actionCase_ == 25) && (writeBuilder_ != null)) {
        return writeBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 25) {
          return (com.google.spanner.executor.v1.WriteMutationsAction) action_;
        }
        return com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to write a mutation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.WriteMutationsAction write = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.WriteMutationsAction,
            com.google.spanner.executor.v1.WriteMutationsAction.Builder,
            com.google.spanner.executor.v1.WriteMutationsActionOrBuilder>
        getWriteFieldBuilder() {
      if (writeBuilder_ == null) {
        if (!(actionCase_ == 25)) {
          action_ = com.google.spanner.executor.v1.WriteMutationsAction.getDefaultInstance();
        }
        writeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.WriteMutationsAction,
                com.google.spanner.executor.v1.WriteMutationsAction.Builder,
                com.google.spanner.executor.v1.WriteMutationsActionOrBuilder>(
                (com.google.spanner.executor.v1.WriteMutationsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 25;
      onChanged();
      return writeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.PartitionedUpdateAction,
            com.google.spanner.executor.v1.PartitionedUpdateAction.Builder,
            com.google.spanner.executor.v1.PartitionedUpdateActionOrBuilder>
        partitionedUpdateBuilder_;
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     *
     * @return Whether the partitionedUpdate field is set.
     */
    @java.lang.Override
    public boolean hasPartitionedUpdate() {
      return actionCase_ == 27;
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     *
     * @return The partitionedUpdate.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.PartitionedUpdateAction getPartitionedUpdate() {
      if (partitionedUpdateBuilder_ == null) {
        if (actionCase_ == 27) {
          return (com.google.spanner.executor.v1.PartitionedUpdateAction) action_;
        }
        return com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
      } else {
        if (actionCase_ == 27) {
          return partitionedUpdateBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    public Builder setPartitionedUpdate(
        com.google.spanner.executor.v1.PartitionedUpdateAction value) {
      if (partitionedUpdateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        partitionedUpdateBuilder_.setMessage(value);
      }
      actionCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    public Builder setPartitionedUpdate(
        com.google.spanner.executor.v1.PartitionedUpdateAction.Builder builderForValue) {
      if (partitionedUpdateBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        partitionedUpdateBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    public Builder mergePartitionedUpdate(
        com.google.spanner.executor.v1.PartitionedUpdateAction value) {
      if (partitionedUpdateBuilder_ == null) {
        if (actionCase_ == 27
            && action_
                != com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.PartitionedUpdateAction.newBuilder(
                      (com.google.spanner.executor.v1.PartitionedUpdateAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 27) {
          partitionedUpdateBuilder_.mergeFrom(value);
        } else {
          partitionedUpdateBuilder_.setMessage(value);
        }
      }
      actionCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    public Builder clearPartitionedUpdate() {
      if (partitionedUpdateBuilder_ == null) {
        if (actionCase_ == 27) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 27) {
          actionCase_ = 0;
          action_ = null;
        }
        partitionedUpdateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    public com.google.spanner.executor.v1.PartitionedUpdateAction.Builder
        getPartitionedUpdateBuilder() {
      return getPartitionedUpdateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.PartitionedUpdateActionOrBuilder
        getPartitionedUpdateOrBuilder() {
      if ((actionCase_ == 27) && (partitionedUpdateBuilder_ != null)) {
        return partitionedUpdateBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 27) {
          return (com.google.spanner.executor.v1.PartitionedUpdateAction) action_;
        }
        return com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to a partitioned update.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.PartitionedUpdateAction partitioned_update = 27;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.PartitionedUpdateAction,
            com.google.spanner.executor.v1.PartitionedUpdateAction.Builder,
            com.google.spanner.executor.v1.PartitionedUpdateActionOrBuilder>
        getPartitionedUpdateFieldBuilder() {
      if (partitionedUpdateBuilder_ == null) {
        if (!(actionCase_ == 27)) {
          action_ = com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
        }
        partitionedUpdateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.PartitionedUpdateAction,
                com.google.spanner.executor.v1.PartitionedUpdateAction.Builder,
                com.google.spanner.executor.v1.PartitionedUpdateActionOrBuilder>(
                (com.google.spanner.executor.v1.PartitionedUpdateAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 27;
      onChanged();
      return partitionedUpdateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.AdminAction,
            com.google.spanner.executor.v1.AdminAction.Builder,
            com.google.spanner.executor.v1.AdminActionOrBuilder>
        adminBuilder_;
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     *
     * @return Whether the admin field is set.
     */
    @java.lang.Override
    public boolean hasAdmin() {
      return actionCase_ == 30;
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     *
     * @return The admin.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.AdminAction getAdmin() {
      if (adminBuilder_ == null) {
        if (actionCase_ == 30) {
          return (com.google.spanner.executor.v1.AdminAction) action_;
        }
        return com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
      } else {
        if (actionCase_ == 30) {
          return adminBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    public Builder setAdmin(com.google.spanner.executor.v1.AdminAction value) {
      if (adminBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        adminBuilder_.setMessage(value);
      }
      actionCase_ = 30;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    public Builder setAdmin(com.google.spanner.executor.v1.AdminAction.Builder builderForValue) {
      if (adminBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        adminBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 30;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    public Builder mergeAdmin(com.google.spanner.executor.v1.AdminAction value) {
      if (adminBuilder_ == null) {
        if (actionCase_ == 30
            && action_ != com.google.spanner.executor.v1.AdminAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.AdminAction.newBuilder(
                      (com.google.spanner.executor.v1.AdminAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 30) {
          adminBuilder_.mergeFrom(value);
        } else {
          adminBuilder_.setMessage(value);
        }
      }
      actionCase_ = 30;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    public Builder clearAdmin() {
      if (adminBuilder_ == null) {
        if (actionCase_ == 30) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 30) {
          actionCase_ = 0;
          action_ = null;
        }
        adminBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    public com.google.spanner.executor.v1.AdminAction.Builder getAdminBuilder() {
      return getAdminFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.AdminActionOrBuilder getAdminOrBuilder() {
      if ((actionCase_ == 30) && (adminBuilder_ != null)) {
        return adminBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 30) {
          return (com.google.spanner.executor.v1.AdminAction) action_;
        }
        return com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action that contains any administrative operation, like database,
     * instance manipulation.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.AdminAction admin = 30;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.AdminAction,
            com.google.spanner.executor.v1.AdminAction.Builder,
            com.google.spanner.executor.v1.AdminActionOrBuilder>
        getAdminFieldBuilder() {
      if (adminBuilder_ == null) {
        if (!(actionCase_ == 30)) {
          action_ = com.google.spanner.executor.v1.AdminAction.getDefaultInstance();
        }
        adminBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.AdminAction,
                com.google.spanner.executor.v1.AdminAction.Builder,
                com.google.spanner.executor.v1.AdminActionOrBuilder>(
                (com.google.spanner.executor.v1.AdminAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 30;
      onChanged();
      return adminBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.StartBatchTransactionAction,
            com.google.spanner.executor.v1.StartBatchTransactionAction.Builder,
            com.google.spanner.executor.v1.StartBatchTransactionActionOrBuilder>
        startBatchTxnBuilder_;
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     *
     * @return Whether the startBatchTxn field is set.
     */
    @java.lang.Override
    public boolean hasStartBatchTxn() {
      return actionCase_ == 40;
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     *
     * @return The startBatchTxn.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.StartBatchTransactionAction getStartBatchTxn() {
      if (startBatchTxnBuilder_ == null) {
        if (actionCase_ == 40) {
          return (com.google.spanner.executor.v1.StartBatchTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
      } else {
        if (actionCase_ == 40) {
          return startBatchTxnBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    public Builder setStartBatchTxn(
        com.google.spanner.executor.v1.StartBatchTransactionAction value) {
      if (startBatchTxnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        startBatchTxnBuilder_.setMessage(value);
      }
      actionCase_ = 40;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    public Builder setStartBatchTxn(
        com.google.spanner.executor.v1.StartBatchTransactionAction.Builder builderForValue) {
      if (startBatchTxnBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        startBatchTxnBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 40;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    public Builder mergeStartBatchTxn(
        com.google.spanner.executor.v1.StartBatchTransactionAction value) {
      if (startBatchTxnBuilder_ == null) {
        if (actionCase_ == 40
            && action_
                != com.google.spanner.executor.v1.StartBatchTransactionAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.StartBatchTransactionAction.newBuilder(
                      (com.google.spanner.executor.v1.StartBatchTransactionAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 40) {
          startBatchTxnBuilder_.mergeFrom(value);
        } else {
          startBatchTxnBuilder_.setMessage(value);
        }
      }
      actionCase_ = 40;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    public Builder clearStartBatchTxn() {
      if (startBatchTxnBuilder_ == null) {
        if (actionCase_ == 40) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 40) {
          actionCase_ = 0;
          action_ = null;
        }
        startBatchTxnBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    public com.google.spanner.executor.v1.StartBatchTransactionAction.Builder
        getStartBatchTxnBuilder() {
      return getStartBatchTxnFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.StartBatchTransactionActionOrBuilder
        getStartBatchTxnOrBuilder() {
      if ((actionCase_ == 40) && (startBatchTxnBuilder_ != null)) {
        return startBatchTxnBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 40) {
          return (com.google.spanner.executor.v1.StartBatchTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to start a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.StartBatchTransactionAction start_batch_txn = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.StartBatchTransactionAction,
            com.google.spanner.executor.v1.StartBatchTransactionAction.Builder,
            com.google.spanner.executor.v1.StartBatchTransactionActionOrBuilder>
        getStartBatchTxnFieldBuilder() {
      if (startBatchTxnBuilder_ == null) {
        if (!(actionCase_ == 40)) {
          action_ = com.google.spanner.executor.v1.StartBatchTransactionAction.getDefaultInstance();
        }
        startBatchTxnBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.StartBatchTransactionAction,
                com.google.spanner.executor.v1.StartBatchTransactionAction.Builder,
                com.google.spanner.executor.v1.StartBatchTransactionActionOrBuilder>(
                (com.google.spanner.executor.v1.StartBatchTransactionAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 40;
      onChanged();
      return startBatchTxnBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CloseBatchTransactionAction,
            com.google.spanner.executor.v1.CloseBatchTransactionAction.Builder,
            com.google.spanner.executor.v1.CloseBatchTransactionActionOrBuilder>
        closeBatchTxnBuilder_;
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     *
     * @return Whether the closeBatchTxn field is set.
     */
    @java.lang.Override
    public boolean hasCloseBatchTxn() {
      return actionCase_ == 41;
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     *
     * @return The closeBatchTxn.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CloseBatchTransactionAction getCloseBatchTxn() {
      if (closeBatchTxnBuilder_ == null) {
        if (actionCase_ == 41) {
          return (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.CloseBatchTransactionAction.getDefaultInstance();
      } else {
        if (actionCase_ == 41) {
          return closeBatchTxnBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.CloseBatchTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    public Builder setCloseBatchTxn(
        com.google.spanner.executor.v1.CloseBatchTransactionAction value) {
      if (closeBatchTxnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        closeBatchTxnBuilder_.setMessage(value);
      }
      actionCase_ = 41;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    public Builder setCloseBatchTxn(
        com.google.spanner.executor.v1.CloseBatchTransactionAction.Builder builderForValue) {
      if (closeBatchTxnBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        closeBatchTxnBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 41;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    public Builder mergeCloseBatchTxn(
        com.google.spanner.executor.v1.CloseBatchTransactionAction value) {
      if (closeBatchTxnBuilder_ == null) {
        if (actionCase_ == 41
            && action_
                != com.google.spanner.executor.v1.CloseBatchTransactionAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.CloseBatchTransactionAction.newBuilder(
                      (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 41) {
          closeBatchTxnBuilder_.mergeFrom(value);
        } else {
          closeBatchTxnBuilder_.setMessage(value);
        }
      }
      actionCase_ = 41;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    public Builder clearCloseBatchTxn() {
      if (closeBatchTxnBuilder_ == null) {
        if (actionCase_ == 41) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 41) {
          actionCase_ = 0;
          action_ = null;
        }
        closeBatchTxnBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    public com.google.spanner.executor.v1.CloseBatchTransactionAction.Builder
        getCloseBatchTxnBuilder() {
      return getCloseBatchTxnFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.CloseBatchTransactionActionOrBuilder
        getCloseBatchTxnOrBuilder() {
      if ((actionCase_ == 41) && (closeBatchTxnBuilder_ != null)) {
        return closeBatchTxnBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 41) {
          return (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_;
        }
        return com.google.spanner.executor.v1.CloseBatchTransactionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to close a batch transaction.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.CloseBatchTransactionAction close_batch_txn = 41;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.CloseBatchTransactionAction,
            com.google.spanner.executor.v1.CloseBatchTransactionAction.Builder,
            com.google.spanner.executor.v1.CloseBatchTransactionActionOrBuilder>
        getCloseBatchTxnFieldBuilder() {
      if (closeBatchTxnBuilder_ == null) {
        if (!(actionCase_ == 41)) {
          action_ = com.google.spanner.executor.v1.CloseBatchTransactionAction.getDefaultInstance();
        }
        closeBatchTxnBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.CloseBatchTransactionAction,
                com.google.spanner.executor.v1.CloseBatchTransactionAction.Builder,
                com.google.spanner.executor.v1.CloseBatchTransactionActionOrBuilder>(
                (com.google.spanner.executor.v1.CloseBatchTransactionAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 41;
      onChanged();
      return closeBatchTxnBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction,
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder,
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadActionOrBuilder>
        generateDbPartitionsReadBuilder_;
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     *
     * @return Whether the generateDbPartitionsRead field is set.
     */
    @java.lang.Override
    public boolean hasGenerateDbPartitionsRead() {
      return actionCase_ == 42;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     *
     * @return The generateDbPartitionsRead.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
        getGenerateDbPartitionsRead() {
      if (generateDbPartitionsReadBuilder_ == null) {
        if (actionCase_ == 42) {
          return (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_;
        }
        return com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
            .getDefaultInstance();
      } else {
        if (actionCase_ == 42) {
          return generateDbPartitionsReadBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    public Builder setGenerateDbPartitionsRead(
        com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction value) {
      if (generateDbPartitionsReadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        generateDbPartitionsReadBuilder_.setMessage(value);
      }
      actionCase_ = 42;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    public Builder setGenerateDbPartitionsRead(
        com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder builderForValue) {
      if (generateDbPartitionsReadBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        generateDbPartitionsReadBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 42;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    public Builder mergeGenerateDbPartitionsRead(
        com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction value) {
      if (generateDbPartitionsReadBuilder_ == null) {
        if (actionCase_ == 42
            && action_
                != com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.newBuilder(
                      (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 42) {
          generateDbPartitionsReadBuilder_.mergeFrom(value);
        } else {
          generateDbPartitionsReadBuilder_.setMessage(value);
        }
      }
      actionCase_ = 42;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    public Builder clearGenerateDbPartitionsRead() {
      if (generateDbPartitionsReadBuilder_ == null) {
        if (actionCase_ == 42) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 42) {
          actionCase_ = 0;
          action_ = null;
        }
        generateDbPartitionsReadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    public com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder
        getGenerateDbPartitionsReadBuilder() {
      return getGenerateDbPartitionsReadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForReadActionOrBuilder
        getGenerateDbPartitionsReadOrBuilder() {
      if ((actionCase_ == 42) && (generateDbPartitionsReadBuilder_ != null)) {
        return generateDbPartitionsReadBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 42) {
          return (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_;
        }
        return com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch read.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForReadAction generate_db_partitions_read = 42;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction,
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder,
            com.google.spanner.executor.v1.GenerateDbPartitionsForReadActionOrBuilder>
        getGenerateDbPartitionsReadFieldBuilder() {
      if (generateDbPartitionsReadBuilder_ == null) {
        if (!(actionCase_ == 42)) {
          action_ =
              com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.getDefaultInstance();
        }
        generateDbPartitionsReadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction,
                com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction.Builder,
                com.google.spanner.executor.v1.GenerateDbPartitionsForReadActionOrBuilder>(
                (com.google.spanner.executor.v1.GenerateDbPartitionsForReadAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 42;
      onChanged();
      return generateDbPartitionsReadBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction,
            com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.Builder,
            com.google.spanner.executor.v1.GenerateDbPartitionsForQueryActionOrBuilder>
        generateDbPartitionsQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     *
     * @return Whether the generateDbPartitionsQuery field is set.
     */
    @java.lang.Override
    public boolean hasGenerateDbPartitionsQuery() {
      return actionCase_ == 43;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     *
     * @return The generateDbPartitionsQuery.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
        getGenerateDbPartitionsQuery() {
      if (generateDbPartitionsQueryBuilder_ == null) {
        if (actionCase_ == 43) {
          return (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_;
        }
        return com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
            .getDefaultInstance();
      } else {
        if (actionCase_ == 43) {
          return generateDbPartitionsQueryBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    public Builder setGenerateDbPartitionsQuery(
        com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction value) {
      if (generateDbPartitionsQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        generateDbPartitionsQueryBuilder_.setMessage(value);
      }
      actionCase_ = 43;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    public Builder setGenerateDbPartitionsQuery(
        com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.Builder builderForValue) {
      if (generateDbPartitionsQueryBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        generateDbPartitionsQueryBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 43;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    public Builder mergeGenerateDbPartitionsQuery(
        com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction value) {
      if (generateDbPartitionsQueryBuilder_ == null) {
        if (actionCase_ == 43
            && action_
                != com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
                    .getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.newBuilder(
                      (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 43) {
          generateDbPartitionsQueryBuilder_.mergeFrom(value);
        } else {
          generateDbPartitionsQueryBuilder_.setMessage(value);
        }
      }
      actionCase_ = 43;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    public Builder clearGenerateDbPartitionsQuery() {
      if (generateDbPartitionsQueryBuilder_ == null) {
        if (actionCase_ == 43) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 43) {
          actionCase_ = 0;
          action_ = null;
        }
        generateDbPartitionsQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    public com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.Builder
        getGenerateDbPartitionsQueryBuilder() {
      return getGenerateDbPartitionsQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.GenerateDbPartitionsForQueryActionOrBuilder
        getGenerateDbPartitionsQueryOrBuilder() {
      if ((actionCase_ == 43) && (generateDbPartitionsQueryBuilder_ != null)) {
        return generateDbPartitionsQueryBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 43) {
          return (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_;
        }
        return com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to generate database partitions for batch query.
     * </pre>
     *
     * <code>
     * .google.spanner.executor.v1.GenerateDbPartitionsForQueryAction generate_db_partitions_query = 43;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction,
            com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.Builder,
            com.google.spanner.executor.v1.GenerateDbPartitionsForQueryActionOrBuilder>
        getGenerateDbPartitionsQueryFieldBuilder() {
      if (generateDbPartitionsQueryBuilder_ == null) {
        if (!(actionCase_ == 43)) {
          action_ =
              com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
                  .getDefaultInstance();
        }
        generateDbPartitionsQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction,
                com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.Builder,
                com.google.spanner.executor.v1.GenerateDbPartitionsForQueryActionOrBuilder>(
                (com.google.spanner.executor.v1.GenerateDbPartitionsForQueryAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 43;
      onChanged();
      return generateDbPartitionsQueryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ExecutePartitionAction,
            com.google.spanner.executor.v1.ExecutePartitionAction.Builder,
            com.google.spanner.executor.v1.ExecutePartitionActionOrBuilder>
        executePartitionBuilder_;
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     *
     * @return Whether the executePartition field is set.
     */
    @java.lang.Override
    public boolean hasExecutePartition() {
      return actionCase_ == 44;
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     *
     * @return The executePartition.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ExecutePartitionAction getExecutePartition() {
      if (executePartitionBuilder_ == null) {
        if (actionCase_ == 44) {
          return (com.google.spanner.executor.v1.ExecutePartitionAction) action_;
        }
        return com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance();
      } else {
        if (actionCase_ == 44) {
          return executePartitionBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    public Builder setExecutePartition(
        com.google.spanner.executor.v1.ExecutePartitionAction value) {
      if (executePartitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        executePartitionBuilder_.setMessage(value);
      }
      actionCase_ = 44;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    public Builder setExecutePartition(
        com.google.spanner.executor.v1.ExecutePartitionAction.Builder builderForValue) {
      if (executePartitionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        executePartitionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 44;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    public Builder mergeExecutePartition(
        com.google.spanner.executor.v1.ExecutePartitionAction value) {
      if (executePartitionBuilder_ == null) {
        if (actionCase_ == 44
            && action_
                != com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ExecutePartitionAction.newBuilder(
                      (com.google.spanner.executor.v1.ExecutePartitionAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 44) {
          executePartitionBuilder_.mergeFrom(value);
        } else {
          executePartitionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 44;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    public Builder clearExecutePartition() {
      if (executePartitionBuilder_ == null) {
        if (actionCase_ == 44) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 44) {
          actionCase_ = 0;
          action_ = null;
        }
        executePartitionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    public com.google.spanner.executor.v1.ExecutePartitionAction.Builder
        getExecutePartitionBuilder() {
      return getExecutePartitionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ExecutePartitionActionOrBuilder
        getExecutePartitionOrBuilder() {
      if ((actionCase_ == 44) && (executePartitionBuilder_ != null)) {
        return executePartitionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 44) {
          return (com.google.spanner.executor.v1.ExecutePartitionAction) action_;
        }
        return com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to execute batch actions on generated partitions.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecutePartitionAction execute_partition = 44;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ExecutePartitionAction,
            com.google.spanner.executor.v1.ExecutePartitionAction.Builder,
            com.google.spanner.executor.v1.ExecutePartitionActionOrBuilder>
        getExecutePartitionFieldBuilder() {
      if (executePartitionBuilder_ == null) {
        if (!(actionCase_ == 44)) {
          action_ = com.google.spanner.executor.v1.ExecutePartitionAction.getDefaultInstance();
        }
        executePartitionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ExecutePartitionAction,
                com.google.spanner.executor.v1.ExecutePartitionAction.Builder,
                com.google.spanner.executor.v1.ExecutePartitionActionOrBuilder>(
                (com.google.spanner.executor.v1.ExecutePartitionAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 44;
      onChanged();
      return executePartitionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ExecuteChangeStreamQuery,
            com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder,
            com.google.spanner.executor.v1.ExecuteChangeStreamQueryOrBuilder>
        executeChangeStreamQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     *
     * @return Whether the executeChangeStreamQuery field is set.
     */
    @java.lang.Override
    public boolean hasExecuteChangeStreamQuery() {
      return actionCase_ == 50;
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     *
     * @return The executeChangeStreamQuery.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ExecuteChangeStreamQuery getExecuteChangeStreamQuery() {
      if (executeChangeStreamQueryBuilder_ == null) {
        if (actionCase_ == 50) {
          return (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_;
        }
        return com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
      } else {
        if (actionCase_ == 50) {
          return executeChangeStreamQueryBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    public Builder setExecuteChangeStreamQuery(
        com.google.spanner.executor.v1.ExecuteChangeStreamQuery value) {
      if (executeChangeStreamQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        executeChangeStreamQueryBuilder_.setMessage(value);
      }
      actionCase_ = 50;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    public Builder setExecuteChangeStreamQuery(
        com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder builderForValue) {
      if (executeChangeStreamQueryBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        executeChangeStreamQueryBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 50;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    public Builder mergeExecuteChangeStreamQuery(
        com.google.spanner.executor.v1.ExecuteChangeStreamQuery value) {
      if (executeChangeStreamQueryBuilder_ == null) {
        if (actionCase_ == 50
            && action_
                != com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.ExecuteChangeStreamQuery.newBuilder(
                      (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 50) {
          executeChangeStreamQueryBuilder_.mergeFrom(value);
        } else {
          executeChangeStreamQueryBuilder_.setMessage(value);
        }
      }
      actionCase_ = 50;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    public Builder clearExecuteChangeStreamQuery() {
      if (executeChangeStreamQueryBuilder_ == null) {
        if (actionCase_ == 50) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 50) {
          actionCase_ = 0;
          action_ = null;
        }
        executeChangeStreamQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    public com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder
        getExecuteChangeStreamQueryBuilder() {
      return getExecuteChangeStreamQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.ExecuteChangeStreamQueryOrBuilder
        getExecuteChangeStreamQueryOrBuilder() {
      if ((actionCase_ == 50) && (executeChangeStreamQueryBuilder_ != null)) {
        return executeChangeStreamQueryBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 50) {
          return (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_;
        }
        return com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Action to execute change stream query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ExecuteChangeStreamQuery execute_change_stream_query = 50;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ExecuteChangeStreamQuery,
            com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder,
            com.google.spanner.executor.v1.ExecuteChangeStreamQueryOrBuilder>
        getExecuteChangeStreamQueryFieldBuilder() {
      if (executeChangeStreamQueryBuilder_ == null) {
        if (!(actionCase_ == 50)) {
          action_ = com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
        }
        executeChangeStreamQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ExecuteChangeStreamQuery,
                com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder,
                com.google.spanner.executor.v1.ExecuteChangeStreamQueryOrBuilder>(
                (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 50;
      onChanged();
      return executeChangeStreamQueryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryCancellationAction,
            com.google.spanner.executor.v1.QueryCancellationAction.Builder,
            com.google.spanner.executor.v1.QueryCancellationActionOrBuilder>
        queryCancellationBuilder_;
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     *
     * @return Whether the queryCancellation field is set.
     */
    @java.lang.Override
    public boolean hasQueryCancellation() {
      return actionCase_ == 51;
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     *
     * @return The queryCancellation.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.QueryCancellationAction getQueryCancellation() {
      if (queryCancellationBuilder_ == null) {
        if (actionCase_ == 51) {
          return (com.google.spanner.executor.v1.QueryCancellationAction) action_;
        }
        return com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance();
      } else {
        if (actionCase_ == 51) {
          return queryCancellationBuilder_.getMessage();
        }
        return com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    public Builder setQueryCancellation(
        com.google.spanner.executor.v1.QueryCancellationAction value) {
      if (queryCancellationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        queryCancellationBuilder_.setMessage(value);
      }
      actionCase_ = 51;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    public Builder setQueryCancellation(
        com.google.spanner.executor.v1.QueryCancellationAction.Builder builderForValue) {
      if (queryCancellationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        queryCancellationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 51;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    public Builder mergeQueryCancellation(
        com.google.spanner.executor.v1.QueryCancellationAction value) {
      if (queryCancellationBuilder_ == null) {
        if (actionCase_ == 51
            && action_
                != com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance()) {
          action_ =
              com.google.spanner.executor.v1.QueryCancellationAction.newBuilder(
                      (com.google.spanner.executor.v1.QueryCancellationAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 51) {
          queryCancellationBuilder_.mergeFrom(value);
        } else {
          queryCancellationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 51;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    public Builder clearQueryCancellation() {
      if (queryCancellationBuilder_ == null) {
        if (actionCase_ == 51) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 51) {
          actionCase_ = 0;
          action_ = null;
        }
        queryCancellationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    public com.google.spanner.executor.v1.QueryCancellationAction.Builder
        getQueryCancellationBuilder() {
      return getQueryCancellationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.QueryCancellationActionOrBuilder
        getQueryCancellationOrBuilder() {
      if ((actionCase_ == 51) && (queryCancellationBuilder_ != null)) {
        return queryCancellationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 51) {
          return (com.google.spanner.executor.v1.QueryCancellationAction) action_;
        }
        return com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Query cancellation action for testing the cancellation of a query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryCancellationAction query_cancellation = 51;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryCancellationAction,
            com.google.spanner.executor.v1.QueryCancellationAction.Builder,
            com.google.spanner.executor.v1.QueryCancellationActionOrBuilder>
        getQueryCancellationFieldBuilder() {
      if (queryCancellationBuilder_ == null) {
        if (!(actionCase_ == 51)) {
          action_ = com.google.spanner.executor.v1.QueryCancellationAction.getDefaultInstance();
        }
        queryCancellationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.QueryCancellationAction,
                com.google.spanner.executor.v1.QueryCancellationAction.Builder,
                com.google.spanner.executor.v1.QueryCancellationActionOrBuilder>(
                (com.google.spanner.executor.v1.QueryCancellationAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 51;
      onChanged();
      return queryCancellationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.SpannerAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.SpannerAction)
  private static final com.google.spanner.executor.v1.SpannerAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.SpannerAction();
  }

  public static com.google.spanner.executor.v1.SpannerAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpannerAction> PARSER =
      new com.google.protobuf.AbstractParser<SpannerAction>() {
        @java.lang.Override
        public SpannerAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpannerAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpannerAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.SpannerAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
