/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Execute a change stream TVF query.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.ExecuteChangeStreamQuery}
 */
public final class ExecuteChangeStreamQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.ExecuteChangeStreamQuery)
    ExecuteChangeStreamQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecuteChangeStreamQuery.newBuilder() to construct.
  private ExecuteChangeStreamQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecuteChangeStreamQuery() {
    name_ = "";
    partitionToken_ = "";
    readOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    cloudDatabaseRole_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecuteChangeStreamQuery();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ExecuteChangeStreamQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ExecuteChangeStreamQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.ExecuteChangeStreamQuery.class,
            com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name for this change stream.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name for this change stream.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Specifies that records with commit_timestamp greater than or equal to
   * start_time should be returned.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies that records with commit_timestamp greater than or equal to
   * start_time should be returned.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Specifies that records with commit_timestamp greater than or equal to
   * start_time should be returned.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Specifies that records with commit_timestamp less than or equal to
   * end_time should be returned.
   * </pre>
   *
   * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies that records with commit_timestamp less than or equal to
   * end_time should be returned.
   * </pre>
   *
   * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Specifies that records with commit_timestamp less than or equal to
   * end_time should be returned.
   * </pre>
   *
   * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int PARTITION_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object partitionToken_ = "";
  /**
   *
   *
   * <pre>
   * Specifies which change stream partition to query, based on the content of
   * child partitions records.
   * </pre>
   *
   * <code>optional string partition_token = 4;</code>
   *
   * @return Whether the partitionToken field is set.
   */
  @java.lang.Override
  public boolean hasPartitionToken() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies which change stream partition to query, based on the content of
   * child partitions records.
   * </pre>
   *
   * <code>optional string partition_token = 4;</code>
   *
   * @return The partitionToken.
   */
  @java.lang.Override
  public java.lang.String getPartitionToken() {
    java.lang.Object ref = partitionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      partitionToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies which change stream partition to query, based on the content of
   * child partitions records.
   * </pre>
   *
   * <code>optional string partition_token = 4;</code>
   *
   * @return The bytes for partitionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPartitionTokenBytes() {
    java.lang.Object ref = partitionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      partitionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_OPTIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList readOptions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Read options for this change stream query.
   * </pre>
   *
   * <code>repeated string read_options = 5;</code>
   *
   * @return A list containing the readOptions.
   */
  public com.google.protobuf.ProtocolStringList getReadOptionsList() {
    return readOptions_;
  }
  /**
   *
   *
   * <pre>
   * Read options for this change stream query.
   * </pre>
   *
   * <code>repeated string read_options = 5;</code>
   *
   * @return The count of readOptions.
   */
  public int getReadOptionsCount() {
    return readOptions_.size();
  }
  /**
   *
   *
   * <pre>
   * Read options for this change stream query.
   * </pre>
   *
   * <code>repeated string read_options = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The readOptions at the given index.
   */
  public java.lang.String getReadOptions(int index) {
    return readOptions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Read options for this change stream query.
   * </pre>
   *
   * <code>repeated string read_options = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the readOptions at the given index.
   */
  public com.google.protobuf.ByteString getReadOptionsBytes(int index) {
    return readOptions_.getByteString(index);
  }

  public static final int HEARTBEAT_MILLISECONDS_FIELD_NUMBER = 6;
  private int heartbeatMilliseconds_ = 0;
  /**
   *
   *
   * <pre>
   * Determines how frequently a heartbeat ChangeRecord will be returned in case
   * there are no transactions committed in this partition, in milliseconds.
   * </pre>
   *
   * <code>optional int32 heartbeat_milliseconds = 6;</code>
   *
   * @return Whether the heartbeatMilliseconds field is set.
   */
  @java.lang.Override
  public boolean hasHeartbeatMilliseconds() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Determines how frequently a heartbeat ChangeRecord will be returned in case
   * there are no transactions committed in this partition, in milliseconds.
   * </pre>
   *
   * <code>optional int32 heartbeat_milliseconds = 6;</code>
   *
   * @return The heartbeatMilliseconds.
   */
  @java.lang.Override
  public int getHeartbeatMilliseconds() {
    return heartbeatMilliseconds_;
  }

  public static final int DEADLINE_SECONDS_FIELD_NUMBER = 7;
  private long deadlineSeconds_ = 0L;
  /**
   *
   *
   * <pre>
   * Deadline for this change stream query, in seconds.
   * </pre>
   *
   * <code>optional int64 deadline_seconds = 7;</code>
   *
   * @return Whether the deadlineSeconds field is set.
   */
  @java.lang.Override
  public boolean hasDeadlineSeconds() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deadline for this change stream query, in seconds.
   * </pre>
   *
   * <code>optional int64 deadline_seconds = 7;</code>
   *
   * @return The deadlineSeconds.
   */
  @java.lang.Override
  public long getDeadlineSeconds() {
    return deadlineSeconds_;
  }

  public static final int CLOUD_DATABASE_ROLE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudDatabaseRole_ = "";
  /**
   *
   *
   * <pre>
   * Database role to assume while performing this action. This should only be
   * set for cloud requests. Setting the database role will enforce additional
   * role-based access checks on this action.
   * </pre>
   *
   * <code>optional string cloud_database_role = 8;</code>
   *
   * @return Whether the cloudDatabaseRole field is set.
   */
  @java.lang.Override
  public boolean hasCloudDatabaseRole() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Database role to assume while performing this action. This should only be
   * set for cloud requests. Setting the database role will enforce additional
   * role-based access checks on this action.
   * </pre>
   *
   * <code>optional string cloud_database_role = 8;</code>
   *
   * @return The cloudDatabaseRole.
   */
  @java.lang.Override
  public java.lang.String getCloudDatabaseRole() {
    java.lang.Object ref = cloudDatabaseRole_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudDatabaseRole_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Database role to assume while performing this action. This should only be
   * set for cloud requests. Setting the database role will enforce additional
   * role-based access checks on this action.
   * </pre>
   *
   * <code>optional string cloud_database_role = 8;</code>
   *
   * @return The bytes for cloudDatabaseRole.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudDatabaseRoleBytes() {
    java.lang.Object ref = cloudDatabaseRole_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudDatabaseRole_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, partitionToken_);
    }
    for (int i = 0; i < readOptions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, readOptions_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(6, heartbeatMilliseconds_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(7, deadlineSeconds_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, cloudDatabaseRole_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, partitionToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < readOptions_.size(); i++) {
        dataSize += computeStringSizeNoTag(readOptions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReadOptionsList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, heartbeatMilliseconds_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, deadlineSeconds_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, cloudDatabaseRole_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.ExecuteChangeStreamQuery)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.ExecuteChangeStreamQuery other =
        (com.google.spanner.executor.v1.ExecuteChangeStreamQuery) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasPartitionToken() != other.hasPartitionToken()) return false;
    if (hasPartitionToken()) {
      if (!getPartitionToken().equals(other.getPartitionToken())) return false;
    }
    if (!getReadOptionsList().equals(other.getReadOptionsList())) return false;
    if (hasHeartbeatMilliseconds() != other.hasHeartbeatMilliseconds()) return false;
    if (hasHeartbeatMilliseconds()) {
      if (getHeartbeatMilliseconds() != other.getHeartbeatMilliseconds()) return false;
    }
    if (hasDeadlineSeconds() != other.hasDeadlineSeconds()) return false;
    if (hasDeadlineSeconds()) {
      if (getDeadlineSeconds() != other.getDeadlineSeconds()) return false;
    }
    if (hasCloudDatabaseRole() != other.hasCloudDatabaseRole()) return false;
    if (hasCloudDatabaseRole()) {
      if (!getCloudDatabaseRole().equals(other.getCloudDatabaseRole())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasPartitionToken()) {
      hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionToken().hashCode();
    }
    if (getReadOptionsCount() > 0) {
      hash = (37 * hash) + READ_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReadOptionsList().hashCode();
    }
    if (hasHeartbeatMilliseconds()) {
      hash = (37 * hash) + HEARTBEAT_MILLISECONDS_FIELD_NUMBER;
      hash = (53 * hash) + getHeartbeatMilliseconds();
    }
    if (hasDeadlineSeconds()) {
      hash = (37 * hash) + DEADLINE_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDeadlineSeconds());
    }
    if (hasCloudDatabaseRole()) {
      hash = (37 * hash) + CLOUD_DATABASE_ROLE_FIELD_NUMBER;
      hash = (53 * hash) + getCloudDatabaseRole().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.ExecuteChangeStreamQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Execute a change stream TVF query.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.ExecuteChangeStreamQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.ExecuteChangeStreamQuery)
      com.google.spanner.executor.v1.ExecuteChangeStreamQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ExecuteChangeStreamQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ExecuteChangeStreamQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.ExecuteChangeStreamQuery.class,
              com.google.spanner.executor.v1.ExecuteChangeStreamQuery.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.ExecuteChangeStreamQuery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      partitionToken_ = "";
      readOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      heartbeatMilliseconds_ = 0;
      deadlineSeconds_ = 0L;
      cloudDatabaseRole_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ExecuteChangeStreamQuery_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ExecuteChangeStreamQuery getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ExecuteChangeStreamQuery build() {
      com.google.spanner.executor.v1.ExecuteChangeStreamQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ExecuteChangeStreamQuery buildPartial() {
      com.google.spanner.executor.v1.ExecuteChangeStreamQuery result =
          new com.google.spanner.executor.v1.ExecuteChangeStreamQuery(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.ExecuteChangeStreamQuery result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.partitionToken_ = partitionToken_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        readOptions_.makeImmutable();
        result.readOptions_ = readOptions_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.heartbeatMilliseconds_ = heartbeatMilliseconds_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.deadlineSeconds_ = deadlineSeconds_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.cloudDatabaseRole_ = cloudDatabaseRole_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.ExecuteChangeStreamQuery) {
        return mergeFrom((com.google.spanner.executor.v1.ExecuteChangeStreamQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.ExecuteChangeStreamQuery other) {
      if (other == com.google.spanner.executor.v1.ExecuteChangeStreamQuery.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasPartitionToken()) {
        partitionToken_ = other.partitionToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.readOptions_.isEmpty()) {
        if (readOptions_.isEmpty()) {
          readOptions_ = other.readOptions_;
          bitField0_ |= 0x00000010;
        } else {
          ensureReadOptionsIsMutable();
          readOptions_.addAll(other.readOptions_);
        }
        onChanged();
      }
      if (other.hasHeartbeatMilliseconds()) {
        setHeartbeatMilliseconds(other.getHeartbeatMilliseconds());
      }
      if (other.hasDeadlineSeconds()) {
        setDeadlineSeconds(other.getDeadlineSeconds());
      }
      if (other.hasCloudDatabaseRole()) {
        cloudDatabaseRole_ = other.cloudDatabaseRole_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                partitionToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReadOptionsIsMutable();
                readOptions_.add(s);
                break;
              } // case 42
            case 48:
              {
                heartbeatMilliseconds_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                deadlineSeconds_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                cloudDatabaseRole_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name for this change stream.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name for this change stream.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name for this change stream.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name for this change stream.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name for this change stream.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp greater than or equal to
     * start_time should be returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies that records with commit_timestamp less than or equal to
     * end_time should be returned.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp end_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object partitionToken_ = "";
    /**
     *
     *
     * <pre>
     * Specifies which change stream partition to query, based on the content of
     * child partitions records.
     * </pre>
     *
     * <code>optional string partition_token = 4;</code>
     *
     * @return Whether the partitionToken field is set.
     */
    public boolean hasPartitionToken() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies which change stream partition to query, based on the content of
     * child partitions records.
     * </pre>
     *
     * <code>optional string partition_token = 4;</code>
     *
     * @return The partitionToken.
     */
    public java.lang.String getPartitionToken() {
      java.lang.Object ref = partitionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partitionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which change stream partition to query, based on the content of
     * child partitions records.
     * </pre>
     *
     * <code>optional string partition_token = 4;</code>
     *
     * @return The bytes for partitionToken.
     */
    public com.google.protobuf.ByteString getPartitionTokenBytes() {
      java.lang.Object ref = partitionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        partitionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which change stream partition to query, based on the content of
     * child partitions records.
     * </pre>
     *
     * <code>optional string partition_token = 4;</code>
     *
     * @param value The partitionToken to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      partitionToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which change stream partition to query, based on the content of
     * child partitions records.
     * </pre>
     *
     * <code>optional string partition_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitionToken() {
      partitionToken_ = getDefaultInstance().getPartitionToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which change stream partition to query, based on the content of
     * child partitions records.
     * </pre>
     *
     * <code>optional string partition_token = 4;</code>
     *
     * @param value The bytes for partitionToken to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      partitionToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList readOptions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReadOptionsIsMutable() {
      if (!readOptions_.isModifiable()) {
        readOptions_ = new com.google.protobuf.LazyStringArrayList(readOptions_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @return A list containing the readOptions.
     */
    public com.google.protobuf.ProtocolStringList getReadOptionsList() {
      readOptions_.makeImmutable();
      return readOptions_;
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @return The count of readOptions.
     */
    public int getReadOptionsCount() {
      return readOptions_.size();
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The readOptions at the given index.
     */
    public java.lang.String getReadOptions(int index) {
      return readOptions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the readOptions at the given index.
     */
    public com.google.protobuf.ByteString getReadOptionsBytes(int index) {
      return readOptions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The readOptions to set.
     * @return This builder for chaining.
     */
    public Builder setReadOptions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReadOptionsIsMutable();
      readOptions_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @param value The readOptions to add.
     * @return This builder for chaining.
     */
    public Builder addReadOptions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReadOptionsIsMutable();
      readOptions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @param values The readOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllReadOptions(java.lang.Iterable<java.lang.String> values) {
      ensureReadOptionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, readOptions_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReadOptions() {
      readOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read options for this change stream query.
     * </pre>
     *
     * <code>repeated string read_options = 5;</code>
     *
     * @param value The bytes of the readOptions to add.
     * @return This builder for chaining.
     */
    public Builder addReadOptionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReadOptionsIsMutable();
      readOptions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int heartbeatMilliseconds_;
    /**
     *
     *
     * <pre>
     * Determines how frequently a heartbeat ChangeRecord will be returned in case
     * there are no transactions committed in this partition, in milliseconds.
     * </pre>
     *
     * <code>optional int32 heartbeat_milliseconds = 6;</code>
     *
     * @return Whether the heartbeatMilliseconds field is set.
     */
    @java.lang.Override
    public boolean hasHeartbeatMilliseconds() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Determines how frequently a heartbeat ChangeRecord will be returned in case
     * there are no transactions committed in this partition, in milliseconds.
     * </pre>
     *
     * <code>optional int32 heartbeat_milliseconds = 6;</code>
     *
     * @return The heartbeatMilliseconds.
     */
    @java.lang.Override
    public int getHeartbeatMilliseconds() {
      return heartbeatMilliseconds_;
    }
    /**
     *
     *
     * <pre>
     * Determines how frequently a heartbeat ChangeRecord will be returned in case
     * there are no transactions committed in this partition, in milliseconds.
     * </pre>
     *
     * <code>optional int32 heartbeat_milliseconds = 6;</code>
     *
     * @param value The heartbeatMilliseconds to set.
     * @return This builder for chaining.
     */
    public Builder setHeartbeatMilliseconds(int value) {

      heartbeatMilliseconds_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines how frequently a heartbeat ChangeRecord will be returned in case
     * there are no transactions committed in this partition, in milliseconds.
     * </pre>
     *
     * <code>optional int32 heartbeat_milliseconds = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeartbeatMilliseconds() {
      bitField0_ = (bitField0_ & ~0x00000020);
      heartbeatMilliseconds_ = 0;
      onChanged();
      return this;
    }

    private long deadlineSeconds_;
    /**
     *
     *
     * <pre>
     * Deadline for this change stream query, in seconds.
     * </pre>
     *
     * <code>optional int64 deadline_seconds = 7;</code>
     *
     * @return Whether the deadlineSeconds field is set.
     */
    @java.lang.Override
    public boolean hasDeadlineSeconds() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deadline for this change stream query, in seconds.
     * </pre>
     *
     * <code>optional int64 deadline_seconds = 7;</code>
     *
     * @return The deadlineSeconds.
     */
    @java.lang.Override
    public long getDeadlineSeconds() {
      return deadlineSeconds_;
    }
    /**
     *
     *
     * <pre>
     * Deadline for this change stream query, in seconds.
     * </pre>
     *
     * <code>optional int64 deadline_seconds = 7;</code>
     *
     * @param value The deadlineSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setDeadlineSeconds(long value) {

      deadlineSeconds_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deadline for this change stream query, in seconds.
     * </pre>
     *
     * <code>optional int64 deadline_seconds = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeadlineSeconds() {
      bitField0_ = (bitField0_ & ~0x00000040);
      deadlineSeconds_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object cloudDatabaseRole_ = "";
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. This should only be
     * set for cloud requests. Setting the database role will enforce additional
     * role-based access checks on this action.
     * </pre>
     *
     * <code>optional string cloud_database_role = 8;</code>
     *
     * @return Whether the cloudDatabaseRole field is set.
     */
    public boolean hasCloudDatabaseRole() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. This should only be
     * set for cloud requests. Setting the database role will enforce additional
     * role-based access checks on this action.
     * </pre>
     *
     * <code>optional string cloud_database_role = 8;</code>
     *
     * @return The cloudDatabaseRole.
     */
    public java.lang.String getCloudDatabaseRole() {
      java.lang.Object ref = cloudDatabaseRole_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudDatabaseRole_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. This should only be
     * set for cloud requests. Setting the database role will enforce additional
     * role-based access checks on this action.
     * </pre>
     *
     * <code>optional string cloud_database_role = 8;</code>
     *
     * @return The bytes for cloudDatabaseRole.
     */
    public com.google.protobuf.ByteString getCloudDatabaseRoleBytes() {
      java.lang.Object ref = cloudDatabaseRole_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudDatabaseRole_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. This should only be
     * set for cloud requests. Setting the database role will enforce additional
     * role-based access checks on this action.
     * </pre>
     *
     * <code>optional string cloud_database_role = 8;</code>
     *
     * @param value The cloudDatabaseRole to set.
     * @return This builder for chaining.
     */
    public Builder setCloudDatabaseRole(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudDatabaseRole_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. This should only be
     * set for cloud requests. Setting the database role will enforce additional
     * role-based access checks on this action.
     * </pre>
     *
     * <code>optional string cloud_database_role = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudDatabaseRole() {
      cloudDatabaseRole_ = getDefaultInstance().getCloudDatabaseRole();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database role to assume while performing this action. This should only be
     * set for cloud requests. Setting the database role will enforce additional
     * role-based access checks on this action.
     * </pre>
     *
     * <code>optional string cloud_database_role = 8;</code>
     *
     * @param value The bytes for cloudDatabaseRole to set.
     * @return This builder for chaining.
     */
    public Builder setCloudDatabaseRoleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudDatabaseRole_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.ExecuteChangeStreamQuery)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.ExecuteChangeStreamQuery)
  private static final com.google.spanner.executor.v1.ExecuteChangeStreamQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.ExecuteChangeStreamQuery();
  }

  public static com.google.spanner.executor.v1.ExecuteChangeStreamQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecuteChangeStreamQuery> PARSER =
      new com.google.protobuf.AbstractParser<ExecuteChangeStreamQuery>() {
        @java.lang.Override
        public ExecuteChangeStreamQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecuteChangeStreamQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecuteChangeStreamQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.ExecuteChangeStreamQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
