/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * An isolated set of Cloud Spanner resources that databases can define
 * placements on.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.InstancePartition}
 */
public final class InstancePartition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.InstancePartition)
    InstancePartitionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstancePartition.newBuilder() to construct.
  private InstancePartition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstancePartition() {
    name_ = "";
    config_ = "";
    displayName_ = "";
    state_ = 0;
    referencingDatabases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    referencingBackups_ = com.google.protobuf.LazyStringArrayList.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstancePartition();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_InstancePartition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_InstancePartition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.InstancePartition.class,
            com.google.spanner.admin.instance.v1.InstancePartition.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current state of the instance partition.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.admin.instance.v1.InstancePartition.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance partition is still being created. Resources may not be
     * available yet, and operations such as creating placements using this
     * instance partition may not work.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The instance partition is fully created and ready to do work such as
     * creating placements and using in databases.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance partition is still being created. Resources may not be
     * available yet, and operations such as creating placements using this
     * instance partition may not work.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The instance partition is fully created and ready to do work such as
     * creating placements and using in databases.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.InstancePartition.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.admin.instance.v1.InstancePartition.State)
  }

  private int bitField0_;
  private int computeCapacityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object computeCapacity_;

  public enum ComputeCapacityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NODE_COUNT(5),
    PROCESSING_UNITS(6),
    COMPUTECAPACITY_NOT_SET(0);
    private final int value;

    private ComputeCapacityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ComputeCapacityCase valueOf(int value) {
      return forNumber(value);
    }

    public static ComputeCapacityCase forNumber(int value) {
      switch (value) {
        case 5:
          return NODE_COUNT;
        case 6:
          return PROCESSING_UNITS;
        case 0:
          return COMPUTECAPACITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ComputeCapacityCase getComputeCapacityCase() {
    return ComputeCapacityCase.forNumber(computeCapacityCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for the instance partition. Values are of the
   * form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
   * The final segment of the name must be between 2 and 64 characters in
   * length. An instance partition's name cannot be changed after the instance
   * partition is created.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for the instance partition. Values are of the
   * form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
   * The final segment of the name must be between 2 and 64 characters in
   * length. An instance partition's name cannot be changed after the instance
   * partition is created.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object config_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the instance partition's configuration. Values are of
   * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
   * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
   * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
   * </pre>
   *
   * <code>
   * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public java.lang.String getConfig() {
    java.lang.Object ref = config_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      config_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the instance partition's configuration. Values are of
   * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
   * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
   * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
   * </pre>
   *
   * <code>
   * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for config.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConfigBytes() {
    java.lang.Object ref = config_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      config_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The descriptive name for this instance partition as it appears in
   * UIs. Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The descriptive name for this instance partition as it appears in
   * UIs. Must be unique per project and between 4 and 30 characters in length.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance partition.
   *
   * Users can set the node_count field to specify the target number of nodes
   * allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 node_count = 5;</code>
   *
   * @return Whether the nodeCount field is set.
   */
  @java.lang.Override
  public boolean hasNodeCount() {
    return computeCapacityCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this instance partition.
   *
   * Users can set the node_count field to specify the target number of nodes
   * allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 node_count = 5;</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    if (computeCapacityCase_ == 5) {
      return (java.lang.Integer) computeCapacity_;
    }
    return 0;
  }

  public static final int PROCESSING_UNITS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance partition.
   *
   * Users can set the processing_units field to specify the target number of
   * processing units allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 processing_units = 6;</code>
   *
   * @return Whether the processingUnits field is set.
   */
  @java.lang.Override
  public boolean hasProcessingUnits() {
    return computeCapacityCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The number of processing units allocated to this instance partition.
   *
   * Users can set the processing_units field to specify the target number of
   * processing units allocated to the instance partition.
   *
   * This may be zero in API responses for instance partitions that are not
   * yet in state `READY`.
   * </pre>
   *
   * <code>int32 processing_units = 6;</code>
   *
   * @return The processingUnits.
   */
  @java.lang.Override
  public int getProcessingUnits() {
    if (computeCapacityCase_ == 6) {
      return (java.lang.Integer) computeCapacity_;
    }
    return 0;
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current instance partition state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current instance partition state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstancePartition.State getState() {
    com.google.spanner.admin.instance.v1.InstancePartition.State result =
        com.google.spanner.admin.instance.v1.InstancePartition.State.forNumber(state_);
    return result == null
        ? com.google.spanner.admin.instance.v1.InstancePartition.State.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the instance partition was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int REFERENCING_DATABASES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencingDatabases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the referencingDatabases.
   */
  public com.google.protobuf.ProtocolStringList getReferencingDatabasesList() {
    return referencingDatabases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of referencingDatabases.
   */
  public int getReferencingDatabasesCount() {
    return referencingDatabases_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingDatabases at the given index.
   */
  public java.lang.String getReferencingDatabases(int index) {
    return referencingDatabases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the databases that reference this
   * instance partition. Referencing databases should share the parent instance.
   * The existence of any referencing database prevents the instance partition
   * from being deleted.
   * </pre>
   *
   * <code>repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingDatabases at the given index.
   */
  public com.google.protobuf.ByteString getReferencingDatabasesBytes(int index) {
    return referencingDatabases_.getByteString(index);
  }

  public static final int REFERENCING_BACKUPS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencingBackups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the referencingBackups.
   */
  public com.google.protobuf.ProtocolStringList getReferencingBackupsList() {
    return referencingBackups_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of referencingBackups.
   */
  public int getReferencingBackupsCount() {
    return referencingBackups_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingBackups at the given index.
   */
  public java.lang.String getReferencingBackups(int index) {
    return referencingBackups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the backups that reference this instance
   * partition. Referencing backups should share the parent instance. The
   * existence of any referencing backup prevents the instance partition from
   * being deleted.
   * </pre>
   *
   * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingBackups at the given index.
   */
  public com.google.protobuf.ByteString getReferencingBackupsBytes(int index) {
    return referencingBackups_.getByteString(index);
  }

  public static final int ETAG_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used for optimistic concurrency control as a way
   * to help prevent simultaneous updates of a instance partition from
   * overwriting each other. It is strongly suggested that systems make use of
   * the etag in the read-modify-write cycle to perform instance partition
   * updates in order to avoid race conditions: An etag is returned in the
   * response which contains instance partitions, and systems are expected to
   * put that etag in the request to update instance partitions to ensure that
   * their change will be applied to the same version of the instance partition.
   * If no etag is provided in the call to update instance partition, then the
   * existing instance partition is overwritten blindly.
   * </pre>
   *
   * <code>string etag = 12;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used for optimistic concurrency control as a way
   * to help prevent simultaneous updates of a instance partition from
   * overwriting each other. It is strongly suggested that systems make use of
   * the etag in the read-modify-write cycle to perform instance partition
   * updates in order to avoid race conditions: An etag is returned in the
   * response which contains instance partitions, and systems are expected to
   * put that etag in the request to update instance partitions to ensure that
   * their change will be applied to the same version of the instance partition.
   * If no etag is provided in the call to update instance partition, then the
   * existing instance partition is overwritten blindly.
   * </pre>
   *
   * <code>string etag = 12;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(config_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, config_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (computeCapacityCase_ == 5) {
      output.writeInt32(5, (int) ((java.lang.Integer) computeCapacity_));
    }
    if (computeCapacityCase_ == 6) {
      output.writeInt32(6, (int) ((java.lang.Integer) computeCapacity_));
    }
    if (state_
        != com.google.spanner.admin.instance.v1.InstancePartition.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    for (int i = 0; i < referencingDatabases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 10, referencingDatabases_.getRaw(i));
    }
    for (int i = 0; i < referencingBackups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, referencingBackups_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(config_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, config_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (computeCapacityCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              5, (int) ((java.lang.Integer) computeCapacity_));
    }
    if (computeCapacityCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              6, (int) ((java.lang.Integer) computeCapacity_));
    }
    if (state_
        != com.google.spanner.admin.instance.v1.InstancePartition.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencingDatabases_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencingDatabases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencingDatabasesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencingBackups_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencingBackups_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencingBackupsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.InstancePartition)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.InstancePartition other =
        (com.google.spanner.admin.instance.v1.InstancePartition) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getConfig().equals(other.getConfig())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getReferencingDatabasesList().equals(other.getReferencingDatabasesList())) return false;
    if (!getReferencingBackupsList().equals(other.getReferencingBackupsList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getComputeCapacityCase().equals(other.getComputeCapacityCase())) return false;
    switch (computeCapacityCase_) {
      case 5:
        if (getNodeCount() != other.getNodeCount()) return false;
        break;
      case 6:
        if (getProcessingUnits() != other.getProcessingUnits()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getConfig().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getReferencingDatabasesCount() > 0) {
      hash = (37 * hash) + REFERENCING_DATABASES_FIELD_NUMBER;
      hash = (53 * hash) + getReferencingDatabasesList().hashCode();
    }
    if (getReferencingBackupsCount() > 0) {
      hash = (37 * hash) + REFERENCING_BACKUPS_FIELD_NUMBER;
      hash = (53 * hash) + getReferencingBackupsList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    switch (computeCapacityCase_) {
      case 5:
        hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getNodeCount();
        break;
      case 6:
        hash = (37 * hash) + PROCESSING_UNITS_FIELD_NUMBER;
        hash = (53 * hash) + getProcessingUnits();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.instance.v1.InstancePartition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An isolated set of Cloud Spanner resources that databases can define
   * placements on.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.InstancePartition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.InstancePartition)
      com.google.spanner.admin.instance.v1.InstancePartitionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_InstancePartition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_InstancePartition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.InstancePartition.class,
              com.google.spanner.admin.instance.v1.InstancePartition.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.InstancePartition.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      config_ = "";
      displayName_ = "";
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      referencingDatabases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      referencingBackups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      etag_ = "";
      computeCapacityCase_ = 0;
      computeCapacity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_InstancePartition_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstancePartition getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.InstancePartition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstancePartition build() {
      com.google.spanner.admin.instance.v1.InstancePartition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstancePartition buildPartial() {
      com.google.spanner.admin.instance.v1.InstancePartition result =
          new com.google.spanner.admin.instance.v1.InstancePartition(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.instance.v1.InstancePartition result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = config_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        referencingDatabases_.makeImmutable();
        result.referencingDatabases_ = referencingDatabases_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        referencingBackups_.makeImmutable();
        result.referencingBackups_ = referencingBackups_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.admin.instance.v1.InstancePartition result) {
      result.computeCapacityCase_ = computeCapacityCase_;
      result.computeCapacity_ = this.computeCapacity_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.InstancePartition) {
        return mergeFrom((com.google.spanner.admin.instance.v1.InstancePartition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.instance.v1.InstancePartition other) {
      if (other == com.google.spanner.admin.instance.v1.InstancePartition.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getConfig().isEmpty()) {
        config_ = other.config_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.referencingDatabases_.isEmpty()) {
        if (referencingDatabases_.isEmpty()) {
          referencingDatabases_ = other.referencingDatabases_;
          bitField0_ |= 0x00000100;
        } else {
          ensureReferencingDatabasesIsMutable();
          referencingDatabases_.addAll(other.referencingDatabases_);
        }
        onChanged();
      }
      if (!other.referencingBackups_.isEmpty()) {
        if (referencingBackups_.isEmpty()) {
          referencingBackups_ = other.referencingBackups_;
          bitField0_ |= 0x00000200;
        } else {
          ensureReferencingBackupsIsMutable();
          referencingBackups_.addAll(other.referencingBackups_);
        }
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getComputeCapacityCase()) {
        case NODE_COUNT:
          {
            setNodeCount(other.getNodeCount());
            break;
          }
        case PROCESSING_UNITS:
          {
            setProcessingUnits(other.getProcessingUnits());
            break;
          }
        case COMPUTECAPACITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                config_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 40:
              {
                computeCapacity_ = input.readInt32();
                computeCapacityCase_ = 5;
                break;
              } // case 40
            case 48:
              {
                computeCapacity_ = input.readInt32();
                computeCapacityCase_ = 6;
                break;
              } // case 48
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencingDatabasesIsMutable();
                referencingDatabases_.add(s);
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencingBackupsIsMutable();
                referencingBackups_.add(s);
                break;
              } // case 90
            case 98:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int computeCapacityCase_ = 0;
    private java.lang.Object computeCapacity_;

    public ComputeCapacityCase getComputeCapacityCase() {
      return ComputeCapacityCase.forNumber(computeCapacityCase_);
    }

    public Builder clearComputeCapacity() {
      computeCapacityCase_ = 0;
      computeCapacity_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance partition. Values are of the
     * form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
     * The final segment of the name must be between 2 and 64 characters in
     * length. An instance partition's name cannot be changed after the instance
     * partition is created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance partition. Values are of the
     * form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
     * The final segment of the name must be between 2 and 64 characters in
     * length. An instance partition's name cannot be changed after the instance
     * partition is created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance partition. Values are of the
     * form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
     * The final segment of the name must be between 2 and 64 characters in
     * length. An instance partition's name cannot be changed after the instance
     * partition is created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance partition. Values are of the
     * form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
     * The final segment of the name must be between 2 and 64 characters in
     * length. An instance partition's name cannot be changed after the instance
     * partition is created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for the instance partition. Values are of the
     * form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
     * The final segment of the name must be between 2 and 64 characters in
     * length. An instance partition's name cannot be changed after the instance
     * partition is created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object config_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the instance partition's configuration. Values are of
     * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
     * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The config.
     */
    public java.lang.String getConfig() {
      java.lang.Object ref = config_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        config_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance partition's configuration. Values are of
     * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
     * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for config.
     */
    public com.google.protobuf.ByteString getConfigBytes() {
      java.lang.Object ref = config_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        config_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance partition's configuration. Values are of
     * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
     * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The config to set.
     * @return This builder for chaining.
     */
    public Builder setConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      config_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance partition's configuration. Values are of
     * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
     * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfig() {
      config_ = getDefaultInstance().getConfig();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance partition's configuration. Values are of
     * the form `projects/&lt;project&gt;/instanceConfigs/&lt;configuration&gt;`. See also
     * [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
     * [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
     * </pre>
     *
     * <code>
     * string config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for config to set.
     * @return This builder for chaining.
     */
    public Builder setConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      config_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance partition as it appears in
     * UIs. Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance partition as it appears in
     * UIs. Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance partition as it appears in
     * UIs. Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance partition as it appears in
     * UIs. Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The descriptive name for this instance partition as it appears in
     * UIs. Must be unique per project and between 4 and 30 characters in length.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance partition.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @return Whether the nodeCount field is set.
     */
    public boolean hasNodeCount() {
      return computeCapacityCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance partition.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @return The nodeCount.
     */
    public int getNodeCount() {
      if (computeCapacityCase_ == 5) {
        return (java.lang.Integer) computeCapacity_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance partition.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      computeCapacityCase_ = 5;
      computeCapacity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this instance partition.
     *
     * Users can set the node_count field to specify the target number of nodes
     * allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 node_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      if (computeCapacityCase_ == 5) {
        computeCapacityCase_ = 0;
        computeCapacity_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance partition.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 processing_units = 6;</code>
     *
     * @return Whether the processingUnits field is set.
     */
    public boolean hasProcessingUnits() {
      return computeCapacityCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance partition.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 processing_units = 6;</code>
     *
     * @return The processingUnits.
     */
    public int getProcessingUnits() {
      if (computeCapacityCase_ == 6) {
        return (java.lang.Integer) computeCapacity_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance partition.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 processing_units = 6;</code>
     *
     * @param value The processingUnits to set.
     * @return This builder for chaining.
     */
    public Builder setProcessingUnits(int value) {

      computeCapacityCase_ = 6;
      computeCapacity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of processing units allocated to this instance partition.
     *
     * Users can set the processing_units field to specify the target number of
     * processing units allocated to the instance partition.
     *
     * This may be zero in API responses for instance partitions that are not
     * yet in state `READY`.
     * </pre>
     *
     * <code>int32 processing_units = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessingUnits() {
      if (computeCapacityCase_ == 6) {
        computeCapacityCase_ = 0;
        computeCapacity_ = null;
        onChanged();
      }
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current instance partition state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance partition state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance partition state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstancePartition.State getState() {
      com.google.spanner.admin.instance.v1.InstancePartition.State result =
          com.google.spanner.admin.instance.v1.InstancePartition.State.forNumber(state_);
      return result == null
          ? com.google.spanner.admin.instance.v1.InstancePartition.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance partition state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.spanner.admin.instance.v1.InstancePartition.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current instance partition state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstancePartition.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the instance partition was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList referencingDatabases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencingDatabasesIsMutable() {
      if (!referencingDatabases_.isModifiable()) {
        referencingDatabases_ = new com.google.protobuf.LazyStringArrayList(referencingDatabases_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the referencingDatabases.
     */
    public com.google.protobuf.ProtocolStringList getReferencingDatabasesList() {
      referencingDatabases_.makeImmutable();
      return referencingDatabases_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of referencingDatabases.
     */
    public int getReferencingDatabasesCount() {
      return referencingDatabases_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencingDatabases at the given index.
     */
    public java.lang.String getReferencingDatabases(int index) {
      return referencingDatabases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencingDatabases at the given index.
     */
    public com.google.protobuf.ByteString getReferencingDatabasesBytes(int index) {
      return referencingDatabases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencingDatabases to set.
     * @return This builder for chaining.
     */
    public Builder setReferencingDatabases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingDatabasesIsMutable();
      referencingDatabases_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The referencingDatabases to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingDatabases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingDatabasesIsMutable();
      referencingDatabases_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The referencingDatabases to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencingDatabases(java.lang.Iterable<java.lang.String> values) {
      ensureReferencingDatabasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencingDatabases_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencingDatabases() {
      referencingDatabases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the databases that reference this
     * instance partition. Referencing databases should share the parent instance.
     * The existence of any referencing database prevents the instance partition
     * from being deleted.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the referencingDatabases to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingDatabasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencingDatabasesIsMutable();
      referencingDatabases_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList referencingBackups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencingBackupsIsMutable() {
      if (!referencingBackups_.isModifiable()) {
        referencingBackups_ = new com.google.protobuf.LazyStringArrayList(referencingBackups_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the referencingBackups.
     */
    public com.google.protobuf.ProtocolStringList getReferencingBackupsList() {
      referencingBackups_.makeImmutable();
      return referencingBackups_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of referencingBackups.
     */
    public int getReferencingBackupsCount() {
      return referencingBackups_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencingBackups at the given index.
     */
    public java.lang.String getReferencingBackups(int index) {
      return referencingBackups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencingBackups at the given index.
     */
    public com.google.protobuf.ByteString getReferencingBackupsBytes(int index) {
      return referencingBackups_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencingBackups to set.
     * @return This builder for chaining.
     */
    public Builder setReferencingBackups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingBackupsIsMutable();
      referencingBackups_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The referencingBackups to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingBackups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingBackupsIsMutable();
      referencingBackups_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The referencingBackups to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencingBackups(java.lang.Iterable<java.lang.String> values) {
      ensureReferencingBackupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencingBackups_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencingBackups() {
      referencingBackups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the backups that reference this instance
     * partition. Referencing backups should share the parent instance. The
     * existence of any referencing backup prevents the instance partition from
     * being deleted.
     * </pre>
     *
     * <code>repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the referencingBackups to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingBackupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencingBackupsIsMutable();
      referencingBackups_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used for optimistic concurrency control as a way
     * to help prevent simultaneous updates of a instance partition from
     * overwriting each other. It is strongly suggested that systems make use of
     * the etag in the read-modify-write cycle to perform instance partition
     * updates in order to avoid race conditions: An etag is returned in the
     * response which contains instance partitions, and systems are expected to
     * put that etag in the request to update instance partitions to ensure that
     * their change will be applied to the same version of the instance partition.
     * If no etag is provided in the call to update instance partition, then the
     * existing instance partition is overwritten blindly.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used for optimistic concurrency control as a way
     * to help prevent simultaneous updates of a instance partition from
     * overwriting each other. It is strongly suggested that systems make use of
     * the etag in the read-modify-write cycle to perform instance partition
     * updates in order to avoid race conditions: An etag is returned in the
     * response which contains instance partitions, and systems are expected to
     * put that etag in the request to update instance partitions to ensure that
     * their change will be applied to the same version of the instance partition.
     * If no etag is provided in the call to update instance partition, then the
     * existing instance partition is overwritten blindly.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used for optimistic concurrency control as a way
     * to help prevent simultaneous updates of a instance partition from
     * overwriting each other. It is strongly suggested that systems make use of
     * the etag in the read-modify-write cycle to perform instance partition
     * updates in order to avoid race conditions: An etag is returned in the
     * response which contains instance partitions, and systems are expected to
     * put that etag in the request to update instance partitions to ensure that
     * their change will be applied to the same version of the instance partition.
     * If no etag is provided in the call to update instance partition, then the
     * existing instance partition is overwritten blindly.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used for optimistic concurrency control as a way
     * to help prevent simultaneous updates of a instance partition from
     * overwriting each other. It is strongly suggested that systems make use of
     * the etag in the read-modify-write cycle to perform instance partition
     * updates in order to avoid race conditions: An etag is returned in the
     * response which contains instance partitions, and systems are expected to
     * put that etag in the request to update instance partitions to ensure that
     * their change will be applied to the same version of the instance partition.
     * If no etag is provided in the call to update instance partition, then the
     * existing instance partition is overwritten blindly.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used for optimistic concurrency control as a way
     * to help prevent simultaneous updates of a instance partition from
     * overwriting each other. It is strongly suggested that systems make use of
     * the etag in the read-modify-write cycle to perform instance partition
     * updates in order to avoid race conditions: An etag is returned in the
     * response which contains instance partitions, and systems are expected to
     * put that etag in the request to update instance partitions to ensure that
     * their change will be applied to the same version of the instance partition.
     * If no etag is provided in the call to update instance partition, then the
     * existing instance partition is overwritten blindly.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.InstancePartition)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.InstancePartition)
  private static final com.google.spanner.admin.instance.v1.InstancePartition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.InstancePartition();
  }

  public static com.google.spanner.admin.instance.v1.InstancePartition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstancePartition> PARSER =
      new com.google.protobuf.AbstractParser<InstancePartition>() {
        @java.lang.Override
        public InstancePartition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstancePartition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstancePartition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstancePartition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
