/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [AddSplitPoints][google.spanner.admin.database.v1.DatabaseAdmin.AddSplitPoints].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.AddSplitPointsRequest}
 */
public final class AddSplitPointsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.AddSplitPointsRequest)
    AddSplitPointsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AddSplitPointsRequest.newBuilder() to construct.
  private AddSplitPointsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AddSplitPointsRequest() {
    database_ = "";
    splitPoints_ = java.util.Collections.emptyList();
    initiator_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AddSplitPointsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_AddSplitPointsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_AddSplitPointsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.AddSplitPointsRequest.class,
            com.google.spanner.admin.database.v1.AddSplitPointsRequest.Builder.class);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * Required. The database on whose tables/indexes split points are to be
   * added. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * </pre>
   *
   * <code>
   * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The database on whose tables/indexes split points are to be
   * added. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * </pre>
   *
   * <code>
   * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPLIT_POINTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.SplitPoints> splitPoints_;

  /**
   *
   *
   * <pre>
   * Required. The split points to add.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.SplitPoints> getSplitPointsList() {
    return splitPoints_;
  }

  /**
   *
   *
   * <pre>
   * Required. The split points to add.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.SplitPointsOrBuilder>
      getSplitPointsOrBuilderList() {
    return splitPoints_;
  }

  /**
   *
   *
   * <pre>
   * Required. The split points to add.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getSplitPointsCount() {
    return splitPoints_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The split points to add.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.SplitPoints getSplitPoints(int index) {
    return splitPoints_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The split points to add.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.SplitPointsOrBuilder getSplitPointsOrBuilder(
      int index) {
    return splitPoints_.get(index);
  }

  public static final int INITIATOR_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object initiator_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A user-supplied tag associated with the split points.
   * For example, "intital_data_load", "special_event_1".
   * Defaults to "CloudAddSplitPointsAPI" if not specified.
   * The length of the tag must not exceed 50 characters,else will be trimmed.
   * Only valid UTF8 characters are allowed.
   * </pre>
   *
   * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The initiator.
   */
  @java.lang.Override
  public java.lang.String getInitiator() {
    java.lang.Object ref = initiator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      initiator_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-supplied tag associated with the split points.
   * For example, "intital_data_load", "special_event_1".
   * Defaults to "CloudAddSplitPointsAPI" if not specified.
   * The length of the tag must not exceed 50 characters,else will be trimmed.
   * Only valid UTF8 characters are allowed.
   * </pre>
   *
   * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for initiator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInitiatorBytes() {
    java.lang.Object ref = initiator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      initiator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    for (int i = 0; i < splitPoints_.size(); i++) {
      output.writeMessage(2, splitPoints_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(initiator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, initiator_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    for (int i = 0; i < splitPoints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, splitPoints_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(initiator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, initiator_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.AddSplitPointsRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.AddSplitPointsRequest other =
        (com.google.spanner.admin.database.v1.AddSplitPointsRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getSplitPointsList().equals(other.getSplitPointsList())) return false;
    if (!getInitiator().equals(other.getInitiator())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (getSplitPointsCount() > 0) {
      hash = (37 * hash) + SPLIT_POINTS_FIELD_NUMBER;
      hash = (53 * hash) + getSplitPointsList().hashCode();
    }
    hash = (37 * hash) + INITIATOR_FIELD_NUMBER;
    hash = (53 * hash) + getInitiator().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.AddSplitPointsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [AddSplitPoints][google.spanner.admin.database.v1.DatabaseAdmin.AddSplitPoints].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.AddSplitPointsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.AddSplitPointsRequest)
      com.google.spanner.admin.database.v1.AddSplitPointsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_AddSplitPointsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_AddSplitPointsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.AddSplitPointsRequest.class,
              com.google.spanner.admin.database.v1.AddSplitPointsRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.AddSplitPointsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      if (splitPointsBuilder_ == null) {
        splitPoints_ = java.util.Collections.emptyList();
      } else {
        splitPoints_ = null;
        splitPointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      initiator_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_AddSplitPointsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.AddSplitPointsRequest getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.AddSplitPointsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.AddSplitPointsRequest build() {
      com.google.spanner.admin.database.v1.AddSplitPointsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.AddSplitPointsRequest buildPartial() {
      com.google.spanner.admin.database.v1.AddSplitPointsRequest result =
          new com.google.spanner.admin.database.v1.AddSplitPointsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.admin.database.v1.AddSplitPointsRequest result) {
      if (splitPointsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          splitPoints_ = java.util.Collections.unmodifiableList(splitPoints_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.splitPoints_ = splitPoints_;
      } else {
        result.splitPoints_ = splitPointsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.AddSplitPointsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.initiator_ = initiator_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.AddSplitPointsRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.AddSplitPointsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.AddSplitPointsRequest other) {
      if (other == com.google.spanner.admin.database.v1.AddSplitPointsRequest.getDefaultInstance())
        return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (splitPointsBuilder_ == null) {
        if (!other.splitPoints_.isEmpty()) {
          if (splitPoints_.isEmpty()) {
            splitPoints_ = other.splitPoints_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSplitPointsIsMutable();
            splitPoints_.addAll(other.splitPoints_);
          }
          onChanged();
        }
      } else {
        if (!other.splitPoints_.isEmpty()) {
          if (splitPointsBuilder_.isEmpty()) {
            splitPointsBuilder_.dispose();
            splitPointsBuilder_ = null;
            splitPoints_ = other.splitPoints_;
            bitField0_ = (bitField0_ & ~0x00000002);
            splitPointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSplitPointsFieldBuilder()
                    : null;
          } else {
            splitPointsBuilder_.addAllMessages(other.splitPoints_);
          }
        }
      }
      if (!other.getInitiator().isEmpty()) {
        initiator_ = other.initiator_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.spanner.admin.database.v1.SplitPoints m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.SplitPoints.parser(),
                        extensionRegistry);
                if (splitPointsBuilder_ == null) {
                  ensureSplitPointsIsMutable();
                  splitPoints_.add(m);
                } else {
                  splitPointsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                initiator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * Required. The database on whose tables/indexes split points are to be
     * added. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The database on whose tables/indexes split points are to be
     * added. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The database on whose tables/indexes split points are to be
     * added. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The database on whose tables/indexes split points are to be
     * added. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The database on whose tables/indexes split points are to be
     * added. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.admin.database.v1.SplitPoints> splitPoints_ =
        java.util.Collections.emptyList();

    private void ensureSplitPointsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        splitPoints_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.SplitPoints>(splitPoints_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.SplitPoints,
            com.google.spanner.admin.database.v1.SplitPoints.Builder,
            com.google.spanner.admin.database.v1.SplitPointsOrBuilder>
        splitPointsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.SplitPoints> getSplitPointsList() {
      if (splitPointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(splitPoints_);
      } else {
        return splitPointsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getSplitPointsCount() {
      if (splitPointsBuilder_ == null) {
        return splitPoints_.size();
      } else {
        return splitPointsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints getSplitPoints(int index) {
      if (splitPointsBuilder_ == null) {
        return splitPoints_.get(index);
      } else {
        return splitPointsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSplitPoints(
        int index, com.google.spanner.admin.database.v1.SplitPoints value) {
      if (splitPointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSplitPointsIsMutable();
        splitPoints_.set(index, value);
        onChanged();
      } else {
        splitPointsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSplitPoints(
        int index, com.google.spanner.admin.database.v1.SplitPoints.Builder builderForValue) {
      if (splitPointsBuilder_ == null) {
        ensureSplitPointsIsMutable();
        splitPoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        splitPointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSplitPoints(com.google.spanner.admin.database.v1.SplitPoints value) {
      if (splitPointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSplitPointsIsMutable();
        splitPoints_.add(value);
        onChanged();
      } else {
        splitPointsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSplitPoints(
        int index, com.google.spanner.admin.database.v1.SplitPoints value) {
      if (splitPointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSplitPointsIsMutable();
        splitPoints_.add(index, value);
        onChanged();
      } else {
        splitPointsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSplitPoints(
        com.google.spanner.admin.database.v1.SplitPoints.Builder builderForValue) {
      if (splitPointsBuilder_ == null) {
        ensureSplitPointsIsMutable();
        splitPoints_.add(builderForValue.build());
        onChanged();
      } else {
        splitPointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSplitPoints(
        int index, com.google.spanner.admin.database.v1.SplitPoints.Builder builderForValue) {
      if (splitPointsBuilder_ == null) {
        ensureSplitPointsIsMutable();
        splitPoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        splitPointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllSplitPoints(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.SplitPoints> values) {
      if (splitPointsBuilder_ == null) {
        ensureSplitPointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, splitPoints_);
        onChanged();
      } else {
        splitPointsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSplitPoints() {
      if (splitPointsBuilder_ == null) {
        splitPoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        splitPointsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeSplitPoints(int index) {
      if (splitPointsBuilder_ == null) {
        ensureSplitPointsIsMutable();
        splitPoints_.remove(index);
        onChanged();
      } else {
        splitPointsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Builder getSplitPointsBuilder(
        int index) {
      return getSplitPointsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPointsOrBuilder getSplitPointsOrBuilder(
        int index) {
      if (splitPointsBuilder_ == null) {
        return splitPoints_.get(index);
      } else {
        return splitPointsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.SplitPointsOrBuilder>
        getSplitPointsOrBuilderList() {
      if (splitPointsBuilder_ != null) {
        return splitPointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(splitPoints_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Builder addSplitPointsBuilder() {
      return getSplitPointsFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.SplitPoints.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Builder addSplitPointsBuilder(
        int index) {
      return getSplitPointsFieldBuilder()
          .addBuilder(index, com.google.spanner.admin.database.v1.SplitPoints.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The split points to add.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints split_points = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.SplitPoints.Builder>
        getSplitPointsBuilderList() {
      return getSplitPointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.SplitPoints,
            com.google.spanner.admin.database.v1.SplitPoints.Builder,
            com.google.spanner.admin.database.v1.SplitPointsOrBuilder>
        getSplitPointsFieldBuilder() {
      if (splitPointsBuilder_ == null) {
        splitPointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.SplitPoints,
                com.google.spanner.admin.database.v1.SplitPoints.Builder,
                com.google.spanner.admin.database.v1.SplitPointsOrBuilder>(
                splitPoints_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        splitPoints_ = null;
      }
      return splitPointsBuilder_;
    }

    private java.lang.Object initiator_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A user-supplied tag associated with the split points.
     * For example, "intital_data_load", "special_event_1".
     * Defaults to "CloudAddSplitPointsAPI" if not specified.
     * The length of the tag must not exceed 50 characters,else will be trimmed.
     * Only valid UTF8 characters are allowed.
     * </pre>
     *
     * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The initiator.
     */
    public java.lang.String getInitiator() {
      java.lang.Object ref = initiator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        initiator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-supplied tag associated with the split points.
     * For example, "intital_data_load", "special_event_1".
     * Defaults to "CloudAddSplitPointsAPI" if not specified.
     * The length of the tag must not exceed 50 characters,else will be trimmed.
     * Only valid UTF8 characters are allowed.
     * </pre>
     *
     * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for initiator.
     */
    public com.google.protobuf.ByteString getInitiatorBytes() {
      java.lang.Object ref = initiator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        initiator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-supplied tag associated with the split points.
     * For example, "intital_data_load", "special_event_1".
     * Defaults to "CloudAddSplitPointsAPI" if not specified.
     * The length of the tag must not exceed 50 characters,else will be trimmed.
     * Only valid UTF8 characters are allowed.
     * </pre>
     *
     * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The initiator to set.
     * @return This builder for chaining.
     */
    public Builder setInitiator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      initiator_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-supplied tag associated with the split points.
     * For example, "intital_data_load", "special_event_1".
     * Defaults to "CloudAddSplitPointsAPI" if not specified.
     * The length of the tag must not exceed 50 characters,else will be trimmed.
     * Only valid UTF8 characters are allowed.
     * </pre>
     *
     * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInitiator() {
      initiator_ = getDefaultInstance().getInitiator();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-supplied tag associated with the split points.
     * For example, "intital_data_load", "special_event_1".
     * Defaults to "CloudAddSplitPointsAPI" if not specified.
     * The length of the tag must not exceed 50 characters,else will be trimmed.
     * Only valid UTF8 characters are allowed.
     * </pre>
     *
     * <code>string initiator = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for initiator to set.
     * @return This builder for chaining.
     */
    public Builder setInitiatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      initiator_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.AddSplitPointsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.AddSplitPointsRequest)
  private static final com.google.spanner.admin.database.v1.AddSplitPointsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.AddSplitPointsRequest();
  }

  public static com.google.spanner.admin.database.v1.AddSplitPointsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AddSplitPointsRequest> PARSER =
      new com.google.protobuf.AbstractParser<AddSplitPointsRequest>() {
        @java.lang.Override
        public AddSplitPointsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AddSplitPointsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AddSplitPointsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.AddSplitPointsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
