/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup_schedule.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * BackupSchedule expresses the automated backup creation specification for a
 * Spanner database.
 * Next ID: 10
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.BackupSchedule}
 */
public final class BackupSchedule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.BackupSchedule)
    BackupScheduleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackupSchedule.newBuilder() to construct.
  private BackupSchedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackupSchedule() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackupSchedule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupScheduleProto
        .internal_static_google_spanner_admin_database_v1_BackupSchedule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupScheduleProto
        .internal_static_google_spanner_admin_database_v1_BackupSchedule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.BackupSchedule.class,
            com.google.spanner.admin.database.v1.BackupSchedule.Builder.class);
  }

  private int bitField0_;
  private int backupTypeSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object backupTypeSpec_;

  public enum BackupTypeSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FULL_BACKUP_SPEC(7),
    INCREMENTAL_BACKUP_SPEC(8),
    BACKUPTYPESPEC_NOT_SET(0);
    private final int value;

    private BackupTypeSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BackupTypeSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static BackupTypeSpecCase forNumber(int value) {
      switch (value) {
        case 7:
          return FULL_BACKUP_SPEC;
        case 8:
          return INCREMENTAL_BACKUP_SPEC;
        case 0:
          return BACKUPTYPESPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BackupTypeSpecCase getBackupTypeSpecCase() {
    return BackupTypeSpecCase.forNumber(backupTypeSpecCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Output only for the
   * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
   * Required for the
   * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
   * operation. A globally unique identifier for the backup schedule which
   * cannot be changed. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
   * The final segment of the name must be between 2 and 60 characters in
   * length.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Output only for the
   * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
   * Required for the
   * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
   * operation. A globally unique identifier for the backup schedule which
   * cannot be changed. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
   * The final segment of the name must be between 2 and 60 characters in
   * length.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPEC_FIELD_NUMBER = 6;
  private com.google.spanner.admin.database.v1.BackupScheduleSpec spec_;
  /**
   *
   *
   * <pre>
   * Optional. The schedule specification based on which the backup creations
   * are triggered.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the spec field is set.
   */
  @java.lang.Override
  public boolean hasSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The schedule specification based on which the backup creations
   * are triggered.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spec.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupScheduleSpec getSpec() {
    return spec_ == null
        ? com.google.spanner.admin.database.v1.BackupScheduleSpec.getDefaultInstance()
        : spec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The schedule specification based on which the backup creations
   * are triggered.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupScheduleSpecOrBuilder getSpecOrBuilder() {
    return spec_ == null
        ? com.google.spanner.admin.database.v1.BackupScheduleSpec.getDefaultInstance()
        : spec_;
  }

  public static final int RETENTION_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration retentionDuration_;
  /**
   *
   *
   * <pre>
   * Optional. The retention duration of a backup that must be at least 6 hours
   * and at most 366 days. The backup is eligible to be automatically deleted
   * once the retention period has elapsed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retentionDuration field is set.
   */
  @java.lang.Override
  public boolean hasRetentionDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The retention duration of a backup that must be at least 6 hours
   * and at most 366 days. The backup is eligible to be automatically deleted
   * once the retention period has elapsed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retentionDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRetentionDuration() {
    return retentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : retentionDuration_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The retention duration of a backup that must be at least 6 hours
   * and at most 366 days. The backup is eligible to be automatically deleted
   * once the retention period has elapsed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
    return retentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : retentionDuration_;
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration that will be used to encrypt the
   * backup. If this field is not specified, the backup will use the same
   * encryption configuration as the database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration that will be used to encrypt the
   * backup. If this field is not specified, the backup will use the same
   * encryption configuration as the database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration that will be used to encrypt the
   * backup. If this field is not specified, the backup will use the same
   * encryption configuration as the database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.CreateBackupEncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  public static final int FULL_BACKUP_SPEC_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The schedule creates only full backups.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
   *
   * @return Whether the fullBackupSpec field is set.
   */
  @java.lang.Override
  public boolean hasFullBackupSpec() {
    return backupTypeSpecCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The schedule creates only full backups.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
   *
   * @return The fullBackupSpec.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.FullBackupSpec getFullBackupSpec() {
    if (backupTypeSpecCase_ == 7) {
      return (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_;
    }
    return com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The schedule creates only full backups.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.FullBackupSpecOrBuilder getFullBackupSpecOrBuilder() {
    if (backupTypeSpecCase_ == 7) {
      return (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_;
    }
    return com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance();
  }

  public static final int INCREMENTAL_BACKUP_SPEC_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The schedule creates incremental backup chains.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
   * </code>
   *
   * @return Whether the incrementalBackupSpec field is set.
   */
  @java.lang.Override
  public boolean hasIncrementalBackupSpec() {
    return backupTypeSpecCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The schedule creates incremental backup chains.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
   * </code>
   *
   * @return The incrementalBackupSpec.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.IncrementalBackupSpec getIncrementalBackupSpec() {
    if (backupTypeSpecCase_ == 8) {
      return (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_;
    }
    return com.google.spanner.admin.database.v1.IncrementalBackupSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The schedule creates incremental backup chains.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.IncrementalBackupSpecOrBuilder
      getIncrementalBackupSpecOrBuilder() {
    if (backupTypeSpecCase_ == 8) {
      return (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_;
    }
    return com.google.spanner.admin.database.v1.IncrementalBackupSpec.getDefaultInstance();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which the schedule was last updated.
   * If the schedule has never been updated, this field contains the timestamp
   * when the schedule was first created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which the schedule was last updated.
   * If the schedule has never been updated, this field contains the timestamp
   * when the schedule was first created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which the schedule was last updated.
   * If the schedule has never been updated, this field contains the timestamp
   * when the schedule was first created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getRetentionDuration());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getEncryptionConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getSpec());
    }
    if (backupTypeSpecCase_ == 7) {
      output.writeMessage(7, (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_);
    }
    if (backupTypeSpecCase_ == 8) {
      output.writeMessage(
          8, (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRetentionDuration());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEncryptionConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSpec());
    }
    if (backupTypeSpecCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_);
    }
    if (backupTypeSpecCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.BackupSchedule)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.BackupSchedule other =
        (com.google.spanner.admin.database.v1.BackupSchedule) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSpec() != other.hasSpec()) return false;
    if (hasSpec()) {
      if (!getSpec().equals(other.getSpec())) return false;
    }
    if (hasRetentionDuration() != other.hasRetentionDuration()) return false;
    if (hasRetentionDuration()) {
      if (!getRetentionDuration().equals(other.getRetentionDuration())) return false;
    }
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getBackupTypeSpecCase().equals(other.getBackupTypeSpecCase())) return false;
    switch (backupTypeSpecCase_) {
      case 7:
        if (!getFullBackupSpec().equals(other.getFullBackupSpec())) return false;
        break;
      case 8:
        if (!getIncrementalBackupSpec().equals(other.getIncrementalBackupSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSpec()) {
      hash = (37 * hash) + SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSpec().hashCode();
    }
    if (hasRetentionDuration()) {
      hash = (37 * hash) + RETENTION_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getRetentionDuration().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (backupTypeSpecCase_) {
      case 7:
        hash = (37 * hash) + FULL_BACKUP_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getFullBackupSpec().hashCode();
        break;
      case 8:
        hash = (37 * hash) + INCREMENTAL_BACKUP_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getIncrementalBackupSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.BackupSchedule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * BackupSchedule expresses the automated backup creation specification for a
   * Spanner database.
   * Next ID: 10
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.BackupSchedule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.BackupSchedule)
      com.google.spanner.admin.database.v1.BackupScheduleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupScheduleProto
          .internal_static_google_spanner_admin_database_v1_BackupSchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupScheduleProto
          .internal_static_google_spanner_admin_database_v1_BackupSchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.BackupSchedule.class,
              com.google.spanner.admin.database.v1.BackupSchedule.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.BackupSchedule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpecFieldBuilder();
        getRetentionDurationFieldBuilder();
        getEncryptionConfigFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      spec_ = null;
      if (specBuilder_ != null) {
        specBuilder_.dispose();
        specBuilder_ = null;
      }
      retentionDuration_ = null;
      if (retentionDurationBuilder_ != null) {
        retentionDurationBuilder_.dispose();
        retentionDurationBuilder_ = null;
      }
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      if (fullBackupSpecBuilder_ != null) {
        fullBackupSpecBuilder_.clear();
      }
      if (incrementalBackupSpecBuilder_ != null) {
        incrementalBackupSpecBuilder_.clear();
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      backupTypeSpecCase_ = 0;
      backupTypeSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupScheduleProto
          .internal_static_google_spanner_admin_database_v1_BackupSchedule_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupSchedule getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.BackupSchedule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupSchedule build() {
      com.google.spanner.admin.database.v1.BackupSchedule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupSchedule buildPartial() {
      com.google.spanner.admin.database.v1.BackupSchedule result =
          new com.google.spanner.admin.database.v1.BackupSchedule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.BackupSchedule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.spec_ = specBuilder_ == null ? spec_ : specBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.retentionDuration_ =
            retentionDurationBuilder_ == null
                ? retentionDuration_
                : retentionDurationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.admin.database.v1.BackupSchedule result) {
      result.backupTypeSpecCase_ = backupTypeSpecCase_;
      result.backupTypeSpec_ = this.backupTypeSpec_;
      if (backupTypeSpecCase_ == 7 && fullBackupSpecBuilder_ != null) {
        result.backupTypeSpec_ = fullBackupSpecBuilder_.build();
      }
      if (backupTypeSpecCase_ == 8 && incrementalBackupSpecBuilder_ != null) {
        result.backupTypeSpec_ = incrementalBackupSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.BackupSchedule) {
        return mergeFrom((com.google.spanner.admin.database.v1.BackupSchedule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.BackupSchedule other) {
      if (other == com.google.spanner.admin.database.v1.BackupSchedule.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSpec()) {
        mergeSpec(other.getSpec());
      }
      if (other.hasRetentionDuration()) {
        mergeRetentionDuration(other.getRetentionDuration());
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getBackupTypeSpecCase()) {
        case FULL_BACKUP_SPEC:
          {
            mergeFullBackupSpec(other.getFullBackupSpec());
            break;
          }
        case INCREMENTAL_BACKUP_SPEC:
          {
            mergeIncrementalBackupSpec(other.getIncrementalBackupSpec());
            break;
          }
        case BACKUPTYPESPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getFullBackupSpecFieldBuilder().getBuilder(), extensionRegistry);
                backupTypeSpecCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getIncrementalBackupSpecFieldBuilder().getBuilder(), extensionRegistry);
                backupTypeSpecCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int backupTypeSpecCase_ = 0;
    private java.lang.Object backupTypeSpec_;

    public BackupTypeSpecCase getBackupTypeSpecCase() {
      return BackupTypeSpecCase.forNumber(backupTypeSpecCase_);
    }

    public Builder clearBackupTypeSpec() {
      backupTypeSpecCase_ = 0;
      backupTypeSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Output only for the
     * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
     * Required for the
     * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
     * operation. A globally unique identifier for the backup schedule which
     * cannot be changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters in
     * length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Output only for the
     * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
     * Required for the
     * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
     * operation. A globally unique identifier for the backup schedule which
     * cannot be changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters in
     * length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Output only for the
     * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
     * Required for the
     * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
     * operation. A globally unique identifier for the backup schedule which
     * cannot be changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters in
     * length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Output only for the
     * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
     * Required for the
     * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
     * operation. A globally unique identifier for the backup schedule which
     * cannot be changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters in
     * length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Output only for the
     * [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
     * Required for the
     * [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
     * operation. A globally unique identifier for the backup schedule which
     * cannot be changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/backupSchedules/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters in
     * length.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.BackupScheduleSpec spec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.BackupScheduleSpec,
            com.google.spanner.admin.database.v1.BackupScheduleSpec.Builder,
            com.google.spanner.admin.database.v1.BackupScheduleSpecOrBuilder>
        specBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the spec field is set.
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The spec.
     */
    public com.google.spanner.admin.database.v1.BackupScheduleSpec getSpec() {
      if (specBuilder_ == null) {
        return spec_ == null
            ? com.google.spanner.admin.database.v1.BackupScheduleSpec.getDefaultInstance()
            : spec_;
      } else {
        return specBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpec(com.google.spanner.admin.database.v1.BackupScheduleSpec value) {
      if (specBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
      } else {
        specBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpec(
        com.google.spanner.admin.database.v1.BackupScheduleSpec.Builder builderForValue) {
      if (specBuilder_ == null) {
        spec_ = builderForValue.build();
      } else {
        specBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpec(com.google.spanner.admin.database.v1.BackupScheduleSpec value) {
      if (specBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && spec_ != null
            && spec_
                != com.google.spanner.admin.database.v1.BackupScheduleSpec.getDefaultInstance()) {
          getSpecBuilder().mergeFrom(value);
        } else {
          spec_ = value;
        }
      } else {
        specBuilder_.mergeFrom(value);
      }
      if (spec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      spec_ = null;
      if (specBuilder_ != null) {
        specBuilder_.dispose();
        specBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.BackupScheduleSpec.Builder getSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.BackupScheduleSpecOrBuilder getSpecOrBuilder() {
      if (specBuilder_ != null) {
        return specBuilder_.getMessageOrBuilder();
      } else {
        return spec_ == null
            ? com.google.spanner.admin.database.v1.BackupScheduleSpec.getDefaultInstance()
            : spec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schedule specification based on which the backup creations
     * are triggered.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.BackupScheduleSpec spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.BackupScheduleSpec,
            com.google.spanner.admin.database.v1.BackupScheduleSpec.Builder,
            com.google.spanner.admin.database.v1.BackupScheduleSpecOrBuilder>
        getSpecFieldBuilder() {
      if (specBuilder_ == null) {
        specBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.BackupScheduleSpec,
                com.google.spanner.admin.database.v1.BackupScheduleSpec.Builder,
                com.google.spanner.admin.database.v1.BackupScheduleSpecOrBuilder>(
                getSpec(), getParentForChildren(), isClean());
        spec_ = null;
      }
      return specBuilder_;
    }

    private com.google.protobuf.Duration retentionDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        retentionDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retentionDuration field is set.
     */
    public boolean hasRetentionDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retentionDuration.
     */
    public com.google.protobuf.Duration getRetentionDuration() {
      if (retentionDurationBuilder_ == null) {
        return retentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : retentionDuration_;
      } else {
        return retentionDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetentionDuration(com.google.protobuf.Duration value) {
      if (retentionDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retentionDuration_ = value;
      } else {
        retentionDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetentionDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (retentionDurationBuilder_ == null) {
        retentionDuration_ = builderForValue.build();
      } else {
        retentionDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRetentionDuration(com.google.protobuf.Duration value) {
      if (retentionDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && retentionDuration_ != null
            && retentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getRetentionDurationBuilder().mergeFrom(value);
        } else {
          retentionDuration_ = value;
        }
      } else {
        retentionDurationBuilder_.mergeFrom(value);
      }
      if (retentionDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRetentionDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      retentionDuration_ = null;
      if (retentionDurationBuilder_ != null) {
        retentionDurationBuilder_.dispose();
        retentionDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getRetentionDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRetentionDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
      if (retentionDurationBuilder_ != null) {
        return retentionDurationBuilder_.getMessageOrBuilder();
      } else {
        return retentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : retentionDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The retention duration of a backup that must be at least 6 hours
     * and at most 366 days. The backup is eligible to be automatically deleted
     * once the retention period has elapsed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRetentionDurationFieldBuilder() {
      if (retentionDurationBuilder_ == null) {
        retentionDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getRetentionDuration(), getParentForChildren(), isClean());
        retentionDuration_ = null;
      }
      return retentionDurationBuilder_;
    }

    private com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig,
            com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.CreateBackupEncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig
                    .getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.CreateBackupEncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration that will be used to encrypt the
     * backup. If this field is not specified, the backup will use the same
     * encryption configuration as the database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig,
            com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.CreateBackupEncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig,
                com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.CreateBackupEncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.FullBackupSpec,
            com.google.spanner.admin.database.v1.FullBackupSpec.Builder,
            com.google.spanner.admin.database.v1.FullBackupSpecOrBuilder>
        fullBackupSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     *
     * @return Whether the fullBackupSpec field is set.
     */
    @java.lang.Override
    public boolean hasFullBackupSpec() {
      return backupTypeSpecCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     *
     * @return The fullBackupSpec.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.FullBackupSpec getFullBackupSpec() {
      if (fullBackupSpecBuilder_ == null) {
        if (backupTypeSpecCase_ == 7) {
          return (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_;
        }
        return com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance();
      } else {
        if (backupTypeSpecCase_ == 7) {
          return fullBackupSpecBuilder_.getMessage();
        }
        return com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    public Builder setFullBackupSpec(com.google.spanner.admin.database.v1.FullBackupSpec value) {
      if (fullBackupSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backupTypeSpec_ = value;
        onChanged();
      } else {
        fullBackupSpecBuilder_.setMessage(value);
      }
      backupTypeSpecCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    public Builder setFullBackupSpec(
        com.google.spanner.admin.database.v1.FullBackupSpec.Builder builderForValue) {
      if (fullBackupSpecBuilder_ == null) {
        backupTypeSpec_ = builderForValue.build();
        onChanged();
      } else {
        fullBackupSpecBuilder_.setMessage(builderForValue.build());
      }
      backupTypeSpecCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    public Builder mergeFullBackupSpec(com.google.spanner.admin.database.v1.FullBackupSpec value) {
      if (fullBackupSpecBuilder_ == null) {
        if (backupTypeSpecCase_ == 7
            && backupTypeSpec_
                != com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance()) {
          backupTypeSpec_ =
              com.google.spanner.admin.database.v1.FullBackupSpec.newBuilder(
                      (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backupTypeSpec_ = value;
        }
        onChanged();
      } else {
        if (backupTypeSpecCase_ == 7) {
          fullBackupSpecBuilder_.mergeFrom(value);
        } else {
          fullBackupSpecBuilder_.setMessage(value);
        }
      }
      backupTypeSpecCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    public Builder clearFullBackupSpec() {
      if (fullBackupSpecBuilder_ == null) {
        if (backupTypeSpecCase_ == 7) {
          backupTypeSpecCase_ = 0;
          backupTypeSpec_ = null;
          onChanged();
        }
      } else {
        if (backupTypeSpecCase_ == 7) {
          backupTypeSpecCase_ = 0;
          backupTypeSpec_ = null;
        }
        fullBackupSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    public com.google.spanner.admin.database.v1.FullBackupSpec.Builder getFullBackupSpecBuilder() {
      return getFullBackupSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.FullBackupSpecOrBuilder
        getFullBackupSpecOrBuilder() {
      if ((backupTypeSpecCase_ == 7) && (fullBackupSpecBuilder_ != null)) {
        return fullBackupSpecBuilder_.getMessageOrBuilder();
      } else {
        if (backupTypeSpecCase_ == 7) {
          return (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_;
        }
        return com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedule creates only full backups.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.FullBackupSpec full_backup_spec = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.FullBackupSpec,
            com.google.spanner.admin.database.v1.FullBackupSpec.Builder,
            com.google.spanner.admin.database.v1.FullBackupSpecOrBuilder>
        getFullBackupSpecFieldBuilder() {
      if (fullBackupSpecBuilder_ == null) {
        if (!(backupTypeSpecCase_ == 7)) {
          backupTypeSpec_ =
              com.google.spanner.admin.database.v1.FullBackupSpec.getDefaultInstance();
        }
        fullBackupSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.FullBackupSpec,
                com.google.spanner.admin.database.v1.FullBackupSpec.Builder,
                com.google.spanner.admin.database.v1.FullBackupSpecOrBuilder>(
                (com.google.spanner.admin.database.v1.FullBackupSpec) backupTypeSpec_,
                getParentForChildren(),
                isClean());
        backupTypeSpec_ = null;
      }
      backupTypeSpecCase_ = 7;
      onChanged();
      return fullBackupSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.IncrementalBackupSpec,
            com.google.spanner.admin.database.v1.IncrementalBackupSpec.Builder,
            com.google.spanner.admin.database.v1.IncrementalBackupSpecOrBuilder>
        incrementalBackupSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     *
     * @return Whether the incrementalBackupSpec field is set.
     */
    @java.lang.Override
    public boolean hasIncrementalBackupSpec() {
      return backupTypeSpecCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     *
     * @return The incrementalBackupSpec.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.IncrementalBackupSpec getIncrementalBackupSpec() {
      if (incrementalBackupSpecBuilder_ == null) {
        if (backupTypeSpecCase_ == 8) {
          return (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_;
        }
        return com.google.spanner.admin.database.v1.IncrementalBackupSpec.getDefaultInstance();
      } else {
        if (backupTypeSpecCase_ == 8) {
          return incrementalBackupSpecBuilder_.getMessage();
        }
        return com.google.spanner.admin.database.v1.IncrementalBackupSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    public Builder setIncrementalBackupSpec(
        com.google.spanner.admin.database.v1.IncrementalBackupSpec value) {
      if (incrementalBackupSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backupTypeSpec_ = value;
        onChanged();
      } else {
        incrementalBackupSpecBuilder_.setMessage(value);
      }
      backupTypeSpecCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    public Builder setIncrementalBackupSpec(
        com.google.spanner.admin.database.v1.IncrementalBackupSpec.Builder builderForValue) {
      if (incrementalBackupSpecBuilder_ == null) {
        backupTypeSpec_ = builderForValue.build();
        onChanged();
      } else {
        incrementalBackupSpecBuilder_.setMessage(builderForValue.build());
      }
      backupTypeSpecCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    public Builder mergeIncrementalBackupSpec(
        com.google.spanner.admin.database.v1.IncrementalBackupSpec value) {
      if (incrementalBackupSpecBuilder_ == null) {
        if (backupTypeSpecCase_ == 8
            && backupTypeSpec_
                != com.google.spanner.admin.database.v1.IncrementalBackupSpec
                    .getDefaultInstance()) {
          backupTypeSpec_ =
              com.google.spanner.admin.database.v1.IncrementalBackupSpec.newBuilder(
                      (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backupTypeSpec_ = value;
        }
        onChanged();
      } else {
        if (backupTypeSpecCase_ == 8) {
          incrementalBackupSpecBuilder_.mergeFrom(value);
        } else {
          incrementalBackupSpecBuilder_.setMessage(value);
        }
      }
      backupTypeSpecCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    public Builder clearIncrementalBackupSpec() {
      if (incrementalBackupSpecBuilder_ == null) {
        if (backupTypeSpecCase_ == 8) {
          backupTypeSpecCase_ = 0;
          backupTypeSpec_ = null;
          onChanged();
        }
      } else {
        if (backupTypeSpecCase_ == 8) {
          backupTypeSpecCase_ = 0;
          backupTypeSpec_ = null;
        }
        incrementalBackupSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    public com.google.spanner.admin.database.v1.IncrementalBackupSpec.Builder
        getIncrementalBackupSpecBuilder() {
      return getIncrementalBackupSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.IncrementalBackupSpecOrBuilder
        getIncrementalBackupSpecOrBuilder() {
      if ((backupTypeSpecCase_ == 8) && (incrementalBackupSpecBuilder_ != null)) {
        return incrementalBackupSpecBuilder_.getMessageOrBuilder();
      } else {
        if (backupTypeSpecCase_ == 8) {
          return (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_;
        }
        return com.google.spanner.admin.database.v1.IncrementalBackupSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedule creates incremental backup chains.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.IncrementalBackupSpec incremental_backup_spec = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.IncrementalBackupSpec,
            com.google.spanner.admin.database.v1.IncrementalBackupSpec.Builder,
            com.google.spanner.admin.database.v1.IncrementalBackupSpecOrBuilder>
        getIncrementalBackupSpecFieldBuilder() {
      if (incrementalBackupSpecBuilder_ == null) {
        if (!(backupTypeSpecCase_ == 8)) {
          backupTypeSpec_ =
              com.google.spanner.admin.database.v1.IncrementalBackupSpec.getDefaultInstance();
        }
        incrementalBackupSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.IncrementalBackupSpec,
                com.google.spanner.admin.database.v1.IncrementalBackupSpec.Builder,
                com.google.spanner.admin.database.v1.IncrementalBackupSpecOrBuilder>(
                (com.google.spanner.admin.database.v1.IncrementalBackupSpec) backupTypeSpec_,
                getParentForChildren(),
                isClean());
        backupTypeSpec_ = null;
      }
      backupTypeSpecCase_ = 8;
      onChanged();
      return incrementalBackupSpecBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which the schedule was last updated.
     * If the schedule has never been updated, this field contains the timestamp
     * when the schedule was first created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.BackupSchedule)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.BackupSchedule)
  private static final com.google.spanner.admin.database.v1.BackupSchedule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.BackupSchedule();
  }

  public static com.google.spanner.admin.database.v1.BackupSchedule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackupSchedule> PARSER =
      new com.google.protobuf.AbstractParser<BackupSchedule>() {
        @java.lang.Override
        public BackupSchedule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackupSchedule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackupSchedule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupSchedule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
