/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.optimization.v1;

import com.google.cloud.optimization.v1.CapacityQuantity;
import com.google.cloud.optimization.v1.CapacityQuantityOrBuilder;
import com.google.cloud.optimization.v1.FleetRoutingProto;
import com.google.cloud.optimization.v1.ShipmentOrBuilder;
import com.google.cloud.optimization.v1.TimeWindow;
import com.google.cloud.optimization.v1.TimeWindowOrBuilder;
import com.google.cloud.optimization.v1.Waypoint;
import com.google.cloud.optimization.v1.WaypointOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldBuilder;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Shipment
extends GeneratedMessageV3
implements ShipmentOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int PICKUPS_FIELD_NUMBER = 1;
    private List<VisitRequest> pickups_;
    public static final int DELIVERIES_FIELD_NUMBER = 2;
    private List<VisitRequest> deliveries_;
    public static final int LOAD_DEMANDS_FIELD_NUMBER = 14;
    private MapField<String, Load> loadDemands_;
    public static final int PENALTY_COST_FIELD_NUMBER = 4;
    private double penaltyCost_ = 0.0;
    public static final int ALLOWED_VEHICLE_INDICES_FIELD_NUMBER = 5;
    private Internal.IntList allowedVehicleIndices_ = Shipment.emptyIntList();
    private int allowedVehicleIndicesMemoizedSerializedSize = -1;
    public static final int COSTS_PER_VEHICLE_FIELD_NUMBER = 6;
    private Internal.DoubleList costsPerVehicle_ = Shipment.emptyDoubleList();
    private int costsPerVehicleMemoizedSerializedSize = -1;
    public static final int COSTS_PER_VEHICLE_INDICES_FIELD_NUMBER = 7;
    private Internal.IntList costsPerVehicleIndices_ = Shipment.emptyIntList();
    private int costsPerVehicleIndicesMemoizedSerializedSize = -1;
    public static final int PICKUP_TO_DELIVERY_RELATIVE_DETOUR_LIMIT_FIELD_NUMBER = 8;
    private double pickupToDeliveryRelativeDetourLimit_ = 0.0;
    public static final int PICKUP_TO_DELIVERY_ABSOLUTE_DETOUR_LIMIT_FIELD_NUMBER = 9;
    private Duration pickupToDeliveryAbsoluteDetourLimit_;
    public static final int PICKUP_TO_DELIVERY_TIME_LIMIT_FIELD_NUMBER = 10;
    private Duration pickupToDeliveryTimeLimit_;
    public static final int SHIPMENT_TYPE_FIELD_NUMBER = 11;
    private volatile Object shipmentType_ = "";
    public static final int LABEL_FIELD_NUMBER = 12;
    private volatile Object label_ = "";
    public static final int IGNORE_FIELD_NUMBER = 13;
    private boolean ignore_ = false;
    public static final int DEMANDS_FIELD_NUMBER = 3;
    private List<CapacityQuantity> demands_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Shipment DEFAULT_INSTANCE = new Shipment();
    private static final Parser<Shipment> PARSER = new AbstractParser<Shipment>(){

        public Shipment parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Shipment.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Shipment(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Shipment() {
        this.pickups_ = Collections.emptyList();
        this.deliveries_ = Collections.emptyList();
        this.allowedVehicleIndices_ = Shipment.emptyIntList();
        this.costsPerVehicle_ = Shipment.emptyDoubleList();
        this.costsPerVehicleIndices_ = Shipment.emptyIntList();
        this.shipmentType_ = "";
        this.label_ = "";
        this.demands_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Shipment();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 14: {
                return this.internalGetLoadDemands();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_fieldAccessorTable.ensureFieldAccessorsInitialized(Shipment.class, Builder.class);
    }

    @Override
    public List<VisitRequest> getPickupsList() {
        return this.pickups_;
    }

    @Override
    public List<? extends VisitRequestOrBuilder> getPickupsOrBuilderList() {
        return this.pickups_;
    }

    @Override
    public int getPickupsCount() {
        return this.pickups_.size();
    }

    @Override
    public VisitRequest getPickups(int index) {
        return this.pickups_.get(index);
    }

    @Override
    public VisitRequestOrBuilder getPickupsOrBuilder(int index) {
        return this.pickups_.get(index);
    }

    @Override
    public List<VisitRequest> getDeliveriesList() {
        return this.deliveries_;
    }

    @Override
    public List<? extends VisitRequestOrBuilder> getDeliveriesOrBuilderList() {
        return this.deliveries_;
    }

    @Override
    public int getDeliveriesCount() {
        return this.deliveries_.size();
    }

    @Override
    public VisitRequest getDeliveries(int index) {
        return this.deliveries_.get(index);
    }

    @Override
    public VisitRequestOrBuilder getDeliveriesOrBuilder(int index) {
        return this.deliveries_.get(index);
    }

    private MapField<String, Load> internalGetLoadDemands() {
        if (this.loadDemands_ == null) {
            return MapField.emptyMapField(LoadDemandsDefaultEntryHolder.defaultEntry);
        }
        return this.loadDemands_;
    }

    @Override
    public int getLoadDemandsCount() {
        return this.internalGetLoadDemands().getMap().size();
    }

    @Override
    public boolean containsLoadDemands(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLoadDemands().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, Load> getLoadDemands() {
        return this.getLoadDemandsMap();
    }

    @Override
    public Map<String, Load> getLoadDemandsMap() {
        return this.internalGetLoadDemands().getMap();
    }

    @Override
    public Load getLoadDemandsOrDefault(String key, Load defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLoadDemands().getMap();
        return map.containsKey(key) ? (Load)map.get(key) : defaultValue;
    }

    @Override
    public Load getLoadDemandsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLoadDemands().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (Load)map.get(key);
    }

    @Override
    public boolean hasPenaltyCost() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public double getPenaltyCost() {
        return this.penaltyCost_;
    }

    @Override
    public List<Integer> getAllowedVehicleIndicesList() {
        return this.allowedVehicleIndices_;
    }

    @Override
    public int getAllowedVehicleIndicesCount() {
        return this.allowedVehicleIndices_.size();
    }

    @Override
    public int getAllowedVehicleIndices(int index) {
        return this.allowedVehicleIndices_.getInt(index);
    }

    @Override
    public List<Double> getCostsPerVehicleList() {
        return this.costsPerVehicle_;
    }

    @Override
    public int getCostsPerVehicleCount() {
        return this.costsPerVehicle_.size();
    }

    @Override
    public double getCostsPerVehicle(int index) {
        return this.costsPerVehicle_.getDouble(index);
    }

    @Override
    public List<Integer> getCostsPerVehicleIndicesList() {
        return this.costsPerVehicleIndices_;
    }

    @Override
    public int getCostsPerVehicleIndicesCount() {
        return this.costsPerVehicleIndices_.size();
    }

    @Override
    public int getCostsPerVehicleIndices(int index) {
        return this.costsPerVehicleIndices_.getInt(index);
    }

    @Override
    public boolean hasPickupToDeliveryRelativeDetourLimit() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public double getPickupToDeliveryRelativeDetourLimit() {
        return this.pickupToDeliveryRelativeDetourLimit_;
    }

    @Override
    public boolean hasPickupToDeliveryAbsoluteDetourLimit() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Duration getPickupToDeliveryAbsoluteDetourLimit() {
        return this.pickupToDeliveryAbsoluteDetourLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryAbsoluteDetourLimit_;
    }

    @Override
    public DurationOrBuilder getPickupToDeliveryAbsoluteDetourLimitOrBuilder() {
        return this.pickupToDeliveryAbsoluteDetourLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryAbsoluteDetourLimit_;
    }

    @Override
    public boolean hasPickupToDeliveryTimeLimit() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Duration getPickupToDeliveryTimeLimit() {
        return this.pickupToDeliveryTimeLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryTimeLimit_;
    }

    @Override
    public DurationOrBuilder getPickupToDeliveryTimeLimitOrBuilder() {
        return this.pickupToDeliveryTimeLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryTimeLimit_;
    }

    @Override
    public String getShipmentType() {
        Object ref = this.shipmentType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.shipmentType_ = s;
        return s;
    }

    @Override
    public ByteString getShipmentTypeBytes() {
        Object ref = this.shipmentType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.shipmentType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getLabel() {
        Object ref = this.label_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.label_ = s;
        return s;
    }

    @Override
    public ByteString getLabelBytes() {
        Object ref = this.label_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.label_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getIgnore() {
        return this.ignore_;
    }

    @Override
    @Deprecated
    public List<CapacityQuantity> getDemandsList() {
        return this.demands_;
    }

    @Override
    @Deprecated
    public List<? extends CapacityQuantityOrBuilder> getDemandsOrBuilderList() {
        return this.demands_;
    }

    @Override
    @Deprecated
    public int getDemandsCount() {
        return this.demands_.size();
    }

    @Override
    @Deprecated
    public CapacityQuantity getDemands(int index) {
        return this.demands_.get(index);
    }

    @Override
    @Deprecated
    public CapacityQuantityOrBuilder getDemandsOrBuilder(int index) {
        return this.demands_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        for (i = 0; i < this.pickups_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.pickups_.get(i));
        }
        for (i = 0; i < this.deliveries_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.deliveries_.get(i));
        }
        for (i = 0; i < this.demands_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.demands_.get(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeDouble(4, this.penaltyCost_);
        }
        if (this.getAllowedVehicleIndicesList().size() > 0) {
            output.writeUInt32NoTag(42);
            output.writeUInt32NoTag(this.allowedVehicleIndicesMemoizedSerializedSize);
        }
        for (i = 0; i < this.allowedVehicleIndices_.size(); ++i) {
            output.writeInt32NoTag(this.allowedVehicleIndices_.getInt(i));
        }
        if (this.getCostsPerVehicleList().size() > 0) {
            output.writeUInt32NoTag(50);
            output.writeUInt32NoTag(this.costsPerVehicleMemoizedSerializedSize);
        }
        for (i = 0; i < this.costsPerVehicle_.size(); ++i) {
            output.writeDoubleNoTag(this.costsPerVehicle_.getDouble(i));
        }
        if (this.getCostsPerVehicleIndicesList().size() > 0) {
            output.writeUInt32NoTag(58);
            output.writeUInt32NoTag(this.costsPerVehicleIndicesMemoizedSerializedSize);
        }
        for (i = 0; i < this.costsPerVehicleIndices_.size(); ++i) {
            output.writeInt32NoTag(this.costsPerVehicleIndices_.getInt(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeDouble(8, this.pickupToDeliveryRelativeDetourLimit_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(9, (MessageLite)this.getPickupToDeliveryAbsoluteDetourLimit());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(10, (MessageLite)this.getPickupToDeliveryTimeLimit());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.shipmentType_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.shipmentType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.label_);
        }
        if (this.ignore_) {
            output.writeBool(13, this.ignore_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLoadDemands(), LoadDemandsDefaultEntryHolder.defaultEntry, (int)14);
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i2 = 0; i2 < this.pickups_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.pickups_.get(i2)));
        }
        for (i2 = 0; i2 < this.deliveries_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.deliveries_.get(i2)));
        }
        for (i2 = 0; i2 < this.demands_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.demands_.get(i2)));
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)4, (double)this.penaltyCost_);
        }
        int dataSize = 0;
        for (i = 0; i < this.allowedVehicleIndices_.size(); ++i) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)this.allowedVehicleIndices_.getInt(i));
        }
        size += dataSize;
        if (!this.getAllowedVehicleIndicesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.allowedVehicleIndicesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        dataSize = 8 * this.getCostsPerVehicleList().size();
        size += dataSize;
        if (!this.getCostsPerVehicleList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.costsPerVehicleMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.costsPerVehicleIndices_.size(); ++i) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)this.costsPerVehicleIndices_.getInt(i));
        }
        size += dataSize;
        if (!this.getCostsPerVehicleIndicesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.costsPerVehicleIndicesMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)8, (double)this.pickupToDeliveryRelativeDetourLimit_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getPickupToDeliveryAbsoluteDetourLimit());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getPickupToDeliveryTimeLimit());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.shipmentType_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.shipmentType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.label_);
        }
        if (this.ignore_) {
            size += CodedOutputStream.computeBoolSize((int)13, (boolean)this.ignore_);
        }
        for (Map.Entry entry : this.internalGetLoadDemands().getMap().entrySet()) {
            MapEntry loadDemands__ = LoadDemandsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)loadDemands__);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Shipment)) {
            return super.equals(obj);
        }
        Shipment other = (Shipment)obj;
        if (!this.getPickupsList().equals(other.getPickupsList())) {
            return false;
        }
        if (!this.getDeliveriesList().equals(other.getDeliveriesList())) {
            return false;
        }
        if (!this.internalGetLoadDemands().equals(other.internalGetLoadDemands())) {
            return false;
        }
        if (this.hasPenaltyCost() != other.hasPenaltyCost()) {
            return false;
        }
        if (this.hasPenaltyCost() && Double.doubleToLongBits(this.getPenaltyCost()) != Double.doubleToLongBits(other.getPenaltyCost())) {
            return false;
        }
        if (!this.getAllowedVehicleIndicesList().equals(other.getAllowedVehicleIndicesList())) {
            return false;
        }
        if (!this.getCostsPerVehicleList().equals(other.getCostsPerVehicleList())) {
            return false;
        }
        if (!this.getCostsPerVehicleIndicesList().equals(other.getCostsPerVehicleIndicesList())) {
            return false;
        }
        if (this.hasPickupToDeliveryRelativeDetourLimit() != other.hasPickupToDeliveryRelativeDetourLimit()) {
            return false;
        }
        if (this.hasPickupToDeliveryRelativeDetourLimit() && Double.doubleToLongBits(this.getPickupToDeliveryRelativeDetourLimit()) != Double.doubleToLongBits(other.getPickupToDeliveryRelativeDetourLimit())) {
            return false;
        }
        if (this.hasPickupToDeliveryAbsoluteDetourLimit() != other.hasPickupToDeliveryAbsoluteDetourLimit()) {
            return false;
        }
        if (this.hasPickupToDeliveryAbsoluteDetourLimit() && !this.getPickupToDeliveryAbsoluteDetourLimit().equals((Object)other.getPickupToDeliveryAbsoluteDetourLimit())) {
            return false;
        }
        if (this.hasPickupToDeliveryTimeLimit() != other.hasPickupToDeliveryTimeLimit()) {
            return false;
        }
        if (this.hasPickupToDeliveryTimeLimit() && !this.getPickupToDeliveryTimeLimit().equals((Object)other.getPickupToDeliveryTimeLimit())) {
            return false;
        }
        if (!this.getShipmentType().equals(other.getShipmentType())) {
            return false;
        }
        if (!this.getLabel().equals(other.getLabel())) {
            return false;
        }
        if (this.getIgnore() != other.getIgnore()) {
            return false;
        }
        if (!this.getDemandsList().equals(other.getDemandsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Shipment.getDescriptor().hashCode();
        if (this.getPickupsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getPickupsList().hashCode();
        }
        if (this.getDeliveriesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getDeliveriesList().hashCode();
        }
        if (!this.internalGetLoadDemands().getMap().isEmpty()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.internalGetLoadDemands().hashCode();
        }
        if (this.hasPenaltyCost()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getPenaltyCost()));
        }
        if (this.getAllowedVehicleIndicesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getAllowedVehicleIndicesList().hashCode();
        }
        if (this.getCostsPerVehicleCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getCostsPerVehicleList().hashCode();
        }
        if (this.getCostsPerVehicleIndicesCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getCostsPerVehicleIndicesList().hashCode();
        }
        if (this.hasPickupToDeliveryRelativeDetourLimit()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getPickupToDeliveryRelativeDetourLimit()));
        }
        if (this.hasPickupToDeliveryAbsoluteDetourLimit()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getPickupToDeliveryAbsoluteDetourLimit().hashCode();
        }
        if (this.hasPickupToDeliveryTimeLimit()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getPickupToDeliveryTimeLimit().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getShipmentType().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getLabel().hashCode();
        hash = 37 * hash + 13;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIgnore());
        if (this.getDemandsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getDemandsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Shipment parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Shipment)PARSER.parseFrom(data);
    }

    public static Shipment parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Shipment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Shipment parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Shipment)PARSER.parseFrom(data);
    }

    public static Shipment parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Shipment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Shipment parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Shipment)PARSER.parseFrom(data);
    }

    public static Shipment parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Shipment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Shipment parseFrom(InputStream input) throws IOException {
        return (Shipment)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Shipment parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Shipment)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Shipment parseDelimitedFrom(InputStream input) throws IOException {
        return (Shipment)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Shipment parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Shipment)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Shipment parseFrom(CodedInputStream input) throws IOException {
        return (Shipment)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Shipment parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Shipment)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Shipment.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Shipment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Shipment getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Shipment> parser() {
        return PARSER;
    }

    public Parser<Shipment> getParserForType() {
        return PARSER;
    }

    public Shipment getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.IntList access$5500() {
        return Shipment.emptyIntList();
    }

    static /* synthetic */ Internal.DoubleList access$5800() {
        return Shipment.emptyDoubleList();
    }

    static /* synthetic */ Internal.IntList access$6200() {
        return Shipment.emptyIntList();
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ShipmentOrBuilder {
        private int bitField0_;
        private List<VisitRequest> pickups_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VisitRequest, VisitRequest.Builder, VisitRequestOrBuilder> pickupsBuilder_;
        private List<VisitRequest> deliveries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VisitRequest, VisitRequest.Builder, VisitRequestOrBuilder> deliveriesBuilder_;
        private static final LoadDemandsConverter loadDemandsConverter = new LoadDemandsConverter();
        private MapFieldBuilder<String, LoadOrBuilder, Load, Load.Builder> loadDemands_;
        private double penaltyCost_;
        private Internal.IntList allowedVehicleIndices_ = Shipment.access$5500();
        private Internal.DoubleList costsPerVehicle_ = Shipment.access$5800();
        private Internal.IntList costsPerVehicleIndices_ = Shipment.access$6200();
        private double pickupToDeliveryRelativeDetourLimit_;
        private Duration pickupToDeliveryAbsoluteDetourLimit_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> pickupToDeliveryAbsoluteDetourLimitBuilder_;
        private Duration pickupToDeliveryTimeLimit_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> pickupToDeliveryTimeLimitBuilder_;
        private Object shipmentType_ = "";
        private Object label_ = "";
        private boolean ignore_;
        private List<CapacityQuantity> demands_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<CapacityQuantity, CapacityQuantity.Builder, CapacityQuantityOrBuilder> demandsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 14: {
                    return this.internalGetLoadDemands();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 14: {
                    return this.internalGetMutableLoadDemands();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_fieldAccessorTable.ensureFieldAccessorsInitialized(Shipment.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getPickupsFieldBuilder();
                this.getDeliveriesFieldBuilder();
                this.getPickupToDeliveryAbsoluteDetourLimitFieldBuilder();
                this.getPickupToDeliveryTimeLimitFieldBuilder();
                this.getDemandsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.pickupsBuilder_ == null) {
                this.pickups_ = Collections.emptyList();
            } else {
                this.pickups_ = null;
                this.pickupsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.deliveriesBuilder_ == null) {
                this.deliveries_ = Collections.emptyList();
            } else {
                this.deliveries_ = null;
                this.deliveriesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.internalGetMutableLoadDemands().clear();
            this.penaltyCost_ = 0.0;
            this.allowedVehicleIndices_ = Shipment.emptyIntList();
            this.costsPerVehicle_ = Shipment.emptyDoubleList();
            this.costsPerVehicleIndices_ = Shipment.emptyIntList();
            this.pickupToDeliveryRelativeDetourLimit_ = 0.0;
            this.pickupToDeliveryAbsoluteDetourLimit_ = null;
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ != null) {
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_.dispose();
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_ = null;
            }
            this.pickupToDeliveryTimeLimit_ = null;
            if (this.pickupToDeliveryTimeLimitBuilder_ != null) {
                this.pickupToDeliveryTimeLimitBuilder_.dispose();
                this.pickupToDeliveryTimeLimitBuilder_ = null;
            }
            this.shipmentType_ = "";
            this.label_ = "";
            this.ignore_ = false;
            if (this.demandsBuilder_ == null) {
                this.demands_ = Collections.emptyList();
            } else {
                this.demands_ = null;
                this.demandsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_descriptor;
        }

        public Shipment getDefaultInstanceForType() {
            return Shipment.getDefaultInstance();
        }

        public Shipment build() {
            Shipment result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Shipment buildPartial() {
            Shipment result = new Shipment(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Shipment result) {
            if (this.pickupsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.pickups_ = Collections.unmodifiableList(this.pickups_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.pickups_ = this.pickups_;
            } else {
                result.pickups_ = this.pickupsBuilder_.build();
            }
            if (this.deliveriesBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.deliveries_ = Collections.unmodifiableList(this.deliveries_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.deliveries_ = this.deliveries_;
            } else {
                result.deliveries_ = this.deliveriesBuilder_.build();
            }
            if (this.demandsBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.demands_ = Collections.unmodifiableList(this.demands_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.demands_ = this.demands_;
            } else {
                result.demands_ = this.demandsBuilder_.build();
            }
        }

        private void buildPartial0(Shipment result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 4) != 0) {
                result.loadDemands_ = this.internalGetLoadDemands().build(LoadDemandsDefaultEntryHolder.defaultEntry);
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.penaltyCost_ = this.penaltyCost_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.allowedVehicleIndices_.makeImmutable();
                result.allowedVehicleIndices_ = this.allowedVehicleIndices_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                this.costsPerVehicle_.makeImmutable();
                result.costsPerVehicle_ = this.costsPerVehicle_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                this.costsPerVehicleIndices_.makeImmutable();
                result.costsPerVehicleIndices_ = this.costsPerVehicleIndices_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.pickupToDeliveryRelativeDetourLimit_ = this.pickupToDeliveryRelativeDetourLimit_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.pickupToDeliveryAbsoluteDetourLimit_ = this.pickupToDeliveryAbsoluteDetourLimitBuilder_ == null ? this.pickupToDeliveryAbsoluteDetourLimit_ : (Duration)this.pickupToDeliveryAbsoluteDetourLimitBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.pickupToDeliveryTimeLimit_ = this.pickupToDeliveryTimeLimitBuilder_ == null ? this.pickupToDeliveryTimeLimit_ : (Duration)this.pickupToDeliveryTimeLimitBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.shipmentType_ = this.shipmentType_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.label_ = this.label_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.ignore_ = this.ignore_;
            }
            Shipment shipment = result;
            shipment.bitField0_ = shipment.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Shipment) {
                return this.mergeFrom((Shipment)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Shipment other) {
            if (other == Shipment.getDefaultInstance()) {
                return this;
            }
            if (this.pickupsBuilder_ == null) {
                if (!other.pickups_.isEmpty()) {
                    if (this.pickups_.isEmpty()) {
                        this.pickups_ = other.pickups_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensurePickupsIsMutable();
                        this.pickups_.addAll(other.pickups_);
                    }
                    this.onChanged();
                }
            } else if (!other.pickups_.isEmpty()) {
                if (this.pickupsBuilder_.isEmpty()) {
                    this.pickupsBuilder_.dispose();
                    this.pickupsBuilder_ = null;
                    this.pickups_ = other.pickups_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.pickupsBuilder_ = alwaysUseFieldBuilders ? this.getPickupsFieldBuilder() : null;
                } else {
                    this.pickupsBuilder_.addAllMessages((Iterable)other.pickups_);
                }
            }
            if (this.deliveriesBuilder_ == null) {
                if (!other.deliveries_.isEmpty()) {
                    if (this.deliveries_.isEmpty()) {
                        this.deliveries_ = other.deliveries_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureDeliveriesIsMutable();
                        this.deliveries_.addAll(other.deliveries_);
                    }
                    this.onChanged();
                }
            } else if (!other.deliveries_.isEmpty()) {
                if (this.deliveriesBuilder_.isEmpty()) {
                    this.deliveriesBuilder_.dispose();
                    this.deliveriesBuilder_ = null;
                    this.deliveries_ = other.deliveries_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.deliveriesBuilder_ = alwaysUseFieldBuilders ? this.getDeliveriesFieldBuilder() : null;
                } else {
                    this.deliveriesBuilder_.addAllMessages((Iterable)other.deliveries_);
                }
            }
            this.internalGetMutableLoadDemands().mergeFrom(other.internalGetLoadDemands());
            this.bitField0_ |= 4;
            if (other.hasPenaltyCost()) {
                this.setPenaltyCost(other.getPenaltyCost());
            }
            if (!other.allowedVehicleIndices_.isEmpty()) {
                if (this.allowedVehicleIndices_.isEmpty()) {
                    this.allowedVehicleIndices_ = other.allowedVehicleIndices_;
                    this.allowedVehicleIndices_.makeImmutable();
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensureAllowedVehicleIndicesIsMutable();
                    this.allowedVehicleIndices_.addAll((Collection)other.allowedVehicleIndices_);
                }
                this.onChanged();
            }
            if (!other.costsPerVehicle_.isEmpty()) {
                if (this.costsPerVehicle_.isEmpty()) {
                    this.costsPerVehicle_ = other.costsPerVehicle_;
                    this.costsPerVehicle_.makeImmutable();
                    this.bitField0_ |= 0x20;
                } else {
                    this.ensureCostsPerVehicleIsMutable();
                    this.costsPerVehicle_.addAll((Collection)other.costsPerVehicle_);
                }
                this.onChanged();
            }
            if (!other.costsPerVehicleIndices_.isEmpty()) {
                if (this.costsPerVehicleIndices_.isEmpty()) {
                    this.costsPerVehicleIndices_ = other.costsPerVehicleIndices_;
                    this.costsPerVehicleIndices_.makeImmutable();
                    this.bitField0_ |= 0x40;
                } else {
                    this.ensureCostsPerVehicleIndicesIsMutable();
                    this.costsPerVehicleIndices_.addAll((Collection)other.costsPerVehicleIndices_);
                }
                this.onChanged();
            }
            if (other.hasPickupToDeliveryRelativeDetourLimit()) {
                this.setPickupToDeliveryRelativeDetourLimit(other.getPickupToDeliveryRelativeDetourLimit());
            }
            if (other.hasPickupToDeliveryAbsoluteDetourLimit()) {
                this.mergePickupToDeliveryAbsoluteDetourLimit(other.getPickupToDeliveryAbsoluteDetourLimit());
            }
            if (other.hasPickupToDeliveryTimeLimit()) {
                this.mergePickupToDeliveryTimeLimit(other.getPickupToDeliveryTimeLimit());
            }
            if (!other.getShipmentType().isEmpty()) {
                this.shipmentType_ = other.shipmentType_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (!other.getLabel().isEmpty()) {
                this.label_ = other.label_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (other.getIgnore()) {
                this.setIgnore(other.getIgnore());
            }
            if (this.demandsBuilder_ == null) {
                if (!other.demands_.isEmpty()) {
                    if (this.demands_.isEmpty()) {
                        this.demands_ = other.demands_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensureDemandsIsMutable();
                        this.demands_.addAll(other.demands_);
                    }
                    this.onChanged();
                }
            } else if (!other.demands_.isEmpty()) {
                if (this.demandsBuilder_.isEmpty()) {
                    this.demandsBuilder_.dispose();
                    this.demandsBuilder_ = null;
                    this.demands_ = other.demands_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.demandsBuilder_ = alwaysUseFieldBuilders ? this.getDemandsFieldBuilder() : null;
                } else {
                    this.demandsBuilder_.addAllMessages((Iterable)other.demands_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block25: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block25;
                        }
                        case 10: {
                            VisitRequest m = (VisitRequest)input.readMessage(VisitRequest.parser(), extensionRegistry);
                            if (this.pickupsBuilder_ == null) {
                                this.ensurePickupsIsMutable();
                                this.pickups_.add(m);
                                continue block25;
                            }
                            this.pickupsBuilder_.addMessage((AbstractMessage)m);
                            continue block25;
                        }
                        case 18: {
                            VisitRequest m = (VisitRequest)input.readMessage(VisitRequest.parser(), extensionRegistry);
                            if (this.deliveriesBuilder_ == null) {
                                this.ensureDeliveriesIsMutable();
                                this.deliveries_.add(m);
                                continue block25;
                            }
                            this.deliveriesBuilder_.addMessage((AbstractMessage)m);
                            continue block25;
                        }
                        case 26: {
                            CapacityQuantity m = (CapacityQuantity)input.readMessage(CapacityQuantity.parser(), extensionRegistry);
                            if (this.demandsBuilder_ == null) {
                                this.ensureDemandsIsMutable();
                                this.demands_.add(m);
                                continue block25;
                            }
                            this.demandsBuilder_.addMessage((AbstractMessage)m);
                            continue block25;
                        }
                        case 33: {
                            this.penaltyCost_ = input.readDouble();
                            this.bitField0_ |= 8;
                            continue block25;
                        }
                        case 40: {
                            int v = input.readInt32();
                            this.ensureAllowedVehicleIndicesIsMutable();
                            this.allowedVehicleIndices_.addInt(v);
                            continue block25;
                        }
                        case 42: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensureAllowedVehicleIndicesIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.allowedVehicleIndices_.addInt(input.readInt32());
                            }
                            input.popLimit(limit);
                            continue block25;
                        }
                        case 49: {
                            double v = input.readDouble();
                            this.ensureCostsPerVehicleIsMutable();
                            this.costsPerVehicle_.addDouble(v);
                            continue block25;
                        }
                        case 50: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            int alloc = length > 4096 ? 4096 : length;
                            this.ensureCostsPerVehicleIsMutable(alloc / 8);
                            while (input.getBytesUntilLimit() > 0) {
                                this.costsPerVehicle_.addDouble(input.readDouble());
                            }
                            input.popLimit(limit);
                            continue block25;
                        }
                        case 56: {
                            int v = input.readInt32();
                            this.ensureCostsPerVehicleIndicesIsMutable();
                            this.costsPerVehicleIndices_.addInt(v);
                            continue block25;
                        }
                        case 58: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensureCostsPerVehicleIndicesIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.costsPerVehicleIndices_.addInt(input.readInt32());
                            }
                            input.popLimit(limit);
                            continue block25;
                        }
                        case 65: {
                            this.pickupToDeliveryRelativeDetourLimit_ = input.readDouble();
                            this.bitField0_ |= 0x80;
                            continue block25;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getPickupToDeliveryAbsoluteDetourLimitFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block25;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getPickupToDeliveryTimeLimitFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block25;
                        }
                        case 90: {
                            this.shipmentType_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block25;
                        }
                        case 98: {
                            this.label_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block25;
                        }
                        case 104: {
                            this.ignore_ = input.readBool();
                            this.bitField0_ |= 0x1000;
                            continue block25;
                        }
                        case 114: {
                            MapEntry loadDemands__ = (MapEntry)input.readMessage(LoadDemandsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLoadDemands().ensureBuilderMap().put(loadDemands__.getKey(), loadDemands__.getValue());
                            this.bitField0_ |= 4;
                            continue block25;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensurePickupsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.pickups_ = new ArrayList<VisitRequest>(this.pickups_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<VisitRequest> getPickupsList() {
            if (this.pickupsBuilder_ == null) {
                return Collections.unmodifiableList(this.pickups_);
            }
            return this.pickupsBuilder_.getMessageList();
        }

        @Override
        public int getPickupsCount() {
            if (this.pickupsBuilder_ == null) {
                return this.pickups_.size();
            }
            return this.pickupsBuilder_.getCount();
        }

        @Override
        public VisitRequest getPickups(int index) {
            if (this.pickupsBuilder_ == null) {
                return this.pickups_.get(index);
            }
            return (VisitRequest)this.pickupsBuilder_.getMessage(index);
        }

        public Builder setPickups(int index, VisitRequest value) {
            if (this.pickupsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePickupsIsMutable();
                this.pickups_.set(index, value);
                this.onChanged();
            } else {
                this.pickupsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPickups(int index, VisitRequest.Builder builderForValue) {
            if (this.pickupsBuilder_ == null) {
                this.ensurePickupsIsMutable();
                this.pickups_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pickupsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPickups(VisitRequest value) {
            if (this.pickupsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePickupsIsMutable();
                this.pickups_.add(value);
                this.onChanged();
            } else {
                this.pickupsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPickups(int index, VisitRequest value) {
            if (this.pickupsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePickupsIsMutable();
                this.pickups_.add(index, value);
                this.onChanged();
            } else {
                this.pickupsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPickups(VisitRequest.Builder builderForValue) {
            if (this.pickupsBuilder_ == null) {
                this.ensurePickupsIsMutable();
                this.pickups_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.pickupsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPickups(int index, VisitRequest.Builder builderForValue) {
            if (this.pickupsBuilder_ == null) {
                this.ensurePickupsIsMutable();
                this.pickups_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pickupsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPickups(Iterable<? extends VisitRequest> values) {
            if (this.pickupsBuilder_ == null) {
                this.ensurePickupsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.pickups_);
                this.onChanged();
            } else {
                this.pickupsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPickups() {
            if (this.pickupsBuilder_ == null) {
                this.pickups_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.pickupsBuilder_.clear();
            }
            return this;
        }

        public Builder removePickups(int index) {
            if (this.pickupsBuilder_ == null) {
                this.ensurePickupsIsMutable();
                this.pickups_.remove(index);
                this.onChanged();
            } else {
                this.pickupsBuilder_.remove(index);
            }
            return this;
        }

        public VisitRequest.Builder getPickupsBuilder(int index) {
            return (VisitRequest.Builder)this.getPickupsFieldBuilder().getBuilder(index);
        }

        @Override
        public VisitRequestOrBuilder getPickupsOrBuilder(int index) {
            if (this.pickupsBuilder_ == null) {
                return this.pickups_.get(index);
            }
            return (VisitRequestOrBuilder)this.pickupsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VisitRequestOrBuilder> getPickupsOrBuilderList() {
            if (this.pickupsBuilder_ != null) {
                return this.pickupsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.pickups_);
        }

        public VisitRequest.Builder addPickupsBuilder() {
            return (VisitRequest.Builder)this.getPickupsFieldBuilder().addBuilder((AbstractMessage)VisitRequest.getDefaultInstance());
        }

        public VisitRequest.Builder addPickupsBuilder(int index) {
            return (VisitRequest.Builder)this.getPickupsFieldBuilder().addBuilder(index, (AbstractMessage)VisitRequest.getDefaultInstance());
        }

        public List<VisitRequest.Builder> getPickupsBuilderList() {
            return this.getPickupsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VisitRequest, VisitRequest.Builder, VisitRequestOrBuilder> getPickupsFieldBuilder() {
            if (this.pickupsBuilder_ == null) {
                this.pickupsBuilder_ = new RepeatedFieldBuilderV3(this.pickups_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pickups_ = null;
            }
            return this.pickupsBuilder_;
        }

        private void ensureDeliveriesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.deliveries_ = new ArrayList<VisitRequest>(this.deliveries_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<VisitRequest> getDeliveriesList() {
            if (this.deliveriesBuilder_ == null) {
                return Collections.unmodifiableList(this.deliveries_);
            }
            return this.deliveriesBuilder_.getMessageList();
        }

        @Override
        public int getDeliveriesCount() {
            if (this.deliveriesBuilder_ == null) {
                return this.deliveries_.size();
            }
            return this.deliveriesBuilder_.getCount();
        }

        @Override
        public VisitRequest getDeliveries(int index) {
            if (this.deliveriesBuilder_ == null) {
                return this.deliveries_.get(index);
            }
            return (VisitRequest)this.deliveriesBuilder_.getMessage(index);
        }

        public Builder setDeliveries(int index, VisitRequest value) {
            if (this.deliveriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDeliveriesIsMutable();
                this.deliveries_.set(index, value);
                this.onChanged();
            } else {
                this.deliveriesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDeliveries(int index, VisitRequest.Builder builderForValue) {
            if (this.deliveriesBuilder_ == null) {
                this.ensureDeliveriesIsMutable();
                this.deliveries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.deliveriesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDeliveries(VisitRequest value) {
            if (this.deliveriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDeliveriesIsMutable();
                this.deliveries_.add(value);
                this.onChanged();
            } else {
                this.deliveriesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDeliveries(int index, VisitRequest value) {
            if (this.deliveriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDeliveriesIsMutable();
                this.deliveries_.add(index, value);
                this.onChanged();
            } else {
                this.deliveriesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDeliveries(VisitRequest.Builder builderForValue) {
            if (this.deliveriesBuilder_ == null) {
                this.ensureDeliveriesIsMutable();
                this.deliveries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.deliveriesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDeliveries(int index, VisitRequest.Builder builderForValue) {
            if (this.deliveriesBuilder_ == null) {
                this.ensureDeliveriesIsMutable();
                this.deliveries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.deliveriesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDeliveries(Iterable<? extends VisitRequest> values) {
            if (this.deliveriesBuilder_ == null) {
                this.ensureDeliveriesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.deliveries_);
                this.onChanged();
            } else {
                this.deliveriesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDeliveries() {
            if (this.deliveriesBuilder_ == null) {
                this.deliveries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.deliveriesBuilder_.clear();
            }
            return this;
        }

        public Builder removeDeliveries(int index) {
            if (this.deliveriesBuilder_ == null) {
                this.ensureDeliveriesIsMutable();
                this.deliveries_.remove(index);
                this.onChanged();
            } else {
                this.deliveriesBuilder_.remove(index);
            }
            return this;
        }

        public VisitRequest.Builder getDeliveriesBuilder(int index) {
            return (VisitRequest.Builder)this.getDeliveriesFieldBuilder().getBuilder(index);
        }

        @Override
        public VisitRequestOrBuilder getDeliveriesOrBuilder(int index) {
            if (this.deliveriesBuilder_ == null) {
                return this.deliveries_.get(index);
            }
            return (VisitRequestOrBuilder)this.deliveriesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VisitRequestOrBuilder> getDeliveriesOrBuilderList() {
            if (this.deliveriesBuilder_ != null) {
                return this.deliveriesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.deliveries_);
        }

        public VisitRequest.Builder addDeliveriesBuilder() {
            return (VisitRequest.Builder)this.getDeliveriesFieldBuilder().addBuilder((AbstractMessage)VisitRequest.getDefaultInstance());
        }

        public VisitRequest.Builder addDeliveriesBuilder(int index) {
            return (VisitRequest.Builder)this.getDeliveriesFieldBuilder().addBuilder(index, (AbstractMessage)VisitRequest.getDefaultInstance());
        }

        public List<VisitRequest.Builder> getDeliveriesBuilderList() {
            return this.getDeliveriesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VisitRequest, VisitRequest.Builder, VisitRequestOrBuilder> getDeliveriesFieldBuilder() {
            if (this.deliveriesBuilder_ == null) {
                this.deliveriesBuilder_ = new RepeatedFieldBuilderV3(this.deliveries_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.deliveries_ = null;
            }
            return this.deliveriesBuilder_;
        }

        private MapFieldBuilder<String, LoadOrBuilder, Load, Load.Builder> internalGetLoadDemands() {
            if (this.loadDemands_ == null) {
                return new MapFieldBuilder((MapFieldBuilder.Converter)loadDemandsConverter);
            }
            return this.loadDemands_;
        }

        private MapFieldBuilder<String, LoadOrBuilder, Load, Load.Builder> internalGetMutableLoadDemands() {
            if (this.loadDemands_ == null) {
                this.loadDemands_ = new MapFieldBuilder((MapFieldBuilder.Converter)loadDemandsConverter);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this.loadDemands_;
        }

        @Override
        public int getLoadDemandsCount() {
            return this.internalGetLoadDemands().ensureBuilderMap().size();
        }

        @Override
        public boolean containsLoadDemands(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLoadDemands().ensureBuilderMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, Load> getLoadDemands() {
            return this.getLoadDemandsMap();
        }

        @Override
        public Map<String, Load> getLoadDemandsMap() {
            return this.internalGetLoadDemands().getImmutableMap();
        }

        @Override
        public Load getLoadDemandsOrDefault(String key, Load defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableLoadDemands().ensureBuilderMap();
            return map.containsKey(key) ? loadDemandsConverter.build((LoadOrBuilder)map.get(key)) : defaultValue;
        }

        @Override
        public Load getLoadDemandsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableLoadDemands().ensureBuilderMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return loadDemandsConverter.build((LoadOrBuilder)map.get(key));
        }

        public Builder clearLoadDemands() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.internalGetMutableLoadDemands().clear();
            return this;
        }

        public Builder removeLoadDemands(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLoadDemands().ensureBuilderMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, Load> getMutableLoadDemands() {
            this.bitField0_ |= 4;
            return this.internalGetMutableLoadDemands().ensureMessageMap();
        }

        public Builder putLoadDemands(String key, Load value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLoadDemands().ensureBuilderMap().put(key, value);
            this.bitField0_ |= 4;
            return this;
        }

        public Builder putAllLoadDemands(Map<String, Load> values) {
            for (Map.Entry<String, Load> e : values.entrySet()) {
                if (e.getKey() != null && e.getValue() != null) continue;
                throw new NullPointerException();
            }
            this.internalGetMutableLoadDemands().ensureBuilderMap().putAll(values);
            this.bitField0_ |= 4;
            return this;
        }

        public Load.Builder putLoadDemandsBuilderIfAbsent(String key) {
            Map builderMap = this.internalGetMutableLoadDemands().ensureBuilderMap();
            LoadOrBuilder entry = (LoadOrBuilder)builderMap.get(key);
            if (entry == null) {
                entry = Load.newBuilder();
                builderMap.put(key, entry);
            }
            if (entry instanceof Load) {
                entry = ((Load)entry).toBuilder();
                builderMap.put(key, entry);
            }
            return (Load.Builder)entry;
        }

        @Override
        public boolean hasPenaltyCost() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public double getPenaltyCost() {
            return this.penaltyCost_;
        }

        public Builder setPenaltyCost(double value) {
            this.penaltyCost_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearPenaltyCost() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.penaltyCost_ = 0.0;
            this.onChanged();
            return this;
        }

        private void ensureAllowedVehicleIndicesIsMutable() {
            if (!this.allowedVehicleIndices_.isModifiable()) {
                this.allowedVehicleIndices_ = (Internal.IntList)Shipment.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.allowedVehicleIndices_));
            }
            this.bitField0_ |= 0x10;
        }

        @Override
        public List<Integer> getAllowedVehicleIndicesList() {
            this.allowedVehicleIndices_.makeImmutable();
            return this.allowedVehicleIndices_;
        }

        @Override
        public int getAllowedVehicleIndicesCount() {
            return this.allowedVehicleIndices_.size();
        }

        @Override
        public int getAllowedVehicleIndices(int index) {
            return this.allowedVehicleIndices_.getInt(index);
        }

        public Builder setAllowedVehicleIndices(int index, int value) {
            this.ensureAllowedVehicleIndicesIsMutable();
            this.allowedVehicleIndices_.setInt(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllowedVehicleIndices(int value) {
            this.ensureAllowedVehicleIndicesIsMutable();
            this.allowedVehicleIndices_.addInt(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllAllowedVehicleIndices(Iterable<? extends Integer> values) {
            this.ensureAllowedVehicleIndicesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.allowedVehicleIndices_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearAllowedVehicleIndices() {
            this.allowedVehicleIndices_ = Shipment.emptyIntList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        private void ensureCostsPerVehicleIsMutable() {
            if (!this.costsPerVehicle_.isModifiable()) {
                this.costsPerVehicle_ = (Internal.DoubleList)Shipment.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.costsPerVehicle_));
            }
            this.bitField0_ |= 0x20;
        }

        private void ensureCostsPerVehicleIsMutable(int capacity) {
            if (!this.costsPerVehicle_.isModifiable()) {
                this.costsPerVehicle_ = (Internal.DoubleList)Shipment.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.costsPerVehicle_), (int)capacity);
            }
            this.bitField0_ |= 0x20;
        }

        @Override
        public List<Double> getCostsPerVehicleList() {
            this.costsPerVehicle_.makeImmutable();
            return this.costsPerVehicle_;
        }

        @Override
        public int getCostsPerVehicleCount() {
            return this.costsPerVehicle_.size();
        }

        @Override
        public double getCostsPerVehicle(int index) {
            return this.costsPerVehicle_.getDouble(index);
        }

        public Builder setCostsPerVehicle(int index, double value) {
            this.ensureCostsPerVehicleIsMutable();
            this.costsPerVehicle_.setDouble(index, value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addCostsPerVehicle(double value) {
            this.ensureCostsPerVehicleIsMutable();
            this.costsPerVehicle_.addDouble(value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addAllCostsPerVehicle(Iterable<? extends Double> values) {
            this.ensureCostsPerVehicleIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.costsPerVehicle_);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearCostsPerVehicle() {
            this.costsPerVehicle_ = Shipment.emptyDoubleList();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        private void ensureCostsPerVehicleIndicesIsMutable() {
            if (!this.costsPerVehicleIndices_.isModifiable()) {
                this.costsPerVehicleIndices_ = (Internal.IntList)Shipment.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.costsPerVehicleIndices_));
            }
            this.bitField0_ |= 0x40;
        }

        @Override
        public List<Integer> getCostsPerVehicleIndicesList() {
            this.costsPerVehicleIndices_.makeImmutable();
            return this.costsPerVehicleIndices_;
        }

        @Override
        public int getCostsPerVehicleIndicesCount() {
            return this.costsPerVehicleIndices_.size();
        }

        @Override
        public int getCostsPerVehicleIndices(int index) {
            return this.costsPerVehicleIndices_.getInt(index);
        }

        public Builder setCostsPerVehicleIndices(int index, int value) {
            this.ensureCostsPerVehicleIndicesIsMutable();
            this.costsPerVehicleIndices_.setInt(index, value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder addCostsPerVehicleIndices(int value) {
            this.ensureCostsPerVehicleIndicesIsMutable();
            this.costsPerVehicleIndices_.addInt(value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder addAllCostsPerVehicleIndices(Iterable<? extends Integer> values) {
            this.ensureCostsPerVehicleIndicesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.costsPerVehicleIndices_);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearCostsPerVehicleIndices() {
            this.costsPerVehicleIndices_ = Shipment.emptyIntList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPickupToDeliveryRelativeDetourLimit() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public double getPickupToDeliveryRelativeDetourLimit() {
            return this.pickupToDeliveryRelativeDetourLimit_;
        }

        public Builder setPickupToDeliveryRelativeDetourLimit(double value) {
            this.pickupToDeliveryRelativeDetourLimit_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearPickupToDeliveryRelativeDetourLimit() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.pickupToDeliveryRelativeDetourLimit_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPickupToDeliveryAbsoluteDetourLimit() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Duration getPickupToDeliveryAbsoluteDetourLimit() {
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
                return this.pickupToDeliveryAbsoluteDetourLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryAbsoluteDetourLimit_;
            }
            return (Duration)this.pickupToDeliveryAbsoluteDetourLimitBuilder_.getMessage();
        }

        public Builder setPickupToDeliveryAbsoluteDetourLimit(Duration value) {
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.pickupToDeliveryAbsoluteDetourLimit_ = value;
            } else {
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setPickupToDeliveryAbsoluteDetourLimit(Duration.Builder builderForValue) {
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
                this.pickupToDeliveryAbsoluteDetourLimit_ = builderForValue.build();
            } else {
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergePickupToDeliveryAbsoluteDetourLimit(Duration value) {
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.pickupToDeliveryAbsoluteDetourLimit_ != null && this.pickupToDeliveryAbsoluteDetourLimit_ != Duration.getDefaultInstance()) {
                    this.getPickupToDeliveryAbsoluteDetourLimitBuilder().mergeFrom(value);
                } else {
                    this.pickupToDeliveryAbsoluteDetourLimit_ = value;
                }
            } else {
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.pickupToDeliveryAbsoluteDetourLimit_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPickupToDeliveryAbsoluteDetourLimit() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.pickupToDeliveryAbsoluteDetourLimit_ = null;
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ != null) {
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_.dispose();
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getPickupToDeliveryAbsoluteDetourLimitBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Duration.Builder)this.getPickupToDeliveryAbsoluteDetourLimitFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getPickupToDeliveryAbsoluteDetourLimitOrBuilder() {
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ != null) {
                return (DurationOrBuilder)this.pickupToDeliveryAbsoluteDetourLimitBuilder_.getMessageOrBuilder();
            }
            return this.pickupToDeliveryAbsoluteDetourLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryAbsoluteDetourLimit_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getPickupToDeliveryAbsoluteDetourLimitFieldBuilder() {
            if (this.pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
                this.pickupToDeliveryAbsoluteDetourLimitBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPickupToDeliveryAbsoluteDetourLimit(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pickupToDeliveryAbsoluteDetourLimit_ = null;
            }
            return this.pickupToDeliveryAbsoluteDetourLimitBuilder_;
        }

        @Override
        public boolean hasPickupToDeliveryTimeLimit() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public Duration getPickupToDeliveryTimeLimit() {
            if (this.pickupToDeliveryTimeLimitBuilder_ == null) {
                return this.pickupToDeliveryTimeLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryTimeLimit_;
            }
            return (Duration)this.pickupToDeliveryTimeLimitBuilder_.getMessage();
        }

        public Builder setPickupToDeliveryTimeLimit(Duration value) {
            if (this.pickupToDeliveryTimeLimitBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.pickupToDeliveryTimeLimit_ = value;
            } else {
                this.pickupToDeliveryTimeLimitBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setPickupToDeliveryTimeLimit(Duration.Builder builderForValue) {
            if (this.pickupToDeliveryTimeLimitBuilder_ == null) {
                this.pickupToDeliveryTimeLimit_ = builderForValue.build();
            } else {
                this.pickupToDeliveryTimeLimitBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergePickupToDeliveryTimeLimit(Duration value) {
            if (this.pickupToDeliveryTimeLimitBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.pickupToDeliveryTimeLimit_ != null && this.pickupToDeliveryTimeLimit_ != Duration.getDefaultInstance()) {
                    this.getPickupToDeliveryTimeLimitBuilder().mergeFrom(value);
                } else {
                    this.pickupToDeliveryTimeLimit_ = value;
                }
            } else {
                this.pickupToDeliveryTimeLimitBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.pickupToDeliveryTimeLimit_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPickupToDeliveryTimeLimit() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.pickupToDeliveryTimeLimit_ = null;
            if (this.pickupToDeliveryTimeLimitBuilder_ != null) {
                this.pickupToDeliveryTimeLimitBuilder_.dispose();
                this.pickupToDeliveryTimeLimitBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getPickupToDeliveryTimeLimitBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (Duration.Builder)this.getPickupToDeliveryTimeLimitFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getPickupToDeliveryTimeLimitOrBuilder() {
            if (this.pickupToDeliveryTimeLimitBuilder_ != null) {
                return (DurationOrBuilder)this.pickupToDeliveryTimeLimitBuilder_.getMessageOrBuilder();
            }
            return this.pickupToDeliveryTimeLimit_ == null ? Duration.getDefaultInstance() : this.pickupToDeliveryTimeLimit_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getPickupToDeliveryTimeLimitFieldBuilder() {
            if (this.pickupToDeliveryTimeLimitBuilder_ == null) {
                this.pickupToDeliveryTimeLimitBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPickupToDeliveryTimeLimit(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pickupToDeliveryTimeLimit_ = null;
            }
            return this.pickupToDeliveryTimeLimitBuilder_;
        }

        @Override
        public String getShipmentType() {
            Object ref = this.shipmentType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.shipmentType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getShipmentTypeBytes() {
            Object ref = this.shipmentType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.shipmentType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setShipmentType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.shipmentType_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearShipmentType() {
            this.shipmentType_ = Shipment.getDefaultInstance().getShipmentType();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setShipmentTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Shipment.checkByteStringIsUtf8((ByteString)value);
            this.shipmentType_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public String getLabel() {
            Object ref = this.label_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.label_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLabelBytes() {
            Object ref = this.label_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.label_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLabel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.label_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearLabel() {
            this.label_ = Shipment.getDefaultInstance().getLabel();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setLabelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Shipment.checkByteStringIsUtf8((ByteString)value);
            this.label_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIgnore() {
            return this.ignore_;
        }

        public Builder setIgnore(boolean value) {
            this.ignore_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearIgnore() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.ignore_ = false;
            this.onChanged();
            return this;
        }

        private void ensureDemandsIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.demands_ = new ArrayList<CapacityQuantity>(this.demands_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        @Deprecated
        public List<CapacityQuantity> getDemandsList() {
            if (this.demandsBuilder_ == null) {
                return Collections.unmodifiableList(this.demands_);
            }
            return this.demandsBuilder_.getMessageList();
        }

        @Override
        @Deprecated
        public int getDemandsCount() {
            if (this.demandsBuilder_ == null) {
                return this.demands_.size();
            }
            return this.demandsBuilder_.getCount();
        }

        @Override
        @Deprecated
        public CapacityQuantity getDemands(int index) {
            if (this.demandsBuilder_ == null) {
                return this.demands_.get(index);
            }
            return (CapacityQuantity)this.demandsBuilder_.getMessage(index);
        }

        @Deprecated
        public Builder setDemands(int index, CapacityQuantity value) {
            if (this.demandsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDemandsIsMutable();
                this.demands_.set(index, value);
                this.onChanged();
            } else {
                this.demandsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        @Deprecated
        public Builder setDemands(int index, CapacityQuantity.Builder builderForValue) {
            if (this.demandsBuilder_ == null) {
                this.ensureDemandsIsMutable();
                this.demands_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.demandsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addDemands(CapacityQuantity value) {
            if (this.demandsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDemandsIsMutable();
                this.demands_.add(value);
                this.onChanged();
            } else {
                this.demandsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        @Deprecated
        public Builder addDemands(int index, CapacityQuantity value) {
            if (this.demandsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDemandsIsMutable();
                this.demands_.add(index, value);
                this.onChanged();
            } else {
                this.demandsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        @Deprecated
        public Builder addDemands(CapacityQuantity.Builder builderForValue) {
            if (this.demandsBuilder_ == null) {
                this.ensureDemandsIsMutable();
                this.demands_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.demandsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addDemands(int index, CapacityQuantity.Builder builderForValue) {
            if (this.demandsBuilder_ == null) {
                this.ensureDemandsIsMutable();
                this.demands_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.demandsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addAllDemands(Iterable<? extends CapacityQuantity> values) {
            if (this.demandsBuilder_ == null) {
                this.ensureDemandsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.demands_);
                this.onChanged();
            } else {
                this.demandsBuilder_.addAllMessages(values);
            }
            return this;
        }

        @Deprecated
        public Builder clearDemands() {
            if (this.demandsBuilder_ == null) {
                this.demands_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.demandsBuilder_.clear();
            }
            return this;
        }

        @Deprecated
        public Builder removeDemands(int index) {
            if (this.demandsBuilder_ == null) {
                this.ensureDemandsIsMutable();
                this.demands_.remove(index);
                this.onChanged();
            } else {
                this.demandsBuilder_.remove(index);
            }
            return this;
        }

        @Deprecated
        public CapacityQuantity.Builder getDemandsBuilder(int index) {
            return (CapacityQuantity.Builder)this.getDemandsFieldBuilder().getBuilder(index);
        }

        @Override
        @Deprecated
        public CapacityQuantityOrBuilder getDemandsOrBuilder(int index) {
            if (this.demandsBuilder_ == null) {
                return this.demands_.get(index);
            }
            return (CapacityQuantityOrBuilder)this.demandsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        @Deprecated
        public List<? extends CapacityQuantityOrBuilder> getDemandsOrBuilderList() {
            if (this.demandsBuilder_ != null) {
                return this.demandsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.demands_);
        }

        @Deprecated
        public CapacityQuantity.Builder addDemandsBuilder() {
            return (CapacityQuantity.Builder)this.getDemandsFieldBuilder().addBuilder((AbstractMessage)CapacityQuantity.getDefaultInstance());
        }

        @Deprecated
        public CapacityQuantity.Builder addDemandsBuilder(int index) {
            return (CapacityQuantity.Builder)this.getDemandsFieldBuilder().addBuilder(index, (AbstractMessage)CapacityQuantity.getDefaultInstance());
        }

        @Deprecated
        public List<CapacityQuantity.Builder> getDemandsBuilderList() {
            return this.getDemandsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<CapacityQuantity, CapacityQuantity.Builder, CapacityQuantityOrBuilder> getDemandsFieldBuilder() {
            if (this.demandsBuilder_ == null) {
                this.demandsBuilder_ = new RepeatedFieldBuilderV3(this.demands_, (this.bitField0_ & 0x2000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.demands_ = null;
            }
            return this.demandsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }

        private static final class LoadDemandsConverter
        implements MapFieldBuilder.Converter<String, LoadOrBuilder, Load> {
            private LoadDemandsConverter() {
            }

            public Load build(LoadOrBuilder val) {
                if (val instanceof Load) {
                    return (Load)val;
                }
                return ((Load.Builder)val).build();
            }

            public MapEntry<String, Load> defaultEntry() {
                return LoadDemandsDefaultEntryHolder.defaultEntry;
            }
        }
    }

    private static final class LoadDemandsDefaultEntryHolder {
        static final MapEntry<String, Load> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_LoadDemandsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)Load.getDefaultInstance());

        private LoadDemandsDefaultEntryHolder() {
        }
    }

    public static final class Load
    extends GeneratedMessageV3
    implements LoadOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int AMOUNT_FIELD_NUMBER = 2;
        private long amount_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Load DEFAULT_INSTANCE = new Load();
        private static final Parser<Load> PARSER = new AbstractParser<Load>(){

            public Load parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Load.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Load(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Load() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Load();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_Load_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_Load_fieldAccessorTable.ensureFieldAccessorsInitialized(Load.class, Builder.class);
        }

        @Override
        public long getAmount() {
            return this.amount_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.amount_ != 0L) {
                output.writeInt64(2, this.amount_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.amount_ != 0L) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)this.amount_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Load)) {
                return super.equals(obj);
            }
            Load other = (Load)obj;
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Load.getDescriptor().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)this.getAmount());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Load parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Load)PARSER.parseFrom(data);
        }

        public static Load parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Load)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Load parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Load)PARSER.parseFrom(data);
        }

        public static Load parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Load)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Load parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Load)PARSER.parseFrom(data);
        }

        public static Load parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Load)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Load parseFrom(InputStream input) throws IOException {
            return (Load)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Load parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Load)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Load parseDelimitedFrom(InputStream input) throws IOException {
            return (Load)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Load parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Load)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Load parseFrom(CodedInputStream input) throws IOException {
            return (Load)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Load parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Load)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Load.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Load prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Load getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Load> parser() {
            return PARSER;
        }

        public Parser<Load> getParserForType() {
            return PARSER;
        }

        public Load getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements LoadOrBuilder {
            private int bitField0_;
            private long amount_;

            public static final Descriptors.Descriptor getDescriptor() {
                return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_Load_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_Load_fieldAccessorTable.ensureFieldAccessorsInitialized(Load.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.amount_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_Load_descriptor;
            }

            public Load getDefaultInstanceForType() {
                return Load.getDefaultInstance();
            }

            public Load build() {
                Load result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Load buildPartial() {
                Load result = new Load(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(Load result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.amount_ = this.amount_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Load) {
                    return this.mergeFrom((Load)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Load other) {
                if (other == Load.getDefaultInstance()) {
                    return this;
                }
                if (other.getAmount() != 0L) {
                    this.setAmount(other.getAmount());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 16: {
                                this.amount_ = input.readInt64();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public long getAmount() {
                return this.amount_;
            }

            public Builder setAmount(long value) {
                this.amount_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearAmount() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.amount_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface LoadOrBuilder
    extends MessageOrBuilder {
        public long getAmount();
    }

    public static final class VisitRequest
    extends GeneratedMessageV3
    implements VisitRequestOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int ARRIVAL_LOCATION_FIELD_NUMBER = 1;
        private LatLng arrivalLocation_;
        public static final int ARRIVAL_WAYPOINT_FIELD_NUMBER = 2;
        private Waypoint arrivalWaypoint_;
        public static final int DEPARTURE_LOCATION_FIELD_NUMBER = 3;
        private LatLng departureLocation_;
        public static final int DEPARTURE_WAYPOINT_FIELD_NUMBER = 4;
        private Waypoint departureWaypoint_;
        public static final int TAGS_FIELD_NUMBER = 5;
        private LazyStringArrayList tags_ = LazyStringArrayList.emptyList();
        public static final int TIME_WINDOWS_FIELD_NUMBER = 6;
        private List<TimeWindow> timeWindows_;
        public static final int DURATION_FIELD_NUMBER = 7;
        private Duration duration_;
        public static final int COST_FIELD_NUMBER = 8;
        private double cost_ = 0.0;
        public static final int LOAD_DEMANDS_FIELD_NUMBER = 12;
        private MapField<String, Load> loadDemands_;
        public static final int VISIT_TYPES_FIELD_NUMBER = 10;
        private LazyStringArrayList visitTypes_ = LazyStringArrayList.emptyList();
        public static final int LABEL_FIELD_NUMBER = 11;
        private volatile Object label_ = "";
        public static final int DEMANDS_FIELD_NUMBER = 9;
        private List<CapacityQuantity> demands_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final VisitRequest DEFAULT_INSTANCE = new VisitRequest();
        private static final Parser<VisitRequest> PARSER = new AbstractParser<VisitRequest>(){

            public VisitRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = VisitRequest.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private VisitRequest(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private VisitRequest() {
            this.tags_ = LazyStringArrayList.emptyList();
            this.timeWindows_ = Collections.emptyList();
            this.visitTypes_ = LazyStringArrayList.emptyList();
            this.label_ = "";
            this.demands_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new VisitRequest();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 12: {
                    return this.internalGetLoadDemands();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(VisitRequest.class, Builder.class);
        }

        @Override
        public boolean hasArrivalLocation() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public LatLng getArrivalLocation() {
            return this.arrivalLocation_ == null ? LatLng.getDefaultInstance() : this.arrivalLocation_;
        }

        @Override
        public LatLngOrBuilder getArrivalLocationOrBuilder() {
            return this.arrivalLocation_ == null ? LatLng.getDefaultInstance() : this.arrivalLocation_;
        }

        @Override
        public boolean hasArrivalWaypoint() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Waypoint getArrivalWaypoint() {
            return this.arrivalWaypoint_ == null ? Waypoint.getDefaultInstance() : this.arrivalWaypoint_;
        }

        @Override
        public WaypointOrBuilder getArrivalWaypointOrBuilder() {
            return this.arrivalWaypoint_ == null ? Waypoint.getDefaultInstance() : this.arrivalWaypoint_;
        }

        @Override
        public boolean hasDepartureLocation() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public LatLng getDepartureLocation() {
            return this.departureLocation_ == null ? LatLng.getDefaultInstance() : this.departureLocation_;
        }

        @Override
        public LatLngOrBuilder getDepartureLocationOrBuilder() {
            return this.departureLocation_ == null ? LatLng.getDefaultInstance() : this.departureLocation_;
        }

        @Override
        public boolean hasDepartureWaypoint() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Waypoint getDepartureWaypoint() {
            return this.departureWaypoint_ == null ? Waypoint.getDefaultInstance() : this.departureWaypoint_;
        }

        @Override
        public WaypointOrBuilder getDepartureWaypointOrBuilder() {
            return this.departureWaypoint_ == null ? Waypoint.getDefaultInstance() : this.departureWaypoint_;
        }

        public ProtocolStringList getTagsList() {
            return this.tags_;
        }

        @Override
        public int getTagsCount() {
            return this.tags_.size();
        }

        @Override
        public String getTags(int index) {
            return this.tags_.get(index);
        }

        @Override
        public ByteString getTagsBytes(int index) {
            return this.tags_.getByteString(index);
        }

        @Override
        public List<TimeWindow> getTimeWindowsList() {
            return this.timeWindows_;
        }

        @Override
        public List<? extends TimeWindowOrBuilder> getTimeWindowsOrBuilderList() {
            return this.timeWindows_;
        }

        @Override
        public int getTimeWindowsCount() {
            return this.timeWindows_.size();
        }

        @Override
        public TimeWindow getTimeWindows(int index) {
            return this.timeWindows_.get(index);
        }

        @Override
        public TimeWindowOrBuilder getTimeWindowsOrBuilder(int index) {
            return this.timeWindows_.get(index);
        }

        @Override
        public boolean hasDuration() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Duration getDuration() {
            return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
        }

        @Override
        public DurationOrBuilder getDurationOrBuilder() {
            return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
        }

        @Override
        public double getCost() {
            return this.cost_;
        }

        private MapField<String, Load> internalGetLoadDemands() {
            if (this.loadDemands_ == null) {
                return MapField.emptyMapField(LoadDemandsDefaultEntryHolder.defaultEntry);
            }
            return this.loadDemands_;
        }

        @Override
        public int getLoadDemandsCount() {
            return this.internalGetLoadDemands().getMap().size();
        }

        @Override
        public boolean containsLoadDemands(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLoadDemands().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, Load> getLoadDemands() {
            return this.getLoadDemandsMap();
        }

        @Override
        public Map<String, Load> getLoadDemandsMap() {
            return this.internalGetLoadDemands().getMap();
        }

        @Override
        public Load getLoadDemandsOrDefault(String key, Load defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLoadDemands().getMap();
            return map.containsKey(key) ? (Load)map.get(key) : defaultValue;
        }

        @Override
        public Load getLoadDemandsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLoadDemands().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (Load)map.get(key);
        }

        public ProtocolStringList getVisitTypesList() {
            return this.visitTypes_;
        }

        @Override
        public int getVisitTypesCount() {
            return this.visitTypes_.size();
        }

        @Override
        public String getVisitTypes(int index) {
            return this.visitTypes_.get(index);
        }

        @Override
        public ByteString getVisitTypesBytes(int index) {
            return this.visitTypes_.getByteString(index);
        }

        @Override
        public String getLabel() {
            Object ref = this.label_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.label_ = s;
            return s;
        }

        @Override
        public ByteString getLabelBytes() {
            Object ref = this.label_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.label_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        @Deprecated
        public List<CapacityQuantity> getDemandsList() {
            return this.demands_;
        }

        @Override
        @Deprecated
        public List<? extends CapacityQuantityOrBuilder> getDemandsOrBuilderList() {
            return this.demands_;
        }

        @Override
        @Deprecated
        public int getDemandsCount() {
            return this.demands_.size();
        }

        @Override
        @Deprecated
        public CapacityQuantity getDemands(int index) {
            return this.demands_.get(index);
        }

        @Override
        @Deprecated
        public CapacityQuantityOrBuilder getDemandsOrBuilder(int index) {
            return this.demands_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            int i;
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(1, (MessageLite)this.getArrivalLocation());
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeMessage(2, (MessageLite)this.getArrivalWaypoint());
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeMessage(3, (MessageLite)this.getDepartureLocation());
            }
            if ((this.bitField0_ & 8) != 0) {
                output.writeMessage(4, (MessageLite)this.getDepartureWaypoint());
            }
            for (i = 0; i < this.tags_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.tags_.getRaw(i));
            }
            for (i = 0; i < this.timeWindows_.size(); ++i) {
                output.writeMessage(6, (MessageLite)this.timeWindows_.get(i));
            }
            if ((this.bitField0_ & 0x10) != 0) {
                output.writeMessage(7, (MessageLite)this.getDuration());
            }
            if (Double.doubleToRawLongBits(this.cost_) != 0L) {
                output.writeDouble(8, this.cost_);
            }
            for (i = 0; i < this.demands_.size(); ++i) {
                output.writeMessage(9, (MessageLite)this.demands_.get(i));
            }
            for (i = 0; i < this.visitTypes_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.visitTypes_.getRaw(i));
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.label_);
            }
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLoadDemands(), LoadDemandsDefaultEntryHolder.defaultEntry, (int)12);
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int i;
            int i2;
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getArrivalLocation());
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getArrivalWaypoint());
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getDepartureLocation());
            }
            if ((this.bitField0_ & 8) != 0) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getDepartureWaypoint());
            }
            int dataSize = 0;
            for (i2 = 0; i2 < this.tags_.size(); ++i2) {
                dataSize += VisitRequest.computeStringSizeNoTag((Object)this.tags_.getRaw(i2));
            }
            size += dataSize;
            size += 1 * this.getTagsList().size();
            for (i = 0; i < this.timeWindows_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.timeWindows_.get(i)));
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getDuration());
            }
            if (Double.doubleToRawLongBits(this.cost_) != 0L) {
                size += CodedOutputStream.computeDoubleSize((int)8, (double)this.cost_);
            }
            for (i = 0; i < this.demands_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.demands_.get(i)));
            }
            dataSize = 0;
            for (i2 = 0; i2 < this.visitTypes_.size(); ++i2) {
                dataSize += VisitRequest.computeStringSizeNoTag((Object)this.visitTypes_.getRaw(i2));
            }
            size += dataSize;
            size += 1 * this.getVisitTypesList().size();
            if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
                size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.label_);
            }
            for (Map.Entry entry : this.internalGetLoadDemands().getMap().entrySet()) {
                MapEntry loadDemands__ = LoadDemandsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)loadDemands__);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VisitRequest)) {
                return super.equals(obj);
            }
            VisitRequest other = (VisitRequest)obj;
            if (this.hasArrivalLocation() != other.hasArrivalLocation()) {
                return false;
            }
            if (this.hasArrivalLocation() && !this.getArrivalLocation().equals((Object)other.getArrivalLocation())) {
                return false;
            }
            if (this.hasArrivalWaypoint() != other.hasArrivalWaypoint()) {
                return false;
            }
            if (this.hasArrivalWaypoint() && !this.getArrivalWaypoint().equals(other.getArrivalWaypoint())) {
                return false;
            }
            if (this.hasDepartureLocation() != other.hasDepartureLocation()) {
                return false;
            }
            if (this.hasDepartureLocation() && !this.getDepartureLocation().equals((Object)other.getDepartureLocation())) {
                return false;
            }
            if (this.hasDepartureWaypoint() != other.hasDepartureWaypoint()) {
                return false;
            }
            if (this.hasDepartureWaypoint() && !this.getDepartureWaypoint().equals(other.getDepartureWaypoint())) {
                return false;
            }
            if (!this.getTagsList().equals(other.getTagsList())) {
                return false;
            }
            if (!this.getTimeWindowsList().equals(other.getTimeWindowsList())) {
                return false;
            }
            if (this.hasDuration() != other.hasDuration()) {
                return false;
            }
            if (this.hasDuration() && !this.getDuration().equals((Object)other.getDuration())) {
                return false;
            }
            if (Double.doubleToLongBits(this.getCost()) != Double.doubleToLongBits(other.getCost())) {
                return false;
            }
            if (!this.internalGetLoadDemands().equals(other.internalGetLoadDemands())) {
                return false;
            }
            if (!this.getVisitTypesList().equals(other.getVisitTypesList())) {
                return false;
            }
            if (!this.getLabel().equals(other.getLabel())) {
                return false;
            }
            if (!this.getDemandsList().equals(other.getDemandsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + VisitRequest.getDescriptor().hashCode();
            if (this.hasArrivalLocation()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getArrivalLocation().hashCode();
            }
            if (this.hasArrivalWaypoint()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getArrivalWaypoint().hashCode();
            }
            if (this.hasDepartureLocation()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getDepartureLocation().hashCode();
            }
            if (this.hasDepartureWaypoint()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getDepartureWaypoint().hashCode();
            }
            if (this.getTagsCount() > 0) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getTagsList().hashCode();
            }
            if (this.getTimeWindowsCount() > 0) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getTimeWindowsList().hashCode();
            }
            if (this.hasDuration()) {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getDuration().hashCode();
            }
            hash = 37 * hash + 8;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCost()));
            if (!this.internalGetLoadDemands().getMap().isEmpty()) {
                hash = 37 * hash + 12;
                hash = 53 * hash + this.internalGetLoadDemands().hashCode();
            }
            if (this.getVisitTypesCount() > 0) {
                hash = 37 * hash + 10;
                hash = 53 * hash + this.getVisitTypesList().hashCode();
            }
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getLabel().hashCode();
            if (this.getDemandsCount() > 0) {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.getDemandsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static VisitRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (VisitRequest)PARSER.parseFrom(data);
        }

        public static VisitRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (VisitRequest)PARSER.parseFrom(data, extensionRegistry);
        }

        public static VisitRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (VisitRequest)PARSER.parseFrom(data);
        }

        public static VisitRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (VisitRequest)PARSER.parseFrom(data, extensionRegistry);
        }

        public static VisitRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (VisitRequest)PARSER.parseFrom(data);
        }

        public static VisitRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (VisitRequest)PARSER.parseFrom(data, extensionRegistry);
        }

        public static VisitRequest parseFrom(InputStream input) throws IOException {
            return (VisitRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static VisitRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (VisitRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static VisitRequest parseDelimitedFrom(InputStream input) throws IOException {
            return (VisitRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static VisitRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (VisitRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static VisitRequest parseFrom(CodedInputStream input) throws IOException {
            return (VisitRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static VisitRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (VisitRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return VisitRequest.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(VisitRequest prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static VisitRequest getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<VisitRequest> parser() {
            return PARSER;
        }

        public Parser<VisitRequest> getParserForType() {
            return PARSER;
        }

        public VisitRequest getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements VisitRequestOrBuilder {
            private int bitField0_;
            private LatLng arrivalLocation_;
            private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> arrivalLocationBuilder_;
            private Waypoint arrivalWaypoint_;
            private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> arrivalWaypointBuilder_;
            private LatLng departureLocation_;
            private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> departureLocationBuilder_;
            private Waypoint departureWaypoint_;
            private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> departureWaypointBuilder_;
            private LazyStringArrayList tags_ = LazyStringArrayList.emptyList();
            private List<TimeWindow> timeWindows_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> timeWindowsBuilder_;
            private Duration duration_;
            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> durationBuilder_;
            private double cost_;
            private static final LoadDemandsConverter loadDemandsConverter = new LoadDemandsConverter();
            private MapFieldBuilder<String, LoadOrBuilder, Load, Load.Builder> loadDemands_;
            private LazyStringArrayList visitTypes_ = LazyStringArrayList.emptyList();
            private Object label_ = "";
            private List<CapacityQuantity> demands_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<CapacityQuantity, CapacityQuantity.Builder, CapacityQuantityOrBuilder> demandsBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_descriptor;
            }

            protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
                switch (number) {
                    case 12: {
                        return this.internalGetLoadDemands();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
                switch (number) {
                    case 12: {
                        return this.internalGetMutableLoadDemands();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(VisitRequest.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getArrivalLocationFieldBuilder();
                    this.getArrivalWaypointFieldBuilder();
                    this.getDepartureLocationFieldBuilder();
                    this.getDepartureWaypointFieldBuilder();
                    this.getTimeWindowsFieldBuilder();
                    this.getDurationFieldBuilder();
                    this.getDemandsFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.arrivalLocation_ = null;
                if (this.arrivalLocationBuilder_ != null) {
                    this.arrivalLocationBuilder_.dispose();
                    this.arrivalLocationBuilder_ = null;
                }
                this.arrivalWaypoint_ = null;
                if (this.arrivalWaypointBuilder_ != null) {
                    this.arrivalWaypointBuilder_.dispose();
                    this.arrivalWaypointBuilder_ = null;
                }
                this.departureLocation_ = null;
                if (this.departureLocationBuilder_ != null) {
                    this.departureLocationBuilder_.dispose();
                    this.departureLocationBuilder_ = null;
                }
                this.departureWaypoint_ = null;
                if (this.departureWaypointBuilder_ != null) {
                    this.departureWaypointBuilder_.dispose();
                    this.departureWaypointBuilder_ = null;
                }
                this.tags_ = LazyStringArrayList.emptyList();
                if (this.timeWindowsBuilder_ == null) {
                    this.timeWindows_ = Collections.emptyList();
                } else {
                    this.timeWindows_ = null;
                    this.timeWindowsBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFDF;
                this.duration_ = null;
                if (this.durationBuilder_ != null) {
                    this.durationBuilder_.dispose();
                    this.durationBuilder_ = null;
                }
                this.cost_ = 0.0;
                this.internalGetMutableLoadDemands().clear();
                this.visitTypes_ = LazyStringArrayList.emptyList();
                this.label_ = "";
                if (this.demandsBuilder_ == null) {
                    this.demands_ = Collections.emptyList();
                } else {
                    this.demands_ = null;
                    this.demandsBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFF7FF;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_descriptor;
            }

            public VisitRequest getDefaultInstanceForType() {
                return VisitRequest.getDefaultInstance();
            }

            public VisitRequest build() {
                VisitRequest result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public VisitRequest buildPartial() {
                VisitRequest result = new VisitRequest(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(VisitRequest result) {
                if (this.timeWindowsBuilder_ == null) {
                    if ((this.bitField0_ & 0x20) != 0) {
                        this.timeWindows_ = Collections.unmodifiableList(this.timeWindows_);
                        this.bitField0_ &= 0xFFFFFFDF;
                    }
                    result.timeWindows_ = this.timeWindows_;
                } else {
                    result.timeWindows_ = this.timeWindowsBuilder_.build();
                }
                if (this.demandsBuilder_ == null) {
                    if ((this.bitField0_ & 0x800) != 0) {
                        this.demands_ = Collections.unmodifiableList(this.demands_);
                        this.bitField0_ &= 0xFFFFF7FF;
                    }
                    result.demands_ = this.demands_;
                } else {
                    result.demands_ = this.demandsBuilder_.build();
                }
            }

            private void buildPartial0(VisitRequest result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.arrivalLocation_ = this.arrivalLocationBuilder_ == null ? this.arrivalLocation_ : (LatLng)this.arrivalLocationBuilder_.build();
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.arrivalWaypoint_ = this.arrivalWaypointBuilder_ == null ? this.arrivalWaypoint_ : (Waypoint)this.arrivalWaypointBuilder_.build();
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.departureLocation_ = this.departureLocationBuilder_ == null ? this.departureLocation_ : (LatLng)this.departureLocationBuilder_.build();
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.departureWaypoint_ = this.departureWaypointBuilder_ == null ? this.departureWaypoint_ : (Waypoint)this.departureWaypointBuilder_.build();
                    to_bitField0_ |= 8;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    this.tags_.makeImmutable();
                    result.tags_ = this.tags_;
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    result.duration_ = this.durationBuilder_ == null ? this.duration_ : (Duration)this.durationBuilder_.build();
                    to_bitField0_ |= 0x10;
                }
                if ((from_bitField0_ & 0x80) != 0) {
                    result.cost_ = this.cost_;
                }
                if ((from_bitField0_ & 0x100) != 0) {
                    result.loadDemands_ = this.internalGetLoadDemands().build(LoadDemandsDefaultEntryHolder.defaultEntry);
                }
                if ((from_bitField0_ & 0x200) != 0) {
                    this.visitTypes_.makeImmutable();
                    result.visitTypes_ = this.visitTypes_;
                }
                if ((from_bitField0_ & 0x400) != 0) {
                    result.label_ = this.label_;
                }
                VisitRequest visitRequest = result;
                visitRequest.bitField0_ = visitRequest.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof VisitRequest) {
                    return this.mergeFrom((VisitRequest)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(VisitRequest other) {
                if (other == VisitRequest.getDefaultInstance()) {
                    return this;
                }
                if (other.hasArrivalLocation()) {
                    this.mergeArrivalLocation(other.getArrivalLocation());
                }
                if (other.hasArrivalWaypoint()) {
                    this.mergeArrivalWaypoint(other.getArrivalWaypoint());
                }
                if (other.hasDepartureLocation()) {
                    this.mergeDepartureLocation(other.getDepartureLocation());
                }
                if (other.hasDepartureWaypoint()) {
                    this.mergeDepartureWaypoint(other.getDepartureWaypoint());
                }
                if (!other.tags_.isEmpty()) {
                    if (this.tags_.isEmpty()) {
                        this.tags_ = other.tags_;
                        this.bitField0_ |= 0x10;
                    } else {
                        this.ensureTagsIsMutable();
                        this.tags_.addAll((Collection)other.tags_);
                    }
                    this.onChanged();
                }
                if (this.timeWindowsBuilder_ == null) {
                    if (!other.timeWindows_.isEmpty()) {
                        if (this.timeWindows_.isEmpty()) {
                            this.timeWindows_ = other.timeWindows_;
                            this.bitField0_ &= 0xFFFFFFDF;
                        } else {
                            this.ensureTimeWindowsIsMutable();
                            this.timeWindows_.addAll(other.timeWindows_);
                        }
                        this.onChanged();
                    }
                } else if (!other.timeWindows_.isEmpty()) {
                    if (this.timeWindowsBuilder_.isEmpty()) {
                        this.timeWindowsBuilder_.dispose();
                        this.timeWindowsBuilder_ = null;
                        this.timeWindows_ = other.timeWindows_;
                        this.bitField0_ &= 0xFFFFFFDF;
                        this.timeWindowsBuilder_ = alwaysUseFieldBuilders ? this.getTimeWindowsFieldBuilder() : null;
                    } else {
                        this.timeWindowsBuilder_.addAllMessages((Iterable)other.timeWindows_);
                    }
                }
                if (other.hasDuration()) {
                    this.mergeDuration(other.getDuration());
                }
                if (other.getCost() != 0.0) {
                    this.setCost(other.getCost());
                }
                this.internalGetMutableLoadDemands().mergeFrom(other.internalGetLoadDemands());
                this.bitField0_ |= 0x100;
                if (!other.visitTypes_.isEmpty()) {
                    if (this.visitTypes_.isEmpty()) {
                        this.visitTypes_ = other.visitTypes_;
                        this.bitField0_ |= 0x200;
                    } else {
                        this.ensureVisitTypesIsMutable();
                        this.visitTypes_.addAll((Collection)other.visitTypes_);
                    }
                    this.onChanged();
                }
                if (!other.getLabel().isEmpty()) {
                    this.label_ = other.label_;
                    this.bitField0_ |= 0x400;
                    this.onChanged();
                }
                if (this.demandsBuilder_ == null) {
                    if (!other.demands_.isEmpty()) {
                        if (this.demands_.isEmpty()) {
                            this.demands_ = other.demands_;
                            this.bitField0_ &= 0xFFFFF7FF;
                        } else {
                            this.ensureDemandsIsMutable();
                            this.demands_.addAll(other.demands_);
                        }
                        this.onChanged();
                    }
                } else if (!other.demands_.isEmpty()) {
                    if (this.demandsBuilder_.isEmpty()) {
                        this.demandsBuilder_.dispose();
                        this.demandsBuilder_ = null;
                        this.demands_ = other.demands_;
                        this.bitField0_ &= 0xFFFFF7FF;
                        this.demandsBuilder_ = alwaysUseFieldBuilders ? this.getDemandsFieldBuilder() : null;
                    } else {
                        this.demandsBuilder_.addAllMessages((Iterable)other.demands_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block20: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block20;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getArrivalLocationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block20;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getArrivalWaypointFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block20;
                            }
                            case 26: {
                                input.readMessage((MessageLite.Builder)this.getDepartureLocationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 4;
                                continue block20;
                            }
                            case 34: {
                                input.readMessage((MessageLite.Builder)this.getDepartureWaypointFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 8;
                                continue block20;
                            }
                            case 42: {
                                String s = input.readStringRequireUtf8();
                                this.ensureTagsIsMutable();
                                this.tags_.add((Object)s);
                                continue block20;
                            }
                            case 50: {
                                GeneratedMessageV3 m = (TimeWindow)input.readMessage(TimeWindow.parser(), extensionRegistry);
                                if (this.timeWindowsBuilder_ == null) {
                                    this.ensureTimeWindowsIsMutable();
                                    this.timeWindows_.add((TimeWindow)m);
                                    continue block20;
                                }
                                this.timeWindowsBuilder_.addMessage((AbstractMessage)m);
                                continue block20;
                            }
                            case 58: {
                                input.readMessage((MessageLite.Builder)this.getDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x40;
                                continue block20;
                            }
                            case 65: {
                                this.cost_ = input.readDouble();
                                this.bitField0_ |= 0x80;
                                continue block20;
                            }
                            case 74: {
                                GeneratedMessageV3 m = (CapacityQuantity)input.readMessage(CapacityQuantity.parser(), extensionRegistry);
                                if (this.demandsBuilder_ == null) {
                                    this.ensureDemandsIsMutable();
                                    this.demands_.add((CapacityQuantity)m);
                                    continue block20;
                                }
                                this.demandsBuilder_.addMessage((AbstractMessage)m);
                                continue block20;
                            }
                            case 82: {
                                String s = input.readStringRequireUtf8();
                                this.ensureVisitTypesIsMutable();
                                this.visitTypes_.add((Object)s);
                                continue block20;
                            }
                            case 90: {
                                this.label_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x400;
                                continue block20;
                            }
                            case 98: {
                                MapEntry loadDemands__ = (MapEntry)input.readMessage(LoadDemandsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableLoadDemands().ensureBuilderMap().put(loadDemands__.getKey(), loadDemands__.getValue());
                                this.bitField0_ |= 0x100;
                                continue block20;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasArrivalLocation() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public LatLng getArrivalLocation() {
                if (this.arrivalLocationBuilder_ == null) {
                    return this.arrivalLocation_ == null ? LatLng.getDefaultInstance() : this.arrivalLocation_;
                }
                return (LatLng)this.arrivalLocationBuilder_.getMessage();
            }

            public Builder setArrivalLocation(LatLng value) {
                if (this.arrivalLocationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.arrivalLocation_ = value;
                } else {
                    this.arrivalLocationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setArrivalLocation(LatLng.Builder builderForValue) {
                if (this.arrivalLocationBuilder_ == null) {
                    this.arrivalLocation_ = builderForValue.build();
                } else {
                    this.arrivalLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeArrivalLocation(LatLng value) {
                if (this.arrivalLocationBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.arrivalLocation_ != null && this.arrivalLocation_ != LatLng.getDefaultInstance()) {
                        this.getArrivalLocationBuilder().mergeFrom(value);
                    } else {
                        this.arrivalLocation_ = value;
                    }
                } else {
                    this.arrivalLocationBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.arrivalLocation_ != null) {
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearArrivalLocation() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.arrivalLocation_ = null;
                if (this.arrivalLocationBuilder_ != null) {
                    this.arrivalLocationBuilder_.dispose();
                    this.arrivalLocationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public LatLng.Builder getArrivalLocationBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return (LatLng.Builder)this.getArrivalLocationFieldBuilder().getBuilder();
            }

            @Override
            public LatLngOrBuilder getArrivalLocationOrBuilder() {
                if (this.arrivalLocationBuilder_ != null) {
                    return (LatLngOrBuilder)this.arrivalLocationBuilder_.getMessageOrBuilder();
                }
                return this.arrivalLocation_ == null ? LatLng.getDefaultInstance() : this.arrivalLocation_;
            }

            private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getArrivalLocationFieldBuilder() {
                if (this.arrivalLocationBuilder_ == null) {
                    this.arrivalLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getArrivalLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.arrivalLocation_ = null;
                }
                return this.arrivalLocationBuilder_;
            }

            @Override
            public boolean hasArrivalWaypoint() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public Waypoint getArrivalWaypoint() {
                if (this.arrivalWaypointBuilder_ == null) {
                    return this.arrivalWaypoint_ == null ? Waypoint.getDefaultInstance() : this.arrivalWaypoint_;
                }
                return (Waypoint)this.arrivalWaypointBuilder_.getMessage();
            }

            public Builder setArrivalWaypoint(Waypoint value) {
                if (this.arrivalWaypointBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.arrivalWaypoint_ = value;
                } else {
                    this.arrivalWaypointBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setArrivalWaypoint(Waypoint.Builder builderForValue) {
                if (this.arrivalWaypointBuilder_ == null) {
                    this.arrivalWaypoint_ = builderForValue.build();
                } else {
                    this.arrivalWaypointBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeArrivalWaypoint(Waypoint value) {
                if (this.arrivalWaypointBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.arrivalWaypoint_ != null && this.arrivalWaypoint_ != Waypoint.getDefaultInstance()) {
                        this.getArrivalWaypointBuilder().mergeFrom(value);
                    } else {
                        this.arrivalWaypoint_ = value;
                    }
                } else {
                    this.arrivalWaypointBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.arrivalWaypoint_ != null) {
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearArrivalWaypoint() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.arrivalWaypoint_ = null;
                if (this.arrivalWaypointBuilder_ != null) {
                    this.arrivalWaypointBuilder_.dispose();
                    this.arrivalWaypointBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Waypoint.Builder getArrivalWaypointBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return (Waypoint.Builder)this.getArrivalWaypointFieldBuilder().getBuilder();
            }

            @Override
            public WaypointOrBuilder getArrivalWaypointOrBuilder() {
                if (this.arrivalWaypointBuilder_ != null) {
                    return (WaypointOrBuilder)this.arrivalWaypointBuilder_.getMessageOrBuilder();
                }
                return this.arrivalWaypoint_ == null ? Waypoint.getDefaultInstance() : this.arrivalWaypoint_;
            }

            private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getArrivalWaypointFieldBuilder() {
                if (this.arrivalWaypointBuilder_ == null) {
                    this.arrivalWaypointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getArrivalWaypoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.arrivalWaypoint_ = null;
                }
                return this.arrivalWaypointBuilder_;
            }

            @Override
            public boolean hasDepartureLocation() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public LatLng getDepartureLocation() {
                if (this.departureLocationBuilder_ == null) {
                    return this.departureLocation_ == null ? LatLng.getDefaultInstance() : this.departureLocation_;
                }
                return (LatLng)this.departureLocationBuilder_.getMessage();
            }

            public Builder setDepartureLocation(LatLng value) {
                if (this.departureLocationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.departureLocation_ = value;
                } else {
                    this.departureLocationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder setDepartureLocation(LatLng.Builder builderForValue) {
                if (this.departureLocationBuilder_ == null) {
                    this.departureLocation_ = builderForValue.build();
                } else {
                    this.departureLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder mergeDepartureLocation(LatLng value) {
                if (this.departureLocationBuilder_ == null) {
                    if ((this.bitField0_ & 4) != 0 && this.departureLocation_ != null && this.departureLocation_ != LatLng.getDefaultInstance()) {
                        this.getDepartureLocationBuilder().mergeFrom(value);
                    } else {
                        this.departureLocation_ = value;
                    }
                } else {
                    this.departureLocationBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.departureLocation_ != null) {
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearDepartureLocation() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.departureLocation_ = null;
                if (this.departureLocationBuilder_ != null) {
                    this.departureLocationBuilder_.dispose();
                    this.departureLocationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public LatLng.Builder getDepartureLocationBuilder() {
                this.bitField0_ |= 4;
                this.onChanged();
                return (LatLng.Builder)this.getDepartureLocationFieldBuilder().getBuilder();
            }

            @Override
            public LatLngOrBuilder getDepartureLocationOrBuilder() {
                if (this.departureLocationBuilder_ != null) {
                    return (LatLngOrBuilder)this.departureLocationBuilder_.getMessageOrBuilder();
                }
                return this.departureLocation_ == null ? LatLng.getDefaultInstance() : this.departureLocation_;
            }

            private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getDepartureLocationFieldBuilder() {
                if (this.departureLocationBuilder_ == null) {
                    this.departureLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDepartureLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.departureLocation_ = null;
                }
                return this.departureLocationBuilder_;
            }

            @Override
            public boolean hasDepartureWaypoint() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public Waypoint getDepartureWaypoint() {
                if (this.departureWaypointBuilder_ == null) {
                    return this.departureWaypoint_ == null ? Waypoint.getDefaultInstance() : this.departureWaypoint_;
                }
                return (Waypoint)this.departureWaypointBuilder_.getMessage();
            }

            public Builder setDepartureWaypoint(Waypoint value) {
                if (this.departureWaypointBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.departureWaypoint_ = value;
                } else {
                    this.departureWaypointBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder setDepartureWaypoint(Waypoint.Builder builderForValue) {
                if (this.departureWaypointBuilder_ == null) {
                    this.departureWaypoint_ = builderForValue.build();
                } else {
                    this.departureWaypointBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder mergeDepartureWaypoint(Waypoint value) {
                if (this.departureWaypointBuilder_ == null) {
                    if ((this.bitField0_ & 8) != 0 && this.departureWaypoint_ != null && this.departureWaypoint_ != Waypoint.getDefaultInstance()) {
                        this.getDepartureWaypointBuilder().mergeFrom(value);
                    } else {
                        this.departureWaypoint_ = value;
                    }
                } else {
                    this.departureWaypointBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.departureWaypoint_ != null) {
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearDepartureWaypoint() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.departureWaypoint_ = null;
                if (this.departureWaypointBuilder_ != null) {
                    this.departureWaypointBuilder_.dispose();
                    this.departureWaypointBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Waypoint.Builder getDepartureWaypointBuilder() {
                this.bitField0_ |= 8;
                this.onChanged();
                return (Waypoint.Builder)this.getDepartureWaypointFieldBuilder().getBuilder();
            }

            @Override
            public WaypointOrBuilder getDepartureWaypointOrBuilder() {
                if (this.departureWaypointBuilder_ != null) {
                    return (WaypointOrBuilder)this.departureWaypointBuilder_.getMessageOrBuilder();
                }
                return this.departureWaypoint_ == null ? Waypoint.getDefaultInstance() : this.departureWaypoint_;
            }

            private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getDepartureWaypointFieldBuilder() {
                if (this.departureWaypointBuilder_ == null) {
                    this.departureWaypointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDepartureWaypoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.departureWaypoint_ = null;
                }
                return this.departureWaypointBuilder_;
            }

            private void ensureTagsIsMutable() {
                if (!this.tags_.isModifiable()) {
                    this.tags_ = new LazyStringArrayList((LazyStringList)this.tags_);
                }
                this.bitField0_ |= 0x10;
            }

            public ProtocolStringList getTagsList() {
                this.tags_.makeImmutable();
                return this.tags_;
            }

            @Override
            public int getTagsCount() {
                return this.tags_.size();
            }

            @Override
            public String getTags(int index) {
                return this.tags_.get(index);
            }

            @Override
            public ByteString getTagsBytes(int index) {
                return this.tags_.getByteString(index);
            }

            public Builder setTags(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTagsIsMutable();
                this.tags_.set(index, value);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder addTags(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTagsIsMutable();
                this.tags_.add((Object)value);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder addAllTags(Iterable<String> values) {
                this.ensureTagsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.tags_);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearTags() {
                this.tags_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
                return this;
            }

            public Builder addTagsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                VisitRequest.checkByteStringIsUtf8((ByteString)value);
                this.ensureTagsIsMutable();
                this.tags_.add(value);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            private void ensureTimeWindowsIsMutable() {
                if ((this.bitField0_ & 0x20) == 0) {
                    this.timeWindows_ = new ArrayList<TimeWindow>(this.timeWindows_);
                    this.bitField0_ |= 0x20;
                }
            }

            @Override
            public List<TimeWindow> getTimeWindowsList() {
                if (this.timeWindowsBuilder_ == null) {
                    return Collections.unmodifiableList(this.timeWindows_);
                }
                return this.timeWindowsBuilder_.getMessageList();
            }

            @Override
            public int getTimeWindowsCount() {
                if (this.timeWindowsBuilder_ == null) {
                    return this.timeWindows_.size();
                }
                return this.timeWindowsBuilder_.getCount();
            }

            @Override
            public TimeWindow getTimeWindows(int index) {
                if (this.timeWindowsBuilder_ == null) {
                    return this.timeWindows_.get(index);
                }
                return (TimeWindow)this.timeWindowsBuilder_.getMessage(index);
            }

            public Builder setTimeWindows(int index, TimeWindow value) {
                if (this.timeWindowsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.set(index, value);
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setTimeWindows(int index, TimeWindow.Builder builderForValue) {
                if (this.timeWindowsBuilder_ == null) {
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addTimeWindows(TimeWindow value) {
                if (this.timeWindowsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.add(value);
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addTimeWindows(int index, TimeWindow value) {
                if (this.timeWindowsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.add(index, value);
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addTimeWindows(TimeWindow.Builder builderForValue) {
                if (this.timeWindowsBuilder_ == null) {
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addTimeWindows(int index, TimeWindow.Builder builderForValue) {
                if (this.timeWindowsBuilder_ == null) {
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllTimeWindows(Iterable<? extends TimeWindow> values) {
                if (this.timeWindowsBuilder_ == null) {
                    this.ensureTimeWindowsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.timeWindows_);
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearTimeWindows() {
                if (this.timeWindowsBuilder_ == null) {
                    this.timeWindows_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.clear();
                }
                return this;
            }

            public Builder removeTimeWindows(int index) {
                if (this.timeWindowsBuilder_ == null) {
                    this.ensureTimeWindowsIsMutable();
                    this.timeWindows_.remove(index);
                    this.onChanged();
                } else {
                    this.timeWindowsBuilder_.remove(index);
                }
                return this;
            }

            public TimeWindow.Builder getTimeWindowsBuilder(int index) {
                return (TimeWindow.Builder)this.getTimeWindowsFieldBuilder().getBuilder(index);
            }

            @Override
            public TimeWindowOrBuilder getTimeWindowsOrBuilder(int index) {
                if (this.timeWindowsBuilder_ == null) {
                    return this.timeWindows_.get(index);
                }
                return (TimeWindowOrBuilder)this.timeWindowsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends TimeWindowOrBuilder> getTimeWindowsOrBuilderList() {
                if (this.timeWindowsBuilder_ != null) {
                    return this.timeWindowsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.timeWindows_);
            }

            public TimeWindow.Builder addTimeWindowsBuilder() {
                return (TimeWindow.Builder)this.getTimeWindowsFieldBuilder().addBuilder((AbstractMessage)TimeWindow.getDefaultInstance());
            }

            public TimeWindow.Builder addTimeWindowsBuilder(int index) {
                return (TimeWindow.Builder)this.getTimeWindowsFieldBuilder().addBuilder(index, (AbstractMessage)TimeWindow.getDefaultInstance());
            }

            public List<TimeWindow.Builder> getTimeWindowsBuilderList() {
                return this.getTimeWindowsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> getTimeWindowsFieldBuilder() {
                if (this.timeWindowsBuilder_ == null) {
                    this.timeWindowsBuilder_ = new RepeatedFieldBuilderV3(this.timeWindows_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.timeWindows_ = null;
                }
                return this.timeWindowsBuilder_;
            }

            @Override
            public boolean hasDuration() {
                return (this.bitField0_ & 0x40) != 0;
            }

            @Override
            public Duration getDuration() {
                if (this.durationBuilder_ == null) {
                    return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
                }
                return (Duration)this.durationBuilder_.getMessage();
            }

            public Builder setDuration(Duration value) {
                if (this.durationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.duration_ = value;
                } else {
                    this.durationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder setDuration(Duration.Builder builderForValue) {
                if (this.durationBuilder_ == null) {
                    this.duration_ = builderForValue.build();
                } else {
                    this.durationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder mergeDuration(Duration value) {
                if (this.durationBuilder_ == null) {
                    if ((this.bitField0_ & 0x40) != 0 && this.duration_ != null && this.duration_ != Duration.getDefaultInstance()) {
                        this.getDurationBuilder().mergeFrom(value);
                    } else {
                        this.duration_ = value;
                    }
                } else {
                    this.durationBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.duration_ != null) {
                    this.bitField0_ |= 0x40;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearDuration() {
                this.bitField0_ &= 0xFFFFFFBF;
                this.duration_ = null;
                if (this.durationBuilder_ != null) {
                    this.durationBuilder_.dispose();
                    this.durationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Duration.Builder getDurationBuilder() {
                this.bitField0_ |= 0x40;
                this.onChanged();
                return (Duration.Builder)this.getDurationFieldBuilder().getBuilder();
            }

            @Override
            public DurationOrBuilder getDurationOrBuilder() {
                if (this.durationBuilder_ != null) {
                    return (DurationOrBuilder)this.durationBuilder_.getMessageOrBuilder();
                }
                return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
            }

            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getDurationFieldBuilder() {
                if (this.durationBuilder_ == null) {
                    this.durationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.duration_ = null;
                }
                return this.durationBuilder_;
            }

            @Override
            public double getCost() {
                return this.cost_;
            }

            public Builder setCost(double value) {
                this.cost_ = value;
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            public Builder clearCost() {
                this.bitField0_ &= 0xFFFFFF7F;
                this.cost_ = 0.0;
                this.onChanged();
                return this;
            }

            private MapFieldBuilder<String, LoadOrBuilder, Load, Load.Builder> internalGetLoadDemands() {
                if (this.loadDemands_ == null) {
                    return new MapFieldBuilder((MapFieldBuilder.Converter)loadDemandsConverter);
                }
                return this.loadDemands_;
            }

            private MapFieldBuilder<String, LoadOrBuilder, Load, Load.Builder> internalGetMutableLoadDemands() {
                if (this.loadDemands_ == null) {
                    this.loadDemands_ = new MapFieldBuilder((MapFieldBuilder.Converter)loadDemandsConverter);
                }
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this.loadDemands_;
            }

            @Override
            public int getLoadDemandsCount() {
                return this.internalGetLoadDemands().ensureBuilderMap().size();
            }

            @Override
            public boolean containsLoadDemands(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetLoadDemands().ensureBuilderMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, Load> getLoadDemands() {
                return this.getLoadDemandsMap();
            }

            @Override
            public Map<String, Load> getLoadDemandsMap() {
                return this.internalGetLoadDemands().getImmutableMap();
            }

            @Override
            public Load getLoadDemandsOrDefault(String key, Load defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetMutableLoadDemands().ensureBuilderMap();
                return map.containsKey(key) ? loadDemandsConverter.build((LoadOrBuilder)map.get(key)) : defaultValue;
            }

            @Override
            public Load getLoadDemandsOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetMutableLoadDemands().ensureBuilderMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return loadDemandsConverter.build((LoadOrBuilder)map.get(key));
            }

            public Builder clearLoadDemands() {
                this.bitField0_ &= 0xFFFFFEFF;
                this.internalGetMutableLoadDemands().clear();
                return this;
            }

            public Builder removeLoadDemands(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableLoadDemands().ensureBuilderMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, Load> getMutableLoadDemands() {
                this.bitField0_ |= 0x100;
                return this.internalGetMutableLoadDemands().ensureMessageMap();
            }

            public Builder putLoadDemands(String key, Load value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableLoadDemands().ensureBuilderMap().put(key, value);
                this.bitField0_ |= 0x100;
                return this;
            }

            public Builder putAllLoadDemands(Map<String, Load> values) {
                for (Map.Entry<String, Load> e : values.entrySet()) {
                    if (e.getKey() != null && e.getValue() != null) continue;
                    throw new NullPointerException();
                }
                this.internalGetMutableLoadDemands().ensureBuilderMap().putAll(values);
                this.bitField0_ |= 0x100;
                return this;
            }

            public Load.Builder putLoadDemandsBuilderIfAbsent(String key) {
                Map builderMap = this.internalGetMutableLoadDemands().ensureBuilderMap();
                LoadOrBuilder entry = (LoadOrBuilder)builderMap.get(key);
                if (entry == null) {
                    entry = Load.newBuilder();
                    builderMap.put(key, entry);
                }
                if (entry instanceof Load) {
                    entry = ((Load)entry).toBuilder();
                    builderMap.put(key, entry);
                }
                return (Load.Builder)entry;
            }

            private void ensureVisitTypesIsMutable() {
                if (!this.visitTypes_.isModifiable()) {
                    this.visitTypes_ = new LazyStringArrayList((LazyStringList)this.visitTypes_);
                }
                this.bitField0_ |= 0x200;
            }

            public ProtocolStringList getVisitTypesList() {
                this.visitTypes_.makeImmutable();
                return this.visitTypes_;
            }

            @Override
            public int getVisitTypesCount() {
                return this.visitTypes_.size();
            }

            @Override
            public String getVisitTypes(int index) {
                return this.visitTypes_.get(index);
            }

            @Override
            public ByteString getVisitTypesBytes(int index) {
                return this.visitTypes_.getByteString(index);
            }

            public Builder setVisitTypes(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVisitTypesIsMutable();
                this.visitTypes_.set(index, value);
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder addVisitTypes(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVisitTypesIsMutable();
                this.visitTypes_.add((Object)value);
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder addAllVisitTypes(Iterable<String> values) {
                this.ensureVisitTypesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.visitTypes_);
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder clearVisitTypes() {
                this.visitTypes_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
                return this;
            }

            public Builder addVisitTypesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                VisitRequest.checkByteStringIsUtf8((ByteString)value);
                this.ensureVisitTypesIsMutable();
                this.visitTypes_.add(value);
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            @Override
            public String getLabel() {
                Object ref = this.label_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.label_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getLabelBytes() {
                Object ref = this.label_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.label_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setLabel(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.label_ = value;
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            public Builder clearLabel() {
                this.label_ = VisitRequest.getDefaultInstance().getLabel();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
                return this;
            }

            public Builder setLabelBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                VisitRequest.checkByteStringIsUtf8((ByteString)value);
                this.label_ = value;
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            private void ensureDemandsIsMutable() {
                if ((this.bitField0_ & 0x800) == 0) {
                    this.demands_ = new ArrayList<CapacityQuantity>(this.demands_);
                    this.bitField0_ |= 0x800;
                }
            }

            @Override
            @Deprecated
            public List<CapacityQuantity> getDemandsList() {
                if (this.demandsBuilder_ == null) {
                    return Collections.unmodifiableList(this.demands_);
                }
                return this.demandsBuilder_.getMessageList();
            }

            @Override
            @Deprecated
            public int getDemandsCount() {
                if (this.demandsBuilder_ == null) {
                    return this.demands_.size();
                }
                return this.demandsBuilder_.getCount();
            }

            @Override
            @Deprecated
            public CapacityQuantity getDemands(int index) {
                if (this.demandsBuilder_ == null) {
                    return this.demands_.get(index);
                }
                return (CapacityQuantity)this.demandsBuilder_.getMessage(index);
            }

            @Deprecated
            public Builder setDemands(int index, CapacityQuantity value) {
                if (this.demandsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureDemandsIsMutable();
                    this.demands_.set(index, value);
                    this.onChanged();
                } else {
                    this.demandsBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            @Deprecated
            public Builder setDemands(int index, CapacityQuantity.Builder builderForValue) {
                if (this.demandsBuilder_ == null) {
                    this.ensureDemandsIsMutable();
                    this.demands_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.demandsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            @Deprecated
            public Builder addDemands(CapacityQuantity value) {
                if (this.demandsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureDemandsIsMutable();
                    this.demands_.add(value);
                    this.onChanged();
                } else {
                    this.demandsBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            @Deprecated
            public Builder addDemands(int index, CapacityQuantity value) {
                if (this.demandsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureDemandsIsMutable();
                    this.demands_.add(index, value);
                    this.onChanged();
                } else {
                    this.demandsBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            @Deprecated
            public Builder addDemands(CapacityQuantity.Builder builderForValue) {
                if (this.demandsBuilder_ == null) {
                    this.ensureDemandsIsMutable();
                    this.demands_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.demandsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            @Deprecated
            public Builder addDemands(int index, CapacityQuantity.Builder builderForValue) {
                if (this.demandsBuilder_ == null) {
                    this.ensureDemandsIsMutable();
                    this.demands_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.demandsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            @Deprecated
            public Builder addAllDemands(Iterable<? extends CapacityQuantity> values) {
                if (this.demandsBuilder_ == null) {
                    this.ensureDemandsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.demands_);
                    this.onChanged();
                } else {
                    this.demandsBuilder_.addAllMessages(values);
                }
                return this;
            }

            @Deprecated
            public Builder clearDemands() {
                if (this.demandsBuilder_ == null) {
                    this.demands_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.onChanged();
                } else {
                    this.demandsBuilder_.clear();
                }
                return this;
            }

            @Deprecated
            public Builder removeDemands(int index) {
                if (this.demandsBuilder_ == null) {
                    this.ensureDemandsIsMutable();
                    this.demands_.remove(index);
                    this.onChanged();
                } else {
                    this.demandsBuilder_.remove(index);
                }
                return this;
            }

            @Deprecated
            public CapacityQuantity.Builder getDemandsBuilder(int index) {
                return (CapacityQuantity.Builder)this.getDemandsFieldBuilder().getBuilder(index);
            }

            @Override
            @Deprecated
            public CapacityQuantityOrBuilder getDemandsOrBuilder(int index) {
                if (this.demandsBuilder_ == null) {
                    return this.demands_.get(index);
                }
                return (CapacityQuantityOrBuilder)this.demandsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            @Deprecated
            public List<? extends CapacityQuantityOrBuilder> getDemandsOrBuilderList() {
                if (this.demandsBuilder_ != null) {
                    return this.demandsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.demands_);
            }

            @Deprecated
            public CapacityQuantity.Builder addDemandsBuilder() {
                return (CapacityQuantity.Builder)this.getDemandsFieldBuilder().addBuilder((AbstractMessage)CapacityQuantity.getDefaultInstance());
            }

            @Deprecated
            public CapacityQuantity.Builder addDemandsBuilder(int index) {
                return (CapacityQuantity.Builder)this.getDemandsFieldBuilder().addBuilder(index, (AbstractMessage)CapacityQuantity.getDefaultInstance());
            }

            @Deprecated
            public List<CapacityQuantity.Builder> getDemandsBuilderList() {
                return this.getDemandsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<CapacityQuantity, CapacityQuantity.Builder, CapacityQuantityOrBuilder> getDemandsFieldBuilder() {
                if (this.demandsBuilder_ == null) {
                    this.demandsBuilder_ = new RepeatedFieldBuilderV3(this.demands_, (this.bitField0_ & 0x800) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.demands_ = null;
                }
                return this.demandsBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }

            private static final class LoadDemandsConverter
            implements MapFieldBuilder.Converter<String, LoadOrBuilder, Load> {
                private LoadDemandsConverter() {
                }

                public Load build(LoadOrBuilder val) {
                    if (val instanceof Load) {
                        return (Load)val;
                    }
                    return ((Load.Builder)val).build();
                }

                public MapEntry<String, Load> defaultEntry() {
                    return LoadDemandsDefaultEntryHolder.defaultEntry;
                }
            }
        }

        private static final class LoadDemandsDefaultEntryHolder {
            static final MapEntry<String, Load> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)FleetRoutingProto.internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_LoadDemandsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)Load.getDefaultInstance());

            private LoadDemandsDefaultEntryHolder() {
            }
        }
    }

    public static interface VisitRequestOrBuilder
    extends MessageOrBuilder {
        public boolean hasArrivalLocation();

        public LatLng getArrivalLocation();

        public LatLngOrBuilder getArrivalLocationOrBuilder();

        public boolean hasArrivalWaypoint();

        public Waypoint getArrivalWaypoint();

        public WaypointOrBuilder getArrivalWaypointOrBuilder();

        public boolean hasDepartureLocation();

        public LatLng getDepartureLocation();

        public LatLngOrBuilder getDepartureLocationOrBuilder();

        public boolean hasDepartureWaypoint();

        public Waypoint getDepartureWaypoint();

        public WaypointOrBuilder getDepartureWaypointOrBuilder();

        public List<String> getTagsList();

        public int getTagsCount();

        public String getTags(int var1);

        public ByteString getTagsBytes(int var1);

        public List<TimeWindow> getTimeWindowsList();

        public TimeWindow getTimeWindows(int var1);

        public int getTimeWindowsCount();

        public List<? extends TimeWindowOrBuilder> getTimeWindowsOrBuilderList();

        public TimeWindowOrBuilder getTimeWindowsOrBuilder(int var1);

        public boolean hasDuration();

        public Duration getDuration();

        public DurationOrBuilder getDurationOrBuilder();

        public double getCost();

        public int getLoadDemandsCount();

        public boolean containsLoadDemands(String var1);

        @Deprecated
        public Map<String, Load> getLoadDemands();

        public Map<String, Load> getLoadDemandsMap();

        public Load getLoadDemandsOrDefault(String var1, Load var2);

        public Load getLoadDemandsOrThrow(String var1);

        public List<String> getVisitTypesList();

        public int getVisitTypesCount();

        public String getVisitTypes(int var1);

        public ByteString getVisitTypesBytes(int var1);

        public String getLabel();

        public ByteString getLabelBytes();

        @Deprecated
        public List<CapacityQuantity> getDemandsList();

        @Deprecated
        public CapacityQuantity getDemands(int var1);

        @Deprecated
        public int getDemandsCount();

        @Deprecated
        public List<? extends CapacityQuantityOrBuilder> getDemandsOrBuilderList();

        @Deprecated
        public CapacityQuantityOrBuilder getDemandsOrBuilder(int var1);
    }
}

