/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServerTlsPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVER_TLS_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serverTlsPolicy;

    @Deprecated
    protected ServerTlsPolicyName() {
        this.project = null;
        this.location = null;
        this.serverTlsPolicy = null;
    }

    private ServerTlsPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serverTlsPolicy = (String)Preconditions.checkNotNull((Object)builder.getServerTlsPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServerTlsPolicy() {
        return this.serverTlsPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServerTlsPolicyName of(String project, String location, String serverTlsPolicy) {
        return ServerTlsPolicyName.newBuilder().setProject(project).setLocation(location).setServerTlsPolicy(serverTlsPolicy).build();
    }

    public static String format(String project, String location, String serverTlsPolicy) {
        return ServerTlsPolicyName.newBuilder().setProject(project).setLocation(location).setServerTlsPolicy(serverTlsPolicy).build().toString();
    }

    public static ServerTlsPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVER_TLS_POLICY.validatedMatch(formattedString, "ServerTlsPolicyName.parse: formattedString not in valid format");
        return ServerTlsPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("server_tls_policy"));
    }

    public static List<ServerTlsPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<ServerTlsPolicyName> list = new ArrayList<ServerTlsPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServerTlsPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServerTlsPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServerTlsPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVER_TLS_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServerTlsPolicyName serverTlsPolicyName = this;
            synchronized (serverTlsPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serverTlsPolicy != null) {
                        fieldMapBuilder.put((Object)"server_tls_policy", (Object)this.serverTlsPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVER_TLS_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "server_tls_policy", this.serverTlsPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServerTlsPolicyName that = (ServerTlsPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serverTlsPolicy, that.serverTlsPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serverTlsPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serverTlsPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServerTlsPolicy() {
            return this.serverTlsPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServerTlsPolicy(String serverTlsPolicy) {
            this.serverTlsPolicy = serverTlsPolicy;
            return this;
        }

        private Builder(ServerTlsPolicyName serverTlsPolicyName) {
            this.project = serverTlsPolicyName.project;
            this.location = serverTlsPolicyName.location;
            this.serverTlsPolicy = serverTlsPolicyName.serverTlsPolicy;
        }

        public ServerTlsPolicyName build() {
            return new ServerTlsPolicyName(this);
        }
    }
}

