/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.memcache.v1;

import com.google.cloud.memcache.v1.CloudMemcacheProto;
import com.google.cloud.memcache.v1.InstanceOrBuilder;
import com.google.cloud.memcache.v1.MaintenancePolicy;
import com.google.cloud.memcache.v1.MaintenancePolicyOrBuilder;
import com.google.cloud.memcache.v1.MaintenanceSchedule;
import com.google.cloud.memcache.v1.MaintenanceScheduleOrBuilder;
import com.google.cloud.memcache.v1.MemcacheParameters;
import com.google.cloud.memcache.v1.MemcacheParametersOrBuilder;
import com.google.cloud.memcache.v1.MemcacheVersion;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Instance
extends GeneratedMessageV3
implements InstanceOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile Object displayName_ = "";
    public static final int LABELS_FIELD_NUMBER = 3;
    private MapField<String, String> labels_;
    public static final int AUTHORIZED_NETWORK_FIELD_NUMBER = 4;
    private volatile Object authorizedNetwork_ = "";
    public static final int ZONES_FIELD_NUMBER = 5;
    private LazyStringList zones_;
    public static final int NODE_COUNT_FIELD_NUMBER = 6;
    private int nodeCount_ = 0;
    public static final int NODE_CONFIG_FIELD_NUMBER = 7;
    private NodeConfig nodeConfig_;
    public static final int MEMCACHE_VERSION_FIELD_NUMBER = 9;
    private int memcacheVersion_ = 0;
    public static final int PARAMETERS_FIELD_NUMBER = 11;
    private MemcacheParameters parameters_;
    public static final int MEMCACHE_NODES_FIELD_NUMBER = 12;
    private List<Node> memcacheNodes_;
    public static final int CREATE_TIME_FIELD_NUMBER = 13;
    private Timestamp createTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 14;
    private Timestamp updateTime_;
    public static final int STATE_FIELD_NUMBER = 15;
    private int state_ = 0;
    public static final int MEMCACHE_FULL_VERSION_FIELD_NUMBER = 18;
    private volatile Object memcacheFullVersion_ = "";
    public static final int INSTANCE_MESSAGES_FIELD_NUMBER = 19;
    private List<InstanceMessage> instanceMessages_;
    public static final int DISCOVERY_ENDPOINT_FIELD_NUMBER = 20;
    private volatile Object discoveryEndpoint_ = "";
    public static final int MAINTENANCE_POLICY_FIELD_NUMBER = 21;
    private MaintenancePolicy maintenancePolicy_;
    public static final int MAINTENANCE_SCHEDULE_FIELD_NUMBER = 22;
    private MaintenanceSchedule maintenanceSchedule_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Instance DEFAULT_INSTANCE = new Instance();
    private static final Parser<Instance> PARSER = new AbstractParser<Instance>(){

        public Instance parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Instance.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Instance(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Instance() {
        this.name_ = "";
        this.displayName_ = "";
        this.authorizedNetwork_ = "";
        this.zones_ = LazyStringArrayList.EMPTY;
        this.memcacheVersion_ = 0;
        this.memcacheNodes_ = Collections.emptyList();
        this.state_ = 0;
        this.memcacheFullVersion_ = "";
        this.instanceMessages_ = Collections.emptyList();
        this.discoveryEndpoint_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Instance();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 3: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_fieldAccessorTable.ensureFieldAccessorsInitialized(Instance.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getAuthorizedNetwork() {
        Object ref = this.authorizedNetwork_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.authorizedNetwork_ = s;
        return s;
    }

    @Override
    public ByteString getAuthorizedNetworkBytes() {
        Object ref = this.authorizedNetwork_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.authorizedNetwork_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getZonesList() {
        return this.zones_;
    }

    @Override
    public int getZonesCount() {
        return this.zones_.size();
    }

    @Override
    public String getZones(int index) {
        return (String)this.zones_.get(index);
    }

    @Override
    public ByteString getZonesBytes(int index) {
        return this.zones_.getByteString(index);
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount_;
    }

    @Override
    public boolean hasNodeConfig() {
        return this.nodeConfig_ != null;
    }

    @Override
    public NodeConfig getNodeConfig() {
        return this.nodeConfig_ == null ? NodeConfig.getDefaultInstance() : this.nodeConfig_;
    }

    @Override
    public NodeConfigOrBuilder getNodeConfigOrBuilder() {
        return this.nodeConfig_ == null ? NodeConfig.getDefaultInstance() : this.nodeConfig_;
    }

    @Override
    public int getMemcacheVersionValue() {
        return this.memcacheVersion_;
    }

    @Override
    public MemcacheVersion getMemcacheVersion() {
        MemcacheVersion result = MemcacheVersion.forNumber(this.memcacheVersion_);
        return result == null ? MemcacheVersion.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasParameters() {
        return this.parameters_ != null;
    }

    @Override
    public MemcacheParameters getParameters() {
        return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
    }

    @Override
    public MemcacheParametersOrBuilder getParametersOrBuilder() {
        return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
    }

    @Override
    public List<Node> getMemcacheNodesList() {
        return this.memcacheNodes_;
    }

    @Override
    public List<? extends NodeOrBuilder> getMemcacheNodesOrBuilderList() {
        return this.memcacheNodes_;
    }

    @Override
    public int getMemcacheNodesCount() {
        return this.memcacheNodes_.size();
    }

    @Override
    public Node getMemcacheNodes(int index) {
        return this.memcacheNodes_.get(index);
    }

    @Override
    public NodeOrBuilder getMemcacheNodesOrBuilder(int index) {
        return this.memcacheNodes_.get(index);
    }

    @Override
    public boolean hasCreateTime() {
        return this.createTime_ != null;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return this.updateTime_ != null;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public String getMemcacheFullVersion() {
        Object ref = this.memcacheFullVersion_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.memcacheFullVersion_ = s;
        return s;
    }

    @Override
    public ByteString getMemcacheFullVersionBytes() {
        Object ref = this.memcacheFullVersion_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.memcacheFullVersion_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<InstanceMessage> getInstanceMessagesList() {
        return this.instanceMessages_;
    }

    @Override
    public List<? extends InstanceMessageOrBuilder> getInstanceMessagesOrBuilderList() {
        return this.instanceMessages_;
    }

    @Override
    public int getInstanceMessagesCount() {
        return this.instanceMessages_.size();
    }

    @Override
    public InstanceMessage getInstanceMessages(int index) {
        return this.instanceMessages_.get(index);
    }

    @Override
    public InstanceMessageOrBuilder getInstanceMessagesOrBuilder(int index) {
        return this.instanceMessages_.get(index);
    }

    @Override
    public String getDiscoveryEndpoint() {
        Object ref = this.discoveryEndpoint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.discoveryEndpoint_ = s;
        return s;
    }

    @Override
    public ByteString getDiscoveryEndpointBytes() {
        Object ref = this.discoveryEndpoint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.discoveryEndpoint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMaintenancePolicy() {
        return this.maintenancePolicy_ != null;
    }

    @Override
    public MaintenancePolicy getMaintenancePolicy() {
        return this.maintenancePolicy_ == null ? MaintenancePolicy.getDefaultInstance() : this.maintenancePolicy_;
    }

    @Override
    public MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder() {
        return this.maintenancePolicy_ == null ? MaintenancePolicy.getDefaultInstance() : this.maintenancePolicy_;
    }

    @Override
    public boolean hasMaintenanceSchedule() {
        return this.maintenanceSchedule_ != null;
    }

    @Override
    public MaintenanceSchedule getMaintenanceSchedule() {
        return this.maintenanceSchedule_ == null ? MaintenanceSchedule.getDefaultInstance() : this.maintenanceSchedule_;
    }

    @Override
    public MaintenanceScheduleOrBuilder getMaintenanceScheduleOrBuilder() {
        return this.maintenanceSchedule_ == null ? MaintenanceSchedule.getDefaultInstance() : this.maintenanceSchedule_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.displayName_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)3);
        if (!GeneratedMessageV3.isStringEmpty((Object)this.authorizedNetwork_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.authorizedNetwork_);
        }
        for (i = 0; i < this.zones_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.zones_.getRaw(i));
        }
        if (this.nodeCount_ != 0) {
            output.writeInt32(6, this.nodeCount_);
        }
        if (this.nodeConfig_ != null) {
            output.writeMessage(7, (MessageLite)this.getNodeConfig());
        }
        if (this.memcacheVersion_ != MemcacheVersion.MEMCACHE_VERSION_UNSPECIFIED.getNumber()) {
            output.writeEnum(9, this.memcacheVersion_);
        }
        if (this.parameters_ != null) {
            output.writeMessage(11, (MessageLite)this.getParameters());
        }
        for (i = 0; i < this.memcacheNodes_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.memcacheNodes_.get(i));
        }
        if (this.createTime_ != null) {
            output.writeMessage(13, (MessageLite)this.getCreateTime());
        }
        if (this.updateTime_ != null) {
            output.writeMessage(14, (MessageLite)this.getUpdateTime());
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(15, this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.memcacheFullVersion_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.memcacheFullVersion_);
        }
        for (i = 0; i < this.instanceMessages_.size(); ++i) {
            output.writeMessage(19, (MessageLite)this.instanceMessages_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.discoveryEndpoint_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)20, (Object)this.discoveryEndpoint_);
        }
        if (this.maintenancePolicy_ != null) {
            output.writeMessage(21, (MessageLite)this.getMaintenancePolicy());
        }
        if (this.maintenanceSchedule_ != null) {
            output.writeMessage(22, (MessageLite)this.getMaintenanceSchedule());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.displayName_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)labels__);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.authorizedNetwork_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.authorizedNetwork_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.zones_.size(); ++i2) {
            dataSize += Instance.computeStringSizeNoTag((Object)this.zones_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getZonesList().size();
        if (this.nodeCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)6, (int)this.nodeCount_);
        }
        if (this.nodeConfig_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getNodeConfig());
        }
        if (this.memcacheVersion_ != MemcacheVersion.MEMCACHE_VERSION_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.memcacheVersion_);
        }
        if (this.parameters_ != null) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getParameters());
        }
        for (i = 0; i < this.memcacheNodes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.memcacheNodes_.get(i)));
        }
        if (this.createTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getCreateTime());
        }
        if (this.updateTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getUpdateTime());
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)15, (int)this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.memcacheFullVersion_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.memcacheFullVersion_);
        }
        for (i = 0; i < this.instanceMessages_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)19, (MessageLite)((MessageLite)this.instanceMessages_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.discoveryEndpoint_)) {
            size += GeneratedMessageV3.computeStringSize((int)20, (Object)this.discoveryEndpoint_);
        }
        if (this.maintenancePolicy_ != null) {
            size += CodedOutputStream.computeMessageSize((int)21, (MessageLite)this.getMaintenancePolicy());
        }
        if (this.maintenanceSchedule_ != null) {
            size += CodedOutputStream.computeMessageSize((int)22, (MessageLite)this.getMaintenanceSchedule());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Instance)) {
            return super.equals(obj);
        }
        Instance other = (Instance)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getAuthorizedNetwork().equals(other.getAuthorizedNetwork())) {
            return false;
        }
        if (!this.getZonesList().equals(other.getZonesList())) {
            return false;
        }
        if (this.getNodeCount() != other.getNodeCount()) {
            return false;
        }
        if (this.hasNodeConfig() != other.hasNodeConfig()) {
            return false;
        }
        if (this.hasNodeConfig() && !this.getNodeConfig().equals(other.getNodeConfig())) {
            return false;
        }
        if (this.memcacheVersion_ != other.memcacheVersion_) {
            return false;
        }
        if (this.hasParameters() != other.hasParameters()) {
            return false;
        }
        if (this.hasParameters() && !this.getParameters().equals(other.getParameters())) {
            return false;
        }
        if (!this.getMemcacheNodesList().equals(other.getMemcacheNodesList())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (!this.getMemcacheFullVersion().equals(other.getMemcacheFullVersion())) {
            return false;
        }
        if (!this.getInstanceMessagesList().equals(other.getInstanceMessagesList())) {
            return false;
        }
        if (!this.getDiscoveryEndpoint().equals(other.getDiscoveryEndpoint())) {
            return false;
        }
        if (this.hasMaintenancePolicy() != other.hasMaintenancePolicy()) {
            return false;
        }
        if (this.hasMaintenancePolicy() && !this.getMaintenancePolicy().equals(other.getMaintenancePolicy())) {
            return false;
        }
        if (this.hasMaintenanceSchedule() != other.hasMaintenanceSchedule()) {
            return false;
        }
        if (this.hasMaintenanceSchedule() && !this.getMaintenanceSchedule().equals(other.getMaintenanceSchedule())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Instance.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDisplayName().hashCode();
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getAuthorizedNetwork().hashCode();
        if (this.getZonesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getZonesList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getNodeCount();
        if (this.hasNodeConfig()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getNodeConfig().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.memcacheVersion_;
        if (this.hasParameters()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getParameters().hashCode();
        }
        if (this.getMemcacheNodesCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getMemcacheNodesList().hashCode();
        }
        if (this.hasCreateTime()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        hash = 37 * hash + 15;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getMemcacheFullVersion().hashCode();
        if (this.getInstanceMessagesCount() > 0) {
            hash = 37 * hash + 19;
            hash = 53 * hash + this.getInstanceMessagesList().hashCode();
        }
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getDiscoveryEndpoint().hashCode();
        if (this.hasMaintenancePolicy()) {
            hash = 37 * hash + 21;
            hash = 53 * hash + this.getMaintenancePolicy().hashCode();
        }
        if (this.hasMaintenanceSchedule()) {
            hash = 37 * hash + 22;
            hash = 53 * hash + this.getMaintenanceSchedule().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Instance parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data);
    }

    public static Instance parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Instance parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data);
    }

    public static Instance parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Instance parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data);
    }

    public static Instance parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Instance)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Instance parseFrom(InputStream input) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Instance parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Instance parseDelimitedFrom(InputStream input) throws IOException {
        return (Instance)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Instance parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Instance)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Instance parseFrom(CodedInputStream input) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Instance parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Instance)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Instance.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Instance prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Instance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Instance> parser() {
        return PARSER;
    }

    public Parser<Instance> getParserForType() {
        return PARSER;
    }

    public Instance getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InstanceOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object displayName_ = "";
        private MapField<String, String> labels_;
        private Object authorizedNetwork_ = "";
        private LazyStringList zones_ = LazyStringArrayList.EMPTY;
        private int nodeCount_;
        private NodeConfig nodeConfig_;
        private SingleFieldBuilderV3<NodeConfig, NodeConfig.Builder, NodeConfigOrBuilder> nodeConfigBuilder_;
        private int memcacheVersion_ = 0;
        private MemcacheParameters parameters_;
        private SingleFieldBuilderV3<MemcacheParameters, MemcacheParameters.Builder, MemcacheParametersOrBuilder> parametersBuilder_;
        private List<Node> memcacheNodes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Node, Node.Builder, NodeOrBuilder> memcacheNodesBuilder_;
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private int state_ = 0;
        private Object memcacheFullVersion_ = "";
        private List<InstanceMessage> instanceMessages_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<InstanceMessage, InstanceMessage.Builder, InstanceMessageOrBuilder> instanceMessagesBuilder_;
        private Object discoveryEndpoint_ = "";
        private MaintenancePolicy maintenancePolicy_;
        private SingleFieldBuilderV3<MaintenancePolicy, MaintenancePolicy.Builder, MaintenancePolicyOrBuilder> maintenancePolicyBuilder_;
        private MaintenanceSchedule maintenanceSchedule_;
        private SingleFieldBuilderV3<MaintenanceSchedule, MaintenanceSchedule.Builder, MaintenanceScheduleOrBuilder> maintenanceScheduleBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 3: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 3: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_fieldAccessorTable.ensureFieldAccessorsInitialized(Instance.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.displayName_ = "";
            this.internalGetMutableLabels().clear();
            this.authorizedNetwork_ = "";
            this.zones_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFEF;
            this.nodeCount_ = 0;
            this.nodeConfig_ = null;
            if (this.nodeConfigBuilder_ != null) {
                this.nodeConfigBuilder_.dispose();
                this.nodeConfigBuilder_ = null;
            }
            this.memcacheVersion_ = 0;
            this.parameters_ = null;
            if (this.parametersBuilder_ != null) {
                this.parametersBuilder_.dispose();
                this.parametersBuilder_ = null;
            }
            if (this.memcacheNodesBuilder_ == null) {
                this.memcacheNodes_ = Collections.emptyList();
            } else {
                this.memcacheNodes_ = null;
                this.memcacheNodesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.state_ = 0;
            this.memcacheFullVersion_ = "";
            if (this.instanceMessagesBuilder_ == null) {
                this.instanceMessages_ = Collections.emptyList();
            } else {
                this.instanceMessages_ = null;
                this.instanceMessagesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFBFFF;
            this.discoveryEndpoint_ = "";
            this.maintenancePolicy_ = null;
            if (this.maintenancePolicyBuilder_ != null) {
                this.maintenancePolicyBuilder_.dispose();
                this.maintenancePolicyBuilder_ = null;
            }
            this.maintenanceSchedule_ = null;
            if (this.maintenanceScheduleBuilder_ != null) {
                this.maintenanceScheduleBuilder_.dispose();
                this.maintenanceScheduleBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_descriptor;
        }

        public Instance getDefaultInstanceForType() {
            return Instance.getDefaultInstance();
        }

        public Instance build() {
            Instance result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Instance buildPartial() {
            Instance result = new Instance(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Instance result) {
            if ((this.bitField0_ & 0x10) != 0) {
                this.zones_ = this.zones_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFEF;
            }
            result.zones_ = this.zones_;
            if (this.memcacheNodesBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.memcacheNodes_ = Collections.unmodifiableList(this.memcacheNodes_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.memcacheNodes_ = this.memcacheNodes_;
            } else {
                result.memcacheNodes_ = this.memcacheNodesBuilder_.build();
            }
            if (this.instanceMessagesBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0) {
                    this.instanceMessages_ = Collections.unmodifiableList(this.instanceMessages_);
                    this.bitField0_ &= 0xFFFFBFFF;
                }
                result.instanceMessages_ = this.instanceMessages_;
            } else {
                result.instanceMessages_ = this.instanceMessagesBuilder_.build();
            }
        }

        private void buildPartial0(Instance result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 8) != 0) {
                result.authorizedNetwork_ = this.authorizedNetwork_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.nodeCount_ = this.nodeCount_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.nodeConfig_ = this.nodeConfigBuilder_ == null ? this.nodeConfig_ : (NodeConfig)this.nodeConfigBuilder_.build();
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.memcacheVersion_ = this.memcacheVersion_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.parameters_ = this.parametersBuilder_ == null ? this.parameters_ : (MemcacheParameters)this.parametersBuilder_.build();
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.memcacheFullVersion_ = this.memcacheFullVersion_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.discoveryEndpoint_ = this.discoveryEndpoint_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.maintenancePolicy_ = this.maintenancePolicyBuilder_ == null ? this.maintenancePolicy_ : (MaintenancePolicy)this.maintenancePolicyBuilder_.build();
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.maintenanceSchedule_ = this.maintenanceScheduleBuilder_ == null ? this.maintenanceSchedule_ : (MaintenanceSchedule)this.maintenanceScheduleBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Instance) {
                return this.mergeFrom((Instance)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Instance other) {
            if (other == Instance.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 4;
            if (!other.getAuthorizedNetwork().isEmpty()) {
                this.authorizedNetwork_ = other.authorizedNetwork_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.zones_.isEmpty()) {
                if (this.zones_.isEmpty()) {
                    this.zones_ = other.zones_;
                    this.bitField0_ &= 0xFFFFFFEF;
                } else {
                    this.ensureZonesIsMutable();
                    this.zones_.addAll((Collection)other.zones_);
                }
                this.onChanged();
            }
            if (other.getNodeCount() != 0) {
                this.setNodeCount(other.getNodeCount());
            }
            if (other.hasNodeConfig()) {
                this.mergeNodeConfig(other.getNodeConfig());
            }
            if (other.memcacheVersion_ != 0) {
                this.setMemcacheVersionValue(other.getMemcacheVersionValue());
            }
            if (other.hasParameters()) {
                this.mergeParameters(other.getParameters());
            }
            if (this.memcacheNodesBuilder_ == null) {
                if (!other.memcacheNodes_.isEmpty()) {
                    if (this.memcacheNodes_.isEmpty()) {
                        this.memcacheNodes_ = other.memcacheNodes_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureMemcacheNodesIsMutable();
                        this.memcacheNodes_.addAll(other.memcacheNodes_);
                    }
                    this.onChanged();
                }
            } else if (!other.memcacheNodes_.isEmpty()) {
                if (this.memcacheNodesBuilder_.isEmpty()) {
                    this.memcacheNodesBuilder_.dispose();
                    this.memcacheNodesBuilder_ = null;
                    this.memcacheNodes_ = other.memcacheNodes_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.memcacheNodesBuilder_ = alwaysUseFieldBuilders ? this.getMemcacheNodesFieldBuilder() : null;
                } else {
                    this.memcacheNodesBuilder_.addAllMessages((Iterable)other.memcacheNodes_);
                }
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (!other.getMemcacheFullVersion().isEmpty()) {
                this.memcacheFullVersion_ = other.memcacheFullVersion_;
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            if (this.instanceMessagesBuilder_ == null) {
                if (!other.instanceMessages_.isEmpty()) {
                    if (this.instanceMessages_.isEmpty()) {
                        this.instanceMessages_ = other.instanceMessages_;
                        this.bitField0_ &= 0xFFFFBFFF;
                    } else {
                        this.ensureInstanceMessagesIsMutable();
                        this.instanceMessages_.addAll(other.instanceMessages_);
                    }
                    this.onChanged();
                }
            } else if (!other.instanceMessages_.isEmpty()) {
                if (this.instanceMessagesBuilder_.isEmpty()) {
                    this.instanceMessagesBuilder_.dispose();
                    this.instanceMessagesBuilder_ = null;
                    this.instanceMessages_ = other.instanceMessages_;
                    this.bitField0_ &= 0xFFFFBFFF;
                    this.instanceMessagesBuilder_ = alwaysUseFieldBuilders ? this.getInstanceMessagesFieldBuilder() : null;
                } else {
                    this.instanceMessagesBuilder_.addAllMessages((Iterable)other.instanceMessages_);
                }
            }
            if (!other.getDiscoveryEndpoint().isEmpty()) {
                this.discoveryEndpoint_ = other.discoveryEndpoint_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (other.hasMaintenancePolicy()) {
                this.mergeMaintenancePolicy(other.getMaintenancePolicy());
            }
            if (other.hasMaintenanceSchedule()) {
                this.mergeMaintenanceSchedule(other.getMaintenanceSchedule());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block26: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block26;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block26;
                        }
                        case 18: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block26;
                        }
                        case 26: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 4;
                            continue block26;
                        }
                        case 34: {
                            this.authorizedNetwork_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block26;
                        }
                        case 42: {
                            String s = input.readStringRequireUtf8();
                            this.ensureZonesIsMutable();
                            this.zones_.add((Object)s);
                            continue block26;
                        }
                        case 48: {
                            this.nodeCount_ = input.readInt32();
                            this.bitField0_ |= 0x20;
                            continue block26;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block26;
                        }
                        case 72: {
                            this.memcacheVersion_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block26;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getParametersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block26;
                        }
                        case 98: {
                            GeneratedMessageV3 m = (Node)input.readMessage(Node.parser(), extensionRegistry);
                            if (this.memcacheNodesBuilder_ == null) {
                                this.ensureMemcacheNodesIsMutable();
                                this.memcacheNodes_.add((Node)m);
                                continue block26;
                            }
                            this.memcacheNodesBuilder_.addMessage((AbstractMessage)m);
                            continue block26;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block26;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block26;
                        }
                        case 120: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x1000;
                            continue block26;
                        }
                        case 146: {
                            this.memcacheFullVersion_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000;
                            continue block26;
                        }
                        case 154: {
                            GeneratedMessageV3 m = (InstanceMessage)input.readMessage(InstanceMessage.parser(), extensionRegistry);
                            if (this.instanceMessagesBuilder_ == null) {
                                this.ensureInstanceMessagesIsMutable();
                                this.instanceMessages_.add((InstanceMessage)m);
                                continue block26;
                            }
                            this.instanceMessagesBuilder_.addMessage((AbstractMessage)m);
                            continue block26;
                        }
                        case 162: {
                            this.discoveryEndpoint_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block26;
                        }
                        case 170: {
                            input.readMessage((MessageLite.Builder)this.getMaintenancePolicyFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block26;
                        }
                        case 178: {
                            input.readMessage((MessageLite.Builder)this.getMaintenanceScheduleFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block26;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Instance.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = Instance.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 4;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 4;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 4;
            return this;
        }

        @Override
        public String getAuthorizedNetwork() {
            Object ref = this.authorizedNetwork_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.authorizedNetwork_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAuthorizedNetworkBytes() {
            Object ref = this.authorizedNetwork_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.authorizedNetwork_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAuthorizedNetwork(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.authorizedNetwork_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearAuthorizedNetwork() {
            this.authorizedNetwork_ = Instance.getDefaultInstance().getAuthorizedNetwork();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setAuthorizedNetworkBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.authorizedNetwork_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensureZonesIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.zones_ = new LazyStringArrayList(this.zones_);
                this.bitField0_ |= 0x10;
            }
        }

        public ProtocolStringList getZonesList() {
            return this.zones_.getUnmodifiableView();
        }

        @Override
        public int getZonesCount() {
            return this.zones_.size();
        }

        @Override
        public String getZones(int index) {
            return (String)this.zones_.get(index);
        }

        @Override
        public ByteString getZonesBytes(int index) {
            return this.zones_.getByteString(index);
        }

        public Builder setZones(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureZonesIsMutable();
            this.zones_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addZones(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureZonesIsMutable();
            this.zones_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllZones(Iterable<String> values) {
            this.ensureZonesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.zones_);
            this.onChanged();
            return this;
        }

        public Builder clearZones() {
            this.zones_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder addZonesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.ensureZonesIsMutable();
            this.zones_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public int getNodeCount() {
            return this.nodeCount_;
        }

        public Builder setNodeCount(int value) {
            this.nodeCount_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearNodeCount() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.nodeCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasNodeConfig() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public NodeConfig getNodeConfig() {
            if (this.nodeConfigBuilder_ == null) {
                return this.nodeConfig_ == null ? NodeConfig.getDefaultInstance() : this.nodeConfig_;
            }
            return (NodeConfig)this.nodeConfigBuilder_.getMessage();
        }

        public Builder setNodeConfig(NodeConfig value) {
            if (this.nodeConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.nodeConfig_ = value;
            } else {
                this.nodeConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setNodeConfig(NodeConfig.Builder builderForValue) {
            if (this.nodeConfigBuilder_ == null) {
                this.nodeConfig_ = builderForValue.build();
            } else {
                this.nodeConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeNodeConfig(NodeConfig value) {
            if (this.nodeConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.nodeConfig_ != null && this.nodeConfig_ != NodeConfig.getDefaultInstance()) {
                    this.getNodeConfigBuilder().mergeFrom(value);
                } else {
                    this.nodeConfig_ = value;
                }
            } else {
                this.nodeConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearNodeConfig() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.nodeConfig_ = null;
            if (this.nodeConfigBuilder_ != null) {
                this.nodeConfigBuilder_.dispose();
                this.nodeConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public NodeConfig.Builder getNodeConfigBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (NodeConfig.Builder)this.getNodeConfigFieldBuilder().getBuilder();
        }

        @Override
        public NodeConfigOrBuilder getNodeConfigOrBuilder() {
            if (this.nodeConfigBuilder_ != null) {
                return (NodeConfigOrBuilder)this.nodeConfigBuilder_.getMessageOrBuilder();
            }
            return this.nodeConfig_ == null ? NodeConfig.getDefaultInstance() : this.nodeConfig_;
        }

        private SingleFieldBuilderV3<NodeConfig, NodeConfig.Builder, NodeConfigOrBuilder> getNodeConfigFieldBuilder() {
            if (this.nodeConfigBuilder_ == null) {
                this.nodeConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getNodeConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.nodeConfig_ = null;
            }
            return this.nodeConfigBuilder_;
        }

        @Override
        public int getMemcacheVersionValue() {
            return this.memcacheVersion_;
        }

        public Builder setMemcacheVersionValue(int value) {
            this.memcacheVersion_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public MemcacheVersion getMemcacheVersion() {
            MemcacheVersion result = MemcacheVersion.forNumber(this.memcacheVersion_);
            return result == null ? MemcacheVersion.UNRECOGNIZED : result;
        }

        public Builder setMemcacheVersion(MemcacheVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.memcacheVersion_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearMemcacheVersion() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.memcacheVersion_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasParameters() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public MemcacheParameters getParameters() {
            if (this.parametersBuilder_ == null) {
                return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
            }
            return (MemcacheParameters)this.parametersBuilder_.getMessage();
        }

        public Builder setParameters(MemcacheParameters value) {
            if (this.parametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.parameters_ = value;
            } else {
                this.parametersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setParameters(MemcacheParameters.Builder builderForValue) {
            if (this.parametersBuilder_ == null) {
                this.parameters_ = builderForValue.build();
            } else {
                this.parametersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeParameters(MemcacheParameters value) {
            if (this.parametersBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.parameters_ != null && this.parameters_ != MemcacheParameters.getDefaultInstance()) {
                    this.getParametersBuilder().mergeFrom(value);
                } else {
                    this.parameters_ = value;
                }
            } else {
                this.parametersBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearParameters() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.parameters_ = null;
            if (this.parametersBuilder_ != null) {
                this.parametersBuilder_.dispose();
                this.parametersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MemcacheParameters.Builder getParametersBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (MemcacheParameters.Builder)this.getParametersFieldBuilder().getBuilder();
        }

        @Override
        public MemcacheParametersOrBuilder getParametersOrBuilder() {
            if (this.parametersBuilder_ != null) {
                return (MemcacheParametersOrBuilder)this.parametersBuilder_.getMessageOrBuilder();
            }
            return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
        }

        private SingleFieldBuilderV3<MemcacheParameters, MemcacheParameters.Builder, MemcacheParametersOrBuilder> getParametersFieldBuilder() {
            if (this.parametersBuilder_ == null) {
                this.parametersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getParameters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.parameters_ = null;
            }
            return this.parametersBuilder_;
        }

        private void ensureMemcacheNodesIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.memcacheNodes_ = new ArrayList<Node>(this.memcacheNodes_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<Node> getMemcacheNodesList() {
            if (this.memcacheNodesBuilder_ == null) {
                return Collections.unmodifiableList(this.memcacheNodes_);
            }
            return this.memcacheNodesBuilder_.getMessageList();
        }

        @Override
        public int getMemcacheNodesCount() {
            if (this.memcacheNodesBuilder_ == null) {
                return this.memcacheNodes_.size();
            }
            return this.memcacheNodesBuilder_.getCount();
        }

        @Override
        public Node getMemcacheNodes(int index) {
            if (this.memcacheNodesBuilder_ == null) {
                return this.memcacheNodes_.get(index);
            }
            return (Node)this.memcacheNodesBuilder_.getMessage(index);
        }

        public Builder setMemcacheNodes(int index, Node value) {
            if (this.memcacheNodesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.set(index, value);
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setMemcacheNodes(int index, Node.Builder builderForValue) {
            if (this.memcacheNodesBuilder_ == null) {
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addMemcacheNodes(Node value) {
            if (this.memcacheNodesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.add(value);
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addMemcacheNodes(int index, Node value) {
            if (this.memcacheNodesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.add(index, value);
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addMemcacheNodes(Node.Builder builderForValue) {
            if (this.memcacheNodesBuilder_ == null) {
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addMemcacheNodes(int index, Node.Builder builderForValue) {
            if (this.memcacheNodesBuilder_ == null) {
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllMemcacheNodes(Iterable<? extends Node> values) {
            if (this.memcacheNodesBuilder_ == null) {
                this.ensureMemcacheNodesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.memcacheNodes_);
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearMemcacheNodes() {
            if (this.memcacheNodesBuilder_ == null) {
                this.memcacheNodes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.clear();
            }
            return this;
        }

        public Builder removeMemcacheNodes(int index) {
            if (this.memcacheNodesBuilder_ == null) {
                this.ensureMemcacheNodesIsMutable();
                this.memcacheNodes_.remove(index);
                this.onChanged();
            } else {
                this.memcacheNodesBuilder_.remove(index);
            }
            return this;
        }

        public Node.Builder getMemcacheNodesBuilder(int index) {
            return (Node.Builder)this.getMemcacheNodesFieldBuilder().getBuilder(index);
        }

        @Override
        public NodeOrBuilder getMemcacheNodesOrBuilder(int index) {
            if (this.memcacheNodesBuilder_ == null) {
                return this.memcacheNodes_.get(index);
            }
            return (NodeOrBuilder)this.memcacheNodesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends NodeOrBuilder> getMemcacheNodesOrBuilderList() {
            if (this.memcacheNodesBuilder_ != null) {
                return this.memcacheNodesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.memcacheNodes_);
        }

        public Node.Builder addMemcacheNodesBuilder() {
            return (Node.Builder)this.getMemcacheNodesFieldBuilder().addBuilder((AbstractMessage)Node.getDefaultInstance());
        }

        public Node.Builder addMemcacheNodesBuilder(int index) {
            return (Node.Builder)this.getMemcacheNodesFieldBuilder().addBuilder(index, (AbstractMessage)Node.getDefaultInstance());
        }

        public List<Node.Builder> getMemcacheNodesBuilderList() {
            return this.getMemcacheNodesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Node, Node.Builder, NodeOrBuilder> getMemcacheNodesFieldBuilder() {
            if (this.memcacheNodesBuilder_ == null) {
                this.memcacheNodesBuilder_ = new RepeatedFieldBuilderV3(this.memcacheNodes_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.memcacheNodes_ = null;
            }
            return this.memcacheNodesBuilder_;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x1000;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getMemcacheFullVersion() {
            Object ref = this.memcacheFullVersion_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.memcacheFullVersion_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMemcacheFullVersionBytes() {
            Object ref = this.memcacheFullVersion_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.memcacheFullVersion_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMemcacheFullVersion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.memcacheFullVersion_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearMemcacheFullVersion() {
            this.memcacheFullVersion_ = Instance.getDefaultInstance().getMemcacheFullVersion();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        public Builder setMemcacheFullVersionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.memcacheFullVersion_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        private void ensureInstanceMessagesIsMutable() {
            if ((this.bitField0_ & 0x4000) == 0) {
                this.instanceMessages_ = new ArrayList<InstanceMessage>(this.instanceMessages_);
                this.bitField0_ |= 0x4000;
            }
        }

        @Override
        public List<InstanceMessage> getInstanceMessagesList() {
            if (this.instanceMessagesBuilder_ == null) {
                return Collections.unmodifiableList(this.instanceMessages_);
            }
            return this.instanceMessagesBuilder_.getMessageList();
        }

        @Override
        public int getInstanceMessagesCount() {
            if (this.instanceMessagesBuilder_ == null) {
                return this.instanceMessages_.size();
            }
            return this.instanceMessagesBuilder_.getCount();
        }

        @Override
        public InstanceMessage getInstanceMessages(int index) {
            if (this.instanceMessagesBuilder_ == null) {
                return this.instanceMessages_.get(index);
            }
            return (InstanceMessage)this.instanceMessagesBuilder_.getMessage(index);
        }

        public Builder setInstanceMessages(int index, InstanceMessage value) {
            if (this.instanceMessagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.set(index, value);
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setInstanceMessages(int index, InstanceMessage.Builder builderForValue) {
            if (this.instanceMessagesBuilder_ == null) {
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInstanceMessages(InstanceMessage value) {
            if (this.instanceMessagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.add(value);
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addInstanceMessages(int index, InstanceMessage value) {
            if (this.instanceMessagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.add(index, value);
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addInstanceMessages(InstanceMessage.Builder builderForValue) {
            if (this.instanceMessagesBuilder_ == null) {
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInstanceMessages(int index, InstanceMessage.Builder builderForValue) {
            if (this.instanceMessagesBuilder_ == null) {
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllInstanceMessages(Iterable<? extends InstanceMessage> values) {
            if (this.instanceMessagesBuilder_ == null) {
                this.ensureInstanceMessagesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.instanceMessages_);
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearInstanceMessages() {
            if (this.instanceMessagesBuilder_ == null) {
                this.instanceMessages_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFBFFF;
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.clear();
            }
            return this;
        }

        public Builder removeInstanceMessages(int index) {
            if (this.instanceMessagesBuilder_ == null) {
                this.ensureInstanceMessagesIsMutable();
                this.instanceMessages_.remove(index);
                this.onChanged();
            } else {
                this.instanceMessagesBuilder_.remove(index);
            }
            return this;
        }

        public InstanceMessage.Builder getInstanceMessagesBuilder(int index) {
            return (InstanceMessage.Builder)this.getInstanceMessagesFieldBuilder().getBuilder(index);
        }

        @Override
        public InstanceMessageOrBuilder getInstanceMessagesOrBuilder(int index) {
            if (this.instanceMessagesBuilder_ == null) {
                return this.instanceMessages_.get(index);
            }
            return (InstanceMessageOrBuilder)this.instanceMessagesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends InstanceMessageOrBuilder> getInstanceMessagesOrBuilderList() {
            if (this.instanceMessagesBuilder_ != null) {
                return this.instanceMessagesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.instanceMessages_);
        }

        public InstanceMessage.Builder addInstanceMessagesBuilder() {
            return (InstanceMessage.Builder)this.getInstanceMessagesFieldBuilder().addBuilder((AbstractMessage)InstanceMessage.getDefaultInstance());
        }

        public InstanceMessage.Builder addInstanceMessagesBuilder(int index) {
            return (InstanceMessage.Builder)this.getInstanceMessagesFieldBuilder().addBuilder(index, (AbstractMessage)InstanceMessage.getDefaultInstance());
        }

        public List<InstanceMessage.Builder> getInstanceMessagesBuilderList() {
            return this.getInstanceMessagesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<InstanceMessage, InstanceMessage.Builder, InstanceMessageOrBuilder> getInstanceMessagesFieldBuilder() {
            if (this.instanceMessagesBuilder_ == null) {
                this.instanceMessagesBuilder_ = new RepeatedFieldBuilderV3(this.instanceMessages_, (this.bitField0_ & 0x4000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.instanceMessages_ = null;
            }
            return this.instanceMessagesBuilder_;
        }

        @Override
        public String getDiscoveryEndpoint() {
            Object ref = this.discoveryEndpoint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.discoveryEndpoint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDiscoveryEndpointBytes() {
            Object ref = this.discoveryEndpoint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.discoveryEndpoint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDiscoveryEndpoint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.discoveryEndpoint_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearDiscoveryEndpoint() {
            this.discoveryEndpoint_ = Instance.getDefaultInstance().getDiscoveryEndpoint();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setDiscoveryEndpointBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Instance.checkByteStringIsUtf8((ByteString)value);
            this.discoveryEndpoint_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMaintenancePolicy() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public MaintenancePolicy getMaintenancePolicy() {
            if (this.maintenancePolicyBuilder_ == null) {
                return this.maintenancePolicy_ == null ? MaintenancePolicy.getDefaultInstance() : this.maintenancePolicy_;
            }
            return (MaintenancePolicy)this.maintenancePolicyBuilder_.getMessage();
        }

        public Builder setMaintenancePolicy(MaintenancePolicy value) {
            if (this.maintenancePolicyBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.maintenancePolicy_ = value;
            } else {
                this.maintenancePolicyBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setMaintenancePolicy(MaintenancePolicy.Builder builderForValue) {
            if (this.maintenancePolicyBuilder_ == null) {
                this.maintenancePolicy_ = builderForValue.build();
            } else {
                this.maintenancePolicyBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeMaintenancePolicy(MaintenancePolicy value) {
            if (this.maintenancePolicyBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.maintenancePolicy_ != null && this.maintenancePolicy_ != MaintenancePolicy.getDefaultInstance()) {
                    this.getMaintenancePolicyBuilder().mergeFrom(value);
                } else {
                    this.maintenancePolicy_ = value;
                }
            } else {
                this.maintenancePolicyBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearMaintenancePolicy() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.maintenancePolicy_ = null;
            if (this.maintenancePolicyBuilder_ != null) {
                this.maintenancePolicyBuilder_.dispose();
                this.maintenancePolicyBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MaintenancePolicy.Builder getMaintenancePolicyBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (MaintenancePolicy.Builder)this.getMaintenancePolicyFieldBuilder().getBuilder();
        }

        @Override
        public MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder() {
            if (this.maintenancePolicyBuilder_ != null) {
                return (MaintenancePolicyOrBuilder)this.maintenancePolicyBuilder_.getMessageOrBuilder();
            }
            return this.maintenancePolicy_ == null ? MaintenancePolicy.getDefaultInstance() : this.maintenancePolicy_;
        }

        private SingleFieldBuilderV3<MaintenancePolicy, MaintenancePolicy.Builder, MaintenancePolicyOrBuilder> getMaintenancePolicyFieldBuilder() {
            if (this.maintenancePolicyBuilder_ == null) {
                this.maintenancePolicyBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMaintenancePolicy(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.maintenancePolicy_ = null;
            }
            return this.maintenancePolicyBuilder_;
        }

        @Override
        public boolean hasMaintenanceSchedule() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public MaintenanceSchedule getMaintenanceSchedule() {
            if (this.maintenanceScheduleBuilder_ == null) {
                return this.maintenanceSchedule_ == null ? MaintenanceSchedule.getDefaultInstance() : this.maintenanceSchedule_;
            }
            return (MaintenanceSchedule)this.maintenanceScheduleBuilder_.getMessage();
        }

        public Builder setMaintenanceSchedule(MaintenanceSchedule value) {
            if (this.maintenanceScheduleBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.maintenanceSchedule_ = value;
            } else {
                this.maintenanceScheduleBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setMaintenanceSchedule(MaintenanceSchedule.Builder builderForValue) {
            if (this.maintenanceScheduleBuilder_ == null) {
                this.maintenanceSchedule_ = builderForValue.build();
            } else {
                this.maintenanceScheduleBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeMaintenanceSchedule(MaintenanceSchedule value) {
            if (this.maintenanceScheduleBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.maintenanceSchedule_ != null && this.maintenanceSchedule_ != MaintenanceSchedule.getDefaultInstance()) {
                    this.getMaintenanceScheduleBuilder().mergeFrom(value);
                } else {
                    this.maintenanceSchedule_ = value;
                }
            } else {
                this.maintenanceScheduleBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearMaintenanceSchedule() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.maintenanceSchedule_ = null;
            if (this.maintenanceScheduleBuilder_ != null) {
                this.maintenanceScheduleBuilder_.dispose();
                this.maintenanceScheduleBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MaintenanceSchedule.Builder getMaintenanceScheduleBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return (MaintenanceSchedule.Builder)this.getMaintenanceScheduleFieldBuilder().getBuilder();
        }

        @Override
        public MaintenanceScheduleOrBuilder getMaintenanceScheduleOrBuilder() {
            if (this.maintenanceScheduleBuilder_ != null) {
                return (MaintenanceScheduleOrBuilder)this.maintenanceScheduleBuilder_.getMessageOrBuilder();
            }
            return this.maintenanceSchedule_ == null ? MaintenanceSchedule.getDefaultInstance() : this.maintenanceSchedule_;
        }

        private SingleFieldBuilderV3<MaintenanceSchedule, MaintenanceSchedule.Builder, MaintenanceScheduleOrBuilder> getMaintenanceScheduleFieldBuilder() {
            if (this.maintenanceScheduleBuilder_ == null) {
                this.maintenanceScheduleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMaintenanceSchedule(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.maintenanceSchedule_ = null;
            }
            return this.maintenanceScheduleBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static final class InstanceMessage
    extends GeneratedMessageV3
    implements InstanceMessageOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CODE_FIELD_NUMBER = 1;
        private int code_ = 0;
        public static final int MESSAGE_FIELD_NUMBER = 2;
        private volatile Object message_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final InstanceMessage DEFAULT_INSTANCE = new InstanceMessage();
        private static final Parser<InstanceMessage> PARSER = new AbstractParser<InstanceMessage>(){

            public InstanceMessage parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = InstanceMessage.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private InstanceMessage(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private InstanceMessage() {
            this.code_ = 0;
            this.message_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new InstanceMessage();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_InstanceMessage_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_InstanceMessage_fieldAccessorTable.ensureFieldAccessorsInitialized(InstanceMessage.class, Builder.class);
        }

        @Override
        public int getCodeValue() {
            return this.code_;
        }

        @Override
        public Code getCode() {
            Code result = Code.forNumber(this.code_);
            return result == null ? Code.UNRECOGNIZED : result;
        }

        @Override
        public String getMessage() {
            Object ref = this.message_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.message_ = s;
            return s;
        }

        @Override
        public ByteString getMessageBytes() {
            Object ref = this.message_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.message_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.code_ != Code.CODE_UNSPECIFIED.getNumber()) {
                output.writeEnum(1, this.code_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.message_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.message_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.code_ != Code.CODE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.code_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.message_)) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.message_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof InstanceMessage)) {
                return super.equals(obj);
            }
            InstanceMessage other = (InstanceMessage)obj;
            if (this.code_ != other.code_) {
                return false;
            }
            if (!this.getMessage().equals(other.getMessage())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + InstanceMessage.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.code_;
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getMessage().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static InstanceMessage parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (InstanceMessage)PARSER.parseFrom(data);
        }

        public static InstanceMessage parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InstanceMessage)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InstanceMessage parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (InstanceMessage)PARSER.parseFrom(data);
        }

        public static InstanceMessage parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InstanceMessage)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InstanceMessage parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (InstanceMessage)PARSER.parseFrom(data);
        }

        public static InstanceMessage parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InstanceMessage)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InstanceMessage parseFrom(InputStream input) throws IOException {
            return (InstanceMessage)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static InstanceMessage parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InstanceMessage)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static InstanceMessage parseDelimitedFrom(InputStream input) throws IOException {
            return (InstanceMessage)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static InstanceMessage parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InstanceMessage)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static InstanceMessage parseFrom(CodedInputStream input) throws IOException {
            return (InstanceMessage)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static InstanceMessage parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InstanceMessage)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return InstanceMessage.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(InstanceMessage prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static InstanceMessage getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<InstanceMessage> parser() {
            return PARSER;
        }

        public Parser<InstanceMessage> getParserForType() {
            return PARSER;
        }

        public InstanceMessage getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements InstanceMessageOrBuilder {
            private int bitField0_;
            private int code_ = 0;
            private Object message_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_InstanceMessage_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_InstanceMessage_fieldAccessorTable.ensureFieldAccessorsInitialized(InstanceMessage.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.code_ = 0;
                this.message_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_InstanceMessage_descriptor;
            }

            public InstanceMessage getDefaultInstanceForType() {
                return InstanceMessage.getDefaultInstance();
            }

            public InstanceMessage build() {
                InstanceMessage result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public InstanceMessage buildPartial() {
                InstanceMessage result = new InstanceMessage(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(InstanceMessage result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.code_ = this.code_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.message_ = this.message_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof InstanceMessage) {
                    return this.mergeFrom((InstanceMessage)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(InstanceMessage other) {
                if (other == InstanceMessage.getDefaultInstance()) {
                    return this;
                }
                if (other.code_ != 0) {
                    this.setCodeValue(other.getCodeValue());
                }
                if (!other.getMessage().isEmpty()) {
                    this.message_ = other.message_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.code_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                this.message_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getCodeValue() {
                return this.code_;
            }

            public Builder setCodeValue(int value) {
                this.code_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public Code getCode() {
                Code result = Code.forNumber(this.code_);
                return result == null ? Code.UNRECOGNIZED : result;
            }

            public Builder setCode(Code value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.code_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearCode() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.code_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public String getMessage() {
                Object ref = this.message_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.message_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getMessageBytes() {
                Object ref = this.message_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.message_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setMessage(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.message_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearMessage() {
                this.message_ = InstanceMessage.getDefaultInstance().getMessage();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setMessageBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                InstanceMessage.checkByteStringIsUtf8((ByteString)value);
                this.message_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum Code implements ProtocolMessageEnum
        {
            CODE_UNSPECIFIED(0),
            ZONE_DISTRIBUTION_UNBALANCED(1),
            UNRECOGNIZED(-1);

            public static final int CODE_UNSPECIFIED_VALUE = 0;
            public static final int ZONE_DISTRIBUTION_UNBALANCED_VALUE = 1;
            private static final Internal.EnumLiteMap<Code> internalValueMap;
            private static final Code[] VALUES;
            private final int value;

            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static Code valueOf(int value) {
                return Code.forNumber(value);
            }

            public static Code forNumber(int value) {
                switch (value) {
                    case 0: {
                        return CODE_UNSPECIFIED;
                    }
                    case 1: {
                        return ZONE_DISTRIBUTION_UNBALANCED;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<Code> internalGetValueMap() {
                return internalValueMap;
            }

            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return (Descriptors.EnumValueDescriptor)Code.getDescriptor().getValues().get(this.ordinal());
            }

            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return Code.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return (Descriptors.EnumDescriptor)InstanceMessage.getDescriptor().getEnumTypes().get(0);
            }

            public static Code valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != Code.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private Code(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<Code>(){

                    public Code findValueByNumber(int number) {
                        return Code.forNumber(number);
                    }
                };
                VALUES = Code.values();
            }
        }
    }

    public static interface InstanceMessageOrBuilder
    extends MessageOrBuilder {
        public int getCodeValue();

        public InstanceMessage.Code getCode();

        public String getMessage();

        public ByteString getMessageBytes();
    }

    public static final class Node
    extends GeneratedMessageV3
    implements NodeOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int NODE_ID_FIELD_NUMBER = 1;
        private volatile Object nodeId_ = "";
        public static final int ZONE_FIELD_NUMBER = 2;
        private volatile Object zone_ = "";
        public static final int STATE_FIELD_NUMBER = 3;
        private int state_ = 0;
        public static final int HOST_FIELD_NUMBER = 4;
        private volatile Object host_ = "";
        public static final int PORT_FIELD_NUMBER = 5;
        private int port_ = 0;
        public static final int PARAMETERS_FIELD_NUMBER = 6;
        private MemcacheParameters parameters_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Node DEFAULT_INSTANCE = new Node();
        private static final Parser<Node> PARSER = new AbstractParser<Node>(){

            public Node parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Node.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Node(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Node() {
            this.nodeId_ = "";
            this.zone_ = "";
            this.state_ = 0;
            this.host_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Node();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_Node_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_Node_fieldAccessorTable.ensureFieldAccessorsInitialized(Node.class, Builder.class);
        }

        @Override
        public String getNodeId() {
            Object ref = this.nodeId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.nodeId_ = s;
            return s;
        }

        @Override
        public ByteString getNodeIdBytes() {
            Object ref = this.nodeId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.nodeId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getZone() {
            Object ref = this.zone_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.zone_ = s;
            return s;
        }

        @Override
        public ByteString getZoneBytes() {
            Object ref = this.zone_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.zone_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        @Override
        public String getHost() {
            Object ref = this.host_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.host_ = s;
            return s;
        }

        @Override
        public ByteString getHostBytes() {
            Object ref = this.host_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.host_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getPort() {
            return this.port_;
        }

        @Override
        public boolean hasParameters() {
            return this.parameters_ != null;
        }

        @Override
        public MemcacheParameters getParameters() {
            return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
        }

        @Override
        public MemcacheParametersOrBuilder getParametersOrBuilder() {
            return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.nodeId_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.nodeId_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.zone_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.zone_);
            }
            if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
                output.writeEnum(3, this.state_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.host_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.host_);
            }
            if (this.port_ != 0) {
                output.writeInt32(5, this.port_);
            }
            if (this.parameters_ != null) {
                output.writeMessage(6, (MessageLite)this.getParameters());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.nodeId_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.nodeId_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.zone_)) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.zone_);
            }
            if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)3, (int)this.state_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.host_)) {
                size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.host_);
            }
            if (this.port_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)5, (int)this.port_);
            }
            if (this.parameters_ != null) {
                size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getParameters());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Node)) {
                return super.equals(obj);
            }
            Node other = (Node)obj;
            if (!this.getNodeId().equals(other.getNodeId())) {
                return false;
            }
            if (!this.getZone().equals(other.getZone())) {
                return false;
            }
            if (this.state_ != other.state_) {
                return false;
            }
            if (!this.getHost().equals(other.getHost())) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.hasParameters() != other.hasParameters()) {
                return false;
            }
            if (this.hasParameters() && !this.getParameters().equals(other.getParameters())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Node.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getNodeId().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getZone().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + this.state_;
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getHost().hashCode();
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPort();
            if (this.hasParameters()) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getParameters().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Node parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Node)PARSER.parseFrom(data);
        }

        public static Node parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Node)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Node parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Node)PARSER.parseFrom(data);
        }

        public static Node parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Node)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Node parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Node)PARSER.parseFrom(data);
        }

        public static Node parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Node)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Node parseFrom(InputStream input) throws IOException {
            return (Node)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Node parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Node)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Node parseDelimitedFrom(InputStream input) throws IOException {
            return (Node)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Node parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Node)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Node parseFrom(CodedInputStream input) throws IOException {
            return (Node)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Node parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Node)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Node.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Node prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Node getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Node> parser() {
            return PARSER;
        }

        public Parser<Node> getParserForType() {
            return PARSER;
        }

        public Node getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements NodeOrBuilder {
            private int bitField0_;
            private Object nodeId_ = "";
            private Object zone_ = "";
            private int state_ = 0;
            private Object host_ = "";
            private int port_;
            private MemcacheParameters parameters_;
            private SingleFieldBuilderV3<MemcacheParameters, MemcacheParameters.Builder, MemcacheParametersOrBuilder> parametersBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_Node_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_Node_fieldAccessorTable.ensureFieldAccessorsInitialized(Node.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.nodeId_ = "";
                this.zone_ = "";
                this.state_ = 0;
                this.host_ = "";
                this.port_ = 0;
                this.parameters_ = null;
                if (this.parametersBuilder_ != null) {
                    this.parametersBuilder_.dispose();
                    this.parametersBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_Node_descriptor;
            }

            public Node getDefaultInstanceForType() {
                return Node.getDefaultInstance();
            }

            public Node build() {
                Node result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Node buildPartial() {
                Node result = new Node(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(Node result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.nodeId_ = this.nodeId_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.zone_ = this.zone_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.state_ = this.state_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.host_ = this.host_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.port_ = this.port_;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.parameters_ = this.parametersBuilder_ == null ? this.parameters_ : (MemcacheParameters)this.parametersBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Node) {
                    return this.mergeFrom((Node)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Node other) {
                if (other == Node.getDefaultInstance()) {
                    return this;
                }
                if (!other.getNodeId().isEmpty()) {
                    this.nodeId_ = other.nodeId_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.getZone().isEmpty()) {
                    this.zone_ = other.zone_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                if (other.state_ != 0) {
                    this.setStateValue(other.getStateValue());
                }
                if (!other.getHost().isEmpty()) {
                    this.host_ = other.host_;
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                if (other.getPort() != 0) {
                    this.setPort(other.getPort());
                }
                if (other.hasParameters()) {
                    this.mergeParameters(other.getParameters());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block14: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block14;
                            }
                            case 10: {
                                this.nodeId_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block14;
                            }
                            case 18: {
                                this.zone_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block14;
                            }
                            case 24: {
                                this.state_ = input.readEnum();
                                this.bitField0_ |= 4;
                                continue block14;
                            }
                            case 34: {
                                this.host_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 8;
                                continue block14;
                            }
                            case 40: {
                                this.port_ = input.readInt32();
                                this.bitField0_ |= 0x10;
                                continue block14;
                            }
                            case 50: {
                                input.readMessage((MessageLite.Builder)this.getParametersFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x20;
                                continue block14;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getNodeId() {
                Object ref = this.nodeId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.nodeId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNodeIdBytes() {
                Object ref = this.nodeId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.nodeId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setNodeId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.nodeId_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearNodeId() {
                this.nodeId_ = Node.getDefaultInstance().getNodeId();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setNodeIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Node.checkByteStringIsUtf8((ByteString)value);
                this.nodeId_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public String getZone() {
                Object ref = this.zone_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.zone_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getZoneBytes() {
                Object ref = this.zone_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.zone_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setZone(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.zone_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearZone() {
                this.zone_ = Node.getDefaultInstance().getZone();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setZoneBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Node.checkByteStringIsUtf8((ByteString)value);
                this.zone_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public int getStateValue() {
                return this.state_;
            }

            public Builder setStateValue(int value) {
                this.state_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            @Override
            public State getState() {
                State result = State.forNumber(this.state_);
                return result == null ? State.UNRECOGNIZED : result;
            }

            public Builder setState(State value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 4;
                this.state_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearState() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.state_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public String getHost() {
                Object ref = this.host_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.host_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getHostBytes() {
                Object ref = this.host_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.host_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setHost(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.host_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearHost() {
                this.host_ = Node.getDefaultInstance().getHost();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder setHostBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Node.checkByteStringIsUtf8((ByteString)value);
                this.host_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            @Override
            public int getPort() {
                return this.port_;
            }

            public Builder setPort(int value) {
                this.port_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearPort() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.port_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasParameters() {
                return (this.bitField0_ & 0x20) != 0;
            }

            @Override
            public MemcacheParameters getParameters() {
                if (this.parametersBuilder_ == null) {
                    return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
                }
                return (MemcacheParameters)this.parametersBuilder_.getMessage();
            }

            public Builder setParameters(MemcacheParameters value) {
                if (this.parametersBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.parameters_ = value;
                } else {
                    this.parametersBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder setParameters(MemcacheParameters.Builder builderForValue) {
                if (this.parametersBuilder_ == null) {
                    this.parameters_ = builderForValue.build();
                } else {
                    this.parametersBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder mergeParameters(MemcacheParameters value) {
                if (this.parametersBuilder_ == null) {
                    if ((this.bitField0_ & 0x20) != 0 && this.parameters_ != null && this.parameters_ != MemcacheParameters.getDefaultInstance()) {
                        this.getParametersBuilder().mergeFrom(value);
                    } else {
                        this.parameters_ = value;
                    }
                } else {
                    this.parametersBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearParameters() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.parameters_ = null;
                if (this.parametersBuilder_ != null) {
                    this.parametersBuilder_.dispose();
                    this.parametersBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public MemcacheParameters.Builder getParametersBuilder() {
                this.bitField0_ |= 0x20;
                this.onChanged();
                return (MemcacheParameters.Builder)this.getParametersFieldBuilder().getBuilder();
            }

            @Override
            public MemcacheParametersOrBuilder getParametersOrBuilder() {
                if (this.parametersBuilder_ != null) {
                    return (MemcacheParametersOrBuilder)this.parametersBuilder_.getMessageOrBuilder();
                }
                return this.parameters_ == null ? MemcacheParameters.getDefaultInstance() : this.parameters_;
            }

            private SingleFieldBuilderV3<MemcacheParameters, MemcacheParameters.Builder, MemcacheParametersOrBuilder> getParametersFieldBuilder() {
                if (this.parametersBuilder_ == null) {
                    this.parametersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getParameters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.parameters_ = null;
                }
                return this.parametersBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum State implements ProtocolMessageEnum
        {
            STATE_UNSPECIFIED(0),
            CREATING(1),
            READY(2),
            DELETING(3),
            UPDATING(4),
            UNRECOGNIZED(-1);

            public static final int STATE_UNSPECIFIED_VALUE = 0;
            public static final int CREATING_VALUE = 1;
            public static final int READY_VALUE = 2;
            public static final int DELETING_VALUE = 3;
            public static final int UPDATING_VALUE = 4;
            private static final Internal.EnumLiteMap<State> internalValueMap;
            private static final State[] VALUES;
            private final int value;

            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static State valueOf(int value) {
                return State.forNumber(value);
            }

            public static State forNumber(int value) {
                switch (value) {
                    case 0: {
                        return STATE_UNSPECIFIED;
                    }
                    case 1: {
                        return CREATING;
                    }
                    case 2: {
                        return READY;
                    }
                    case 3: {
                        return DELETING;
                    }
                    case 4: {
                        return UPDATING;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<State> internalGetValueMap() {
                return internalValueMap;
            }

            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
            }

            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return State.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return (Descriptors.EnumDescriptor)Node.getDescriptor().getEnumTypes().get(0);
            }

            public static State valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != State.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private State(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<State>(){

                    public State findValueByNumber(int number) {
                        return State.forNumber(number);
                    }
                };
                VALUES = State.values();
            }
        }
    }

    public static interface NodeOrBuilder
    extends MessageOrBuilder {
        public String getNodeId();

        public ByteString getNodeIdBytes();

        public String getZone();

        public ByteString getZoneBytes();

        public int getStateValue();

        public Node.State getState();

        public String getHost();

        public ByteString getHostBytes();

        public int getPort();

        public boolean hasParameters();

        public MemcacheParameters getParameters();

        public MemcacheParametersOrBuilder getParametersOrBuilder();
    }

    public static final class NodeConfig
    extends GeneratedMessageV3
    implements NodeConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CPU_COUNT_FIELD_NUMBER = 1;
        private int cpuCount_ = 0;
        public static final int MEMORY_SIZE_MB_FIELD_NUMBER = 2;
        private int memorySizeMb_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final NodeConfig DEFAULT_INSTANCE = new NodeConfig();
        private static final Parser<NodeConfig> PARSER = new AbstractParser<NodeConfig>(){

            public NodeConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = NodeConfig.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private NodeConfig(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private NodeConfig() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new NodeConfig();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_NodeConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_NodeConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeConfig.class, Builder.class);
        }

        @Override
        public int getCpuCount() {
            return this.cpuCount_;
        }

        @Override
        public int getMemorySizeMb() {
            return this.memorySizeMb_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.cpuCount_ != 0) {
                output.writeInt32(1, this.cpuCount_);
            }
            if (this.memorySizeMb_ != 0) {
                output.writeInt32(2, this.memorySizeMb_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.cpuCount_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)1, (int)this.cpuCount_);
            }
            if (this.memorySizeMb_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)2, (int)this.memorySizeMb_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NodeConfig)) {
                return super.equals(obj);
            }
            NodeConfig other = (NodeConfig)obj;
            if (this.getCpuCount() != other.getCpuCount()) {
                return false;
            }
            if (this.getMemorySizeMb() != other.getMemorySizeMb()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + NodeConfig.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getCpuCount();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getMemorySizeMb();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static NodeConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (NodeConfig)PARSER.parseFrom(data);
        }

        public static NodeConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (NodeConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static NodeConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (NodeConfig)PARSER.parseFrom(data);
        }

        public static NodeConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (NodeConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static NodeConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (NodeConfig)PARSER.parseFrom(data);
        }

        public static NodeConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (NodeConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static NodeConfig parseFrom(InputStream input) throws IOException {
            return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static NodeConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static NodeConfig parseDelimitedFrom(InputStream input) throws IOException {
            return (NodeConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static NodeConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (NodeConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static NodeConfig parseFrom(CodedInputStream input) throws IOException {
            return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static NodeConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (NodeConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return NodeConfig.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(NodeConfig prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static NodeConfig getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<NodeConfig> parser() {
            return PARSER;
        }

        public Parser<NodeConfig> getParserForType() {
            return PARSER;
        }

        public NodeConfig getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements NodeConfigOrBuilder {
            private int bitField0_;
            private int cpuCount_;
            private int memorySizeMb_;

            public static final Descriptors.Descriptor getDescriptor() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_NodeConfig_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_NodeConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeConfig.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.cpuCount_ = 0;
                this.memorySizeMb_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CloudMemcacheProto.internal_static_google_cloud_memcache_v1_Instance_NodeConfig_descriptor;
            }

            public NodeConfig getDefaultInstanceForType() {
                return NodeConfig.getDefaultInstance();
            }

            public NodeConfig build() {
                NodeConfig result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public NodeConfig buildPartial() {
                NodeConfig result = new NodeConfig(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(NodeConfig result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.cpuCount_ = this.cpuCount_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.memorySizeMb_ = this.memorySizeMb_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof NodeConfig) {
                    return this.mergeFrom((NodeConfig)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(NodeConfig other) {
                if (other == NodeConfig.getDefaultInstance()) {
                    return this;
                }
                if (other.getCpuCount() != 0) {
                    this.setCpuCount(other.getCpuCount());
                }
                if (other.getMemorySizeMb() != 0) {
                    this.setMemorySizeMb(other.getMemorySizeMb());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.cpuCount_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 16: {
                                this.memorySizeMb_ = input.readInt32();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getCpuCount() {
                return this.cpuCount_;
            }

            public Builder setCpuCount(int value) {
                this.cpuCount_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCpuCount() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.cpuCount_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public int getMemorySizeMb() {
                return this.memorySizeMb_;
            }

            public Builder setMemorySizeMb(int value) {
                this.memorySizeMb_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearMemorySizeMb() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.memorySizeMb_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface NodeConfigOrBuilder
    extends MessageOrBuilder {
        public int getCpuCount();

        public int getMemorySizeMb();
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        CREATING(1),
        READY(2),
        UPDATING(3),
        DELETING(4),
        PERFORMING_MAINTENANCE(5),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int CREATING_VALUE = 1;
        public static final int READY_VALUE = 2;
        public static final int UPDATING_VALUE = 3;
        public static final int DELETING_VALUE = 4;
        public static final int PERFORMING_MAINTENANCE_VALUE = 5;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return CREATING;
                }
                case 2: {
                    return READY;
                }
                case 3: {
                    return UPDATING;
                }
                case 4: {
                    return DELETING;
                }
                case 5: {
                    return PERFORMING_MAINTENANCE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Instance.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

