/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2/functions.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.functions.v2;

/**
 *
 *
 * <pre>
 * Each Stage of the deployment process
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2.Stage}
 */
public final class Stage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2.Stage)
    StageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Stage.newBuilder() to construct.
  private Stage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Stage() {
    name_ = 0;
    message_ = "";
    state_ = 0;
    resource_ = "";
    resourceUri_ = "";
    stateMessages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Stage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_Stage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_Stage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2.Stage.class,
            com.google.cloud.functions.v2.Stage.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible names for a Stage
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2.Stage.Name}
   */
  public enum Name implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. Invalid name.
     * </pre>
     *
     * <code>NAME_UNSPECIFIED = 0;</code>
     */
    NAME_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Artifact Regsitry Stage
     * </pre>
     *
     * <code>ARTIFACT_REGISTRY = 1;</code>
     */
    ARTIFACT_REGISTRY(1),
    /**
     *
     *
     * <pre>
     * Build Stage
     * </pre>
     *
     * <code>BUILD = 2;</code>
     */
    BUILD(2),
    /**
     *
     *
     * <pre>
     * Service Stage
     * </pre>
     *
     * <code>SERVICE = 3;</code>
     */
    SERVICE(3),
    /**
     *
     *
     * <pre>
     * Trigger Stage
     * </pre>
     *
     * <code>TRIGGER = 4;</code>
     */
    TRIGGER(4),
    /**
     *
     *
     * <pre>
     * Service Rollback Stage
     * </pre>
     *
     * <code>SERVICE_ROLLBACK = 5;</code>
     */
    SERVICE_ROLLBACK(5),
    /**
     *
     *
     * <pre>
     * Trigger Rollback Stage
     * </pre>
     *
     * <code>TRIGGER_ROLLBACK = 6;</code>
     */
    TRIGGER_ROLLBACK(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. Invalid name.
     * </pre>
     *
     * <code>NAME_UNSPECIFIED = 0;</code>
     */
    public static final int NAME_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Artifact Regsitry Stage
     * </pre>
     *
     * <code>ARTIFACT_REGISTRY = 1;</code>
     */
    public static final int ARTIFACT_REGISTRY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Build Stage
     * </pre>
     *
     * <code>BUILD = 2;</code>
     */
    public static final int BUILD_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Service Stage
     * </pre>
     *
     * <code>SERVICE = 3;</code>
     */
    public static final int SERVICE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Trigger Stage
     * </pre>
     *
     * <code>TRIGGER = 4;</code>
     */
    public static final int TRIGGER_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Service Rollback Stage
     * </pre>
     *
     * <code>SERVICE_ROLLBACK = 5;</code>
     */
    public static final int SERVICE_ROLLBACK_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Trigger Rollback Stage
     * </pre>
     *
     * <code>TRIGGER_ROLLBACK = 6;</code>
     */
    public static final int TRIGGER_ROLLBACK_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Name valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Name forNumber(int value) {
      switch (value) {
        case 0:
          return NAME_UNSPECIFIED;
        case 1:
          return ARTIFACT_REGISTRY;
        case 2:
          return BUILD;
        case 3:
          return SERVICE;
        case 4:
          return TRIGGER;
        case 5:
          return SERVICE_ROLLBACK;
        case 6:
          return TRIGGER_ROLLBACK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Name> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Name> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Name>() {
          public Name findValueByNumber(int number) {
            return Name.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2.Stage.getDescriptor().getEnumTypes().get(0);
    }

    private static final Name[] VALUES = values();

    public static Name valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Name(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2.Stage.Name)
  }

  /**
   *
   *
   * <pre>
   * Possible states for a Stage
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2.Stage.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Stage has not started.
     * </pre>
     *
     * <code>NOT_STARTED = 1;</code>
     */
    NOT_STARTED(1),
    /**
     *
     *
     * <pre>
     * Stage is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 2;</code>
     */
    IN_PROGRESS(2),
    /**
     *
     *
     * <pre>
     * Stage has completed.
     * </pre>
     *
     * <code>COMPLETE = 3;</code>
     */
    COMPLETE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Stage has not started.
     * </pre>
     *
     * <code>NOT_STARTED = 1;</code>
     */
    public static final int NOT_STARTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Stage is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 2;</code>
     */
    public static final int IN_PROGRESS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Stage has completed.
     * </pre>
     *
     * <code>COMPLETE = 3;</code>
     */
    public static final int COMPLETE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return NOT_STARTED;
        case 2:
          return IN_PROGRESS;
        case 3:
          return COMPLETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2.Stage.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2.Stage.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private int name_ = 0;
  /**
   *
   *
   * <pre>
   * Name of the Stage. This will be unique for each Stage.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
   *
   * @return The enum numeric value on the wire for name.
   */
  @java.lang.Override
  public int getNameValue() {
    return name_;
  }
  /**
   *
   *
   * <pre>
   * Name of the Stage. This will be unique for each Stage.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.Stage.Name getName() {
    com.google.cloud.functions.v2.Stage.Name result =
        com.google.cloud.functions.v2.Stage.Name.forNumber(name_);
    return result == null ? com.google.cloud.functions.v2.Stage.Name.UNRECOGNIZED : result;
  }

  public static final int MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * Message describing the Stage
   * </pre>
   *
   * <code>string message = 2;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Message describing the Stage
   * </pre>
   *
   * <code>string message = 2;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Current state of the Stage
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Current state of the Stage
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.Stage.State getState() {
    com.google.cloud.functions.v2.Stage.State result =
        com.google.cloud.functions.v2.Stage.State.forNumber(state_);
    return result == null ? com.google.cloud.functions.v2.Stage.State.UNRECOGNIZED : result;
  }

  public static final int RESOURCE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * Resource of the Stage
   * </pre>
   *
   * <code>string resource = 4;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource of the Stage
   * </pre>
   *
   * <code>string resource = 4;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceUri_ = "";
  /**
   *
   *
   * <pre>
   * Link to the current Stage resource
   * </pre>
   *
   * <code>string resource_uri = 5;</code>
   *
   * @return The resourceUri.
   */
  @java.lang.Override
  public java.lang.String getResourceUri() {
    java.lang.Object ref = resourceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Link to the current Stage resource
   * </pre>
   *
   * <code>string resource_uri = 5;</code>
   *
   * @return The bytes for resourceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceUriBytes() {
    java.lang.Object ref = resourceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_MESSAGES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2.StateMessage> stateMessages_;
  /**
   *
   *
   * <pre>
   * State messages from the current Stage.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2.StateMessage> getStateMessagesList() {
    return stateMessages_;
  }
  /**
   *
   *
   * <pre>
   * State messages from the current Stage.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v2.StateMessageOrBuilder>
      getStateMessagesOrBuilderList() {
    return stateMessages_;
  }
  /**
   *
   *
   * <pre>
   * State messages from the current Stage.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
   */
  @java.lang.Override
  public int getStateMessagesCount() {
    return stateMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * State messages from the current Stage.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.StateMessage getStateMessages(int index) {
    return stateMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * State messages from the current Stage.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.StateMessageOrBuilder getStateMessagesOrBuilder(int index) {
    return stateMessages_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (name_ != com.google.cloud.functions.v2.Stage.Name.NAME_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, message_);
    }
    if (state_ != com.google.cloud.functions.v2.Stage.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, resourceUri_);
    }
    for (int i = 0; i < stateMessages_.size(); i++) {
      output.writeMessage(6, stateMessages_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (name_ != com.google.cloud.functions.v2.Stage.Name.NAME_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, message_);
    }
    if (state_ != com.google.cloud.functions.v2.Stage.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, resourceUri_);
    }
    for (int i = 0; i < stateMessages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, stateMessages_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2.Stage)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2.Stage other = (com.google.cloud.functions.v2.Stage) obj;

    if (name_ != other.name_) return false;
    if (!getMessage().equals(other.getMessage())) return false;
    if (state_ != other.state_) return false;
    if (!getResource().equals(other.getResource())) return false;
    if (!getResourceUri().equals(other.getResourceUri())) return false;
    if (!getStateMessagesList().equals(other.getStateMessagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + name_;
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + RESOURCE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getResourceUri().hashCode();
    if (getStateMessagesCount() > 0) {
      hash = (37 * hash) + STATE_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getStateMessagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Stage parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.Stage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.Stage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2.Stage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Each Stage of the deployment process
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2.Stage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2.Stage)
      com.google.cloud.functions.v2.StageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_Stage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_Stage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2.Stage.class,
              com.google.cloud.functions.v2.Stage.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2.Stage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = 0;
      message_ = "";
      state_ = 0;
      resource_ = "";
      resourceUri_ = "";
      if (stateMessagesBuilder_ == null) {
        stateMessages_ = java.util.Collections.emptyList();
      } else {
        stateMessages_ = null;
        stateMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_Stage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.Stage getDefaultInstanceForType() {
      return com.google.cloud.functions.v2.Stage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.Stage build() {
      com.google.cloud.functions.v2.Stage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.Stage buildPartial() {
      com.google.cloud.functions.v2.Stage result = new com.google.cloud.functions.v2.Stage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.functions.v2.Stage result) {
      if (stateMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          stateMessages_ = java.util.Collections.unmodifiableList(stateMessages_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.stateMessages_ = stateMessages_;
      } else {
        result.stateMessages_ = stateMessagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2.Stage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.message_ = message_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resource_ = resource_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.resourceUri_ = resourceUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2.Stage) {
        return mergeFrom((com.google.cloud.functions.v2.Stage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2.Stage other) {
      if (other == com.google.cloud.functions.v2.Stage.getDefaultInstance()) return this;
      if (other.name_ != 0) {
        setNameValue(other.getNameValue());
      }
      if (!other.getMessage().isEmpty()) {
        message_ = other.message_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getResourceUri().isEmpty()) {
        resourceUri_ = other.resourceUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (stateMessagesBuilder_ == null) {
        if (!other.stateMessages_.isEmpty()) {
          if (stateMessages_.isEmpty()) {
            stateMessages_ = other.stateMessages_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureStateMessagesIsMutable();
            stateMessages_.addAll(other.stateMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.stateMessages_.isEmpty()) {
          if (stateMessagesBuilder_.isEmpty()) {
            stateMessagesBuilder_.dispose();
            stateMessagesBuilder_ = null;
            stateMessages_ = other.stateMessages_;
            bitField0_ = (bitField0_ & ~0x00000020);
            stateMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStateMessagesFieldBuilder()
                    : null;
          } else {
            stateMessagesBuilder_.addAllMessages(other.stateMessages_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                name_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                resourceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.functions.v2.StateMessage m =
                    input.readMessage(
                        com.google.cloud.functions.v2.StateMessage.parser(), extensionRegistry);
                if (stateMessagesBuilder_ == null) {
                  ensureStateMessagesIsMutable();
                  stateMessages_.add(m);
                } else {
                  stateMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int name_ = 0;
    /**
     *
     *
     * <pre>
     * Name of the Stage. This will be unique for each Stage.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
     *
     * @return The enum numeric value on the wire for name.
     */
    @java.lang.Override
    public int getNameValue() {
      return name_;
    }
    /**
     *
     *
     * <pre>
     * Name of the Stage. This will be unique for each Stage.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
     *
     * @param value The enum numeric value on the wire for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameValue(int value) {
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Stage. This will be unique for each Stage.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.Stage.Name getName() {
      com.google.cloud.functions.v2.Stage.Name result =
          com.google.cloud.functions.v2.Stage.Name.forNumber(name_);
      return result == null ? com.google.cloud.functions.v2.Stage.Name.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Name of the Stage. This will be unique for each Stage.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(com.google.cloud.functions.v2.Stage.Name value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      name_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Stage. This will be unique for each Stage.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.Name name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      bitField0_ = (bitField0_ & ~0x00000001);
      name_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Message describing the Stage
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Message describing the Stage
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Message describing the Stage
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message describing the Stage
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message describing the Stage
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Current state of the Stage
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Current state of the Stage
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current state of the Stage
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.Stage.State getState() {
      com.google.cloud.functions.v2.Stage.State result =
          com.google.cloud.functions.v2.Stage.State.forNumber(state_);
      return result == null ? com.google.cloud.functions.v2.Stage.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Current state of the Stage
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.functions.v2.Stage.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current state of the Stage
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Stage.State state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * Resource of the Stage
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource of the Stage
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource of the Stage
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource of the Stage
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource of the Stage
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object resourceUri_ = "";
    /**
     *
     *
     * <pre>
     * Link to the current Stage resource
     * </pre>
     *
     * <code>string resource_uri = 5;</code>
     *
     * @return The resourceUri.
     */
    public java.lang.String getResourceUri() {
      java.lang.Object ref = resourceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Link to the current Stage resource
     * </pre>
     *
     * <code>string resource_uri = 5;</code>
     *
     * @return The bytes for resourceUri.
     */
    public com.google.protobuf.ByteString getResourceUriBytes() {
      java.lang.Object ref = resourceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Link to the current Stage resource
     * </pre>
     *
     * <code>string resource_uri = 5;</code>
     *
     * @param value The resourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Link to the current Stage resource
     * </pre>
     *
     * <code>string resource_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceUri() {
      resourceUri_ = getDefaultInstance().getResourceUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Link to the current Stage resource
     * </pre>
     *
     * <code>string resource_uri = 5;</code>
     *
     * @param value The bytes for resourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.functions.v2.StateMessage> stateMessages_ =
        java.util.Collections.emptyList();

    private void ensureStateMessagesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        stateMessages_ =
            new java.util.ArrayList<com.google.cloud.functions.v2.StateMessage>(stateMessages_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2.StateMessage,
            com.google.cloud.functions.v2.StateMessage.Builder,
            com.google.cloud.functions.v2.StateMessageOrBuilder>
        stateMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public java.util.List<com.google.cloud.functions.v2.StateMessage> getStateMessagesList() {
      if (stateMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stateMessages_);
      } else {
        return stateMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public int getStateMessagesCount() {
      if (stateMessagesBuilder_ == null) {
        return stateMessages_.size();
      } else {
        return stateMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public com.google.cloud.functions.v2.StateMessage getStateMessages(int index) {
      if (stateMessagesBuilder_ == null) {
        return stateMessages_.get(index);
      } else {
        return stateMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder setStateMessages(int index, com.google.cloud.functions.v2.StateMessage value) {
      if (stateMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateMessagesIsMutable();
        stateMessages_.set(index, value);
        onChanged();
      } else {
        stateMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder setStateMessages(
        int index, com.google.cloud.functions.v2.StateMessage.Builder builderForValue) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        stateMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder addStateMessages(com.google.cloud.functions.v2.StateMessage value) {
      if (stateMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateMessagesIsMutable();
        stateMessages_.add(value);
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder addStateMessages(int index, com.google.cloud.functions.v2.StateMessage value) {
      if (stateMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateMessagesIsMutable();
        stateMessages_.add(index, value);
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder addStateMessages(
        com.google.cloud.functions.v2.StateMessage.Builder builderForValue) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.add(builderForValue.build());
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder addStateMessages(
        int index, com.google.cloud.functions.v2.StateMessage.Builder builderForValue) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder addAllStateMessages(
        java.lang.Iterable<? extends com.google.cloud.functions.v2.StateMessage> values) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stateMessages_);
        onChanged();
      } else {
        stateMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder clearStateMessages() {
      if (stateMessagesBuilder_ == null) {
        stateMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        stateMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public Builder removeStateMessages(int index) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.remove(index);
        onChanged();
      } else {
        stateMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public com.google.cloud.functions.v2.StateMessage.Builder getStateMessagesBuilder(int index) {
      return getStateMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public com.google.cloud.functions.v2.StateMessageOrBuilder getStateMessagesOrBuilder(
        int index) {
      if (stateMessagesBuilder_ == null) {
        return stateMessages_.get(index);
      } else {
        return stateMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.functions.v2.StateMessageOrBuilder>
        getStateMessagesOrBuilderList() {
      if (stateMessagesBuilder_ != null) {
        return stateMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stateMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public com.google.cloud.functions.v2.StateMessage.Builder addStateMessagesBuilder() {
      return getStateMessagesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v2.StateMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public com.google.cloud.functions.v2.StateMessage.Builder addStateMessagesBuilder(int index) {
      return getStateMessagesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v2.StateMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * State messages from the current Stage.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.StateMessage state_messages = 6;</code>
     */
    public java.util.List<com.google.cloud.functions.v2.StateMessage.Builder>
        getStateMessagesBuilderList() {
      return getStateMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2.StateMessage,
            com.google.cloud.functions.v2.StateMessage.Builder,
            com.google.cloud.functions.v2.StateMessageOrBuilder>
        getStateMessagesFieldBuilder() {
      if (stateMessagesBuilder_ == null) {
        stateMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2.StateMessage,
                com.google.cloud.functions.v2.StateMessage.Builder,
                com.google.cloud.functions.v2.StateMessageOrBuilder>(
                stateMessages_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        stateMessages_ = null;
      }
      return stateMessagesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2.Stage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2.Stage)
  private static final com.google.cloud.functions.v2.Stage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2.Stage();
  }

  public static com.google.cloud.functions.v2.Stage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Stage> PARSER =
      new com.google.protobuf.AbstractParser<Stage>() {
        @java.lang.Override
        public Stage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Stage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Stage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2.Stage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
