/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v1/functions.proto

package com.google.cloud.functions.v1;

/**
 *
 *
 * <pre>
 * Describes a Cloud Function that contains user computation executed in
 * response to an event. It encapsulate function and triggers configurations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v1.CloudFunction}
 */
public final class CloudFunction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.CloudFunction)
    CloudFunctionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudFunction.newBuilder() to construct.
  private CloudFunction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudFunction() {
    name_ = "";
    description_ = "";
    status_ = 0;
    entryPoint_ = "";
    runtime_ = "";
    serviceAccountEmail_ = "";
    network_ = "";
    vpcConnector_ = "";
    vpcConnectorEgressSettings_ = 0;
    ingressSettings_ = 0;
    buildId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudFunction();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CloudFunction(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              sourceCodeCase_ = 3;
              sourceCode_ = s;
              break;
            }
          case 34:
            {
              com.google.cloud.functions.v1.SourceRepository.Builder subBuilder = null;
              if (sourceCodeCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.functions.v1.SourceRepository) sourceCode_).toBuilder();
              }
              sourceCode_ =
                  input.readMessage(
                      com.google.cloud.functions.v1.SourceRepository.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.functions.v1.SourceRepository) sourceCode_);
                sourceCode_ = subBuilder.buildPartial();
              }
              sourceCodeCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.functions.v1.HttpsTrigger.Builder subBuilder = null;
              if (triggerCase_ == 5) {
                subBuilder = ((com.google.cloud.functions.v1.HttpsTrigger) trigger_).toBuilder();
              }
              trigger_ =
                  input.readMessage(
                      com.google.cloud.functions.v1.HttpsTrigger.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.functions.v1.HttpsTrigger) trigger_);
                trigger_ = subBuilder.buildPartial();
              }
              triggerCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.functions.v1.EventTrigger.Builder subBuilder = null;
              if (triggerCase_ == 6) {
                subBuilder = ((com.google.cloud.functions.v1.EventTrigger) trigger_).toBuilder();
              }
              trigger_ =
                  input.readMessage(
                      com.google.cloud.functions.v1.EventTrigger.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.functions.v1.EventTrigger) trigger_);
                trigger_ = subBuilder.buildPartial();
              }
              triggerCase_ = 6;
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              entryPoint_ = s;
              break;
            }
          case 74:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeout_ != null) {
                subBuilder = timeout_.toBuilder();
              }
              timeout_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeout_);
                timeout_ = subBuilder.buildPartial();
              }

              break;
            }
          case 80:
            {
              availableMemoryMb_ = input.readInt32();
              break;
            }
          case 90:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccountEmail_ = s;
              break;
            }
          case 98:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 112:
            {
              versionId_ = input.readInt64();
              break;
            }
          case 122:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 130:
            {
              java.lang.String s = input.readStringRequireUtf8();
              sourceCodeCase_ = 16;
              sourceCode_ = s;
              break;
            }
          case 138:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                environmentVariables_ =
                    com.google.protobuf.MapField.newMapField(
                        EnvironmentVariablesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                  environmentVariables__ =
                      input.readMessage(
                          EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              environmentVariables_
                  .getMutableMap()
                  .put(environmentVariables__.getKey(), environmentVariables__.getValue());
              break;
            }
          case 146:
            {
              java.lang.String s = input.readStringRequireUtf8();

              network_ = s;
              break;
            }
          case 154:
            {
              java.lang.String s = input.readStringRequireUtf8();

              runtime_ = s;
              break;
            }
          case 160:
            {
              maxInstances_ = input.readInt32();
              break;
            }
          case 178:
            {
              java.lang.String s = input.readStringRequireUtf8();

              vpcConnector_ = s;
              break;
            }
          case 184:
            {
              int rawValue = input.readEnum();

              vpcConnectorEgressSettings_ = rawValue;
              break;
            }
          case 192:
            {
              int rawValue = input.readEnum();

              ingressSettings_ = rawValue;
              break;
            }
          case 218:
            {
              java.lang.String s = input.readStringRequireUtf8();

              buildId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      case 17:
        return internalGetEnvironmentVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_CloudFunction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v1.CloudFunction.class,
            com.google.cloud.functions.v1.CloudFunction.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Available egress settings.
   * This controls what traffic is diverted through the VPC Access Connector
   * resource. By default PRIVATE_RANGES_ONLY will be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings}
   */
  public enum VpcConnectorEgressSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the VPC Access Connector only for private IP space from RFC1918.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 1;</code>
     */
    PRIVATE_RANGES_ONLY(1),
    /**
     *
     *
     * <pre>
     * Force the use of VPC Access Connector for all egress traffic from the
     * function.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 2;</code>
     */
    ALL_TRAFFIC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the VPC Access Connector only for private IP space from RFC1918.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 1;</code>
     */
    public static final int PRIVATE_RANGES_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Force the use of VPC Access Connector for all egress traffic from the
     * function.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 2;</code>
     */
    public static final int ALL_TRAFFIC_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VpcConnectorEgressSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VpcConnectorEgressSettings forNumber(int value) {
      switch (value) {
        case 0:
          return VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED;
        case 1:
          return PRIVATE_RANGES_ONLY;
        case 2:
          return ALL_TRAFFIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>() {
              public VpcConnectorEgressSettings findValueByNumber(int number) {
                return VpcConnectorEgressSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v1.CloudFunction.getDescriptor().getEnumTypes().get(0);
    }

    private static final VpcConnectorEgressSettings[] VALUES = values();

    public static VpcConnectorEgressSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VpcConnectorEgressSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings)
  }

  /**
   *
   *
   * <pre>
   * Available ingress settings.
   * This controls what traffic can reach the function.
   * If unspecified, ALLOW_ALL will be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v1.CloudFunction.IngressSettings}
   */
  public enum IngressSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    INGRESS_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from public and private sources.
     * </pre>
     *
     * <code>ALLOW_ALL = 1;</code>
     */
    ALLOW_ALL(1),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from only private VPC sources.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_ONLY = 2;</code>
     */
    ALLOW_INTERNAL_ONLY(2),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from private VPC sources and through GCLB.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_AND_GCLB = 3;</code>
     */
    ALLOW_INTERNAL_AND_GCLB(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int INGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from public and private sources.
     * </pre>
     *
     * <code>ALLOW_ALL = 1;</code>
     */
    public static final int ALLOW_ALL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from only private VPC sources.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_ONLY = 2;</code>
     */
    public static final int ALLOW_INTERNAL_ONLY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from private VPC sources and through GCLB.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_AND_GCLB = 3;</code>
     */
    public static final int ALLOW_INTERNAL_AND_GCLB_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IngressSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IngressSettings forNumber(int value) {
      switch (value) {
        case 0:
          return INGRESS_SETTINGS_UNSPECIFIED;
        case 1:
          return ALLOW_ALL;
        case 2:
          return ALLOW_INTERNAL_ONLY;
        case 3:
          return ALLOW_INTERNAL_AND_GCLB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IngressSettings> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IngressSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IngressSettings>() {
              public IngressSettings findValueByNumber(int number) {
                return IngressSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v1.CloudFunction.getDescriptor().getEnumTypes().get(1);
    }

    private static final IngressSettings[] VALUES = values();

    public static IngressSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IngressSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v1.CloudFunction.IngressSettings)
  }

  private int sourceCodeCase_ = 0;
  private java.lang.Object sourceCode_;

  public enum SourceCodeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_ARCHIVE_URL(3),
    SOURCE_REPOSITORY(4),
    SOURCE_UPLOAD_URL(16),
    SOURCECODE_NOT_SET(0);
    private final int value;

    private SourceCodeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCodeCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCodeCase forNumber(int value) {
      switch (value) {
        case 3:
          return SOURCE_ARCHIVE_URL;
        case 4:
          return SOURCE_REPOSITORY;
        case 16:
          return SOURCE_UPLOAD_URL;
        case 0:
          return SOURCECODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCodeCase getSourceCodeCase() {
    return SourceCodeCase.forNumber(sourceCodeCase_);
  }

  private int triggerCase_ = 0;
  private java.lang.Object trigger_;

  public enum TriggerCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HTTPS_TRIGGER(5),
    EVENT_TRIGGER(6),
    TRIGGER_NOT_SET(0);
    private final int value;

    private TriggerCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TriggerCase valueOf(int value) {
      return forNumber(value);
    }

    public static TriggerCase forNumber(int value) {
      switch (value) {
        case 5:
          return HTTPS_TRIGGER;
        case 6:
          return EVENT_TRIGGER;
        case 0:
          return TRIGGER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TriggerCase getTriggerCase() {
    return TriggerCase.forNumber(triggerCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A user-defined name of the function. Function names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the function. Function names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * User-provided description of a function.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-provided description of a function.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_ARCHIVE_URL_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
   * archive which contains the function.
   * </pre>
   *
   * <code>string source_archive_url = 3;</code>
   *
   * @return Whether the sourceArchiveUrl field is set.
   */
  public boolean hasSourceArchiveUrl() {
    return sourceCodeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
   * archive which contains the function.
   * </pre>
   *
   * <code>string source_archive_url = 3;</code>
   *
   * @return The sourceArchiveUrl.
   */
  public java.lang.String getSourceArchiveUrl() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 3) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCodeCase_ == 3) {
        sourceCode_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
   * archive which contains the function.
   * </pre>
   *
   * <code>string source_archive_url = 3;</code>
   *
   * @return The bytes for sourceArchiveUrl.
   */
  public com.google.protobuf.ByteString getSourceArchiveUrlBytes() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 3) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCodeCase_ == 3) {
        sourceCode_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_REPOSITORY_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * **Beta Feature**
   * The source repository where a function is hosted.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
   *
   * @return Whether the sourceRepository field is set.
   */
  @java.lang.Override
  public boolean hasSourceRepository() {
    return sourceCodeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * **Beta Feature**
   * The source repository where a function is hosted.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
   *
   * @return The sourceRepository.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SourceRepository getSourceRepository() {
    if (sourceCodeCase_ == 4) {
      return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
    }
    return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * **Beta Feature**
   * The source repository where a function is hosted.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SourceRepositoryOrBuilder getSourceRepositoryOrBuilder() {
    if (sourceCodeCase_ == 4) {
      return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
    }
    return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
  }

  public static final int SOURCE_UPLOAD_URL_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage signed URL used for source uploading, generated
   * by calling [google.cloud.functions.v1.GenerateUploadUrl].
   * The signature is validated on write methods (Create, Update)
   * The signature is stripped from the Function object on read methods (Get,
   * List)
   * </pre>
   *
   * <code>string source_upload_url = 16;</code>
   *
   * @return Whether the sourceUploadUrl field is set.
   */
  public boolean hasSourceUploadUrl() {
    return sourceCodeCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage signed URL used for source uploading, generated
   * by calling [google.cloud.functions.v1.GenerateUploadUrl].
   * The signature is validated on write methods (Create, Update)
   * The signature is stripped from the Function object on read methods (Get,
   * List)
   * </pre>
   *
   * <code>string source_upload_url = 16;</code>
   *
   * @return The sourceUploadUrl.
   */
  public java.lang.String getSourceUploadUrl() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 16) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCodeCase_ == 16) {
        sourceCode_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage signed URL used for source uploading, generated
   * by calling [google.cloud.functions.v1.GenerateUploadUrl].
   * The signature is validated on write methods (Create, Update)
   * The signature is stripped from the Function object on read methods (Get,
   * List)
   * </pre>
   *
   * <code>string source_upload_url = 16;</code>
   *
   * @return The bytes for sourceUploadUrl.
   */
  public com.google.protobuf.ByteString getSourceUploadUrlBytes() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 16) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCodeCase_ == 16) {
        sourceCode_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTPS_TRIGGER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * An HTTPS endpoint type of source that can be triggered via URL.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
   *
   * @return Whether the httpsTrigger field is set.
   */
  @java.lang.Override
  public boolean hasHttpsTrigger() {
    return triggerCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * An HTTPS endpoint type of source that can be triggered via URL.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
   *
   * @return The httpsTrigger.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.HttpsTrigger getHttpsTrigger() {
    if (triggerCase_ == 5) {
      return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An HTTPS endpoint type of source that can be triggered via URL.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.HttpsTriggerOrBuilder getHttpsTriggerOrBuilder() {
    if (triggerCase_ == 5) {
      return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
  }

  public static final int EVENT_TRIGGER_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A source that fires events in response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
   *
   * @return Whether the eventTrigger field is set.
   */
  @java.lang.Override
  public boolean hasEventTrigger() {
    return triggerCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A source that fires events in response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
   *
   * @return The eventTrigger.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.EventTrigger getEventTrigger() {
    if (triggerCase_ == 6) {
      return (com.google.cloud.functions.v1.EventTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A source that fires events in response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.EventTriggerOrBuilder getEventTriggerOrBuilder() {
    if (triggerCase_ == 6) {
      return (com.google.cloud.functions.v1.EventTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
  }

  public static final int STATUS_FIELD_NUMBER = 7;
  private int status_;
  /**
   *
   *
   * <pre>
   * Output only. Status of the function deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status of the function deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunctionStatus getStatus() {
    @SuppressWarnings("deprecation")
    com.google.cloud.functions.v1.CloudFunctionStatus result =
        com.google.cloud.functions.v1.CloudFunctionStatus.valueOf(status_);
    return result == null ? com.google.cloud.functions.v1.CloudFunctionStatus.UNRECOGNIZED : result;
  }

  public static final int ENTRY_POINT_FIELD_NUMBER = 8;
  private volatile java.lang.Object entryPoint_;
  /**
   *
   *
   * <pre>
   * The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * For Node.js this is name of a function exported by the module specified
   * in `source_location`.
   * </pre>
   *
   * <code>string entry_point = 8;</code>
   *
   * @return The entryPoint.
   */
  @java.lang.Override
  public java.lang.String getEntryPoint() {
    java.lang.Object ref = entryPoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entryPoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * For Node.js this is name of a function exported by the module specified
   * in `source_location`.
   * </pre>
   *
   * <code>string entry_point = 8;</code>
   *
   * @return The bytes for entryPoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntryPointBytes() {
    java.lang.Object ref = entryPoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entryPoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUNTIME_FIELD_NUMBER = 19;
  private volatile java.lang.Object runtime_;
  /**
   *
   *
   * <pre>
   * The runtime in which to run the function. Required when deploying a new
   * function, optional when updating an existing function. For a complete
   * list of possible choices, see the
   * [`gcloud` command
   * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
   * </pre>
   *
   * <code>string runtime = 19;</code>
   *
   * @return The runtime.
   */
  @java.lang.Override
  public java.lang.String getRuntime() {
    java.lang.Object ref = runtime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      runtime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The runtime in which to run the function. Required when deploying a new
   * function, optional when updating an existing function. For a complete
   * list of possible choices, see the
   * [`gcloud` command
   * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
   * </pre>
   *
   * <code>string runtime = 19;</code>
   *
   * @return The bytes for runtime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuntimeBytes() {
    java.lang.Object ref = runtime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      runtime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIMEOUT_FIELD_NUMBER = 9;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 9;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 9;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int AVAILABLE_MEMORY_MB_FIELD_NUMBER = 10;
  private int availableMemoryMb_;
  /**
   *
   *
   * <pre>
   * The amount of memory in MB available for a function.
   * Defaults to 256MB.
   * </pre>
   *
   * <code>int32 available_memory_mb = 10;</code>
   *
   * @return The availableMemoryMb.
   */
  @java.lang.Override
  public int getAvailableMemoryMb() {
    return availableMemoryMb_;
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 11;
  private volatile java.lang.Object serviceAccountEmail_;
  /**
   *
   *
   * <pre>
   * The email of the function's service account. If empty, defaults to
   * `{project_id}&#64;appspot.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 11;</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The email of the function's service account. If empty, defaults to
   * `{project_id}&#64;appspot.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 11;</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int VERSION_ID_FIELD_NUMBER = 14;
  private long versionId_;
  /**
   *
   *
   * <pre>
   * Output only. The version identifier of the Cloud Function. Each deployment attempt
   * results in a new version of a function being created.
   * </pre>
   *
   * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public long getVersionId() {
    return versionId_;
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v1.FunctionsProto
                .internal_static_google_cloud_functions_v1_CloudFunction_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 17;

  private static final class EnvironmentVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v1.FunctionsProto
                .internal_static_google_cloud_functions_v1_CloudFunction_EnvironmentVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironmentVariables() {
    if (environmentVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvironmentVariablesDefaultEntryHolder.defaultEntry);
    }
    return environmentVariables_;
  }

  public int getEnvironmentVariablesCount() {
    return internalGetEnvironmentVariables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public boolean containsEnvironmentVariables(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetEnvironmentVariables().getMap().containsKey(key);
  }
  /** Use {@link #getEnvironmentVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
    return getEnvironmentVariablesMap();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
    return internalGetEnvironmentVariables().getMap();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentVariablesOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NETWORK_FIELD_NUMBER = 18;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * The VPC Network that this cloud function can connect to. It can be
   * either the fully-qualified URI, or the short name of the network resource.
   * If the short network name is used, the network must belong to the same
   * project. Otherwise, it must belong to a project within the same
   * organization. The format of this field is either
   * `projects/{project}/global/networks/{network}` or `{network}`, where
   * `{project}` is a project id where the network is defined, and `{network}`
   * is the short name of the network.
   * This field is mutually exclusive with `vpc_connector` and will be replaced
   * by it.
   * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
   * more information on connecting Cloud projects.
   * </pre>
   *
   * <code>string network = 18;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The VPC Network that this cloud function can connect to. It can be
   * either the fully-qualified URI, or the short name of the network resource.
   * If the short network name is used, the network must belong to the same
   * project. Otherwise, it must belong to a project within the same
   * organization. The format of this field is either
   * `projects/{project}/global/networks/{network}` or `{network}`, where
   * `{project}` is a project id where the network is defined, and `{network}`
   * is the short name of the network.
   * This field is mutually exclusive with `vpc_connector` and will be replaced
   * by it.
   * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
   * more information on connecting Cloud projects.
   * </pre>
   *
   * <code>string network = 18;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_INSTANCES_FIELD_NUMBER = 20;
  private int maxInstances_;
  /**
   *
   *
   * <pre>
   * The limit on the maximum number of function instances that may coexist at a
   * given time.
   * </pre>
   *
   * <code>int32 max_instances = 20;</code>
   *
   * @return The maxInstances.
   */
  @java.lang.Override
  public int getMaxInstances() {
    return maxInstances_;
  }

  public static final int VPC_CONNECTOR_FIELD_NUMBER = 22;
  private volatile java.lang.Object vpcConnector_;
  /**
   *
   *
   * <pre>
   * The VPC Network Connector that this cloud function can connect to. It can
   * be either the fully-qualified URI, or the short name of the network
   * connector resource. The format of this field is
   * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
   * This field is mutually exclusive with `network` field and will eventually
   * replace it.
   * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
   * more information on connecting Cloud projects.
   * </pre>
   *
   * <code>string vpc_connector = 22;</code>
   *
   * @return The vpcConnector.
   */
  @java.lang.Override
  public java.lang.String getVpcConnector() {
    java.lang.Object ref = vpcConnector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpcConnector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The VPC Network Connector that this cloud function can connect to. It can
   * be either the fully-qualified URI, or the short name of the network
   * connector resource. The format of this field is
   * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
   * This field is mutually exclusive with `network` field and will eventually
   * replace it.
   * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
   * more information on connecting Cloud projects.
   * </pre>
   *
   * <code>string vpc_connector = 22;</code>
   *
   * @return The bytes for vpcConnector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpcConnectorBytes() {
    java.lang.Object ref = vpcConnector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpcConnector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER = 23;
  private int vpcConnectorEgressSettings_;
  /**
   *
   *
   * <pre>
   * The egress settings for the connector, controlling what traffic is diverted
   * through it.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
   * </code>
   *
   * @return The enum numeric value on the wire for vpcConnectorEgressSettings.
   */
  @java.lang.Override
  public int getVpcConnectorEgressSettingsValue() {
    return vpcConnectorEgressSettings_;
  }
  /**
   *
   *
   * <pre>
   * The egress settings for the connector, controlling what traffic is diverted
   * through it.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
   * </code>
   *
   * @return The vpcConnectorEgressSettings.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
      getVpcConnectorEgressSettings() {
    @SuppressWarnings("deprecation")
    com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings result =
        com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.valueOf(
            vpcConnectorEgressSettings_);
    return result == null
        ? com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.UNRECOGNIZED
        : result;
  }

  public static final int INGRESS_SETTINGS_FIELD_NUMBER = 24;
  private int ingressSettings_;
  /**
   *
   *
   * <pre>
   * The ingress settings for the function, controlling what traffic can reach
   * it.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
   *
   * @return The enum numeric value on the wire for ingressSettings.
   */
  @java.lang.Override
  public int getIngressSettingsValue() {
    return ingressSettings_;
  }
  /**
   *
   *
   * <pre>
   * The ingress settings for the function, controlling what traffic can reach
   * it.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
   *
   * @return The ingressSettings.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.IngressSettings getIngressSettings() {
    @SuppressWarnings("deprecation")
    com.google.cloud.functions.v1.CloudFunction.IngressSettings result =
        com.google.cloud.functions.v1.CloudFunction.IngressSettings.valueOf(ingressSettings_);
    return result == null
        ? com.google.cloud.functions.v1.CloudFunction.IngressSettings.UNRECOGNIZED
        : result;
  }

  public static final int BUILD_ID_FIELD_NUMBER = 27;
  private volatile java.lang.Object buildId_;
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build ID of the latest successful deployment of the
   * function.
   * </pre>
   *
   * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The buildId.
   */
  @java.lang.Override
  public java.lang.String getBuildId() {
    java.lang.Object ref = buildId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build ID of the latest successful deployment of the
   * function.
   * </pre>
   *
   * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for buildId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildIdBytes() {
    java.lang.Object ref = buildId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (sourceCodeCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceCode_);
    }
    if (sourceCodeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.functions.v1.SourceRepository) sourceCode_);
    }
    if (triggerCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.functions.v1.HttpsTrigger) trigger_);
    }
    if (triggerCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.functions.v1.EventTrigger) trigger_);
    }
    if (status_
        != com.google.cloud.functions.v1.CloudFunctionStatus.CLOUD_FUNCTION_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, status_);
    }
    if (!getEntryPointBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, entryPoint_);
    }
    if (timeout_ != null) {
      output.writeMessage(9, getTimeout());
    }
    if (availableMemoryMb_ != 0) {
      output.writeInt32(10, availableMemoryMb_);
    }
    if (!getServiceAccountEmailBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serviceAccountEmail_);
    }
    if (updateTime_ != null) {
      output.writeMessage(12, getUpdateTime());
    }
    if (versionId_ != 0L) {
      output.writeInt64(14, versionId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (sourceCodeCase_ == 16) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, sourceCode_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetEnvironmentVariables(),
        EnvironmentVariablesDefaultEntryHolder.defaultEntry,
        17);
    if (!getNetworkBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, network_);
    }
    if (!getRuntimeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, runtime_);
    }
    if (maxInstances_ != 0) {
      output.writeInt32(20, maxInstances_);
    }
    if (!getVpcConnectorBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, vpcConnector_);
    }
    if (vpcConnectorEgressSettings_
        != com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
            .VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(23, vpcConnectorEgressSettings_);
    }
    if (ingressSettings_
        != com.google.cloud.functions.v1.CloudFunction.IngressSettings.INGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(24, ingressSettings_);
    }
    if (!getBuildIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, buildId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (sourceCodeCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceCode_);
    }
    if (sourceCodeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.functions.v1.SourceRepository) sourceCode_);
    }
    if (triggerCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.functions.v1.HttpsTrigger) trigger_);
    }
    if (triggerCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.functions.v1.EventTrigger) trigger_);
    }
    if (status_
        != com.google.cloud.functions.v1.CloudFunctionStatus.CLOUD_FUNCTION_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, status_);
    }
    if (!getEntryPointBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, entryPoint_);
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTimeout());
    }
    if (availableMemoryMb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, availableMemoryMb_);
    }
    if (!getServiceAccountEmailBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, serviceAccountEmail_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    if (versionId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(14, versionId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (sourceCodeCase_ == 16) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, sourceCode_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironmentVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environmentVariables__ =
          EnvironmentVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, environmentVariables__);
    }
    if (!getNetworkBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, network_);
    }
    if (!getRuntimeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, runtime_);
    }
    if (maxInstances_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(20, maxInstances_);
    }
    if (!getVpcConnectorBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, vpcConnector_);
    }
    if (vpcConnectorEgressSettings_
        != com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
            .VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(23, vpcConnectorEgressSettings_);
    }
    if (ingressSettings_
        != com.google.cloud.functions.v1.CloudFunction.IngressSettings.INGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(24, ingressSettings_);
    }
    if (!getBuildIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, buildId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v1.CloudFunction)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v1.CloudFunction other =
        (com.google.cloud.functions.v1.CloudFunction) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (status_ != other.status_) return false;
    if (!getEntryPoint().equals(other.getEntryPoint())) return false;
    if (!getRuntime().equals(other.getRuntime())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (getAvailableMemoryMb() != other.getAvailableMemoryMb()) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getVersionId() != other.getVersionId()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables()))
      return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (getMaxInstances() != other.getMaxInstances()) return false;
    if (!getVpcConnector().equals(other.getVpcConnector())) return false;
    if (vpcConnectorEgressSettings_ != other.vpcConnectorEgressSettings_) return false;
    if (ingressSettings_ != other.ingressSettings_) return false;
    if (!getBuildId().equals(other.getBuildId())) return false;
    if (!getSourceCodeCase().equals(other.getSourceCodeCase())) return false;
    switch (sourceCodeCase_) {
      case 3:
        if (!getSourceArchiveUrl().equals(other.getSourceArchiveUrl())) return false;
        break;
      case 4:
        if (!getSourceRepository().equals(other.getSourceRepository())) return false;
        break;
      case 16:
        if (!getSourceUploadUrl().equals(other.getSourceUploadUrl())) return false;
        break;
      case 0:
      default:
    }
    if (!getTriggerCase().equals(other.getTriggerCase())) return false;
    switch (triggerCase_) {
      case 5:
        if (!getHttpsTrigger().equals(other.getHttpsTrigger())) return false;
        break;
      case 6:
        if (!getEventTrigger().equals(other.getEventTrigger())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + ENTRY_POINT_FIELD_NUMBER;
    hash = (53 * hash) + getEntryPoint().hashCode();
    hash = (37 * hash) + RUNTIME_FIELD_NUMBER;
    hash = (53 * hash) + getRuntime().hashCode();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + AVAILABLE_MEMORY_MB_FIELD_NUMBER;
    hash = (53 * hash) + getAvailableMemoryMb();
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getVersionId());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetEnvironmentVariables().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironmentVariables().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + MAX_INSTANCES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxInstances();
    hash = (37 * hash) + VPC_CONNECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getVpcConnector().hashCode();
    hash = (37 * hash) + VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + vpcConnectorEgressSettings_;
    hash = (37 * hash) + INGRESS_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + ingressSettings_;
    hash = (37 * hash) + BUILD_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBuildId().hashCode();
    switch (sourceCodeCase_) {
      case 3:
        hash = (37 * hash) + SOURCE_ARCHIVE_URL_FIELD_NUMBER;
        hash = (53 * hash) + getSourceArchiveUrl().hashCode();
        break;
      case 4:
        hash = (37 * hash) + SOURCE_REPOSITORY_FIELD_NUMBER;
        hash = (53 * hash) + getSourceRepository().hashCode();
        break;
      case 16:
        hash = (37 * hash) + SOURCE_UPLOAD_URL_FIELD_NUMBER;
        hash = (53 * hash) + getSourceUploadUrl().hashCode();
        break;
      case 0:
      default:
    }
    switch (triggerCase_) {
      case 5:
        hash = (37 * hash) + HTTPS_TRIGGER_FIELD_NUMBER;
        hash = (53 * hash) + getHttpsTrigger().hashCode();
        break;
      case 6:
        hash = (37 * hash) + EVENT_TRIGGER_FIELD_NUMBER;
        hash = (53 * hash) + getEventTrigger().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v1.CloudFunction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a Cloud Function that contains user computation executed in
   * response to an event. It encapsulate function and triggers configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.CloudFunction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.CloudFunction)
      com.google.cloud.functions.v1.CloudFunctionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 15:
          return internalGetLabels();
        case 17:
          return internalGetEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 15:
          return internalGetMutableLabels();
        case 17:
          return internalGetMutableEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.CloudFunction.class,
              com.google.cloud.functions.v1.CloudFunction.Builder.class);
    }

    // Construct using com.google.cloud.functions.v1.CloudFunction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      status_ = 0;

      entryPoint_ = "";

      runtime_ = "";

      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      availableMemoryMb_ = 0;

      serviceAccountEmail_ = "";

      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      versionId_ = 0L;

      internalGetMutableLabels().clear();
      internalGetMutableEnvironmentVariables().clear();
      network_ = "";

      maxInstances_ = 0;

      vpcConnector_ = "";

      vpcConnectorEgressSettings_ = 0;

      ingressSettings_ = 0;

      buildId_ = "";

      sourceCodeCase_ = 0;
      sourceCode_ = null;
      triggerCase_ = 0;
      trigger_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction getDefaultInstanceForType() {
      return com.google.cloud.functions.v1.CloudFunction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction build() {
      com.google.cloud.functions.v1.CloudFunction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction buildPartial() {
      com.google.cloud.functions.v1.CloudFunction result =
          new com.google.cloud.functions.v1.CloudFunction(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      if (sourceCodeCase_ == 3) {
        result.sourceCode_ = sourceCode_;
      }
      if (sourceCodeCase_ == 4) {
        if (sourceRepositoryBuilder_ == null) {
          result.sourceCode_ = sourceCode_;
        } else {
          result.sourceCode_ = sourceRepositoryBuilder_.build();
        }
      }
      if (sourceCodeCase_ == 16) {
        result.sourceCode_ = sourceCode_;
      }
      if (triggerCase_ == 5) {
        if (httpsTriggerBuilder_ == null) {
          result.trigger_ = trigger_;
        } else {
          result.trigger_ = httpsTriggerBuilder_.build();
        }
      }
      if (triggerCase_ == 6) {
        if (eventTriggerBuilder_ == null) {
          result.trigger_ = trigger_;
        } else {
          result.trigger_ = eventTriggerBuilder_.build();
        }
      }
      result.status_ = status_;
      result.entryPoint_ = entryPoint_;
      result.runtime_ = runtime_;
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      result.availableMemoryMb_ = availableMemoryMb_;
      result.serviceAccountEmail_ = serviceAccountEmail_;
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.versionId_ = versionId_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.environmentVariables_ = internalGetEnvironmentVariables();
      result.environmentVariables_.makeImmutable();
      result.network_ = network_;
      result.maxInstances_ = maxInstances_;
      result.vpcConnector_ = vpcConnector_;
      result.vpcConnectorEgressSettings_ = vpcConnectorEgressSettings_;
      result.ingressSettings_ = ingressSettings_;
      result.buildId_ = buildId_;
      result.sourceCodeCase_ = sourceCodeCase_;
      result.triggerCase_ = triggerCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v1.CloudFunction) {
        return mergeFrom((com.google.cloud.functions.v1.CloudFunction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v1.CloudFunction other) {
      if (other == com.google.cloud.functions.v1.CloudFunction.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getEntryPoint().isEmpty()) {
        entryPoint_ = other.entryPoint_;
        onChanged();
      }
      if (!other.getRuntime().isEmpty()) {
        runtime_ = other.runtime_;
        onChanged();
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getAvailableMemoryMb() != 0) {
        setAvailableMemoryMb(other.getAvailableMemoryMb());
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getVersionId() != 0L) {
        setVersionId(other.getVersionId());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (other.getMaxInstances() != 0) {
        setMaxInstances(other.getMaxInstances());
      }
      if (!other.getVpcConnector().isEmpty()) {
        vpcConnector_ = other.vpcConnector_;
        onChanged();
      }
      if (other.vpcConnectorEgressSettings_ != 0) {
        setVpcConnectorEgressSettingsValue(other.getVpcConnectorEgressSettingsValue());
      }
      if (other.ingressSettings_ != 0) {
        setIngressSettingsValue(other.getIngressSettingsValue());
      }
      if (!other.getBuildId().isEmpty()) {
        buildId_ = other.buildId_;
        onChanged();
      }
      switch (other.getSourceCodeCase()) {
        case SOURCE_ARCHIVE_URL:
          {
            sourceCodeCase_ = 3;
            sourceCode_ = other.sourceCode_;
            onChanged();
            break;
          }
        case SOURCE_REPOSITORY:
          {
            mergeSourceRepository(other.getSourceRepository());
            break;
          }
        case SOURCE_UPLOAD_URL:
          {
            sourceCodeCase_ = 16;
            sourceCode_ = other.sourceCode_;
            onChanged();
            break;
          }
        case SOURCECODE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTriggerCase()) {
        case HTTPS_TRIGGER:
          {
            mergeHttpsTrigger(other.getHttpsTrigger());
            break;
          }
        case EVENT_TRIGGER:
          {
            mergeEventTrigger(other.getEventTrigger());
            break;
          }
        case TRIGGER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.functions.v1.CloudFunction parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.functions.v1.CloudFunction) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int sourceCodeCase_ = 0;
    private java.lang.Object sourceCode_;

    public SourceCodeCase getSourceCodeCase() {
      return SourceCodeCase.forNumber(sourceCodeCase_);
    }

    public Builder clearSourceCode() {
      sourceCodeCase_ = 0;
      sourceCode_ = null;
      onChanged();
      return this;
    }

    private int triggerCase_ = 0;
    private java.lang.Object trigger_;

    public TriggerCase getTriggerCase() {
      return TriggerCase.forNumber(triggerCase_);
    }

    public Builder clearTrigger() {
      triggerCase_ = 0;
      trigger_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return Whether the sourceArchiveUrl field is set.
     */
    @java.lang.Override
    public boolean hasSourceArchiveUrl() {
      return sourceCodeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return The sourceArchiveUrl.
     */
    @java.lang.Override
    public java.lang.String getSourceArchiveUrl() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 3) {
        ref = sourceCode_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCodeCase_ == 3) {
          sourceCode_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return The bytes for sourceArchiveUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceArchiveUrlBytes() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 3) {
        ref = sourceCode_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCodeCase_ == 3) {
          sourceCode_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @param value The sourceArchiveUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceArchiveUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCodeCase_ = 3;
      sourceCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceArchiveUrl() {
      if (sourceCodeCase_ == 3) {
        sourceCodeCase_ = 0;
        sourceCode_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @param value The bytes for sourceArchiveUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceArchiveUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCodeCase_ = 3;
      sourceCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.SourceRepository,
            com.google.cloud.functions.v1.SourceRepository.Builder,
            com.google.cloud.functions.v1.SourceRepositoryOrBuilder>
        sourceRepositoryBuilder_;
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     *
     * @return Whether the sourceRepository field is set.
     */
    @java.lang.Override
    public boolean hasSourceRepository() {
      return sourceCodeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     *
     * @return The sourceRepository.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.SourceRepository getSourceRepository() {
      if (sourceRepositoryBuilder_ == null) {
        if (sourceCodeCase_ == 4) {
          return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
        }
        return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
      } else {
        if (sourceCodeCase_ == 4) {
          return sourceRepositoryBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder setSourceRepository(com.google.cloud.functions.v1.SourceRepository value) {
      if (sourceRepositoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceCode_ = value;
        onChanged();
      } else {
        sourceRepositoryBuilder_.setMessage(value);
      }
      sourceCodeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder setSourceRepository(
        com.google.cloud.functions.v1.SourceRepository.Builder builderForValue) {
      if (sourceRepositoryBuilder_ == null) {
        sourceCode_ = builderForValue.build();
        onChanged();
      } else {
        sourceRepositoryBuilder_.setMessage(builderForValue.build());
      }
      sourceCodeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder mergeSourceRepository(com.google.cloud.functions.v1.SourceRepository value) {
      if (sourceRepositoryBuilder_ == null) {
        if (sourceCodeCase_ == 4
            && sourceCode_ != com.google.cloud.functions.v1.SourceRepository.getDefaultInstance()) {
          sourceCode_ =
              com.google.cloud.functions.v1.SourceRepository.newBuilder(
                      (com.google.cloud.functions.v1.SourceRepository) sourceCode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceCode_ = value;
        }
        onChanged();
      } else {
        if (sourceCodeCase_ == 4) {
          sourceRepositoryBuilder_.mergeFrom(value);
        }
        sourceRepositoryBuilder_.setMessage(value);
      }
      sourceCodeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder clearSourceRepository() {
      if (sourceRepositoryBuilder_ == null) {
        if (sourceCodeCase_ == 4) {
          sourceCodeCase_ = 0;
          sourceCode_ = null;
          onChanged();
        }
      } else {
        if (sourceCodeCase_ == 4) {
          sourceCodeCase_ = 0;
          sourceCode_ = null;
        }
        sourceRepositoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public com.google.cloud.functions.v1.SourceRepository.Builder getSourceRepositoryBuilder() {
      return getSourceRepositoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.SourceRepositoryOrBuilder getSourceRepositoryOrBuilder() {
      if ((sourceCodeCase_ == 4) && (sourceRepositoryBuilder_ != null)) {
        return sourceRepositoryBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCodeCase_ == 4) {
          return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
        }
        return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.SourceRepository,
            com.google.cloud.functions.v1.SourceRepository.Builder,
            com.google.cloud.functions.v1.SourceRepositoryOrBuilder>
        getSourceRepositoryFieldBuilder() {
      if (sourceRepositoryBuilder_ == null) {
        if (!(sourceCodeCase_ == 4)) {
          sourceCode_ = com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
        }
        sourceRepositoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.SourceRepository,
                com.google.cloud.functions.v1.SourceRepository.Builder,
                com.google.cloud.functions.v1.SourceRepositoryOrBuilder>(
                (com.google.cloud.functions.v1.SourceRepository) sourceCode_,
                getParentForChildren(),
                isClean());
        sourceCode_ = null;
      }
      sourceCodeCase_ = 4;
      onChanged();
      ;
      return sourceRepositoryBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return Whether the sourceUploadUrl field is set.
     */
    @java.lang.Override
    public boolean hasSourceUploadUrl() {
      return sourceCodeCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return The sourceUploadUrl.
     */
    @java.lang.Override
    public java.lang.String getSourceUploadUrl() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 16) {
        ref = sourceCode_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCodeCase_ == 16) {
          sourceCode_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return The bytes for sourceUploadUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceUploadUrlBytes() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 16) {
        ref = sourceCode_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCodeCase_ == 16) {
          sourceCode_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @param value The sourceUploadUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceUploadUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCodeCase_ = 16;
      sourceCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceUploadUrl() {
      if (sourceCodeCase_ == 16) {
        sourceCodeCase_ = 0;
        sourceCode_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @param value The bytes for sourceUploadUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceUploadUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCodeCase_ = 16;
      sourceCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.HttpsTrigger,
            com.google.cloud.functions.v1.HttpsTrigger.Builder,
            com.google.cloud.functions.v1.HttpsTriggerOrBuilder>
        httpsTriggerBuilder_;
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     *
     * @return Whether the httpsTrigger field is set.
     */
    @java.lang.Override
    public boolean hasHttpsTrigger() {
      return triggerCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     *
     * @return The httpsTrigger.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.HttpsTrigger getHttpsTrigger() {
      if (httpsTriggerBuilder_ == null) {
        if (triggerCase_ == 5) {
          return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
      } else {
        if (triggerCase_ == 5) {
          return httpsTriggerBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder setHttpsTrigger(com.google.cloud.functions.v1.HttpsTrigger value) {
      if (httpsTriggerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trigger_ = value;
        onChanged();
      } else {
        httpsTriggerBuilder_.setMessage(value);
      }
      triggerCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder setHttpsTrigger(
        com.google.cloud.functions.v1.HttpsTrigger.Builder builderForValue) {
      if (httpsTriggerBuilder_ == null) {
        trigger_ = builderForValue.build();
        onChanged();
      } else {
        httpsTriggerBuilder_.setMessage(builderForValue.build());
      }
      triggerCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder mergeHttpsTrigger(com.google.cloud.functions.v1.HttpsTrigger value) {
      if (httpsTriggerBuilder_ == null) {
        if (triggerCase_ == 5
            && trigger_ != com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance()) {
          trigger_ =
              com.google.cloud.functions.v1.HttpsTrigger.newBuilder(
                      (com.google.cloud.functions.v1.HttpsTrigger) trigger_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trigger_ = value;
        }
        onChanged();
      } else {
        if (triggerCase_ == 5) {
          httpsTriggerBuilder_.mergeFrom(value);
        }
        httpsTriggerBuilder_.setMessage(value);
      }
      triggerCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder clearHttpsTrigger() {
      if (httpsTriggerBuilder_ == null) {
        if (triggerCase_ == 5) {
          triggerCase_ = 0;
          trigger_ = null;
          onChanged();
        }
      } else {
        if (triggerCase_ == 5) {
          triggerCase_ = 0;
          trigger_ = null;
        }
        httpsTriggerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public com.google.cloud.functions.v1.HttpsTrigger.Builder getHttpsTriggerBuilder() {
      return getHttpsTriggerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.HttpsTriggerOrBuilder getHttpsTriggerOrBuilder() {
      if ((triggerCase_ == 5) && (httpsTriggerBuilder_ != null)) {
        return httpsTriggerBuilder_.getMessageOrBuilder();
      } else {
        if (triggerCase_ == 5) {
          return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.HttpsTrigger,
            com.google.cloud.functions.v1.HttpsTrigger.Builder,
            com.google.cloud.functions.v1.HttpsTriggerOrBuilder>
        getHttpsTriggerFieldBuilder() {
      if (httpsTriggerBuilder_ == null) {
        if (!(triggerCase_ == 5)) {
          trigger_ = com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
        }
        httpsTriggerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.HttpsTrigger,
                com.google.cloud.functions.v1.HttpsTrigger.Builder,
                com.google.cloud.functions.v1.HttpsTriggerOrBuilder>(
                (com.google.cloud.functions.v1.HttpsTrigger) trigger_,
                getParentForChildren(),
                isClean());
        trigger_ = null;
      }
      triggerCase_ = 5;
      onChanged();
      ;
      return httpsTriggerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.EventTrigger,
            com.google.cloud.functions.v1.EventTrigger.Builder,
            com.google.cloud.functions.v1.EventTriggerOrBuilder>
        eventTriggerBuilder_;
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     *
     * @return Whether the eventTrigger field is set.
     */
    @java.lang.Override
    public boolean hasEventTrigger() {
      return triggerCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     *
     * @return The eventTrigger.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.EventTrigger getEventTrigger() {
      if (eventTriggerBuilder_ == null) {
        if (triggerCase_ == 6) {
          return (com.google.cloud.functions.v1.EventTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
      } else {
        if (triggerCase_ == 6) {
          return eventTriggerBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder setEventTrigger(com.google.cloud.functions.v1.EventTrigger value) {
      if (eventTriggerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trigger_ = value;
        onChanged();
      } else {
        eventTriggerBuilder_.setMessage(value);
      }
      triggerCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder setEventTrigger(
        com.google.cloud.functions.v1.EventTrigger.Builder builderForValue) {
      if (eventTriggerBuilder_ == null) {
        trigger_ = builderForValue.build();
        onChanged();
      } else {
        eventTriggerBuilder_.setMessage(builderForValue.build());
      }
      triggerCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder mergeEventTrigger(com.google.cloud.functions.v1.EventTrigger value) {
      if (eventTriggerBuilder_ == null) {
        if (triggerCase_ == 6
            && trigger_ != com.google.cloud.functions.v1.EventTrigger.getDefaultInstance()) {
          trigger_ =
              com.google.cloud.functions.v1.EventTrigger.newBuilder(
                      (com.google.cloud.functions.v1.EventTrigger) trigger_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trigger_ = value;
        }
        onChanged();
      } else {
        if (triggerCase_ == 6) {
          eventTriggerBuilder_.mergeFrom(value);
        }
        eventTriggerBuilder_.setMessage(value);
      }
      triggerCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder clearEventTrigger() {
      if (eventTriggerBuilder_ == null) {
        if (triggerCase_ == 6) {
          triggerCase_ = 0;
          trigger_ = null;
          onChanged();
        }
      } else {
        if (triggerCase_ == 6) {
          triggerCase_ = 0;
          trigger_ = null;
        }
        eventTriggerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public com.google.cloud.functions.v1.EventTrigger.Builder getEventTriggerBuilder() {
      return getEventTriggerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.EventTriggerOrBuilder getEventTriggerOrBuilder() {
      if ((triggerCase_ == 6) && (eventTriggerBuilder_ != null)) {
        return eventTriggerBuilder_.getMessageOrBuilder();
      } else {
        if (triggerCase_ == 6) {
          return (com.google.cloud.functions.v1.EventTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.EventTrigger,
            com.google.cloud.functions.v1.EventTrigger.Builder,
            com.google.cloud.functions.v1.EventTriggerOrBuilder>
        getEventTriggerFieldBuilder() {
      if (eventTriggerBuilder_ == null) {
        if (!(triggerCase_ == 6)) {
          trigger_ = com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
        }
        eventTriggerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.EventTrigger,
                com.google.cloud.functions.v1.EventTrigger.Builder,
                com.google.cloud.functions.v1.EventTriggerOrBuilder>(
                (com.google.cloud.functions.v1.EventTrigger) trigger_,
                getParentForChildren(),
                isClean());
        trigger_ = null;
      }
      triggerCase_ = 6;
      onChanged();
      ;
      return eventTriggerBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {

      status_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunctionStatus getStatus() {
      @SuppressWarnings("deprecation")
      com.google.cloud.functions.v1.CloudFunctionStatus result =
          com.google.cloud.functions.v1.CloudFunctionStatus.valueOf(status_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunctionStatus.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloud.functions.v1.CloudFunctionStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }

      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {

      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object entryPoint_ = "";
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @return The entryPoint.
     */
    public java.lang.String getEntryPoint() {
      java.lang.Object ref = entryPoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entryPoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @return The bytes for entryPoint.
     */
    public com.google.protobuf.ByteString getEntryPointBytes() {
      java.lang.Object ref = entryPoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entryPoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @param value The entryPoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entryPoint_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntryPoint() {

      entryPoint_ = getDefaultInstance().getEntryPoint();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @param value The bytes for entryPoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entryPoint_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object runtime_ = "";
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @return The runtime.
     */
    public java.lang.String getRuntime() {
      java.lang.Object ref = runtime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        runtime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @return The bytes for runtime.
     */
    public com.google.protobuf.ByteString getRuntimeBytes() {
      java.lang.Object ref = runtime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        runtime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @param value The runtime to set.
     * @return This builder for chaining.
     */
    public Builder setRuntime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      runtime_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuntime() {

      runtime_ = getDefaultInstance().getRuntime();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @param value The bytes for runtime to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      runtime_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private int availableMemoryMb_;
    /**
     *
     *
     * <pre>
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     * </pre>
     *
     * <code>int32 available_memory_mb = 10;</code>
     *
     * @return The availableMemoryMb.
     */
    @java.lang.Override
    public int getAvailableMemoryMb() {
      return availableMemoryMb_;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     * </pre>
     *
     * <code>int32 available_memory_mb = 10;</code>
     *
     * @param value The availableMemoryMb to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableMemoryMb(int value) {

      availableMemoryMb_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     * </pre>
     *
     * <code>int32 available_memory_mb = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableMemoryMb() {

      availableMemoryMb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccountEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {

      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccountEmail_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private long versionId_;
    /**
     *
     *
     * <pre>
     * Output only. The version identifier of the Cloud Function. Each deployment attempt
     * results in a new version of a function being created.
     * </pre>
     *
     * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The versionId.
     */
    @java.lang.Override
    public long getVersionId() {
      return versionId_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version identifier of the Cloud Function. Each deployment attempt
     * results in a new version of a function being created.
     * </pre>
     *
     * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(long value) {

      versionId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version identifier of the Cloud Function. Each deployment attempt
     * results in a new version of a function being created.
     * </pre>
     *
     * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {

      versionId_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironmentVariables() {
      if (environmentVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      return environmentVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironmentVariables() {
      onChanged();
      ;
      if (environmentVariables_ == null) {
        environmentVariables_ =
            com.google.protobuf.MapField.newMapField(
                EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!environmentVariables_.isMutable()) {
        environmentVariables_ = environmentVariables_.copy();
      }
      return environmentVariables_;
    }

    public int getEnvironmentVariablesCount() {
      return internalGetEnvironmentVariables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public boolean containsEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetEnvironmentVariables().getMap().containsKey(key);
    }
    /** Use {@link #getEnvironmentVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
      return getEnvironmentVariablesMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
      return internalGetEnvironmentVariables().getMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentVariablesOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironmentVariables() {
      internalGetMutableEnvironmentVariables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    public Builder removeEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironmentVariables() {
      return internalGetMutableEnvironmentVariables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    public Builder putEnvironmentVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    public Builder putAllEnvironmentVariables(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string network = 18;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string network = 18;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string network = 18;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string network = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string network = 18;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private int maxInstances_;
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     * </pre>
     *
     * <code>int32 max_instances = 20;</code>
     *
     * @return The maxInstances.
     */
    @java.lang.Override
    public int getMaxInstances() {
      return maxInstances_;
    }
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     * </pre>
     *
     * <code>int32 max_instances = 20;</code>
     *
     * @param value The maxInstances to set.
     * @return This builder for chaining.
     */
    public Builder setMaxInstances(int value) {

      maxInstances_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     * </pre>
     *
     * <code>int32 max_instances = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxInstances() {

      maxInstances_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object vpcConnector_ = "";
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @return The vpcConnector.
     */
    public java.lang.String getVpcConnector() {
      java.lang.Object ref = vpcConnector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpcConnector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @return The bytes for vpcConnector.
     */
    public com.google.protobuf.ByteString getVpcConnectorBytes() {
      java.lang.Object ref = vpcConnector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpcConnector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @param value The vpcConnector to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      vpcConnector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcConnector() {

      vpcConnector_ = getDefaultInstance().getVpcConnector();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @param value The bytes for vpcConnector to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      vpcConnector_ = value;
      onChanged();
      return this;
    }

    private int vpcConnectorEgressSettings_ = 0;
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @return The enum numeric value on the wire for vpcConnectorEgressSettings.
     */
    @java.lang.Override
    public int getVpcConnectorEgressSettingsValue() {
      return vpcConnectorEgressSettings_;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @param value The enum numeric value on the wire for vpcConnectorEgressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorEgressSettingsValue(int value) {

      vpcConnectorEgressSettings_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @return The vpcConnectorEgressSettings.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
        getVpcConnectorEgressSettings() {
      @SuppressWarnings("deprecation")
      com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings result =
          com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.valueOf(
              vpcConnectorEgressSettings_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @param value The vpcConnectorEgressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorEgressSettings(
        com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }

      vpcConnectorEgressSettings_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcConnectorEgressSettings() {

      vpcConnectorEgressSettings_ = 0;
      onChanged();
      return this;
    }

    private int ingressSettings_ = 0;
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @return The enum numeric value on the wire for ingressSettings.
     */
    @java.lang.Override
    public int getIngressSettingsValue() {
      return ingressSettings_;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @param value The enum numeric value on the wire for ingressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIngressSettingsValue(int value) {

      ingressSettings_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @return The ingressSettings.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.IngressSettings getIngressSettings() {
      @SuppressWarnings("deprecation")
      com.google.cloud.functions.v1.CloudFunction.IngressSettings result =
          com.google.cloud.functions.v1.CloudFunction.IngressSettings.valueOf(ingressSettings_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunction.IngressSettings.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @param value The ingressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIngressSettings(
        com.google.cloud.functions.v1.CloudFunction.IngressSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }

      ingressSettings_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIngressSettings() {

      ingressSettings_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object buildId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The buildId.
     */
    public java.lang.String getBuildId() {
      java.lang.Object ref = buildId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for buildId.
     */
    public com.google.protobuf.ByteString getBuildIdBytes() {
      java.lang.Object ref = buildId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The buildId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      buildId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildId() {

      buildId_ = getDefaultInstance().getBuildId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for buildId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      buildId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.CloudFunction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.CloudFunction)
  private static final com.google.cloud.functions.v1.CloudFunction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v1.CloudFunction();
  }

  public static com.google.cloud.functions.v1.CloudFunction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudFunction> PARSER =
      new com.google.protobuf.AbstractParser<CloudFunction>() {
        @java.lang.Override
        public CloudFunction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CloudFunction(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CloudFunction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudFunction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
