/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CloudFunctionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/functions/{function}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String function;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFunction() {
        return this.function;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CloudFunctionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.function = (String)Preconditions.checkNotNull((Object)builder.getFunction());
    }

    public static CloudFunctionName of(String project, String location, String function) {
        return CloudFunctionName.newBuilder().setProject(project).setLocation(location).setFunction(function).build();
    }

    public static String format(String project, String location, String function) {
        return CloudFunctionName.newBuilder().setProject(project).setLocation(location).setFunction(function).build().toString();
    }

    public static CloudFunctionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CloudFunctionName.parse: formattedString not in valid format");
        return CloudFunctionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("function"));
    }

    public static List<CloudFunctionName> parseList(List<String> formattedStrings) {
        ArrayList<CloudFunctionName> list = new ArrayList<CloudFunctionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudFunctionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudFunctionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudFunctionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudFunctionName cloudFunctionName = this;
            synchronized (cloudFunctionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"function", (Object)this.function);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "function", this.function});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CloudFunctionName) {
            CloudFunctionName that = (CloudFunctionName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.function.equals(that.function);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.function.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String function;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFunction() {
            return this.function;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFunction(String function) {
            this.function = function;
            return this;
        }

        private Builder() {
        }

        private Builder(CloudFunctionName cloudFunctionName) {
            this.project = cloudFunctionName.project;
            this.location = cloudFunctionName.location;
            this.function = cloudFunctionName.function;
        }

        public CloudFunctionName build() {
            return new CloudFunctionName(this);
        }
    }
}

