/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataStore;

    @Deprecated
    protected DataStoreName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
    }

    private DataStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataStoreName of(String project, String location, String dataStore) {
        return DataStoreName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build();
    }

    public static String format(String project, String location, String dataStore) {
        return DataStoreName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).build().toString();
    }

    public static DataStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_STORE.validatedMatch(formattedString, "DataStoreName.parse: formattedString not in valid format");
        return DataStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"));
    }

    public static List<DataStoreName> parseList(List<String> formattedStrings) {
        ArrayList<DataStoreName> list = new ArrayList<DataStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataStoreName dataStoreName = this;
            synchronized (dataStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_STORE.instantiate(new String[]{"project", this.project, "location", this.location, "data_store", this.dataStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DataStoreName that = (DataStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataStore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        private Builder(DataStoreName dataStoreName) {
            this.project = dataStoreName.project;
            this.location = dataStoreName.location;
            this.dataStore = dataStoreName.dataStore;
        }

        public DataStoreName build() {
            return new DataStoreName(this);
        }
    }
}

