/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnswerName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_SESSION_ANSWER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}/answers/{answer}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION_ANSWER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/sessions/{session}/answers/{answer}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE_SESSION_ANSWER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/sessions/{session}/answers/{answer}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String session;
    private final String answer;
    private final String collection;
    private final String engine;

    @Deprecated
    protected AnswerName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.session = null;
        this.answer = null;
        this.collection = null;
        this.engine = null;
    }

    private AnswerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.answer = (String)Preconditions.checkNotNull((Object)builder.getAnswer());
        this.collection = null;
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_SESSION_ANSWER;
    }

    private AnswerName(ProjectLocationCollectionDataStoreSessionAnswerBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.answer = (String)Preconditions.checkNotNull((Object)builder.getAnswer());
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION_ANSWER;
    }

    private AnswerName(ProjectLocationCollectionEngineSessionAnswerBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.answer = (String)Preconditions.checkNotNull((Object)builder.getAnswer());
        this.dataStore = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_ENGINE_SESSION_ANSWER;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getSession() {
        return this.session;
    }

    public String getAnswer() {
        return this.answer;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreSessionAnswerBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreSessionAnswerBuilder newProjectLocationCollectionDataStoreSessionAnswerBuilder() {
        return new ProjectLocationCollectionDataStoreSessionAnswerBuilder();
    }

    public static ProjectLocationCollectionEngineSessionAnswerBuilder newProjectLocationCollectionEngineSessionAnswerBuilder() {
        return new ProjectLocationCollectionEngineSessionAnswerBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnswerName of(String project, String location, String dataStore, String session, String answer) {
        return AnswerName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).setAnswer(answer).build();
    }

    public static AnswerName ofProjectLocationDataStoreSessionAnswerName(String project, String location, String dataStore, String session, String answer) {
        return AnswerName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).setAnswer(answer).build();
    }

    public static AnswerName ofProjectLocationCollectionDataStoreSessionAnswerName(String project, String location, String collection, String dataStore, String session, String answer) {
        return AnswerName.newProjectLocationCollectionDataStoreSessionAnswerBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSession(session).setAnswer(answer).build();
    }

    public static AnswerName ofProjectLocationCollectionEngineSessionAnswerName(String project, String location, String collection, String engine, String session, String answer) {
        return AnswerName.newProjectLocationCollectionEngineSessionAnswerBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setSession(session).setAnswer(answer).build();
    }

    public static String format(String project, String location, String dataStore, String session, String answer) {
        return AnswerName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).setAnswer(answer).build().toString();
    }

    public static String formatProjectLocationDataStoreSessionAnswerName(String project, String location, String dataStore, String session, String answer) {
        return AnswerName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).setAnswer(answer).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreSessionAnswerName(String project, String location, String collection, String dataStore, String session, String answer) {
        return AnswerName.newProjectLocationCollectionDataStoreSessionAnswerBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSession(session).setAnswer(answer).build().toString();
    }

    public static String formatProjectLocationCollectionEngineSessionAnswerName(String project, String location, String collection, String engine, String session, String answer) {
        return AnswerName.newProjectLocationCollectionEngineSessionAnswerBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setSession(session).setAnswer(answer).build().toString();
    }

    public static AnswerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_SESSION_ANSWER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_SESSION_ANSWER.match(formattedString);
            return AnswerName.ofProjectLocationDataStoreSessionAnswerName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("session"), (String)matchMap.get("answer"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION_ANSWER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION_ANSWER.match(formattedString);
            return AnswerName.ofProjectLocationCollectionDataStoreSessionAnswerName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("session"), (String)matchMap.get("answer"));
        }
        if (PROJECT_LOCATION_COLLECTION_ENGINE_SESSION_ANSWER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE_SESSION_ANSWER.match(formattedString);
            return AnswerName.ofProjectLocationCollectionEngineSessionAnswerName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"), (String)matchMap.get("session"), (String)matchMap.get("answer"));
        }
        throw new ValidationException("AnswerName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AnswerName> parseList(List<String> formattedStrings) {
        ArrayList<AnswerName> list = new ArrayList<AnswerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnswerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnswerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnswerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_SESSION_ANSWER.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION_ANSWER.matches(formattedString) || PROJECT_LOCATION_COLLECTION_ENGINE_SESSION_ANSWER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnswerName answerName = this;
            synchronized (answerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.answer != null) {
                        fieldMapBuilder.put((Object)"answer", (Object)this.answer);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnswerName that = (AnswerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.session, that.session) && Objects.equals(this.answer, that.answer) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.answer);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engine);
    }

    public static class ProjectLocationCollectionEngineSessionAnswerBuilder {
        private String project;
        private String location;
        private String collection;
        private String engine;
        private String session;
        private String answer;

        protected ProjectLocationCollectionEngineSessionAnswerBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getSession() {
            return this.session;
        }

        public String getAnswer() {
            return this.answer;
        }

        public ProjectLocationCollectionEngineSessionAnswerBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionEngineSessionAnswerBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionEngineSessionAnswerBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionEngineSessionAnswerBuilder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public ProjectLocationCollectionEngineSessionAnswerBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationCollectionEngineSessionAnswerBuilder setAnswer(String answer) {
            this.answer = answer;
            return this;
        }

        public AnswerName build() {
            return new AnswerName(this);
        }
    }

    public static class ProjectLocationCollectionDataStoreSessionAnswerBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String session;
        private String answer;

        protected ProjectLocationCollectionDataStoreSessionAnswerBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSession() {
            return this.session;
        }

        public String getAnswer() {
            return this.answer;
        }

        public ProjectLocationCollectionDataStoreSessionAnswerBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionAnswerBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionAnswerBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionAnswerBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionAnswerBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionAnswerBuilder setAnswer(String answer) {
            this.answer = answer;
            return this;
        }

        public AnswerName build() {
            return new AnswerName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String session;
        private String answer;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSession() {
            return this.session;
        }

        public String getAnswer() {
            return this.answer;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setAnswer(String answer) {
            this.answer = answer;
            return this;
        }

        private Builder(AnswerName answerName) {
            Preconditions.checkArgument((boolean)Objects.equals(answerName.pathTemplate, PROJECT_LOCATION_DATA_STORE_SESSION_ANSWER), (Object)"toBuilder is only supported when AnswerName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}/answers/{answer}");
            this.project = answerName.project;
            this.location = answerName.location;
            this.dataStore = answerName.dataStore;
            this.session = answerName.session;
            this.answer = answerName.answer;
        }

        public AnswerName build() {
            return new AnswerName(this);
        }
    }
}

