/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetSiteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_TARGET_SITE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_TARGET_SITE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String targetSite;
    private final String collection;

    @Deprecated
    protected TargetSiteName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.targetSite = null;
        this.collection = null;
    }

    private TargetSiteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.targetSite = (String)Preconditions.checkNotNull((Object)builder.getTargetSite());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_TARGET_SITE;
    }

    private TargetSiteName(ProjectLocationCollectionDataStoreTargetSiteBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.targetSite = (String)Preconditions.checkNotNull((Object)builder.getTargetSite());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_TARGET_SITE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getTargetSite() {
        return this.targetSite;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationDataStoreTargetSiteBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationCollectionDataStoreTargetSiteBuilder newProjectLocationCollectionDataStoreTargetSiteBuilder() {
        return new ProjectLocationCollectionDataStoreTargetSiteBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TargetSiteName of(String project, String location, String dataStore, String targetSite) {
        return TargetSiteName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setTargetSite(targetSite).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TargetSiteName ofProjectLocationDataStoreTargetSiteName(String project, String location, String dataStore, String targetSite) {
        return TargetSiteName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setTargetSite(targetSite).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TargetSiteName ofProjectLocationCollectionDataStoreTargetSiteName(String project, String location, String collection, String dataStore, String targetSite) {
        return TargetSiteName.newProjectLocationCollectionDataStoreTargetSiteBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setTargetSite(targetSite).build();
    }

    public static String format(String project, String location, String dataStore, String targetSite) {
        return TargetSiteName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setTargetSite(targetSite).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationDataStoreTargetSiteName(String project, String location, String dataStore, String targetSite) {
        return TargetSiteName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setTargetSite(targetSite).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationCollectionDataStoreTargetSiteName(String project, String location, String collection, String dataStore, String targetSite) {
        return TargetSiteName.newProjectLocationCollectionDataStoreTargetSiteBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setTargetSite(targetSite).build().toString();
    }

    public static TargetSiteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_TARGET_SITE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_TARGET_SITE.match(formattedString);
            return TargetSiteName.ofProjectLocationDataStoreTargetSiteName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("target_site"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_TARGET_SITE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_TARGET_SITE.match(formattedString);
            return TargetSiteName.ofProjectLocationCollectionDataStoreTargetSiteName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("target_site"));
        }
        throw new ValidationException("TargetSiteName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<TargetSiteName> parseList(List<String> formattedStrings) {
        ArrayList<TargetSiteName> list = new ArrayList<TargetSiteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TargetSiteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TargetSiteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TargetSiteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_TARGET_SITE.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_TARGET_SITE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TargetSiteName targetSiteName = this;
            synchronized (targetSiteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.targetSite != null) {
                        fieldMapBuilder.put((Object)"target_site", (Object)this.targetSite);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TargetSiteName that = (TargetSiteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.targetSite, that.targetSite) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.targetSite);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationCollectionDataStoreTargetSiteBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String targetSite;

        protected ProjectLocationCollectionDataStoreTargetSiteBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getTargetSite() {
            return this.targetSite;
        }

        public ProjectLocationCollectionDataStoreTargetSiteBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreTargetSiteBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreTargetSiteBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreTargetSiteBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreTargetSiteBuilder setTargetSite(String targetSite) {
            this.targetSite = targetSite;
            return this;
        }

        public TargetSiteName build() {
            return new TargetSiteName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String targetSite;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getTargetSite() {
            return this.targetSite;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setTargetSite(String targetSite) {
            this.targetSite = targetSite;
            return this;
        }

        private Builder(TargetSiteName targetSiteName) {
            Preconditions.checkArgument((boolean)Objects.equals(targetSiteName.pathTemplate, PROJECT_LOCATION_DATA_STORE_TARGET_SITE), (Object)"toBuilder is only supported when TargetSiteName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}");
            this.project = targetSiteName.project;
            this.location = targetSiteName.location;
            this.dataStore = targetSiteName.dataStore;
            this.targetSite = targetSiteName.targetSite;
        }

        public TargetSiteName build() {
            return new TargetSiteName(this);
        }
    }
}

