/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChunkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT_CHUNK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}/chunks/{chunk}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT_CHUNK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}/chunks/{chunk}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String branch;
    private final String document;
    private final String chunk;
    private final String collection;

    @Deprecated
    protected ChunkName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.branch = null;
        this.document = null;
        this.chunk = null;
        this.collection = null;
    }

    private ChunkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.chunk = (String)Preconditions.checkNotNull((Object)builder.getChunk());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT_CHUNK;
    }

    private ChunkName(ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.chunk = (String)Preconditions.checkNotNull((Object)builder.getChunk());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT_CHUNK;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDocument() {
        return this.document;
    }

    public String getChunk() {
        return this.chunk;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreBranchDocumentChunkBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder newProjectLocationCollectionDataStoreBranchDocumentChunkBuilder() {
        return new ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChunkName of(String project, String location, String dataStore, String branch, String document, String chunk) {
        return ChunkName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).setChunk(chunk).build();
    }

    public static ChunkName ofProjectLocationDataStoreBranchDocumentChunkName(String project, String location, String dataStore, String branch, String document, String chunk) {
        return ChunkName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).setChunk(chunk).build();
    }

    public static ChunkName ofProjectLocationCollectionDataStoreBranchDocumentChunkName(String project, String location, String collection, String dataStore, String branch, String document, String chunk) {
        return ChunkName.newProjectLocationCollectionDataStoreBranchDocumentChunkBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setBranch(branch).setDocument(document).setChunk(chunk).build();
    }

    public static String format(String project, String location, String dataStore, String branch, String document, String chunk) {
        return ChunkName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).setChunk(chunk).build().toString();
    }

    public static String formatProjectLocationDataStoreBranchDocumentChunkName(String project, String location, String dataStore, String branch, String document, String chunk) {
        return ChunkName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).setChunk(chunk).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreBranchDocumentChunkName(String project, String location, String collection, String dataStore, String branch, String document, String chunk) {
        return ChunkName.newProjectLocationCollectionDataStoreBranchDocumentChunkBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setBranch(branch).setDocument(document).setChunk(chunk).build().toString();
    }

    public static ChunkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT_CHUNK.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT_CHUNK.match(formattedString);
            return ChunkName.ofProjectLocationDataStoreBranchDocumentChunkName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"), (String)matchMap.get("document"), (String)matchMap.get("chunk"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT_CHUNK.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT_CHUNK.match(formattedString);
            return ChunkName.ofProjectLocationCollectionDataStoreBranchDocumentChunkName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"), (String)matchMap.get("document"), (String)matchMap.get("chunk"));
        }
        throw new ValidationException("ChunkName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ChunkName> parseList(List<String> formattedStrings) {
        ArrayList<ChunkName> list = new ArrayList<ChunkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChunkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChunkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChunkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT_CHUNK.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT_CHUNK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChunkName chunkName = this;
            synchronized (chunkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.branch != null) {
                        fieldMapBuilder.put((Object)"branch", (Object)this.branch);
                    }
                    if (this.document != null) {
                        fieldMapBuilder.put((Object)"document", (Object)this.document);
                    }
                    if (this.chunk != null) {
                        fieldMapBuilder.put((Object)"chunk", (Object)this.chunk);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChunkName that = (ChunkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.branch, that.branch) && Objects.equals(this.document, that.document) && Objects.equals(this.chunk, that.chunk) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.branch);
        h *= 1000003;
        h ^= Objects.hashCode(this.document);
        h *= 1000003;
        h ^= Objects.hashCode(this.chunk);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String branch;
        private String document;
        private String chunk;

        protected ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getDocument() {
            return this.document;
        }

        public String getChunk() {
            return this.chunk;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setDocument(String document) {
            this.document = document;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentChunkBuilder setChunk(String chunk) {
            this.chunk = chunk;
            return this;
        }

        public ChunkName build() {
            return new ChunkName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String branch;
        private String document;
        private String chunk;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getDocument() {
            return this.document;
        }

        public String getChunk() {
            return this.chunk;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        public Builder setChunk(String chunk) {
            this.chunk = chunk;
            return this;
        }

        private Builder(ChunkName chunkName) {
            Preconditions.checkArgument((boolean)Objects.equals(chunkName.pathTemplate, PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT_CHUNK), (Object)"toBuilder is only supported when ChunkName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}/chunks/{chunk}");
            this.project = chunkName.project;
            this.location = chunkName.location;
            this.dataStore = chunkName.dataStore;
            this.branch = chunkName.branch;
            this.document = chunkName.document;
            this.chunk = chunkName.chunk;
        }

        public ChunkName build() {
            return new ChunkName(this);
        }
    }
}

