/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IntentName
implements ResourceName {
    private static final PathTemplate PROJECT_INTENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/intents/{intent}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String intent;

    @Deprecated
    protected IntentName() {
        this.project = null;
        this.intent = null;
    }

    private IntentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.intent = (String)Preconditions.checkNotNull((Object)builder.getIntent());
    }

    public String getProject() {
        return this.project;
    }

    public String getIntent() {
        return this.intent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IntentName of(String project, String intent) {
        return IntentName.newBuilder().setProject(project).setIntent(intent).build();
    }

    public static String format(String project, String intent) {
        return IntentName.newBuilder().setProject(project).setIntent(intent).build().toString();
    }

    public static IntentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INTENT.validatedMatch(formattedString, "IntentName.parse: formattedString not in valid format");
        return IntentName.of((String)matchMap.get("project"), (String)matchMap.get("intent"));
    }

    public static List<IntentName> parseList(List<String> formattedStrings) {
        ArrayList<IntentName> list = new ArrayList<IntentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IntentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IntentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IntentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INTENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IntentName intentName = this;
            synchronized (intentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.intent != null) {
                        fieldMapBuilder.put((Object)"intent", (Object)this.intent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INTENT.instantiate(new String[]{"project", this.project, "intent", this.intent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            IntentName that = (IntentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.intent, that.intent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.intent);
    }

    public static class Builder {
        private String project;
        private String intent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getIntent() {
            return this.intent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setIntent(String intent) {
            this.intent = intent;
            return this;
        }

        private Builder(IntentName intentName) {
            this.project = intentName.project;
            this.intent = intentName.intent;
        }

        public IntentName build() {
            return new IntentName(this);
        }
    }
}

