/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CallMatcherName
implements ResourceName {
    private static final PathTemplate PROJECT_CONVERSATION_CALL_MATCHER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversations/{conversation}/callMatchers/{call_matcher}");
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_CALL_MATCHER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}/callMatchers/{call_matcher}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String conversation;
    private final String callMatcher;
    private final String location;

    @Deprecated
    protected CallMatcherName() {
        this.project = null;
        this.conversation = null;
        this.callMatcher = null;
        this.location = null;
    }

    private CallMatcherName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.callMatcher = (String)Preconditions.checkNotNull((Object)builder.getCallMatcher());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION_CALL_MATCHER;
    }

    private CallMatcherName(ProjectLocationConversationCallMatcherBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.callMatcher = (String)Preconditions.checkNotNull((Object)builder.getCallMatcher());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_CALL_MATCHER;
    }

    public String getProject() {
        return this.project;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getCallMatcher() {
        return this.callMatcher;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectConversationCallMatcherBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationConversationCallMatcherBuilder newProjectLocationConversationCallMatcherBuilder() {
        return new ProjectLocationConversationCallMatcherBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CallMatcherName of(String project, String conversation, String callMatcher) {
        return CallMatcherName.newBuilder().setProject(project).setConversation(conversation).setCallMatcher(callMatcher).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CallMatcherName ofProjectConversationCallMatcherName(String project, String conversation, String callMatcher) {
        return CallMatcherName.newBuilder().setProject(project).setConversation(conversation).setCallMatcher(callMatcher).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CallMatcherName ofProjectLocationConversationCallMatcherName(String project, String location, String conversation, String callMatcher) {
        return CallMatcherName.newProjectLocationConversationCallMatcherBuilder().setProject(project).setLocation(location).setConversation(conversation).setCallMatcher(callMatcher).build();
    }

    public static String format(String project, String conversation, String callMatcher) {
        return CallMatcherName.newBuilder().setProject(project).setConversation(conversation).setCallMatcher(callMatcher).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectConversationCallMatcherName(String project, String conversation, String callMatcher) {
        return CallMatcherName.newBuilder().setProject(project).setConversation(conversation).setCallMatcher(callMatcher).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationConversationCallMatcherName(String project, String location, String conversation, String callMatcher) {
        return CallMatcherName.newProjectLocationConversationCallMatcherBuilder().setProject(project).setLocation(location).setConversation(conversation).setCallMatcher(callMatcher).build().toString();
    }

    public static CallMatcherName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONVERSATION_CALL_MATCHER.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION_CALL_MATCHER.match(formattedString);
            return CallMatcherName.ofProjectConversationCallMatcherName((String)matchMap.get("project"), (String)matchMap.get("conversation"), (String)matchMap.get("call_matcher"));
        }
        if (PROJECT_LOCATION_CONVERSATION_CALL_MATCHER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_CALL_MATCHER.match(formattedString);
            return CallMatcherName.ofProjectLocationConversationCallMatcherName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"), (String)matchMap.get("call_matcher"));
        }
        throw new ValidationException("CallMatcherName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CallMatcherName> parseList(List<String> formattedStrings) {
        ArrayList<CallMatcherName> list = new ArrayList<CallMatcherName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CallMatcherName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CallMatcherName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CallMatcherName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONVERSATION_CALL_MATCHER.matches(formattedString) || PROJECT_LOCATION_CONVERSATION_CALL_MATCHER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CallMatcherName callMatcherName = this;
            synchronized (callMatcherName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.callMatcher != null) {
                        fieldMapBuilder.put((Object)"call_matcher", (Object)this.callMatcher);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CallMatcherName that = (CallMatcherName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.callMatcher, that.callMatcher) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        h ^= Objects.hashCode(this.callMatcher);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationConversationCallMatcherBuilder {
        private String project;
        private String location;
        private String conversation;
        private String callMatcher;

        protected ProjectLocationConversationCallMatcherBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getCallMatcher() {
            return this.callMatcher;
        }

        public ProjectLocationConversationCallMatcherBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationConversationCallMatcherBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationConversationCallMatcherBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ProjectLocationConversationCallMatcherBuilder setCallMatcher(String callMatcher) {
            this.callMatcher = callMatcher;
            return this;
        }

        public CallMatcherName build() {
            return new CallMatcherName(this);
        }
    }

    public static class Builder {
        private String project;
        private String conversation;
        private String callMatcher;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getCallMatcher() {
            return this.callMatcher;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public Builder setCallMatcher(String callMatcher) {
            this.callMatcher = callMatcher;
            return this;
        }

        private Builder(CallMatcherName callMatcherName) {
            Preconditions.checkArgument((boolean)Objects.equals(callMatcherName.pathTemplate, PROJECT_CONVERSATION_CALL_MATCHER), (Object)"toBuilder is only supported when CallMatcherName has the pattern of projects/{project}/conversations/{conversation}/callMatchers/{call_matcher}");
            this.project = callMatcherName.project;
            this.conversation = callMatcherName.conversation;
            this.callMatcher = callMatcherName.callMatcher;
        }

        public CallMatcherName build() {
            return new CallMatcherName(this);
        }
    }
}

