/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionName
implements ResourceName {
    private static final PathTemplate PROJECT_SESSION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/sessions/{session}");
    private static final PathTemplate PROJECT_ENVIRONMENT_USER_SESSION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String session;
    private String environment;
    private String user;

    @Deprecated
    protected SessionName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getSession() {
        return this.session;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    private SessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.pathTemplate = PROJECT_SESSION_PATH_TEMPLATE;
    }

    private SessionName(ProjectEnvironmentUserSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.pathTemplate = PROJECT_ENVIRONMENT_USER_SESSION_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectSessionBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectEnvironmentUserSessionBuilder newProjectEnvironmentUserSessionBuilder() {
        return new ProjectEnvironmentUserSessionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionName of(String project, String session) {
        return SessionName.newProjectSessionBuilder().setProject(project).setSession(session).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SessionName ofProjectSessionName(String project, String session) {
        return SessionName.newProjectSessionBuilder().setProject(project).setSession(session).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SessionName ofProjectEnvironmentUserSessionName(String project, String environment, String user, String session) {
        return SessionName.newProjectEnvironmentUserSessionBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).build();
    }

    public static String format(String project, String session) {
        return SessionName.newBuilder().setProject(project).setSession(session).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSessionName(String project, String session) {
        return SessionName.newBuilder().setProject(project).setSession(session).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectEnvironmentUserSessionName(String project, String environment, String user, String session) {
        return SessionName.newProjectEnvironmentUserSessionBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).build().toString();
    }

    public static SessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SESSION_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_SESSION_PATH_TEMPLATE.match(formattedString);
            return SessionName.ofProjectSessionName((String)matchMap.get("project"), (String)matchMap.get("session"));
        }
        if (PROJECT_ENVIRONMENT_USER_SESSION_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_ENVIRONMENT_USER_SESSION_PATH_TEMPLATE.match(formattedString);
            return SessionName.ofProjectEnvironmentUserSessionName((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SessionName> parseList(List<String> formattedStrings) {
        ArrayList<SessionName> list = new ArrayList<SessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SESSION_PATH_TEMPLATE.matches(formattedString) || PROJECT_ENVIRONMENT_USER_SESSION_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionName sessionName = this;
            synchronized (sessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SessionName that = (SessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.session, that.session) && Objects.equals(this.environment, that.environment) && Objects.equals(this.user, that.user);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.user);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectEnvironmentUserSessionBuilder {
        private String project;
        private String environment;
        private String user;
        private String session;

        private ProjectEnvironmentUserSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectEnvironmentUserSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectEnvironmentUserSessionBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectEnvironmentUserSessionBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectEnvironmentUserSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String session;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder(SessionName sessionName) {
            Preconditions.checkArgument((sessionName.pathTemplate == PROJECT_SESSION_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when SessionName has the pattern of projects/{project}/agent/sessions/{session}.");
            this.project = sessionName.project;
            this.session = sessionName.session;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }
}

