/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devicestreaming.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeviceSessionName
implements ResourceName {
    private static final PathTemplate PROJECT_DEVICE_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/deviceSessions/{device_session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String deviceSession;

    @Deprecated
    protected DeviceSessionName() {
        this.project = null;
        this.deviceSession = null;
    }

    private DeviceSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.deviceSession = (String)Preconditions.checkNotNull((Object)builder.getDeviceSession());
    }

    public String getProject() {
        return this.project;
    }

    public String getDeviceSession() {
        return this.deviceSession;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceSessionName of(String project, String deviceSession) {
        return DeviceSessionName.newBuilder().setProject(project).setDeviceSession(deviceSession).build();
    }

    public static String format(String project, String deviceSession) {
        return DeviceSessionName.newBuilder().setProject(project).setDeviceSession(deviceSession).build().toString();
    }

    public static DeviceSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DEVICE_SESSION.validatedMatch(formattedString, "DeviceSessionName.parse: formattedString not in valid format");
        return DeviceSessionName.of((String)matchMap.get("project"), (String)matchMap.get("device_session"));
    }

    public static List<DeviceSessionName> parseList(List<String> formattedStrings) {
        ArrayList<DeviceSessionName> list = new ArrayList<DeviceSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeviceSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeviceSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeviceSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DEVICE_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeviceSessionName deviceSessionName = this;
            synchronized (deviceSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.deviceSession != null) {
                        fieldMapBuilder.put((Object)"device_session", (Object)this.deviceSession);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DEVICE_SESSION.instantiate(new String[]{"project", this.project, "device_session", this.deviceSession});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeviceSessionName that = (DeviceSessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.deviceSession, that.deviceSession);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deviceSession);
    }

    public static class Builder {
        private String project;
        private String deviceSession;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDeviceSession() {
            return this.deviceSession;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDeviceSession(String deviceSession) {
            this.deviceSession = deviceSession;
            return this;
        }

        private Builder(DeviceSessionName deviceSessionName) {
            this.project = deviceSessionName.project;
            this.deviceSession = deviceSessionName.deviceSession;
        }

        public DeviceSessionName build() {
            return new DeviceSessionName(this);
        }
    }
}

