/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AutomationRunName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION_RUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deliveryPipeline;
    private final String automationRun;

    @Deprecated
    protected AutomationRunName() {
        this.project = null;
        this.location = null;
        this.deliveryPipeline = null;
        this.automationRun = null;
    }

    private AutomationRunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deliveryPipeline = (String)Preconditions.checkNotNull((Object)builder.getDeliveryPipeline());
        this.automationRun = (String)Preconditions.checkNotNull((Object)builder.getAutomationRun());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeliveryPipeline() {
        return this.deliveryPipeline;
    }

    public String getAutomationRun() {
        return this.automationRun;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutomationRunName of(String project, String location, String deliveryPipeline, String automationRun) {
        return AutomationRunName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setAutomationRun(automationRun).build();
    }

    public static String format(String project, String location, String deliveryPipeline, String automationRun) {
        return AutomationRunName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setAutomationRun(automationRun).build().toString();
    }

    public static AutomationRunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION_RUN.validatedMatch(formattedString, "AutomationRunName.parse: formattedString not in valid format");
        return AutomationRunName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("delivery_pipeline"), (String)matchMap.get("automation_run"));
    }

    public static List<AutomationRunName> parseList(List<String> formattedStrings) {
        ArrayList<AutomationRunName> list = new ArrayList<AutomationRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutomationRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutomationRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutomationRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION_RUN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutomationRunName automationRunName = this;
            synchronized (automationRunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deliveryPipeline != null) {
                        fieldMapBuilder.put((Object)"delivery_pipeline", (Object)this.deliveryPipeline);
                    }
                    if (this.automationRun != null) {
                        fieldMapBuilder.put((Object)"automation_run", (Object)this.automationRun);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION_RUN.instantiate(new String[]{"project", this.project, "location", this.location, "delivery_pipeline", this.deliveryPipeline, "automation_run", this.automationRun});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutomationRunName that = (AutomationRunName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deliveryPipeline, that.deliveryPipeline) && Objects.equals(this.automationRun, that.automationRun);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.deliveryPipeline);
        h *= 1000003;
        return h ^= Objects.hashCode(this.automationRun);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deliveryPipeline;
        private String automationRun;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeliveryPipeline() {
            return this.deliveryPipeline;
        }

        public String getAutomationRun() {
            return this.automationRun;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeliveryPipeline(String deliveryPipeline) {
            this.deliveryPipeline = deliveryPipeline;
            return this;
        }

        public Builder setAutomationRun(String automationRun) {
            this.automationRun = automationRun;
            return this;
        }

        private Builder(AutomationRunName automationRunName) {
            this.project = automationRunName.project;
            this.location = automationRunName.location;
            this.deliveryPipeline = automationRunName.deliveryPipeline;
            this.automationRun = automationRunName.automationRun;
        }

        public AutomationRunName build() {
            return new AutomationRunName(this);
        }
    }
}

