/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeployPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEPLOY_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deployPolicies/{deploy_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deployPolicy;

    @Deprecated
    protected DeployPolicyName() {
        this.project = null;
        this.location = null;
        this.deployPolicy = null;
    }

    private DeployPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deployPolicy = (String)Preconditions.checkNotNull((Object)builder.getDeployPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeployPolicy() {
        return this.deployPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeployPolicyName of(String project, String location, String deployPolicy) {
        return DeployPolicyName.newBuilder().setProject(project).setLocation(location).setDeployPolicy(deployPolicy).build();
    }

    public static String format(String project, String location, String deployPolicy) {
        return DeployPolicyName.newBuilder().setProject(project).setLocation(location).setDeployPolicy(deployPolicy).build().toString();
    }

    public static DeployPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEPLOY_POLICY.validatedMatch(formattedString, "DeployPolicyName.parse: formattedString not in valid format");
        return DeployPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("deploy_policy"));
    }

    public static List<DeployPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<DeployPolicyName> list = new ArrayList<DeployPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeployPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeployPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeployPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEPLOY_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeployPolicyName deployPolicyName = this;
            synchronized (deployPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deployPolicy != null) {
                        fieldMapBuilder.put((Object)"deploy_policy", (Object)this.deployPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEPLOY_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "deploy_policy", this.deployPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeployPolicyName that = (DeployPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deployPolicy, that.deployPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deployPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deployPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeployPolicy() {
            return this.deployPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeployPolicy(String deployPolicy) {
            this.deployPolicy = deployPolicy;
            return this;
        }

        private Builder(DeployPolicyName deployPolicyName) {
            this.project = deployPolicyName.project;
            this.location = deployPolicyName.location;
            this.deployPolicy = deployPolicyName.deployPolicy;
        }

        public DeployPolicyName build() {
            return new DeployPolicyName(this);
        }
    }
}

