/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobRunName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT_JOB_RUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{job_run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deliveryPipeline;
    private final String release;
    private final String rollout;
    private final String jobRun;

    @Deprecated
    protected JobRunName() {
        this.project = null;
        this.location = null;
        this.deliveryPipeline = null;
        this.release = null;
        this.rollout = null;
        this.jobRun = null;
    }

    private JobRunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deliveryPipeline = (String)Preconditions.checkNotNull((Object)builder.getDeliveryPipeline());
        this.release = (String)Preconditions.checkNotNull((Object)builder.getRelease());
        this.rollout = (String)Preconditions.checkNotNull((Object)builder.getRollout());
        this.jobRun = (String)Preconditions.checkNotNull((Object)builder.getJobRun());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeliveryPipeline() {
        return this.deliveryPipeline;
    }

    public String getRelease() {
        return this.release;
    }

    public String getRollout() {
        return this.rollout;
    }

    public String getJobRun() {
        return this.jobRun;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static JobRunName of(String project, String location, String deliveryPipeline, String release, String rollout, String jobRun) {
        return JobRunName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setRelease(release).setRollout(rollout).setJobRun(jobRun).build();
    }

    public static String format(String project, String location, String deliveryPipeline, String release, String rollout, String jobRun) {
        return JobRunName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setRelease(release).setRollout(rollout).setJobRun(jobRun).build().toString();
    }

    public static JobRunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT_JOB_RUN.validatedMatch(formattedString, "JobRunName.parse: formattedString not in valid format");
        return JobRunName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("delivery_pipeline"), (String)matchMap.get("release"), (String)matchMap.get("rollout"), (String)matchMap.get("job_run"));
    }

    public static List<JobRunName> parseList(List<String> formattedStrings) {
        ArrayList<JobRunName> list = new ArrayList<JobRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(JobRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<JobRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (JobRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT_JOB_RUN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            JobRunName jobRunName = this;
            synchronized (jobRunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deliveryPipeline != null) {
                        fieldMapBuilder.put((Object)"delivery_pipeline", (Object)this.deliveryPipeline);
                    }
                    if (this.release != null) {
                        fieldMapBuilder.put((Object)"release", (Object)this.release);
                    }
                    if (this.rollout != null) {
                        fieldMapBuilder.put((Object)"rollout", (Object)this.rollout);
                    }
                    if (this.jobRun != null) {
                        fieldMapBuilder.put((Object)"job_run", (Object)this.jobRun);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT_JOB_RUN.instantiate(new String[]{"project", this.project, "location", this.location, "delivery_pipeline", this.deliveryPipeline, "release", this.release, "rollout", this.rollout, "job_run", this.jobRun});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            JobRunName that = (JobRunName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deliveryPipeline, that.deliveryPipeline) && Objects.equals(this.release, that.release) && Objects.equals(this.rollout, that.rollout) && Objects.equals(this.jobRun, that.jobRun);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.deliveryPipeline);
        h *= 1000003;
        h ^= Objects.hashCode(this.release);
        h *= 1000003;
        h ^= Objects.hashCode(this.rollout);
        h *= 1000003;
        return h ^= Objects.hashCode(this.jobRun);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deliveryPipeline;
        private String release;
        private String rollout;
        private String jobRun;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeliveryPipeline() {
            return this.deliveryPipeline;
        }

        public String getRelease() {
            return this.release;
        }

        public String getRollout() {
            return this.rollout;
        }

        public String getJobRun() {
            return this.jobRun;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeliveryPipeline(String deliveryPipeline) {
            this.deliveryPipeline = deliveryPipeline;
            return this;
        }

        public Builder setRelease(String release) {
            this.release = release;
            return this;
        }

        public Builder setRollout(String rollout) {
            this.rollout = rollout;
            return this;
        }

        public Builder setJobRun(String jobRun) {
            this.jobRun = jobRun;
            return this;
        }

        private Builder(JobRunName jobRunName) {
            this.project = jobRunName.project;
            this.location = jobRunName.location;
            this.deliveryPipeline = jobRunName.deliveryPipeline;
            this.release = jobRunName.release;
            this.rollout = jobRunName.rollout;
            this.jobRun = jobRunName.jobRun;
        }

        public JobRunName build() {
            return new JobRunName(this);
        }
    }
}

