/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents a single action in a workflow invocation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction}
 */
public final class WorkflowInvocationAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction)
    WorkflowInvocationActionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WorkflowInvocationAction.newBuilder() to construct.
  private WorkflowInvocationAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowInvocationAction() {
    state_ = 0;
    failureReason_ = "";
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowInvocationAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.class,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the current state of a workflow invocation action.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataform.v1.WorkflowInvocationAction.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The action has not yet been considered for invocation.
     * </pre>
     *
     * <code>PENDING = 0;</code>
     */
    PENDING(0),
    /**
     *
     *
     * <pre>
     * The action is currently running.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * Execution of the action was skipped because upstream dependencies did not
     * all complete successfully. A terminal state.
     * </pre>
     *
     * <code>SKIPPED = 2;</code>
     */
    SKIPPED(2),
    /**
     *
     *
     * <pre>
     * Execution of the action was disabled as per the configuration of the
     * corresponding compilation result action. A terminal state.
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    DISABLED(3),
    /**
     *
     *
     * <pre>
     * The action succeeded. A terminal state.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    /**
     *
     *
     * <pre>
     * The action was cancelled. A terminal state.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    CANCELLED(5),
    /**
     *
     *
     * <pre>
     * The action failed. A terminal state.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The action has not yet been considered for invocation.
     * </pre>
     *
     * <code>PENDING = 0;</code>
     */
    public static final int PENDING_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The action is currently running.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Execution of the action was skipped because upstream dependencies did not
     * all complete successfully. A terminal state.
     * </pre>
     *
     * <code>SKIPPED = 2;</code>
     */
    public static final int SKIPPED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Execution of the action was disabled as per the configuration of the
     * corresponding compilation result action. A terminal state.
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    public static final int DISABLED_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The action succeeded. A terminal state.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;

    /**
     *
     *
     * <pre>
     * The action was cancelled. A terminal state.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    public static final int CANCELLED_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The action failed. A terminal state.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return PENDING;
        case 1:
          return RUNNING;
        case 2:
          return SKIPPED;
        case 3:
          return DISABLED;
        case 4:
          return SUCCEEDED;
        case 5:
          return CANCELLED;
        case 6:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataform.v1.WorkflowInvocationAction.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataform.v1.WorkflowInvocationAction.State)
  }

  public interface BigQueryActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed.
     * </pre>
     *
     * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sqlScript.
     */
    java.lang.String getSqlScript();

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed.
     * </pre>
     *
     * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for sqlScript.
     */
    com.google.protobuf.ByteString getSqlScriptBytes();

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    java.lang.String getJobId();

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    com.google.protobuf.ByteString getJobIdBytes();
  }

  /**
   *
   *
   * <pre>
   * Represents a workflow action that will run against BigQuery.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction}
   */
  public static final class BigQueryAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)
      BigQueryActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BigQueryAction.newBuilder() to construct.
    private BigQueryAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQueryAction() {
      sqlScript_ = "";
      jobId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQueryAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_BigQueryAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_BigQueryAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.class,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder.class);
    }

    public static final int SQL_SCRIPT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sqlScript_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed.
     * </pre>
     *
     * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sqlScript.
     */
    @java.lang.Override
    public java.lang.String getSqlScript() {
      java.lang.Object ref = sqlScript_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sqlScript_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed.
     * </pre>
     *
     * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for sqlScript.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSqlScriptBytes() {
      java.lang.Object ref = sqlScript_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sqlScript_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int JOB_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object jobId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    @java.lang.Override
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sqlScript_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sqlScript_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, jobId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sqlScript_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sqlScript_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, jobId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction other =
          (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) obj;

      if (!getSqlScript().equals(other.getSqlScript())) return false;
      if (!getJobId().equals(other.getJobId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SQL_SCRIPT_FIELD_NUMBER;
      hash = (53 * hash) + getSqlScript().hashCode();
      hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
      hash = (53 * hash) + getJobId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a workflow action that will run against BigQuery.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_BigQueryAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_BigQueryAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sqlScript_ = "";
        jobId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_BigQueryAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction build() {
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction buildPartial() {
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction result =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sqlScript_ = sqlScript_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.jobId_ = jobId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction other) {
        if (other
            == com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
                .getDefaultInstance()) return this;
        if (!other.getSqlScript().isEmpty()) {
          sqlScript_ = other.sqlScript_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getJobId().isEmpty()) {
          jobId_ = other.jobId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  sqlScript_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  jobId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object sqlScript_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed.
       * </pre>
       *
       * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The sqlScript.
       */
      public java.lang.String getSqlScript() {
        java.lang.Object ref = sqlScript_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sqlScript_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed.
       * </pre>
       *
       * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for sqlScript.
       */
      public com.google.protobuf.ByteString getSqlScriptBytes() {
        java.lang.Object ref = sqlScript_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sqlScript_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed.
       * </pre>
       *
       * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The sqlScript to set.
       * @return This builder for chaining.
       */
      public Builder setSqlScript(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sqlScript_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed.
       * </pre>
       *
       * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSqlScript() {
        sqlScript_ = getDefaultInstance().getSqlScript();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed.
       * </pre>
       *
       * <code>string sql_script = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for sqlScript to set.
       * @return This builder for chaining.
       */
      public Builder setSqlScriptBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sqlScript_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object jobId_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The jobId.
       */
      public java.lang.String getJobId() {
        java.lang.Object ref = jobId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for jobId.
       */
      public com.google.protobuf.ByteString getJobIdBytes() {
        java.lang.Object ref = jobId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The jobId to set.
       * @return This builder for chaining.
       */
      public Builder setJobId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobId() {
        jobId_ = getDefaultInstance().getJobId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for jobId to set.
       * @return This builder for chaining.
       */
      public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        jobId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)
    private static final com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction();
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQueryAction> PARSER =
        new com.google.protobuf.AbstractParser<BigQueryAction>() {
          @java.lang.Override
          public BigQueryAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQueryAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQueryAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NotebookActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The code contents of a Notebook to be run.
     * </pre>
     *
     * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The contents.
     */
    java.lang.String getContents();

    /**
     *
     *
     * <pre>
     * Output only. The code contents of a Notebook to be run.
     * </pre>
     *
     * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for contents.
     */
    com.google.protobuf.ByteString getContentsBytes();

    /**
     *
     *
     * <pre>
     * Output only. The ID of the Vertex job that executed the notebook in
     * contents and also the ID used for the outputs created in Google Cloud
     * Storage buckets. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    java.lang.String getJobId();

    /**
     *
     *
     * <pre>
     * Output only. The ID of the Vertex job that executed the notebook in
     * contents and also the ID used for the outputs created in Google Cloud
     * Storage buckets. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    com.google.protobuf.ByteString getJobIdBytes();
  }

  /**
   *
   *
   * <pre>
   * Represents a workflow action that will run against a Notebook runtime.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction}
   */
  public static final class NotebookAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)
      NotebookActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NotebookAction.newBuilder() to construct.
    private NotebookAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NotebookAction() {
      contents_ = "";
      jobId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NotebookAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_NotebookAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_NotebookAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.class,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder.class);
    }

    public static final int CONTENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object contents_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The code contents of a Notebook to be run.
     * </pre>
     *
     * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The contents.
     */
    @java.lang.Override
    public java.lang.String getContents() {
      java.lang.Object ref = contents_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contents_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The code contents of a Notebook to be run.
     * </pre>
     *
     * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for contents.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentsBytes() {
      java.lang.Object ref = contents_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contents_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int JOB_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object jobId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The ID of the Vertex job that executed the notebook in
     * contents and also the ID used for the outputs created in Google Cloud
     * Storage buckets. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    @java.lang.Override
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the Vertex job that executed the notebook in
     * contents and also the ID used for the outputs created in Google Cloud
     * Storage buckets. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contents_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, contents_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, jobId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contents_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, contents_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, jobId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction other =
          (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) obj;

      if (!getContents().equals(other.getContents())) return false;
      if (!getJobId().equals(other.getJobId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContents().hashCode();
      hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
      hash = (53 * hash) + getJobId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a workflow action that will run against a Notebook runtime.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_NotebookAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_NotebookAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        contents_ = "";
        jobId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_NotebookAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction build() {
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction buildPartial() {
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction result =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.contents_ = contents_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.jobId_ = jobId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction other) {
        if (other
            == com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
                .getDefaultInstance()) return this;
        if (!other.getContents().isEmpty()) {
          contents_ = other.contents_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getJobId().isEmpty()) {
          jobId_ = other.jobId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  contents_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  jobId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object contents_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The code contents of a Notebook to be run.
       * </pre>
       *
       * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The contents.
       */
      public java.lang.String getContents() {
        java.lang.Object ref = contents_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          contents_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The code contents of a Notebook to be run.
       * </pre>
       *
       * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for contents.
       */
      public com.google.protobuf.ByteString getContentsBytes() {
        java.lang.Object ref = contents_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          contents_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The code contents of a Notebook to be run.
       * </pre>
       *
       * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The contents to set.
       * @return This builder for chaining.
       */
      public Builder setContents(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        contents_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The code contents of a Notebook to be run.
       * </pre>
       *
       * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContents() {
        contents_ = getDefaultInstance().getContents();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The code contents of a Notebook to be run.
       * </pre>
       *
       * <code>string contents = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for contents to set.
       * @return This builder for chaining.
       */
      public Builder setContentsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        contents_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object jobId_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The ID of the Vertex job that executed the notebook in
       * contents and also the ID used for the outputs created in Google Cloud
       * Storage buckets. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The jobId.
       */
      public java.lang.String getJobId() {
        java.lang.Object ref = jobId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the Vertex job that executed the notebook in
       * contents and also the ID used for the outputs created in Google Cloud
       * Storage buckets. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for jobId.
       */
      public com.google.protobuf.ByteString getJobIdBytes() {
        java.lang.Object ref = jobId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the Vertex job that executed the notebook in
       * contents and also the ID used for the outputs created in Google Cloud
       * Storage buckets. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The jobId to set.
       * @return This builder for chaining.
       */
      public Builder setJobId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the Vertex job that executed the notebook in
       * contents and also the ID used for the outputs created in Google Cloud
       * Storage buckets. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobId() {
        jobId_ = getDefaultInstance().getJobId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the Vertex job that executed the notebook in
       * contents and also the ID used for the outputs created in Google Cloud
       * Storage buckets. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for jobId to set.
       * @return This builder for chaining.
       */
      public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        jobId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)
    private static final com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction();
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NotebookAction> PARSER =
        new com.google.protobuf.AbstractParser<NotebookAction>() {
          @java.lang.Override
          public NotebookAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NotebookAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NotebookAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataPreparationActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. YAML representing the contents of the data preparation.
     * Can be used to show the customer what the input was to their workflow.
     * </pre>
     *
     * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the contentsYaml field is set.
     */
    boolean hasContentsYaml();

    /**
     *
     *
     * <pre>
     * Output only. YAML representing the contents of the data preparation.
     * Can be used to show the customer what the input was to their workflow.
     * </pre>
     *
     * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The contentsYaml.
     */
    java.lang.String getContentsYaml();

    /**
     *
     *
     * <pre>
     * Output only. YAML representing the contents of the data preparation.
     * Can be used to show the customer what the input was to their workflow.
     * </pre>
     *
     * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for contentsYaml.
     */
    com.google.protobuf.ByteString getContentsYamlBytes();

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
     * </code>
     *
     * @return Whether the contentsSql field is set.
     */
    boolean hasContentsSql();

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
     * </code>
     *
     * @return The contentsSql.
     */
    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition
        getContentsSql();

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
     * </code>
     */
    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSqlDefinitionOrBuilder
        getContentsSqlOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed. For
     * reference only.
     * </pre>
     *
     * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generatedSql.
     */
    java.lang.String getGeneratedSql();

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed. For
     * reference only.
     * </pre>
     *
     * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for generatedSql.
     */
    com.google.protobuf.ByteString getGeneratedSqlBytes();

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    java.lang.String getJobId();

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    com.google.protobuf.ByteString getJobIdBytes();

    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.DefinitionCase
        getDefinitionCase();
  }

  /**
   *
   *
   * <pre>
   * Represents a workflow action that will run a Data Preparation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction}
   */
  public static final class DataPreparationAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
      DataPreparationActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DataPreparationAction.newBuilder() to construct.
    private DataPreparationAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataPreparationAction() {
      generatedSql_ = "";
      jobId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataPreparationAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.class,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder
                  .class);
    }

    public interface ActionSqlDefinitionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
       * </code>
       *
       * @return Whether the errorTable field is set.
       */
      boolean hasErrorTable();

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
       * </code>
       *
       * @return The errorTable.
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable
          getErrorTable();

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
       * </code>
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTableOrBuilder
          getErrorTableOrBuilder();

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
       * </code>
       *
       * @return Whether the loadConfig field is set.
       */
      boolean hasLoadConfig();

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
       * </code>
       *
       * @return The loadConfig.
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig
          getLoadConfig();

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
       * </code>
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfigOrBuilder
          getLoadConfigOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Definition of a SQL Data Preparation
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition}
     */
    public static final class ActionSqlDefinition extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition)
        ActionSqlDefinitionOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ActionSqlDefinition.newBuilder() to construct.
      private ActionSqlDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActionSqlDefinition() {
        query_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActionSqlDefinition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSqlDefinition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSqlDefinition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition.Builder.class);
      }

      private int bitField0_;
      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ERROR_TABLE_FIELD_NUMBER = 2;
      private com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          errorTable_;

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
       * </code>
       *
       * @return Whether the errorTable field is set.
       */
      @java.lang.Override
      public boolean hasErrorTable() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
       * </code>
       *
       * @return The errorTable.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          getErrorTable() {
        return errorTable_ == null
            ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable.getDefaultInstance()
            : errorTable_;
      }

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTableOrBuilder
          getErrorTableOrBuilder() {
        return errorTable_ == null
            ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable.getDefaultInstance()
            : errorTable_;
      }

      public static final int LOAD_CONFIG_FIELD_NUMBER = 3;
      private com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          loadConfig_;

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
       * </code>
       *
       * @return Whether the loadConfig field is set.
       */
      @java.lang.Override
      public boolean hasLoadConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
       * </code>
       *
       * @return The loadConfig.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          getLoadConfig() {
        return loadConfig_ == null
            ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig.getDefaultInstance()
            : loadConfig_;
      }

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfigOrBuilder
          getLoadConfigOrBuilder() {
        return loadConfig_ == null
            ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig.getDefaultInstance()
            : loadConfig_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getErrorTable());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getLoadConfig());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getErrorTable());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLoadConfig());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition
            other =
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSqlDefinition)
                    obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (hasErrorTable() != other.hasErrorTable()) return false;
        if (hasErrorTable()) {
          if (!getErrorTable().equals(other.getErrorTable())) return false;
        }
        if (hasLoadConfig() != other.hasLoadConfig()) return false;
        if (hasLoadConfig()) {
          if (!getLoadConfig().equals(other.getLoadConfig())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        if (hasErrorTable()) {
          hash = (37 * hash) + ERROR_TABLE_FIELD_NUMBER;
          hash = (53 * hash) + getErrorTable().hashCode();
        }
        if (hasLoadConfig()) {
          hash = (37 * hash) + LOAD_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getLoadConfig().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Definition of a SQL Data Preparation
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition)
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinitionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSqlDefinition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSqlDefinition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinition.class,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinition.Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getErrorTableFieldBuilder();
            getLoadConfigFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          errorTable_ = null;
          if (errorTableBuilder_ != null) {
            errorTableBuilder_.dispose();
            errorTableBuilder_ = null;
          }
          loadConfig_ = null;
          if (loadConfigBuilder_ != null) {
            loadConfigBuilder_.dispose();
            loadConfigBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSqlDefinition_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition
            build() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition
            buildPartial() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition
              result =
                  new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinition(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.errorTable_ =
                errorTableBuilder_ == null ? errorTable_ : errorTableBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.loadConfig_ =
                loadConfigBuilder_ == null ? loadConfig_ : loadConfigBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSqlDefinition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition
                other) {
          if (other
              == com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition.getDefaultInstance()) return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasErrorTable()) {
            mergeErrorTable(other.getErrorTable());
          }
          if (other.hasLoadConfig()) {
            mergeLoadConfig(other.getLoadConfig());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getErrorTableFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getLoadConfigFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable
            errorTable_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTableOrBuilder>
            errorTableBuilder_;

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         *
         * @return Whether the errorTable field is set.
         */
        public boolean hasErrorTable() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         *
         * @return The errorTable.
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable
            getErrorTable() {
          if (errorTableBuilder_ == null) {
            return errorTable_ == null
                ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.getDefaultInstance()
                : errorTable_;
          } else {
            return errorTableBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        public Builder setErrorTable(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable
                value) {
          if (errorTableBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            errorTable_ = value;
          } else {
            errorTableBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        public Builder setErrorTable(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.Builder
                builderForValue) {
          if (errorTableBuilder_ == null) {
            errorTable_ = builderForValue.build();
          } else {
            errorTableBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        public Builder mergeErrorTable(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable
                value) {
          if (errorTableBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && errorTable_ != null
                && errorTable_
                    != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionErrorTable.getDefaultInstance()) {
              getErrorTableBuilder().mergeFrom(value);
            } else {
              errorTable_ = value;
            }
          } else {
            errorTableBuilder_.mergeFrom(value);
          }
          if (errorTable_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        public Builder clearErrorTable() {
          bitField0_ = (bitField0_ & ~0x00000002);
          errorTable_ = null;
          if (errorTableBuilder_ != null) {
            errorTableBuilder_.dispose();
            errorTableBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable.Builder
            getErrorTableBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getErrorTableFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTableOrBuilder
            getErrorTableOrBuilder() {
          if (errorTableBuilder_ != null) {
            return errorTableBuilder_.getMessageOrBuilder();
          } else {
            return errorTable_ == null
                ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.getDefaultInstance()
                : errorTable_;
          }
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable error_table = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTableOrBuilder>
            getErrorTableFieldBuilder() {
          if (errorTableBuilder_ == null) {
            errorTableBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionErrorTable,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionErrorTable.Builder,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionErrorTableOrBuilder>(
                    getErrorTable(), getParentForChildren(), isClean());
            errorTable_ = null;
          }
          return errorTableBuilder_;
        }

        private com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig
            loadConfig_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfigOrBuilder>
            loadConfigBuilder_;

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         *
         * @return Whether the loadConfig field is set.
         */
        public boolean hasLoadConfig() {
          return ((bitField0_ & 0x00000004) != 0);
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         *
         * @return The loadConfig.
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig
            getLoadConfig() {
          if (loadConfigBuilder_ == null) {
            return loadConfig_ == null
                ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.getDefaultInstance()
                : loadConfig_;
          } else {
            return loadConfigBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        public Builder setLoadConfig(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig
                value) {
          if (loadConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            loadConfig_ = value;
          } else {
            loadConfigBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        public Builder setLoadConfig(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.Builder
                builderForValue) {
          if (loadConfigBuilder_ == null) {
            loadConfig_ = builderForValue.build();
          } else {
            loadConfigBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        public Builder mergeLoadConfig(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig
                value) {
          if (loadConfigBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && loadConfig_ != null
                && loadConfig_
                    != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionLoadConfig.getDefaultInstance()) {
              getLoadConfigBuilder().mergeFrom(value);
            } else {
              loadConfig_ = value;
            }
          } else {
            loadConfigBuilder_.mergeFrom(value);
          }
          if (loadConfig_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        public Builder clearLoadConfig() {
          bitField0_ = (bitField0_ & ~0x00000004);
          loadConfig_ = null;
          if (loadConfigBuilder_ != null) {
            loadConfigBuilder_.dispose();
            loadConfigBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig.Builder
            getLoadConfigBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getLoadConfigFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfigOrBuilder
            getLoadConfigOrBuilder() {
          if (loadConfigBuilder_ != null) {
            return loadConfigBuilder_.getMessageOrBuilder();
          } else {
            return loadConfig_ == null
                ? com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.getDefaultInstance()
                : loadConfig_;
          }
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig load_config = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfigOrBuilder>
            getLoadConfigFieldBuilder() {
          if (loadConfigBuilder_ == null) {
            loadConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionLoadConfig,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionLoadConfig.Builder,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionLoadConfigOrBuilder>(
                    getLoadConfig(), getParentForChildren(), isClean());
            loadConfig_ = null;
          }
          return loadConfigBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition)
      private static final com.google.cloud.dataform.v1.WorkflowInvocationAction
              .DataPreparationAction.ActionSqlDefinition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition();
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActionSqlDefinition> PARSER =
          new com.google.protobuf.AbstractParser<ActionSqlDefinition>() {
            @java.lang.Override
            public ActionSqlDefinition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActionSqlDefinition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActionSqlDefinition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ActionErrorTableOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return Whether the target field is set.
       */
      boolean hasTarget();

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return The target.
       */
      com.google.cloud.dataform.v1.Target getTarget();

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       */
      com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder();

      /**
       *
       *
       * <pre>
       * Error table partition expiration in days. Only positive values are
       * allowed.
       * </pre>
       *
       * <code>int32 retention_days = 2;</code>
       *
       * @return The retentionDays.
       */
      int getRetentionDays();
    }

    /**
     *
     *
     * <pre>
     * Error table information, used to write error data into a BigQuery
     * table.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable}
     */
    public static final class ActionErrorTable extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable)
        ActionErrorTableOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ActionErrorTable.newBuilder() to construct.
      private ActionErrorTable(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActionErrorTable() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActionErrorTable();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionErrorTable_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionErrorTable_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable.Builder.class);
      }

      private int bitField0_;
      public static final int TARGET_FIELD_NUMBER = 1;
      private com.google.cloud.dataform.v1.Target target_;

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return Whether the target field is set.
       */
      @java.lang.Override
      public boolean hasTarget() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return The target.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.Target getTarget() {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      }

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      }

      public static final int RETENTION_DAYS_FIELD_NUMBER = 2;
      private int retentionDays_ = 0;

      /**
       *
       *
       * <pre>
       * Error table partition expiration in days. Only positive values are
       * allowed.
       * </pre>
       *
       * <code>int32 retention_days = 2;</code>
       *
       * @return The retentionDays.
       */
      @java.lang.Override
      public int getRetentionDays() {
        return retentionDays_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getTarget());
        }
        if (retentionDays_ != 0) {
          output.writeInt32(2, retentionDays_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTarget());
        }
        if (retentionDays_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, retentionDays_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable
            other =
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionErrorTable)
                    obj;

        if (hasTarget() != other.hasTarget()) return false;
        if (hasTarget()) {
          if (!getTarget().equals(other.getTarget())) return false;
        }
        if (getRetentionDays() != other.getRetentionDays()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTarget()) {
          hash = (37 * hash) + TARGET_FIELD_NUMBER;
          hash = (53 * hash) + getTarget().hashCode();
        }
        hash = (37 * hash) + RETENTION_DAYS_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionDays();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionErrorTable
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Error table information, used to write error data into a BigQuery
       * table.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable)
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTableOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionErrorTable_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionErrorTable_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionErrorTable.class,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionErrorTable.Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getTargetFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          target_ = null;
          if (targetBuilder_ != null) {
            targetBuilder_.dispose();
            targetBuilder_ = null;
          }
          retentionDays_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionErrorTable_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable
            build() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionErrorTable
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable
            buildPartial() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionErrorTable
              result =
                  new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionErrorTable(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.target_ = targetBuilder_ == null ? target_ : targetBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.retentionDays_ = retentionDays_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionErrorTable) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionErrorTable)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionErrorTable
                other) {
          if (other
              == com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionErrorTable.getDefaultInstance()) return this;
          if (other.hasTarget()) {
            mergeTarget(other.getTarget());
          }
          if (other.getRetentionDays() != 0) {
            setRetentionDays(other.getRetentionDays());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getTargetFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    retentionDays_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.dataform.v1.Target target_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>
            targetBuilder_;

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         *
         * @return Whether the target field is set.
         */
        public boolean hasTarget() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         *
         * @return The target.
         */
        public com.google.cloud.dataform.v1.Target getTarget() {
          if (targetBuilder_ == null) {
            return target_ == null
                ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
                : target_;
          } else {
            return targetBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder setTarget(com.google.cloud.dataform.v1.Target value) {
          if (targetBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            target_ = value;
          } else {
            targetBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder setTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
          if (targetBuilder_ == null) {
            target_ = builderForValue.build();
          } else {
            targetBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder mergeTarget(com.google.cloud.dataform.v1.Target value) {
          if (targetBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && target_ != null
                && target_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
              getTargetBuilder().mergeFrom(value);
            } else {
              target_ = value;
            }
          } else {
            targetBuilder_.mergeFrom(value);
          }
          if (target_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder clearTarget() {
          bitField0_ = (bitField0_ & ~0x00000001);
          target_ = null;
          if (targetBuilder_ != null) {
            targetBuilder_.dispose();
            targetBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public com.google.cloud.dataform.v1.Target.Builder getTargetBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getTargetFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
          if (targetBuilder_ != null) {
            return targetBuilder_.getMessageOrBuilder();
          } else {
            return target_ == null
                ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
                : target_;
          }
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>
            getTargetFieldBuilder() {
          if (targetBuilder_ == null) {
            targetBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.Target,
                    com.google.cloud.dataform.v1.Target.Builder,
                    com.google.cloud.dataform.v1.TargetOrBuilder>(
                    getTarget(), getParentForChildren(), isClean());
            target_ = null;
          }
          return targetBuilder_;
        }

        private int retentionDays_;

        /**
         *
         *
         * <pre>
         * Error table partition expiration in days. Only positive values are
         * allowed.
         * </pre>
         *
         * <code>int32 retention_days = 2;</code>
         *
         * @return The retentionDays.
         */
        @java.lang.Override
        public int getRetentionDays() {
          return retentionDays_;
        }

        /**
         *
         *
         * <pre>
         * Error table partition expiration in days. Only positive values are
         * allowed.
         * </pre>
         *
         * <code>int32 retention_days = 2;</code>
         *
         * @param value The retentionDays to set.
         * @return This builder for chaining.
         */
        public Builder setRetentionDays(int value) {

          retentionDays_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table partition expiration in days. Only positive values are
         * allowed.
         * </pre>
         *
         * <code>int32 retention_days = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRetentionDays() {
          bitField0_ = (bitField0_ & ~0x00000002);
          retentionDays_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionErrorTable)
      private static final com.google.cloud.dataform.v1.WorkflowInvocationAction
              .DataPreparationAction.ActionErrorTable
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionErrorTable();
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActionErrorTable> PARSER =
          new com.google.protobuf.AbstractParser<ActionErrorTable>() {
            @java.lang.Override
            public ActionErrorTable parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActionErrorTable> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActionErrorTable> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionErrorTable
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ActionLoadConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
       * </code>
       *
       * @return Whether the replace field is set.
       */
      boolean hasReplace();

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
       * </code>
       *
       * @return The replace.
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          getReplace();

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
       * </code>
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadModeOrBuilder
          getReplaceOrBuilder();

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
       * </code>
       *
       * @return Whether the append field is set.
       */
      boolean hasAppend();

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
       * </code>
       *
       * @return The append.
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          getAppend();

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
       * </code>
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadModeOrBuilder
          getAppendOrBuilder();

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for
       * a column in the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
       * </code>
       *
       * @return Whether the maximum field is set.
       */
      boolean hasMaximum();

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for
       * a column in the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
       * </code>
       *
       * @return The maximum.
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          getMaximum();

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for
       * a column in the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
       * </code>
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadModeOrBuilder
          getMaximumOrBuilder();

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
       * </code>
       *
       * @return Whether the unique field is set.
       */
      boolean hasUnique();

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
       * </code>
       *
       * @return The unique.
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          getUnique();

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
       * </code>
       */
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadModeOrBuilder
          getUniqueOrBuilder();

      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig
              .ModeCase
          getModeCase();
    }

    /**
     *
     *
     * <pre>
     * Simplified load configuration for actions
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig}
     */
    public static final class ActionLoadConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig)
        ActionLoadConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ActionLoadConfig.newBuilder() to construct.
      private ActionLoadConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActionLoadConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActionLoadConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionLoadConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionLoadConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig.Builder.class);
      }

      private int modeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object mode_;

      public enum ModeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        REPLACE(1),
        APPEND(2),
        MAXIMUM(3),
        UNIQUE(4),
        MODE_NOT_SET(0);
        private final int value;

        private ModeCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ModeCase valueOf(int value) {
          return forNumber(value);
        }

        public static ModeCase forNumber(int value) {
          switch (value) {
            case 1:
              return REPLACE;
            case 2:
              return APPEND;
            case 3:
              return MAXIMUM;
            case 4:
              return UNIQUE;
            case 0:
              return MODE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ModeCase getModeCase() {
        return ModeCase.forNumber(modeCase_);
      }

      public static final int REPLACE_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
       * </code>
       *
       * @return Whether the replace field is set.
       */
      @java.lang.Override
      public boolean hasReplace() {
        return modeCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
       * </code>
       *
       * @return The replace.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          getReplace() {
        if (modeCase_ == 1) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSimpleLoadMode.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadModeOrBuilder
          getReplaceOrBuilder() {
        if (modeCase_ == 1) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSimpleLoadMode.getDefaultInstance();
      }

      public static final int APPEND_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
       * </code>
       *
       * @return Whether the append field is set.
       */
      @java.lang.Override
      public boolean hasAppend() {
        return modeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
       * </code>
       *
       * @return The append.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          getAppend() {
        if (modeCase_ == 2) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSimpleLoadMode.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadModeOrBuilder
          getAppendOrBuilder() {
        if (modeCase_ == 2) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSimpleLoadMode.getDefaultInstance();
      }

      public static final int MAXIMUM_FIELD_NUMBER = 3;

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for
       * a column in the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
       * </code>
       *
       * @return Whether the maximum field is set.
       */
      @java.lang.Override
      public boolean hasMaximum() {
        return modeCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for
       * a column in the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
       * </code>
       *
       * @return The maximum.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          getMaximum() {
        if (modeCase_ == 3) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionIncrementalLoadMode.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for
       * a column in the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadModeOrBuilder
          getMaximumOrBuilder() {
        if (modeCase_ == 3) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionIncrementalLoadMode.getDefaultInstance();
      }

      public static final int UNIQUE_FIELD_NUMBER = 4;

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
       * </code>
       *
       * @return Whether the unique field is set.
       */
      @java.lang.Override
      public boolean hasUnique() {
        return modeCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
       * </code>
       *
       * @return The unique.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          getUnique() {
        if (modeCase_ == 4) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionIncrementalLoadMode.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadModeOrBuilder
          getUniqueOrBuilder() {
        if (modeCase_ == 4) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode)
              mode_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionIncrementalLoadMode.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (modeCase_ == 1) {
          output.writeMessage(
              1,
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode)
                  mode_);
        }
        if (modeCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode)
                  mode_);
        }
        if (modeCase_ == 3) {
          output.writeMessage(
              3,
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode)
                  mode_);
        }
        if (modeCase_ == 4) {
          output.writeMessage(
              4,
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode)
                  mode_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (modeCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1,
                  (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                          .ActionSimpleLoadMode)
                      mode_);
        }
        if (modeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                          .ActionSimpleLoadMode)
                      mode_);
        }
        if (modeCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                          .ActionIncrementalLoadMode)
                      mode_);
        }
        if (modeCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4,
                  (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                          .ActionIncrementalLoadMode)
                      mode_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig
            other =
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionLoadConfig)
                    obj;

        if (!getModeCase().equals(other.getModeCase())) return false;
        switch (modeCase_) {
          case 1:
            if (!getReplace().equals(other.getReplace())) return false;
            break;
          case 2:
            if (!getAppend().equals(other.getAppend())) return false;
            break;
          case 3:
            if (!getMaximum().equals(other.getMaximum())) return false;
            break;
          case 4:
            if (!getUnique().equals(other.getUnique())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (modeCase_) {
          case 1:
            hash = (37 * hash) + REPLACE_FIELD_NUMBER;
            hash = (53 * hash) + getReplace().hashCode();
            break;
          case 2:
            hash = (37 * hash) + APPEND_FIELD_NUMBER;
            hash = (53 * hash) + getAppend().hashCode();
            break;
          case 3:
            hash = (37 * hash) + MAXIMUM_FIELD_NUMBER;
            hash = (53 * hash) + getMaximum().hashCode();
            break;
          case 4:
            hash = (37 * hash) + UNIQUE_FIELD_NUMBER;
            hash = (53 * hash) + getUnique().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionLoadConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Simplified load configuration for actions
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig)
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionLoadConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionLoadConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionLoadConfig.class,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionLoadConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (replaceBuilder_ != null) {
            replaceBuilder_.clear();
          }
          if (appendBuilder_ != null) {
            appendBuilder_.clear();
          }
          if (maximumBuilder_ != null) {
            maximumBuilder_.clear();
          }
          if (uniqueBuilder_ != null) {
            uniqueBuilder_.clear();
          }
          modeCase_ = 0;
          mode_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionLoadConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig
            build() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionLoadConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig
            buildPartial() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionLoadConfig
              result =
                  new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionLoadConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig
                result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig
                result) {
          result.modeCase_ = modeCase_;
          result.mode_ = this.mode_;
          if (modeCase_ == 1 && replaceBuilder_ != null) {
            result.mode_ = replaceBuilder_.build();
          }
          if (modeCase_ == 2 && appendBuilder_ != null) {
            result.mode_ = appendBuilder_.build();
          }
          if (modeCase_ == 3 && maximumBuilder_ != null) {
            result.mode_ = maximumBuilder_.build();
          }
          if (modeCase_ == 4 && uniqueBuilder_ != null) {
            result.mode_ = uniqueBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionLoadConfig) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionLoadConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionLoadConfig
                other) {
          if (other
              == com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionLoadConfig.getDefaultInstance()) return this;
          switch (other.getModeCase()) {
            case REPLACE:
              {
                mergeReplace(other.getReplace());
                break;
              }
            case APPEND:
              {
                mergeAppend(other.getAppend());
                break;
              }
            case MAXIMUM:
              {
                mergeMaximum(other.getMaximum());
                break;
              }
            case UNIQUE:
              {
                mergeUnique(other.getUnique());
                break;
              }
            case MODE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getReplaceFieldBuilder().getBuilder(), extensionRegistry);
                    modeCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getAppendFieldBuilder().getBuilder(), extensionRegistry);
                    modeCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getMaximumFieldBuilder().getBuilder(), extensionRegistry);
                    modeCase_ = 3;
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(getUniqueFieldBuilder().getBuilder(), extensionRegistry);
                    modeCase_ = 4;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int modeCase_ = 0;
        private java.lang.Object mode_;

        public ModeCase getModeCase() {
          return ModeCase.forNumber(modeCase_);
        }

        public Builder clearMode() {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadModeOrBuilder>
            replaceBuilder_;

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         *
         * @return Whether the replace field is set.
         */
        @java.lang.Override
        public boolean hasReplace() {
          return modeCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         *
         * @return The replace.
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode
            getReplace() {
          if (replaceBuilder_ == null) {
            if (modeCase_ == 1) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.getDefaultInstance();
          } else {
            if (modeCase_ == 1) {
              return replaceBuilder_.getMessage();
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        public Builder setReplace(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode
                value) {
          if (replaceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            mode_ = value;
            onChanged();
          } else {
            replaceBuilder_.setMessage(value);
          }
          modeCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        public Builder setReplace(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder
                builderForValue) {
          if (replaceBuilder_ == null) {
            mode_ = builderForValue.build();
            onChanged();
          } else {
            replaceBuilder_.setMessage(builderForValue.build());
          }
          modeCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        public Builder mergeReplace(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode
                value) {
          if (replaceBuilder_ == null) {
            if (modeCase_ == 1
                && mode_
                    != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode.getDefaultInstance()) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode.newBuilder(
                          (com.google.cloud.dataform.v1.WorkflowInvocationAction
                                  .DataPreparationAction.ActionSimpleLoadMode)
                              mode_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              mode_ = value;
            }
            onChanged();
          } else {
            if (modeCase_ == 1) {
              replaceBuilder_.mergeFrom(value);
            } else {
              replaceBuilder_.setMessage(value);
            }
          }
          modeCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        public Builder clearReplace() {
          if (replaceBuilder_ == null) {
            if (modeCase_ == 1) {
              modeCase_ = 0;
              mode_ = null;
              onChanged();
            }
          } else {
            if (modeCase_ == 1) {
              modeCase_ = 0;
              mode_ = null;
            }
            replaceBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.Builder
            getReplaceBuilder() {
          return getReplaceFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadModeOrBuilder
            getReplaceOrBuilder() {
          if ((modeCase_ == 1) && (replaceBuilder_ != null)) {
            return replaceBuilder_.getMessageOrBuilder();
          } else {
            if (modeCase_ == 1) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Replace destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode replace = 1;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadModeOrBuilder>
            getReplaceFieldBuilder() {
          if (replaceBuilder_ == null) {
            if (!(modeCase_ == 1)) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode.getDefaultInstance();
            }
            replaceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode.Builder,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadModeOrBuilder>(
                    (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                            .ActionSimpleLoadMode)
                        mode_,
                    getParentForChildren(),
                    isClean());
            mode_ = null;
          }
          modeCase_ = 1;
          onChanged();
          return replaceBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadModeOrBuilder>
            appendBuilder_;

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         *
         * @return Whether the append field is set.
         */
        @java.lang.Override
        public boolean hasAppend() {
          return modeCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         *
         * @return The append.
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode
            getAppend() {
          if (appendBuilder_ == null) {
            if (modeCase_ == 2) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.getDefaultInstance();
          } else {
            if (modeCase_ == 2) {
              return appendBuilder_.getMessage();
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        public Builder setAppend(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode
                value) {
          if (appendBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            mode_ = value;
            onChanged();
          } else {
            appendBuilder_.setMessage(value);
          }
          modeCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        public Builder setAppend(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder
                builderForValue) {
          if (appendBuilder_ == null) {
            mode_ = builderForValue.build();
            onChanged();
          } else {
            appendBuilder_.setMessage(builderForValue.build());
          }
          modeCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        public Builder mergeAppend(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode
                value) {
          if (appendBuilder_ == null) {
            if (modeCase_ == 2
                && mode_
                    != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode.getDefaultInstance()) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode.newBuilder(
                          (com.google.cloud.dataform.v1.WorkflowInvocationAction
                                  .DataPreparationAction.ActionSimpleLoadMode)
                              mode_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              mode_ = value;
            }
            onChanged();
          } else {
            if (modeCase_ == 2) {
              appendBuilder_.mergeFrom(value);
            } else {
              appendBuilder_.setMessage(value);
            }
          }
          modeCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        public Builder clearAppend() {
          if (appendBuilder_ == null) {
            if (modeCase_ == 2) {
              modeCase_ = 0;
              mode_ = null;
              onChanged();
            }
          } else {
            if (modeCase_ == 2) {
              modeCase_ = 0;
              mode_ = null;
            }
            appendBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.Builder
            getAppendBuilder() {
          return getAppendFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadModeOrBuilder
            getAppendOrBuilder() {
          if ((modeCase_ == 2) && (appendBuilder_ != null)) {
            return appendBuilder_.getMessageOrBuilder();
          } else {
            if (modeCase_ == 2) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Append into destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode append = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadModeOrBuilder>
            getAppendFieldBuilder() {
          if (appendBuilder_ == null) {
            if (!(modeCase_ == 2)) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode.getDefaultInstance();
            }
            appendBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode.Builder,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadModeOrBuilder>(
                    (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                            .ActionSimpleLoadMode)
                        mode_,
                    getParentForChildren(),
                    isClean());
            mode_ = null;
          }
          modeCase_ = 2;
          onChanged();
          return appendBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadModeOrBuilder>
            maximumBuilder_;

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         *
         * @return Whether the maximum field is set.
         */
        @java.lang.Override
        public boolean hasMaximum() {
          return modeCase_ == 3;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         *
         * @return The maximum.
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode
            getMaximum() {
          if (maximumBuilder_ == null) {
            if (modeCase_ == 3) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.getDefaultInstance();
          } else {
            if (modeCase_ == 3) {
              return maximumBuilder_.getMessage();
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        public Builder setMaximum(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode
                value) {
          if (maximumBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            mode_ = value;
            onChanged();
          } else {
            maximumBuilder_.setMessage(value);
          }
          modeCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        public Builder setMaximum(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder
                builderForValue) {
          if (maximumBuilder_ == null) {
            mode_ = builderForValue.build();
            onChanged();
          } else {
            maximumBuilder_.setMessage(builderForValue.build());
          }
          modeCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        public Builder mergeMaximum(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode
                value) {
          if (maximumBuilder_ == null) {
            if (modeCase_ == 3
                && mode_
                    != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode.getDefaultInstance()) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode.newBuilder(
                          (com.google.cloud.dataform.v1.WorkflowInvocationAction
                                  .DataPreparationAction.ActionIncrementalLoadMode)
                              mode_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              mode_ = value;
            }
            onChanged();
          } else {
            if (modeCase_ == 3) {
              maximumBuilder_.mergeFrom(value);
            } else {
              maximumBuilder_.setMessage(value);
            }
          }
          modeCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        public Builder clearMaximum() {
          if (maximumBuilder_ == null) {
            if (modeCase_ == 3) {
              modeCase_ = 0;
              mode_ = null;
              onChanged();
            }
          } else {
            if (modeCase_ == 3) {
              modeCase_ = 0;
              mode_ = null;
            }
            maximumBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.Builder
            getMaximumBuilder() {
          return getMaximumFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadModeOrBuilder
            getMaximumOrBuilder() {
          if ((modeCase_ == 3) && (maximumBuilder_ != null)) {
            return maximumBuilder_.getMessageOrBuilder();
          } else {
            if (modeCase_ == 3) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value exceeds the previous maximum value for
         * a column in the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode maximum = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadModeOrBuilder>
            getMaximumFieldBuilder() {
          if (maximumBuilder_ == null) {
            if (!(modeCase_ == 3)) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode.getDefaultInstance();
            }
            maximumBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode.Builder,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadModeOrBuilder>(
                    (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                            .ActionIncrementalLoadMode)
                        mode_,
                    getParentForChildren(),
                    isClean());
            mode_ = null;
          }
          modeCase_ = 3;
          onChanged();
          return maximumBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadModeOrBuilder>
            uniqueBuilder_;

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         *
         * @return Whether the unique field is set.
         */
        @java.lang.Override
        public boolean hasUnique() {
          return modeCase_ == 4;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         *
         * @return The unique.
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode
            getUnique() {
          if (uniqueBuilder_ == null) {
            if (modeCase_ == 4) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.getDefaultInstance();
          } else {
            if (modeCase_ == 4) {
              return uniqueBuilder_.getMessage();
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        public Builder setUnique(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode
                value) {
          if (uniqueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            mode_ = value;
            onChanged();
          } else {
            uniqueBuilder_.setMessage(value);
          }
          modeCase_ = 4;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        public Builder setUnique(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder
                builderForValue) {
          if (uniqueBuilder_ == null) {
            mode_ = builderForValue.build();
            onChanged();
          } else {
            uniqueBuilder_.setMessage(builderForValue.build());
          }
          modeCase_ = 4;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        public Builder mergeUnique(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode
                value) {
          if (uniqueBuilder_ == null) {
            if (modeCase_ == 4
                && mode_
                    != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode.getDefaultInstance()) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode.newBuilder(
                          (com.google.cloud.dataform.v1.WorkflowInvocationAction
                                  .DataPreparationAction.ActionIncrementalLoadMode)
                              mode_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              mode_ = value;
            }
            onChanged();
          } else {
            if (modeCase_ == 4) {
              uniqueBuilder_.mergeFrom(value);
            } else {
              uniqueBuilder_.setMessage(value);
            }
          }
          modeCase_ = 4;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        public Builder clearUnique() {
          if (uniqueBuilder_ == null) {
            if (modeCase_ == 4) {
              modeCase_ = 0;
              mode_ = null;
              onChanged();
            }
          } else {
            if (modeCase_ == 4) {
              modeCase_ = 0;
              mode_ = null;
            }
            uniqueBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.Builder
            getUniqueBuilder() {
          return getUniqueFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadModeOrBuilder
            getUniqueOrBuilder() {
          if ((modeCase_ == 4) && (uniqueBuilder_ != null)) {
            return uniqueBuilder_.getMessageOrBuilder();
          } else {
            if (modeCase_ == 4) {
              return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode)
                  mode_;
            }
            return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Insert records where the value of a column is not already present in
         * the destination table
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode unique = 4;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadModeOrBuilder>
            getUniqueFieldBuilder() {
          if (uniqueBuilder_ == null) {
            if (!(modeCase_ == 4)) {
              mode_ =
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode.getDefaultInstance();
            }
            uniqueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode.Builder,
                    com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadModeOrBuilder>(
                    (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                            .ActionIncrementalLoadMode)
                        mode_,
                    getParentForChildren(),
                    isClean());
            mode_ = null;
          }
          modeCase_ = 4;
          onChanged();
          return uniqueBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionLoadConfig)
      private static final com.google.cloud.dataform.v1.WorkflowInvocationAction
              .DataPreparationAction.ActionLoadConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionLoadConfig();
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActionLoadConfig> PARSER =
          new com.google.protobuf.AbstractParser<ActionLoadConfig>() {
            @java.lang.Override
            public ActionLoadConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActionLoadConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActionLoadConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionLoadConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ActionSimpleLoadModeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Simple load definition
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode}
     */
    public static final class ActionSimpleLoadMode extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode)
        ActionSimpleLoadModeOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ActionSimpleLoadMode.newBuilder() to construct.
      private ActionSimpleLoadMode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActionSimpleLoadMode() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActionSimpleLoadMode();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSimpleLoadMode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSimpleLoadMode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode
            other =
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode)
                    obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Simple load definition
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode)
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadModeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSimpleLoadMode_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSimpleLoadMode_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode.class,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode.Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionSimpleLoadMode_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode
            build() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode
            buildPartial() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode
              result =
                  new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSimpleLoadMode(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSimpleLoadMode)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSimpleLoadMode
                other) {
          if (other
              == com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSimpleLoadMode.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSimpleLoadMode)
      private static final com.google.cloud.dataform.v1.WorkflowInvocationAction
              .DataPreparationAction.ActionSimpleLoadMode
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSimpleLoadMode();
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActionSimpleLoadMode> PARSER =
          new com.google.protobuf.AbstractParser<ActionSimpleLoadMode>() {
            @java.lang.Override
            public ActionSimpleLoadMode parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActionSimpleLoadMode> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActionSimpleLoadMode> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSimpleLoadMode
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ActionIncrementalLoadModeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return The column.
       */
      java.lang.String getColumn();

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return The bytes for column.
       */
      com.google.protobuf.ByteString getColumnBytes();
    }

    /**
     *
     *
     * <pre>
     * Load definition for incremental load modes
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode}
     */
    public static final class ActionIncrementalLoadMode
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode)
        ActionIncrementalLoadModeOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ActionIncrementalLoadMode.newBuilder() to construct.
      private ActionIncrementalLoadMode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ActionIncrementalLoadMode() {
        column_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ActionIncrementalLoadMode();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionIncrementalLoadMode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionIncrementalLoadMode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode.Builder.class);
      }

      public static final int COLUMN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object column_ = "";

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return The column.
       */
      @java.lang.Override
      public java.lang.String getColumn() {
        java.lang.Object ref = column_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          column_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return The bytes for column.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getColumnBytes() {
        java.lang.Object ref = column_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          column_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, column_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, column_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode
            other =
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode)
                    obj;

        if (!getColumn().equals(other.getColumn())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + getColumn().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Load definition for incremental load modes
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode)
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadModeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionIncrementalLoadMode_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionIncrementalLoadMode_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode.class,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode.Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          column_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_ActionIncrementalLoadMode_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode
            build() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode
            buildPartial() {
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode
              result =
                  new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionIncrementalLoadMode(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.column_ = column_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionIncrementalLoadMode)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionIncrementalLoadMode
                other) {
          if (other
              == com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionIncrementalLoadMode.getDefaultInstance()) return this;
          if (!other.getColumn().isEmpty()) {
            column_ = other.column_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    column_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object column_ = "";

        /**
         *
         *
         * <pre>
         * Column name for incremental load modes
         * </pre>
         *
         * <code>string column = 1;</code>
         *
         * @return The column.
         */
        public java.lang.String getColumn() {
          java.lang.Object ref = column_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            column_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Column name for incremental load modes
         * </pre>
         *
         * <code>string column = 1;</code>
         *
         * @return The bytes for column.
         */
        public com.google.protobuf.ByteString getColumnBytes() {
          java.lang.Object ref = column_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            column_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Column name for incremental load modes
         * </pre>
         *
         * <code>string column = 1;</code>
         *
         * @param value The column to set.
         * @return This builder for chaining.
         */
        public Builder setColumn(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          column_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Column name for incremental load modes
         * </pre>
         *
         * <code>string column = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearColumn() {
          column_ = getDefaultInstance().getColumn();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Column name for incremental load modes
         * </pre>
         *
         * <code>string column = 1;</code>
         *
         * @param value The bytes for column to set.
         * @return This builder for chaining.
         */
        public Builder setColumnBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          column_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionIncrementalLoadMode)
      private static final com.google.cloud.dataform.v1.WorkflowInvocationAction
              .DataPreparationAction.ActionIncrementalLoadMode
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionIncrementalLoadMode();
      }

      public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ActionIncrementalLoadMode> PARSER =
          new com.google.protobuf.AbstractParser<ActionIncrementalLoadMode>() {
            @java.lang.Override
            public ActionIncrementalLoadMode parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ActionIncrementalLoadMode> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ActionIncrementalLoadMode> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionIncrementalLoadMode
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int definitionCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object definition_;

    public enum DefinitionCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONTENTS_YAML(2),
      CONTENTS_SQL(6),
      DEFINITION_NOT_SET(0);
      private final int value;

      private DefinitionCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DefinitionCase valueOf(int value) {
        return forNumber(value);
      }

      public static DefinitionCase forNumber(int value) {
        switch (value) {
          case 2:
            return CONTENTS_YAML;
          case 6:
            return CONTENTS_SQL;
          case 0:
            return DEFINITION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DefinitionCase getDefinitionCase() {
      return DefinitionCase.forNumber(definitionCase_);
    }

    public static final int CONTENTS_YAML_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Output only. YAML representing the contents of the data preparation.
     * Can be used to show the customer what the input was to their workflow.
     * </pre>
     *
     * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the contentsYaml field is set.
     */
    public boolean hasContentsYaml() {
      return definitionCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Output only. YAML representing the contents of the data preparation.
     * Can be used to show the customer what the input was to their workflow.
     * </pre>
     *
     * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The contentsYaml.
     */
    public java.lang.String getContentsYaml() {
      java.lang.Object ref = "";
      if (definitionCase_ == 2) {
        ref = definition_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (definitionCase_ == 2) {
          definition_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. YAML representing the contents of the data preparation.
     * Can be used to show the customer what the input was to their workflow.
     * </pre>
     *
     * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for contentsYaml.
     */
    public com.google.protobuf.ByteString getContentsYamlBytes() {
      java.lang.Object ref = "";
      if (definitionCase_ == 2) {
        ref = definition_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (definitionCase_ == 2) {
          definition_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENTS_SQL_FIELD_NUMBER = 6;

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
     * </code>
     *
     * @return Whether the contentsSql field is set.
     */
    @java.lang.Override
    public boolean hasContentsSql() {
      return definitionCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
     * </code>
     *
     * @return The contentsSql.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSqlDefinition
        getContentsSql() {
      if (definitionCase_ == 6) {
        return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition)
            definition_;
      }
      return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
          .ActionSqlDefinition.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .ActionSqlDefinitionOrBuilder
        getContentsSqlOrBuilder() {
      if (definitionCase_ == 6) {
        return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .ActionSqlDefinition)
            definition_;
      }
      return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
          .ActionSqlDefinition.getDefaultInstance();
    }

    public static final int GENERATED_SQL_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object generatedSql_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed. For
     * reference only.
     * </pre>
     *
     * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generatedSql.
     */
    @java.lang.Override
    public java.lang.String getGeneratedSql() {
      java.lang.Object ref = generatedSql_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        generatedSql_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The generated BigQuery SQL script that will be executed. For
     * reference only.
     * </pre>
     *
     * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for generatedSql.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGeneratedSqlBytes() {
      java.lang.Object ref = generatedSql_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        generatedSql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int JOB_ID_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object jobId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    @java.lang.Override
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the BigQuery job that executed the SQL in
     * sql_script. Only set once the job has started to run.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (definitionCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, definition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatedSql_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, generatedSql_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jobId_);
      }
      if (definitionCase_ == 6) {
        output.writeMessage(
            6,
            (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition)
                definition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (definitionCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, definition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatedSql_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, generatedSql_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, jobId_);
      }
      if (definitionCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6,
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                        .ActionSqlDefinition)
                    definition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction other =
          (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction) obj;

      if (!getGeneratedSql().equals(other.getGeneratedSql())) return false;
      if (!getJobId().equals(other.getJobId())) return false;
      if (!getDefinitionCase().equals(other.getDefinitionCase())) return false;
      switch (definitionCase_) {
        case 2:
          if (!getContentsYaml().equals(other.getContentsYaml())) return false;
          break;
        case 6:
          if (!getContentsSql().equals(other.getContentsSql())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GENERATED_SQL_FIELD_NUMBER;
      hash = (53 * hash) + getGeneratedSql().hashCode();
      hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
      hash = (53 * hash) + getJobId().hashCode();
      switch (definitionCase_) {
        case 2:
          hash = (37 * hash) + CONTENTS_YAML_FIELD_NUMBER;
          hash = (53 * hash) + getContentsYaml().hashCode();
          break;
        case 6:
          hash = (37 * hash) + CONTENTS_SQL_FIELD_NUMBER;
          hash = (53 * hash) + getContentsSql().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a workflow action that will run a Data Preparation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.class,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (contentsSqlBuilder_ != null) {
          contentsSqlBuilder_.clear();
        }
        generatedSql_ = "";
        jobId_ = "";
        definitionCase_ = 0;
        definition_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_DataPreparationAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction build() {
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
          buildPartial() {
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction result =
            new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.generatedSql_ = generatedSql_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.jobId_ = jobId_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction result) {
        result.definitionCase_ = definitionCase_;
        result.definition_ = this.definition_;
        if (definitionCase_ == 6 && contentsSqlBuilder_ != null) {
          result.definition_ = contentsSqlBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction other) {
        if (other
            == com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                .getDefaultInstance()) return this;
        if (!other.getGeneratedSql().isEmpty()) {
          generatedSql_ = other.generatedSql_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getJobId().isEmpty()) {
          jobId_ = other.jobId_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        switch (other.getDefinitionCase()) {
          case CONTENTS_YAML:
            {
              definitionCase_ = 2;
              definition_ = other.definition_;
              onChanged();
              break;
            }
          case CONTENTS_SQL:
            {
              mergeContentsSql(other.getContentsSql());
              break;
            }
          case DEFINITION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  definitionCase_ = 2;
                  definition_ = s;
                  break;
                } // case 18
              case 26:
                {
                  generatedSql_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  jobId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 50:
                {
                  input.readMessage(getContentsSqlFieldBuilder().getBuilder(), extensionRegistry);
                  definitionCase_ = 6;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int definitionCase_ = 0;
      private java.lang.Object definition_;

      public DefinitionCase getDefinitionCase() {
        return DefinitionCase.forNumber(definitionCase_);
      }

      public Builder clearDefinition() {
        definitionCase_ = 0;
        definition_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Output only. YAML representing the contents of the data preparation.
       * Can be used to show the customer what the input was to their workflow.
       * </pre>
       *
       * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the contentsYaml field is set.
       */
      @java.lang.Override
      public boolean hasContentsYaml() {
        return definitionCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Output only. YAML representing the contents of the data preparation.
       * Can be used to show the customer what the input was to their workflow.
       * </pre>
       *
       * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The contentsYaml.
       */
      @java.lang.Override
      public java.lang.String getContentsYaml() {
        java.lang.Object ref = "";
        if (definitionCase_ == 2) {
          ref = definition_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (definitionCase_ == 2) {
            definition_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. YAML representing the contents of the data preparation.
       * Can be used to show the customer what the input was to their workflow.
       * </pre>
       *
       * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for contentsYaml.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContentsYamlBytes() {
        java.lang.Object ref = "";
        if (definitionCase_ == 2) {
          ref = definition_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (definitionCase_ == 2) {
            definition_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. YAML representing the contents of the data preparation.
       * Can be used to show the customer what the input was to their workflow.
       * </pre>
       *
       * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The contentsYaml to set.
       * @return This builder for chaining.
       */
      public Builder setContentsYaml(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        definitionCase_ = 2;
        definition_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. YAML representing the contents of the data preparation.
       * Can be used to show the customer what the input was to their workflow.
       * </pre>
       *
       * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentsYaml() {
        if (definitionCase_ == 2) {
          definitionCase_ = 0;
          definition_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. YAML representing the contents of the data preparation.
       * Can be used to show the customer what the input was to their workflow.
       * </pre>
       *
       * <code>string contents_yaml = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for contentsYaml to set.
       * @return This builder for chaining.
       */
      public Builder setContentsYamlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        definitionCase_ = 2;
        definition_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition.Builder,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinitionOrBuilder>
          contentsSqlBuilder_;

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       *
       * @return Whether the contentsSql field is set.
       */
      @java.lang.Override
      public boolean hasContentsSql() {
        return definitionCase_ == 6;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       *
       * @return The contentsSql.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition
          getContentsSql() {
        if (contentsSqlBuilder_ == null) {
          if (definitionCase_ == 6) {
            return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition)
                definition_;
          }
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition.getDefaultInstance();
        } else {
          if (definitionCase_ == 6) {
            return contentsSqlBuilder_.getMessage();
          }
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder setContentsSql(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition
              value) {
        if (contentsSqlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          definition_ = value;
          onChanged();
        } else {
          contentsSqlBuilder_.setMessage(value);
        }
        definitionCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder setContentsSql(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition.Builder
              builderForValue) {
        if (contentsSqlBuilder_ == null) {
          definition_ = builderForValue.build();
          onChanged();
        } else {
          contentsSqlBuilder_.setMessage(builderForValue.build());
        }
        definitionCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder mergeContentsSql(
          com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition
              value) {
        if (contentsSqlBuilder_ == null) {
          if (definitionCase_ == 6
              && definition_
                  != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinition.getDefaultInstance()) {
            definition_ =
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition.newBuilder(
                        (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                                .ActionSqlDefinition)
                            definition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            definition_ = value;
          }
          onChanged();
        } else {
          if (definitionCase_ == 6) {
            contentsSqlBuilder_.mergeFrom(value);
          } else {
            contentsSqlBuilder_.setMessage(value);
          }
        }
        definitionCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder clearContentsSql() {
        if (contentsSqlBuilder_ == null) {
          if (definitionCase_ == 6) {
            definitionCase_ = 0;
            definition_ = null;
            onChanged();
          }
        } else {
          if (definitionCase_ == 6) {
            definitionCase_ = 0;
            definition_ = null;
          }
          contentsSqlBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition.Builder
          getContentsSqlBuilder() {
        return getContentsSqlFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinitionOrBuilder
          getContentsSqlOrBuilder() {
        if ((definitionCase_ == 6) && (contentsSqlBuilder_ != null)) {
          return contentsSqlBuilder_.getMessageOrBuilder();
        } else {
          if (definitionCase_ == 6) {
            return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition)
                definition_;
          }
          return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
              .ActionSqlDefinition.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.ActionSqlDefinition contents_sql = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinition.Builder,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .ActionSqlDefinitionOrBuilder>
          getContentsSqlFieldBuilder() {
        if (contentsSqlBuilder_ == null) {
          if (!(definitionCase_ == 6)) {
            definition_ =
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .ActionSqlDefinition.getDefaultInstance();
          }
          contentsSqlBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinition,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinition.Builder,
                  com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                      .ActionSqlDefinitionOrBuilder>(
                  (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                          .ActionSqlDefinition)
                      definition_,
                  getParentForChildren(),
                  isClean());
          definition_ = null;
        }
        definitionCase_ = 6;
        onChanged();
        return contentsSqlBuilder_;
      }

      private java.lang.Object generatedSql_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed. For
       * reference only.
       * </pre>
       *
       * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The generatedSql.
       */
      public java.lang.String getGeneratedSql() {
        java.lang.Object ref = generatedSql_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          generatedSql_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed. For
       * reference only.
       * </pre>
       *
       * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for generatedSql.
       */
      public com.google.protobuf.ByteString getGeneratedSqlBytes() {
        java.lang.Object ref = generatedSql_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          generatedSql_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed. For
       * reference only.
       * </pre>
       *
       * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The generatedSql to set.
       * @return This builder for chaining.
       */
      public Builder setGeneratedSql(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        generatedSql_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed. For
       * reference only.
       * </pre>
       *
       * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGeneratedSql() {
        generatedSql_ = getDefaultInstance().getGeneratedSql();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The generated BigQuery SQL script that will be executed. For
       * reference only.
       * </pre>
       *
       * <code>string generated_sql = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for generatedSql to set.
       * @return This builder for chaining.
       */
      public Builder setGeneratedSqlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        generatedSql_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object jobId_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The jobId.
       */
      public java.lang.String getJobId() {
        java.lang.Object ref = jobId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for jobId.
       */
      public com.google.protobuf.ByteString getJobIdBytes() {
        java.lang.Object ref = jobId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The jobId to set.
       * @return This builder for chaining.
       */
      public Builder setJobId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobId_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobId() {
        jobId_ = getDefaultInstance().getJobId();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The ID of the BigQuery job that executed the SQL in
       * sql_script. Only set once the job has started to run.
       * </pre>
       *
       * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for jobId to set.
       * @return This builder for chaining.
       */
      public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        jobId_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
    private static final com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction();
    }

    public static com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataPreparationAction> PARSER =
        new com.google.protobuf.AbstractParser<DataPreparationAction>() {
          @java.lang.Override
          public DataPreparationAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataPreparationAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataPreparationAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGQUERY_ACTION(6),
    NOTEBOOK_ACTION(8),
    DATA_PREPARATION_ACTION(9),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 6:
          return BIGQUERY_ACTION;
        case 8:
          return NOTEBOOK_ACTION;
        case 9:
          return DATA_PREPARATION_ACTION;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int BIGQUERY_ACTION_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's bigquery action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the bigqueryAction field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryAction() {
    return actionCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's bigquery action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bigqueryAction.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction getBigqueryAction() {
    if (actionCase_ == 6) {
      return (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_;
    }
    return com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's bigquery action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryActionOrBuilder
      getBigqueryActionOrBuilder() {
    if (actionCase_ == 6) {
      return (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_;
    }
    return com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        .getDefaultInstance();
  }

  public static final int NOTEBOOK_ACTION_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's notebook action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the notebookAction field is set.
   */
  @java.lang.Override
  public boolean hasNotebookAction() {
    return actionCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's notebook action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notebookAction.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction getNotebookAction() {
    if (actionCase_ == 8) {
      return (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_;
    }
    return com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's notebook action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookActionOrBuilder
      getNotebookActionOrBuilder() {
    if (actionCase_ == 8) {
      return (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_;
    }
    return com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        .getDefaultInstance();
  }

  public static final int DATA_PREPARATION_ACTION_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's data preparation action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataPreparationAction field is set.
   */
  @java.lang.Override
  public boolean hasDataPreparationAction() {
    return actionCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's data preparation action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataPreparationAction.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
      getDataPreparationAction() {
    if (actionCase_ == 9) {
      return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction) action_;
    }
    return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow action's data preparation action details.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationActionOrBuilder
      getDataPreparationActionOrBuilder() {
    if (actionCase_ == 9) {
      return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction) action_;
    }
    return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        .getDefaultInstance();
  }

  public static final int TARGET_FIELD_NUMBER = 1;
  private com.google.cloud.dataform.v1.Target target_;

  /**
   *
   *
   * <pre>
   * Output only. This action's identifier. Unique within the workflow
   * invocation.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the target field is set.
   */
  @java.lang.Override
  public boolean hasTarget() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. This action's identifier. Unique within the workflow
   * invocation.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The target.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Target getTarget() {
    return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This action's identifier. Unique within the workflow
   * invocation.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
    return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
  }

  public static final int CANONICAL_TARGET_FIELD_NUMBER = 2;
  private com.google.cloud.dataform.v1.Target canonicalTarget_;

  /**
   *
   *
   * <pre>
   * Output only. The action's identifier if the project had been compiled
   * without any overrides configured. Unique within the compilation result.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the canonicalTarget field is set.
   */
  @java.lang.Override
  public boolean hasCanonicalTarget() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The action's identifier if the project had been compiled
   * without any overrides configured. Unique within the compilation result.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The canonicalTarget.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Target getCanonicalTarget() {
    return canonicalTarget_ == null
        ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
        : canonicalTarget_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The action's identifier if the project had been compiled
   * without any overrides configured. Unique within the compilation result.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.TargetOrBuilder getCanonicalTargetOrBuilder() {
    return canonicalTarget_ == null
        ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
        : canonicalTarget_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. This action's current state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This action's current state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction.State getState() {
    com.google.cloud.dataform.v1.WorkflowInvocationAction.State result =
        com.google.cloud.dataform.v1.WorkflowInvocationAction.State.forNumber(state_);
    return result == null
        ? com.google.cloud.dataform.v1.WorkflowInvocationAction.State.UNRECOGNIZED
        : result;
  }

  public static final int FAILURE_REASON_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object failureReason_ = "";

  /**
   *
   *
   * <pre>
   * Output only. If and only if action's state is FAILED a failure reason is
   * set.
   * </pre>
   *
   * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The failureReason.
   */
  @java.lang.Override
  public java.lang.String getFailureReason() {
    java.lang.Object ref = failureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      failureReason_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. If and only if action's state is FAILED a failure reason is
   * set.
   * </pre>
   *
   * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for failureReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFailureReasonBytes() {
    java.lang.Object ref = failureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      failureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVOCATION_TIMING_FIELD_NUMBER = 5;
  private com.google.type.Interval invocationTiming_;

  /**
   *
   *
   * <pre>
   * Output only. This action's timing details.
   * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
   * CANCELLED, FAILED] state.
   * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
   * state.
   * </pre>
   *
   * <code>.google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the invocationTiming field is set.
   */
  @java.lang.Override
  public boolean hasInvocationTiming() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. This action's timing details.
   * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
   * CANCELLED, FAILED] state.
   * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
   * state.
   * </pre>
   *
   * <code>.google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The invocationTiming.
   */
  @java.lang.Override
  public com.google.type.Interval getInvocationTiming() {
    return invocationTiming_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : invocationTiming_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This action's timing details.
   * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
   * CANCELLED, FAILED] state.
   * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
   * state.
   * </pre>
   *
   * <code>.google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.type.IntervalOrBuilder getInvocationTimingOrBuilder() {
    return invocationTiming_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : invocationTiming_;
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTarget());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getCanonicalTarget());
    }
    if (state_ != com.google.cloud.dataform.v1.WorkflowInvocationAction.State.PENDING.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getInvocationTiming());
    }
    if (actionCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, failureReason_);
    }
    if (actionCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_);
    }
    if (actionCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction) action_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTarget());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCanonicalTarget());
    }
    if (state_ != com.google.cloud.dataform.v1.WorkflowInvocationAction.State.PENDING.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInvocationTiming());
    }
    if (actionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, failureReason_);
    }
    if (actionCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_);
    }
    if (actionCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
                  action_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.WorkflowInvocationAction other =
        (com.google.cloud.dataform.v1.WorkflowInvocationAction) obj;

    if (hasTarget() != other.hasTarget()) return false;
    if (hasTarget()) {
      if (!getTarget().equals(other.getTarget())) return false;
    }
    if (hasCanonicalTarget() != other.hasCanonicalTarget()) return false;
    if (hasCanonicalTarget()) {
      if (!getCanonicalTarget().equals(other.getCanonicalTarget())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getFailureReason().equals(other.getFailureReason())) return false;
    if (hasInvocationTiming() != other.hasInvocationTiming()) return false;
    if (hasInvocationTiming()) {
      if (!getInvocationTiming().equals(other.getInvocationTiming())) return false;
    }
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 6:
        if (!getBigqueryAction().equals(other.getBigqueryAction())) return false;
        break;
      case 8:
        if (!getNotebookAction().equals(other.getNotebookAction())) return false;
        break;
      case 9:
        if (!getDataPreparationAction().equals(other.getDataPreparationAction())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTarget()) {
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTarget().hashCode();
    }
    if (hasCanonicalTarget()) {
      hash = (37 * hash) + CANONICAL_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getCanonicalTarget().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getFailureReason().hashCode();
    if (hasInvocationTiming()) {
      hash = (37 * hash) + INVOCATION_TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getInvocationTiming().hashCode();
    }
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    switch (actionCase_) {
      case 6:
        hash = (37 * hash) + BIGQUERY_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryAction().hashCode();
        break;
      case 8:
        hash = (37 * hash) + NOTEBOOK_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getNotebookAction().hashCode();
        break;
      case 9:
        hash = (37 * hash) + DATA_PREPARATION_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getDataPreparationAction().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataform.v1.WorkflowInvocationAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a single action in a workflow invocation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocationAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocationAction)
      com.google.cloud.dataform.v1.WorkflowInvocationActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowInvocationAction.class,
              com.google.cloud.dataform.v1.WorkflowInvocationAction.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.WorkflowInvocationAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTargetFieldBuilder();
        getCanonicalTargetFieldBuilder();
        getInvocationTimingFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigqueryActionBuilder_ != null) {
        bigqueryActionBuilder_.clear();
      }
      if (notebookActionBuilder_ != null) {
        notebookActionBuilder_.clear();
      }
      if (dataPreparationActionBuilder_ != null) {
        dataPreparationActionBuilder_.clear();
      }
      target_ = null;
      if (targetBuilder_ != null) {
        targetBuilder_.dispose();
        targetBuilder_ = null;
      }
      canonicalTarget_ = null;
      if (canonicalTargetBuilder_ != null) {
        canonicalTargetBuilder_.dispose();
        canonicalTargetBuilder_ = null;
      }
      state_ = 0;
      failureReason_ = "";
      invocationTiming_ = null;
      if (invocationTimingBuilder_ != null) {
        invocationTimingBuilder_.dispose();
        invocationTimingBuilder_ = null;
      }
      internalMetadata_ = "";
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocationAction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.WorkflowInvocationAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction build() {
      com.google.cloud.dataform.v1.WorkflowInvocationAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction buildPartial() {
      com.google.cloud.dataform.v1.WorkflowInvocationAction result =
          new com.google.cloud.dataform.v1.WorkflowInvocationAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataform.v1.WorkflowInvocationAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.target_ = targetBuilder_ == null ? target_ : targetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.canonicalTarget_ =
            canonicalTargetBuilder_ == null ? canonicalTarget_ : canonicalTargetBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.failureReason_ = failureReason_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.invocationTiming_ =
            invocationTimingBuilder_ == null ? invocationTiming_ : invocationTimingBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataform.v1.WorkflowInvocationAction result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 6 && bigqueryActionBuilder_ != null) {
        result.action_ = bigqueryActionBuilder_.build();
      }
      if (actionCase_ == 8 && notebookActionBuilder_ != null) {
        result.action_ = notebookActionBuilder_.build();
      }
      if (actionCase_ == 9 && dataPreparationActionBuilder_ != null) {
        result.action_ = dataPreparationActionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.WorkflowInvocationAction) {
        return mergeFrom((com.google.cloud.dataform.v1.WorkflowInvocationAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.WorkflowInvocationAction other) {
      if (other == com.google.cloud.dataform.v1.WorkflowInvocationAction.getDefaultInstance())
        return this;
      if (other.hasTarget()) {
        mergeTarget(other.getTarget());
      }
      if (other.hasCanonicalTarget()) {
        mergeCanonicalTarget(other.getCanonicalTarget());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getFailureReason().isEmpty()) {
        failureReason_ = other.failureReason_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasInvocationTiming()) {
        mergeInvocationTiming(other.getInvocationTiming());
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      switch (other.getActionCase()) {
        case BIGQUERY_ACTION:
          {
            mergeBigqueryAction(other.getBigqueryAction());
            break;
          }
        case NOTEBOOK_ACTION:
          {
            mergeNotebookAction(other.getNotebookAction());
            break;
          }
        case DATA_PREPARATION_ACTION:
          {
            mergeDataPreparationAction(other.getDataPreparationAction());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTargetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCanonicalTargetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getInvocationTimingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBigqueryActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                failureReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getNotebookActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getDataPreparationActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryActionOrBuilder>
        bigqueryActionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the bigqueryAction field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryAction() {
      return actionCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bigqueryAction.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
        getBigqueryAction() {
      if (bigqueryActionBuilder_ == null) {
        if (actionCase_ == 6) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
            .getDefaultInstance();
      } else {
        if (actionCase_ == 6) {
          return bigqueryActionBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction value) {
      if (bigqueryActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        bigqueryActionBuilder_.setMessage(value);
      }
      actionCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder
            builderForValue) {
      if (bigqueryActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeBigqueryAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction value) {
      if (bigqueryActionBuilder_ == null) {
        if (actionCase_ == 6
            && action_
                != com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.newBuilder(
                      (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction)
                          action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 6) {
          bigqueryActionBuilder_.mergeFrom(value);
        } else {
          bigqueryActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBigqueryAction() {
      if (bigqueryActionBuilder_ == null) {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
        }
        bigqueryActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder
        getBigqueryActionBuilder() {
      return getBigqueryActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryActionOrBuilder
        getBigqueryActionOrBuilder() {
      if ((actionCase_ == 6) && (bigqueryActionBuilder_ != null)) {
        return bigqueryActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 6) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's bigquery action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction bigquery_action = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryActionOrBuilder>
        getBigqueryActionFieldBuilder() {
      if (bigqueryActionBuilder_ == null) {
        if (!(actionCase_ == 6)) {
          action_ =
              com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction
                  .getDefaultInstance();
        }
        bigqueryActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryActionOrBuilder>(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.BigQueryAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 6;
      onChanged();
      return bigqueryActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookActionOrBuilder>
        notebookActionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the notebookAction field is set.
     */
    @java.lang.Override
    public boolean hasNotebookAction() {
      return actionCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notebookAction.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
        getNotebookAction() {
      if (notebookActionBuilder_ == null) {
        if (actionCase_ == 8) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
            .getDefaultInstance();
      } else {
        if (actionCase_ == 8) {
          return notebookActionBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotebookAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction value) {
      if (notebookActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        notebookActionBuilder_.setMessage(value);
      }
      actionCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotebookAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder
            builderForValue) {
      if (notebookActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        notebookActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNotebookAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction value) {
      if (notebookActionBuilder_ == null) {
        if (actionCase_ == 8
            && action_
                != com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.newBuilder(
                      (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction)
                          action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 8) {
          notebookActionBuilder_.mergeFrom(value);
        } else {
          notebookActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNotebookAction() {
      if (notebookActionBuilder_ == null) {
        if (actionCase_ == 8) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 8) {
          actionCase_ = 0;
          action_ = null;
        }
        notebookActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder
        getNotebookActionBuilder() {
      return getNotebookActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookActionOrBuilder
        getNotebookActionOrBuilder() {
      if ((actionCase_ == 8) && (notebookActionBuilder_ != null)) {
        return notebookActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 8) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's notebook action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction notebook_action = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookActionOrBuilder>
        getNotebookActionFieldBuilder() {
      if (notebookActionBuilder_ == null) {
        if (!(actionCase_ == 8)) {
          action_ =
              com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction
                  .getDefaultInstance();
        }
        notebookActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookActionOrBuilder>(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.NotebookAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 8;
      onChanged();
      return notebookActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationActionOrBuilder>
        dataPreparationActionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataPreparationAction field is set.
     */
    @java.lang.Override
    public boolean hasDataPreparationAction() {
      return actionCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataPreparationAction.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
        getDataPreparationAction() {
      if (dataPreparationActionBuilder_ == null) {
        if (actionCase_ == 9) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
              action_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .getDefaultInstance();
      } else {
        if (actionCase_ == 9) {
          return dataPreparationActionBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataPreparationAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction value) {
      if (dataPreparationActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        dataPreparationActionBuilder_.setMessage(value);
      }
      actionCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataPreparationAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder
            builderForValue) {
      if (dataPreparationActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        dataPreparationActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataPreparationAction(
        com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction value) {
      if (dataPreparationActionBuilder_ == null) {
        if (actionCase_ == 9
            && action_
                != com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .newBuilder(
                      (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
                          action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 9) {
          dataPreparationActionBuilder_.mergeFrom(value);
        } else {
          dataPreparationActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataPreparationAction() {
      if (dataPreparationActionBuilder_ == null) {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
        }
        dataPreparationActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder
        getDataPreparationActionBuilder() {
      return getDataPreparationActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationActionOrBuilder
        getDataPreparationActionOrBuilder() {
      if ((actionCase_ == 9) && (dataPreparationActionBuilder_ != null)) {
        return dataPreparationActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 9) {
          return (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
              action_;
        }
        return com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow action's data preparation action details.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction data_preparation_action = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder,
            com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationActionOrBuilder>
        getDataPreparationActionFieldBuilder() {
      if (dataPreparationActionBuilder_ == null) {
        if (!(actionCase_ == 9)) {
          action_ =
              com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction
                  .getDefaultInstance();
        }
        dataPreparationActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction,
                com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction.Builder,
                com.google.cloud.dataform.v1.WorkflowInvocationAction
                    .DataPreparationActionOrBuilder>(
                (com.google.cloud.dataform.v1.WorkflowInvocationAction.DataPreparationAction)
                    action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 9;
      onChanged();
      return dataPreparationActionBuilder_;
    }

    private com.google.cloud.dataform.v1.Target target_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        targetBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the target field is set.
     */
    public boolean hasTarget() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The target.
     */
    public com.google.cloud.dataform.v1.Target getTarget() {
      if (targetBuilder_ == null) {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      } else {
        return targetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTarget(com.google.cloud.dataform.v1.Target value) {
      if (targetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
      } else {
        targetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (targetBuilder_ == null) {
        target_ = builderForValue.build();
      } else {
        targetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTarget(com.google.cloud.dataform.v1.Target value) {
      if (targetBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && target_ != null
            && target_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
          getTargetBuilder().mergeFrom(value);
        } else {
          target_ = value;
        }
      } else {
        targetBuilder_.mergeFrom(value);
      }
      if (target_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTarget() {
      bitField0_ = (bitField0_ & ~0x00000008);
      target_ = null;
      if (targetBuilder_ != null) {
        targetBuilder_.dispose();
        targetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.Target.Builder getTargetBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTargetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
      if (targetBuilder_ != null) {
        return targetBuilder_.getMessageOrBuilder();
      } else {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's identifier. Unique within the workflow
     * invocation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target target = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        getTargetFieldBuilder() {
      if (targetBuilder_ == null) {
        targetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>(
                getTarget(), getParentForChildren(), isClean());
        target_ = null;
      }
      return targetBuilder_;
    }

    private com.google.cloud.dataform.v1.Target canonicalTarget_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        canonicalTargetBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the canonicalTarget field is set.
     */
    public boolean hasCanonicalTarget() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The canonicalTarget.
     */
    public com.google.cloud.dataform.v1.Target getCanonicalTarget() {
      if (canonicalTargetBuilder_ == null) {
        return canonicalTarget_ == null
            ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
            : canonicalTarget_;
      } else {
        return canonicalTargetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCanonicalTarget(com.google.cloud.dataform.v1.Target value) {
      if (canonicalTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        canonicalTarget_ = value;
      } else {
        canonicalTargetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCanonicalTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (canonicalTargetBuilder_ == null) {
        canonicalTarget_ = builderForValue.build();
      } else {
        canonicalTargetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCanonicalTarget(com.google.cloud.dataform.v1.Target value) {
      if (canonicalTargetBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && canonicalTarget_ != null
            && canonicalTarget_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
          getCanonicalTargetBuilder().mergeFrom(value);
        } else {
          canonicalTarget_ = value;
        }
      } else {
        canonicalTargetBuilder_.mergeFrom(value);
      }
      if (canonicalTarget_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCanonicalTarget() {
      bitField0_ = (bitField0_ & ~0x00000010);
      canonicalTarget_ = null;
      if (canonicalTargetBuilder_ != null) {
        canonicalTargetBuilder_.dispose();
        canonicalTargetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.Target.Builder getCanonicalTargetBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCanonicalTargetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.TargetOrBuilder getCanonicalTargetOrBuilder() {
      if (canonicalTargetBuilder_ != null) {
        return canonicalTargetBuilder_.getMessageOrBuilder();
      } else {
        return canonicalTarget_ == null
            ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
            : canonicalTarget_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The action's identifier if the project had been compiled
     * without any overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target canonical_target = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        getCanonicalTargetFieldBuilder() {
      if (canonicalTargetBuilder_ == null) {
        canonicalTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>(
                getCanonicalTarget(), getParentForChildren(), isClean());
        canonicalTarget_ = null;
      }
      return canonicalTargetBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. This action's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocationAction.State getState() {
      com.google.cloud.dataform.v1.WorkflowInvocationAction.State result =
          com.google.cloud.dataform.v1.WorkflowInvocationAction.State.forNumber(state_);
      return result == null
          ? com.google.cloud.dataform.v1.WorkflowInvocationAction.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataform.v1.WorkflowInvocationAction.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocationAction.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object failureReason_ = "";

    /**
     *
     *
     * <pre>
     * Output only. If and only if action's state is FAILED a failure reason is
     * set.
     * </pre>
     *
     * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failureReason.
     */
    public java.lang.String getFailureReason() {
      java.lang.Object ref = failureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        failureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If and only if action's state is FAILED a failure reason is
     * set.
     * </pre>
     *
     * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for failureReason.
     */
    public com.google.protobuf.ByteString getFailureReasonBytes() {
      java.lang.Object ref = failureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        failureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If and only if action's state is FAILED a failure reason is
     * set.
     * </pre>
     *
     * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The failureReason to set.
     * @return This builder for chaining.
     */
    public Builder setFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      failureReason_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If and only if action's state is FAILED a failure reason is
     * set.
     * </pre>
     *
     * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureReason() {
      failureReason_ = getDefaultInstance().getFailureReason();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If and only if action's state is FAILED a failure reason is
     * set.
     * </pre>
     *
     * <code>string failure_reason = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for failureReason to set.
     * @return This builder for chaining.
     */
    public Builder setFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      failureReason_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.type.Interval invocationTiming_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        invocationTimingBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the invocationTiming field is set.
     */
    public boolean hasInvocationTiming() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The invocationTiming.
     */
    public com.google.type.Interval getInvocationTiming() {
      if (invocationTimingBuilder_ == null) {
        return invocationTiming_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : invocationTiming_;
      } else {
        return invocationTimingBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInvocationTiming(com.google.type.Interval value) {
      if (invocationTimingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        invocationTiming_ = value;
      } else {
        invocationTimingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInvocationTiming(com.google.type.Interval.Builder builderForValue) {
      if (invocationTimingBuilder_ == null) {
        invocationTiming_ = builderForValue.build();
      } else {
        invocationTimingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeInvocationTiming(com.google.type.Interval value) {
      if (invocationTimingBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && invocationTiming_ != null
            && invocationTiming_ != com.google.type.Interval.getDefaultInstance()) {
          getInvocationTimingBuilder().mergeFrom(value);
        } else {
          invocationTiming_ = value;
        }
      } else {
        invocationTimingBuilder_.mergeFrom(value);
      }
      if (invocationTiming_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearInvocationTiming() {
      bitField0_ = (bitField0_ & ~0x00000080);
      invocationTiming_ = null;
      if (invocationTimingBuilder_ != null) {
        invocationTimingBuilder_.dispose();
        invocationTimingBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.type.Interval.Builder getInvocationTimingBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getInvocationTimingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.type.IntervalOrBuilder getInvocationTimingOrBuilder() {
      if (invocationTimingBuilder_ != null) {
        return invocationTimingBuilder_.getMessageOrBuilder();
      } else {
        return invocationTiming_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : invocationTiming_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This action's timing details.
     * `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
     * CANCELLED, FAILED] state.
     * `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
     * state.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        getInvocationTimingFieldBuilder() {
      if (invocationTimingBuilder_ == null) {
        invocationTimingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>(
                getInvocationTiming(), getParentForChildren(), isClean());
        invocationTiming_ = null;
      }
      return invocationTimingBuilder_;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocationAction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocationAction)
  private static final com.google.cloud.dataform.v1.WorkflowInvocationAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.WorkflowInvocationAction();
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocationAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowInvocationAction> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowInvocationAction>() {
        @java.lang.Override
        public WorkflowInvocationAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkflowInvocationAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowInvocationAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocationAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
