/*
 * Decompiled with CFR 0.152.
 */
package io.grafeas.v1beta1.pkg;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScanConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/scanConfigs/{scan_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String scanConfig;

    public String getProject() {
        return this.project;
    }

    public String getScanConfig() {
        return this.scanConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ScanConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.scanConfig = (String)Preconditions.checkNotNull((Object)builder.getScanConfig());
    }

    public static ScanConfigName of(String project, String scanConfig) {
        return ScanConfigName.newBuilder().setProject(project).setScanConfig(scanConfig).build();
    }

    public static String format(String project, String scanConfig) {
        return ScanConfigName.newBuilder().setProject(project).setScanConfig(scanConfig).build().toString();
    }

    public static ScanConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ScanConfigName.parse: formattedString not in valid format");
        return ScanConfigName.of((String)matchMap.get("project"), (String)matchMap.get("scan_config"));
    }

    public static List<ScanConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ScanConfigName> list = new ArrayList<ScanConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ScanConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ScanConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ScanConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ScanConfigName scanConfigName = this;
            synchronized (scanConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"scanConfig", (Object)this.scanConfig);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "scan_config", this.scanConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ScanConfigName) {
            ScanConfigName that = (ScanConfigName)o;
            return this.project.equals(that.project) && this.scanConfig.equals(that.scanConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.scanConfig.hashCode();
    }

    public static class Builder {
        private String project;
        private String scanConfig;

        public String getProject() {
            return this.project;
        }

        public String getScanConfig() {
            return this.scanConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setScanConfig(String scanConfig) {
            this.scanConfig = scanConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(ScanConfigName scanConfigName) {
            this.project = scanConfigName.project;
            this.scanConfig = scanConfigName.scanConfig;
        }

        public ScanConfigName build() {
            return new ScanConfigName(this);
        }
    }
}

