/*
 * Decompiled with CFR 0.152.
 */
package io.grafeas.v1beta1.attestation;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OccurrenceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/occurrences/{occurrence}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String occurrence;

    public String getProject() {
        return this.project;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OccurrenceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.occurrence = (String)Preconditions.checkNotNull((Object)builder.getOccurrence());
    }

    public static OccurrenceName of(String project, String occurrence) {
        return OccurrenceName.newBuilder().setProject(project).setOccurrence(occurrence).build();
    }

    public static String format(String project, String occurrence) {
        return OccurrenceName.newBuilder().setProject(project).setOccurrence(occurrence).build().toString();
    }

    public static OccurrenceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OccurrenceName.parse: formattedString not in valid format");
        return OccurrenceName.of((String)matchMap.get("project"), (String)matchMap.get("occurrence"));
    }

    public static List<OccurrenceName> parseList(List<String> formattedStrings) {
        ArrayList<OccurrenceName> list = new ArrayList<OccurrenceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OccurrenceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OccurrenceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OccurrenceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OccurrenceName occurrenceName = this;
            synchronized (occurrenceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"occurrence", (Object)this.occurrence);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "occurrence", this.occurrence});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OccurrenceName) {
            OccurrenceName that = (OccurrenceName)o;
            return this.project.equals(that.project) && this.occurrence.equals(that.occurrence);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.occurrence.hashCode();
    }

    public static class Builder {
        private String project;
        private String occurrence;

        public String getProject() {
            return this.project;
        }

        public String getOccurrence() {
            return this.occurrence;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setOccurrence(String occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        private Builder() {
        }

        private Builder(OccurrenceName occurrenceName) {
            this.project = occurrenceName.project;
            this.occurrence = occurrenceName.occurrence;
        }

        public OccurrenceName build() {
            return new OccurrenceName(this);
        }
    }
}

