/*
 * Decompiled with CFR 0.152.
 */
package com.google.containeranalysis.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.containeranalysis.v1.IamResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UntypedIamResourceName
extends IamResourceName {
    private final String rawValue;
    private Map<String, String> valueMap;

    private UntypedIamResourceName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
        this.valueMap = ImmutableMap.of((Object)"", (Object)rawValue);
    }

    public static UntypedIamResourceName from(ResourceName resourceName) {
        return new UntypedIamResourceName(resourceName.toString());
    }

    public static UntypedIamResourceName parse(String formattedString) {
        return new UntypedIamResourceName(formattedString);
    }

    public static List<UntypedIamResourceName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedIamResourceName> list = new ArrayList<UntypedIamResourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedIamResourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedIamResourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedIamResourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    public Map<String, String> getFieldValuesMap() {
        return this.valueMap;
    }

    public String getFieldValue(String fieldName) {
        return this.valueMap.get(fieldName);
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedIamResourceName) {
            UntypedIamResourceName that = (UntypedIamResourceName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

