/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PartnerName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/partner");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;

    @Deprecated
    protected PartnerName() {
        this.organization = null;
        this.location = null;
    }

    private PartnerName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PartnerName of(String organization, String location) {
        return PartnerName.newBuilder().setOrganization(organization).setLocation(location).build();
    }

    public static String format(String organization, String location) {
        return PartnerName.newBuilder().setOrganization(organization).setLocation(location).build().toString();
    }

    public static PartnerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION.validatedMatch(formattedString, "PartnerName.parse: formattedString not in valid format");
        return PartnerName.of((String)matchMap.get("organization"), (String)matchMap.get("location"));
    }

    public static List<PartnerName> parseList(List<String> formattedStrings) {
        ArrayList<PartnerName> list = new ArrayList<PartnerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PartnerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PartnerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PartnerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PartnerName partnerName = this;
            synchronized (partnerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION.instantiate(new String[]{"organization", this.organization, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PartnerName that = (PartnerName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String organization;
        private String location;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(PartnerName partnerName) {
            this.organization = partnerName.organization;
            this.location = partnerName.location;
        }

        public PartnerName build() {
            return new PartnerName(this);
        }
    }
}

