/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for Bigtable.ReadModifyWriteRow.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.ReadModifyWriteRowRequest}
 */
public final class ReadModifyWriteRowRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadModifyWriteRowRequest)
    ReadModifyWriteRowRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadModifyWriteRowRequest.newBuilder() to construct.
  private ReadModifyWriteRowRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadModifyWriteRowRequest() {
    tableName_ = "";
    appProfileId_ = "";
    rowKey_ = com.google.protobuf.ByteString.EMPTY;
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadModifyWriteRowRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ReadModifyWriteRowRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              tableName_ = s;
              break;
            }
          case 18:
            {
              rowKey_ = input.readBytes();
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                rules_ = new java.util.ArrayList<com.google.bigtable.v2.ReadModifyWriteRule>();
                mutable_bitField0_ |= 0x00000001;
              }
              rules_.add(
                  input.readMessage(
                      com.google.bigtable.v2.ReadModifyWriteRule.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              appProfileId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        rules_ = java.util.Collections.unmodifiableList(rules_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadModifyWriteRowRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadModifyWriteRowRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.ReadModifyWriteRowRequest.class,
            com.google.bigtable.v2.ReadModifyWriteRowRequest.Builder.class);
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object tableName_;
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the read/modify/write rules should be
   * applied.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the read/modify/write rules should be
   * applied.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object appProfileId_;
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 4;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 4;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROW_KEY_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString rowKey_;
  /**
   *
   *
   * <pre>
   * Required. The key of the row to which the read/modify/write rules should be applied.
   * </pre>
   *
   * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rowKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRowKey() {
    return rowKey_;
  }

  public static final int RULES_FIELD_NUMBER = 3;
  private java.util.List<com.google.bigtable.v2.ReadModifyWriteRule> rules_;
  /**
   *
   *
   * <pre>
   * Required. Rules specifying how the specified row's contents are to be transformed
   * into writes. Entries are applied in order, meaning that earlier rules will
   * affect the results of later ones.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.ReadModifyWriteRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Required. Rules specifying how the specified row's contents are to be transformed
   * into writes. Entries are applied in order, meaning that earlier rules will
   * affect the results of later ones.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Required. Rules specifying how the specified row's contents are to be transformed
   * into writes. Entries are applied in order, meaning that earlier rules will
   * affect the results of later ones.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Rules specifying how the specified row's contents are to be transformed
   * into writes. Entries are applied in order, meaning that earlier rules will
   * affect the results of later ones.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadModifyWriteRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Rules specifying how the specified row's contents are to be transformed
   * into writes. Entries are applied in order, meaning that earlier rules will
   * affect the results of later ones.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tableName_);
    }
    if (!rowKey_.isEmpty()) {
      output.writeBytes(2, rowKey_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(3, rules_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, appProfileId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tableName_);
    }
    if (!rowKey_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, rowKey_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, rules_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, appProfileId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.ReadModifyWriteRowRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.ReadModifyWriteRowRequest other =
        (com.google.bigtable.v2.ReadModifyWriteRowRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (!getRowKey().equals(other.getRowKey())) return false;
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    hash = (37 * hash) + ROW_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getRowKey().hashCode();
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.ReadModifyWriteRowRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Bigtable.ReadModifyWriteRow.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadModifyWriteRowRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadModifyWriteRowRequest)
      com.google.bigtable.v2.ReadModifyWriteRowRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadModifyWriteRowRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadModifyWriteRowRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadModifyWriteRowRequest.class,
              com.google.bigtable.v2.ReadModifyWriteRowRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.ReadModifyWriteRowRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRulesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tableName_ = "";

      appProfileId_ = "";

      rowKey_ = com.google.protobuf.ByteString.EMPTY;

      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadModifyWriteRowRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadModifyWriteRowRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.ReadModifyWriteRowRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadModifyWriteRowRequest build() {
      com.google.bigtable.v2.ReadModifyWriteRowRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadModifyWriteRowRequest buildPartial() {
      com.google.bigtable.v2.ReadModifyWriteRowRequest result =
          new com.google.bigtable.v2.ReadModifyWriteRowRequest(this);
      int from_bitField0_ = bitField0_;
      result.tableName_ = tableName_;
      result.appProfileId_ = appProfileId_;
      result.rowKey_ = rowKey_;
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.ReadModifyWriteRowRequest) {
        return mergeFrom((com.google.bigtable.v2.ReadModifyWriteRowRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.ReadModifyWriteRowRequest other) {
      if (other == com.google.bigtable.v2.ReadModifyWriteRowRequest.getDefaultInstance())
        return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        onChanged();
      }
      if (other.getRowKey() != com.google.protobuf.ByteString.EMPTY) {
        setRowKey(other.getRowKey());
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000001);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.v2.ReadModifyWriteRowRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.v2.ReadModifyWriteRowRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object tableName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the read/modify/write rules should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the read/modify/write rules should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the read/modify/write rules should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tableName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the read/modify/write rules should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {

      tableName_ = getDefaultInstance().getTableName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the read/modify/write rules should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tableName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      appProfileId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {

      appProfileId_ = getDefaultInstance().getAppProfileId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      appProfileId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the read/modify/write rules should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowKey() {
      return rowKey_;
    }
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the read/modify/write rules should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rowKey to set.
     * @return This builder for chaining.
     */
    public Builder setRowKey(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      rowKey_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the read/modify/write rules should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowKey() {

      rowKey_ = getDefaultInstance().getRowKey();
      onChanged();
      return this;
    }

    private java.util.List<com.google.bigtable.v2.ReadModifyWriteRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        rules_ = new java.util.ArrayList<com.google.bigtable.v2.ReadModifyWriteRule>(rules_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.ReadModifyWriteRule,
            com.google.bigtable.v2.ReadModifyWriteRule.Builder,
            com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.v2.ReadModifyWriteRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.ReadModifyWriteRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRules(int index, com.google.bigtable.v2.ReadModifyWriteRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRules(
        int index, com.google.bigtable.v2.ReadModifyWriteRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(com.google.bigtable.v2.ReadModifyWriteRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(int index, com.google.bigtable.v2.ReadModifyWriteRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(com.google.bigtable.v2.ReadModifyWriteRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(
        int index, com.google.bigtable.v2.ReadModifyWriteRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.bigtable.v2.ReadModifyWriteRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.ReadModifyWriteRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.ReadModifyWriteRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.bigtable.v2.ReadModifyWriteRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.ReadModifyWriteRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.bigtable.v2.ReadModifyWriteRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Rules specifying how the specified row's contents are to be transformed
     * into writes. Entries are applied in order, meaning that earlier rules will
     * affect the results of later ones.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.ReadModifyWriteRule rules = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.v2.ReadModifyWriteRule.Builder>
        getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.ReadModifyWriteRule,
            com.google.bigtable.v2.ReadModifyWriteRule.Builder,
            com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.ReadModifyWriteRule,
                com.google.bigtable.v2.ReadModifyWriteRule.Builder,
                com.google.bigtable.v2.ReadModifyWriteRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadModifyWriteRowRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadModifyWriteRowRequest)
  private static final com.google.bigtable.v2.ReadModifyWriteRowRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadModifyWriteRowRequest();
  }

  public static com.google.bigtable.v2.ReadModifyWriteRowRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadModifyWriteRowRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReadModifyWriteRowRequest>() {
        @java.lang.Override
        public ReadModifyWriteRowRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ReadModifyWriteRowRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ReadModifyWriteRowRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadModifyWriteRowRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.ReadModifyWriteRowRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
