/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.bigtable.admin.v2;

public interface CreateBackupRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.CreateBackupRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. This must be one of the clusters in the instance in which this
   * table is located. The backup will be stored in this cluster. Values are
   * of the form `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. This must be one of the clusters in the instance in which this
   * table is located. The backup will be stored in this cluster. Values are
   * of the form `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The id of the backup to be created. The `backup_id` along with
   * the parent `parent` are combined as {parent}/backups/{backup_id} to create
   * the full backup name, of the form:
   * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
   * This string must be between 1 and 50 characters in length and match the
   * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
   * </pre>
   *
   * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The backupId.
   */
  java.lang.String getBackupId();
  /**
   *
   *
   * <pre>
   * Required. The id of the backup to be created. The `backup_id` along with
   * the parent `parent` are combined as {parent}/backups/{backup_id} to create
   * the full backup name, of the form:
   * `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
   * This string must be between 1 and 50 characters in length and match the
   * regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
   * </pre>
   *
   * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for backupId.
   */
  com.google.protobuf.ByteString getBackupIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The backup to create.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Backup backup = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the backup field is set.
   */
  boolean hasBackup();
  /**
   *
   *
   * <pre>
   * Required. The backup to create.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Backup backup = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The backup.
   */
  com.google.bigtable.admin.v2.Backup getBackup();
  /**
   *
   *
   * <pre>
   * Required. The backup to create.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Backup backup = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.bigtable.admin.v2.BackupOrBuilder getBackupOrBuilder();
}
