/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClusterName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/clusters/{cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String cluster;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getCluster() {
        return this.cluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
    }

    public static ClusterName of(String project, String instance, String cluster) {
        return ClusterName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).build();
    }

    public static String format(String project, String instance, String cluster) {
        return ClusterName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).build().toString();
    }

    public static ClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ClusterName.parse: formattedString not in valid format");
        return ClusterName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("cluster"));
    }

    public static List<ClusterName> parseList(List<String> formattedStrings) {
        ArrayList<ClusterName> list = new ArrayList<ClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClusterName clusterName = this;
            synchronized (clusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "cluster", this.cluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClusterName) {
            ClusterName that = (ClusterName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.cluster.equals(that.cluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        return h ^= this.cluster.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String cluster;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getCluster() {
            return this.cluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        private Builder() {
        }

        private Builder(ClusterName clusterName) {
            this.project = clusterName.project;
            this.instance = clusterName.instance;
            this.cluster = clusterName.cluster;
        }

        public ClusterName build() {
            return new ClusterName(this);
        }
    }
}

