/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class TransferConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_TRANSFER_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/transferConfigs/{transfer_config}");
    private static final PathTemplate PROJECT_LOCATION_TRANSFER_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/transferConfigs/{transfer_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String transferConfig;
    private final String location;

    @Deprecated
    protected TransferConfigName() {
        this.project = null;
        this.transferConfig = null;
        this.location = null;
    }

    private TransferConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.location = null;
        this.pathTemplate = PROJECT_TRANSFER_CONFIG;
    }

    private TransferConfigName(ProjectLocationTransferConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.pathTemplate = PROJECT_LOCATION_TRANSFER_CONFIG;
    }

    public String getProject() {
        return this.project;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectTransferConfigBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationTransferConfigBuilder newProjectLocationTransferConfigBuilder() {
        return new ProjectLocationTransferConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TransferConfigName of(String project, String transferConfig) {
        return TransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TransferConfigName ofProjectTransferConfigName(String project, String transferConfig) {
        return TransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TransferConfigName ofProjectLocationTransferConfigName(String project, String location, String transferConfig) {
        return TransferConfigName.newProjectLocationTransferConfigBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).build();
    }

    public static String format(String project, String transferConfig) {
        return TransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectTransferConfigName(String project, String transferConfig) {
        return TransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationTransferConfigName(String project, String location, String transferConfig) {
        return TransferConfigName.newProjectLocationTransferConfigBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).build().toString();
    }

    public static TransferConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_TRANSFER_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_TRANSFER_CONFIG.match(formattedString);
            return TransferConfigName.ofProjectTransferConfigName((String)matchMap.get("project"), (String)matchMap.get("transfer_config"));
        }
        if (PROJECT_LOCATION_TRANSFER_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_TRANSFER_CONFIG.match(formattedString);
            return TransferConfigName.ofProjectLocationTransferConfigName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("transfer_config"));
        }
        throw new ValidationException("TransferConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TRANSFER_CONFIG.matches(formattedString) || PROJECT_LOCATION_TRANSFER_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TransferConfigName transferConfigName = this;
            synchronized (transferConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.transferConfig != null) {
                        fieldMapBuilder.put((Object)"transfer_config", (Object)this.transferConfig);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TransferConfigName that = (TransferConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.transferConfig, that.transferConfig) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.transferConfig);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationTransferConfigBuilder {
        private String project;
        private String location;
        private String transferConfig;

        protected ProjectLocationTransferConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public ProjectLocationTransferConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationTransferConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationTransferConfigBuilder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        public TransferConfigName build() {
            return new TransferConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String transferConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        private Builder(TransferConfigName transferConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(transferConfigName.pathTemplate, PROJECT_TRANSFER_CONFIG), (Object)"toBuilder is only supported when TransferConfigName has the pattern of projects/{project}/transferConfigs/{transfer_config}");
            this.project = transferConfigName.project;
            this.transferConfig = transferConfigName.transferConfig;
        }

        public TransferConfigName build() {
            return new TransferConfigName(this);
        }
    }
}

