/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.dataexchange.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_EXCHANGE_LISTING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataExchanges/{data_exchange}/listings/{listing}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataExchange;
    private final String listing;

    @Deprecated
    protected ListingName() {
        this.project = null;
        this.location = null;
        this.dataExchange = null;
        this.listing = null;
    }

    private ListingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataExchange = (String)Preconditions.checkNotNull((Object)builder.getDataExchange());
        this.listing = (String)Preconditions.checkNotNull((Object)builder.getListing());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataExchange() {
        return this.dataExchange;
    }

    public String getListing() {
        return this.listing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ListingName of(String project, String location, String dataExchange, String listing) {
        return ListingName.newBuilder().setProject(project).setLocation(location).setDataExchange(dataExchange).setListing(listing).build();
    }

    public static String format(String project, String location, String dataExchange, String listing) {
        return ListingName.newBuilder().setProject(project).setLocation(location).setDataExchange(dataExchange).setListing(listing).build().toString();
    }

    public static ListingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_EXCHANGE_LISTING.validatedMatch(formattedString, "ListingName.parse: formattedString not in valid format");
        return ListingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_exchange"), (String)matchMap.get("listing"));
    }

    public static List<ListingName> parseList(List<String> formattedStrings) {
        ArrayList<ListingName> list = new ArrayList<ListingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ListingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ListingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ListingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_EXCHANGE_LISTING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ListingName listingName = this;
            synchronized (listingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataExchange != null) {
                        fieldMapBuilder.put((Object)"data_exchange", (Object)this.dataExchange);
                    }
                    if (this.listing != null) {
                        fieldMapBuilder.put((Object)"listing", (Object)this.listing);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_EXCHANGE_LISTING.instantiate(new String[]{"project", this.project, "location", this.location, "data_exchange", this.dataExchange, "listing", this.listing});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ListingName that = (ListingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataExchange, that.dataExchange) && Objects.equals(this.listing, that.listing);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataExchange);
        h *= 1000003;
        return h ^= Objects.hashCode(this.listing);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataExchange;
        private String listing;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataExchange() {
            return this.dataExchange;
        }

        public String getListing() {
            return this.listing;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataExchange(String dataExchange) {
            this.dataExchange = dataExchange;
            return this;
        }

        public Builder setListing(String listing) {
            this.listing = listing;
            return this;
        }

        private Builder(ListingName listingName) {
            this.project = listingName.project;
            this.location = listingName.location;
            this.dataExchange = listingName.dataExchange;
            this.listing = listingName.listing;
        }

        public ListingName build() {
            return new ListingName(this);
        }
    }
}

