/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.dataexchange.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataExchangeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_EXCHANGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataExchanges/{data_exchange}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataExchange;

    @Deprecated
    protected DataExchangeName() {
        this.project = null;
        this.location = null;
        this.dataExchange = null;
    }

    private DataExchangeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataExchange = (String)Preconditions.checkNotNull((Object)builder.getDataExchange());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataExchange() {
        return this.dataExchange;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataExchangeName of(String project, String location, String dataExchange) {
        return DataExchangeName.newBuilder().setProject(project).setLocation(location).setDataExchange(dataExchange).build();
    }

    public static String format(String project, String location, String dataExchange) {
        return DataExchangeName.newBuilder().setProject(project).setLocation(location).setDataExchange(dataExchange).build().toString();
    }

    public static DataExchangeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_EXCHANGE.validatedMatch(formattedString, "DataExchangeName.parse: formattedString not in valid format");
        return DataExchangeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_exchange"));
    }

    public static List<DataExchangeName> parseList(List<String> formattedStrings) {
        ArrayList<DataExchangeName> list = new ArrayList<DataExchangeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataExchangeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataExchangeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataExchangeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_EXCHANGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataExchangeName dataExchangeName = this;
            synchronized (dataExchangeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataExchange != null) {
                        fieldMapBuilder.put((Object)"data_exchange", (Object)this.dataExchange);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_EXCHANGE.instantiate(new String[]{"project", this.project, "location", this.location, "data_exchange", this.dataExchange});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DataExchangeName that = (DataExchangeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataExchange, that.dataExchange);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataExchange);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataExchange;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataExchange() {
            return this.dataExchange;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataExchange(String dataExchange) {
            this.dataExchange = dataExchange;
            return this;
        }

        private Builder(DataExchangeName dataExchangeName) {
            this.project = dataExchangeName.project;
            this.location = dataExchangeName.location;
            this.dataExchange = dataExchangeName.dataExchange;
        }

        public DataExchangeName build() {
            return new DataExchangeName(this);
        }
    }
}

