/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/data.proto

// Protobuf Java Version: 3.25.8
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * Explains a metric.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.MetricMetadata}
 */
public final class MetricMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.MetricMetadata)
    MetricMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MetricMetadata.newBuilder() to construct.
  private MetricMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MetricMetadata() {
    apiName_ = "";
    uiName_ = "";
    description_ = "";
    deprecatedApiNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    type_ = 0;
    expression_ = "";
    blockedReasons_ = java.util.Collections.emptyList();
    category_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MetricMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_MetricMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_MetricMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.MetricMetadata.class,
            com.google.analytics.data.v1beta.MetricMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Justifications for why this metric is blocked.
   * </pre>
   *
   * Protobuf enum {@code google.analytics.data.v1beta.MetricMetadata.BlockedReason}
   */
  public enum BlockedReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Will never be specified in API response.
     * </pre>
     *
     * <code>BLOCKED_REASON_UNSPECIFIED = 0;</code>
     */
    BLOCKED_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If present, your access is blocked to revenue related metrics for this
     * property, and this metric is revenue related.
     * </pre>
     *
     * <code>NO_REVENUE_METRICS = 1;</code>
     */
    NO_REVENUE_METRICS(1),
    /**
     *
     *
     * <pre>
     * If present, your access is blocked to cost related metrics for this
     * property, and this metric is cost related.
     * </pre>
     *
     * <code>NO_COST_METRICS = 2;</code>
     */
    NO_COST_METRICS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Will never be specified in API response.
     * </pre>
     *
     * <code>BLOCKED_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int BLOCKED_REASON_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * If present, your access is blocked to revenue related metrics for this
     * property, and this metric is revenue related.
     * </pre>
     *
     * <code>NO_REVENUE_METRICS = 1;</code>
     */
    public static final int NO_REVENUE_METRICS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * If present, your access is blocked to cost related metrics for this
     * property, and this metric is cost related.
     * </pre>
     *
     * <code>NO_COST_METRICS = 2;</code>
     */
    public static final int NO_COST_METRICS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BlockedReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BlockedReason forNumber(int value) {
      switch (value) {
        case 0:
          return BLOCKED_REASON_UNSPECIFIED;
        case 1:
          return NO_REVENUE_METRICS;
        case 2:
          return NO_COST_METRICS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BlockedReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BlockedReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BlockedReason>() {
          public BlockedReason findValueByNumber(int number) {
            return BlockedReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.analytics.data.v1beta.MetricMetadata.getDescriptor().getEnumTypes().get(0);
    }

    private static final BlockedReason[] VALUES = values();

    public static BlockedReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BlockedReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.analytics.data.v1beta.MetricMetadata.BlockedReason)
  }

  public static final int API_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object apiName_ = "";

  /**
   *
   *
   * <pre>
   * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
   * `eventCount`.
   * </pre>
   *
   * <code>string api_name = 1;</code>
   *
   * @return The apiName.
   */
  @java.lang.Override
  public java.lang.String getApiName() {
    java.lang.Object ref = apiName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      apiName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
   * `eventCount`.
   * </pre>
   *
   * <code>string api_name = 1;</code>
   *
   * @return The bytes for apiName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApiNameBytes() {
    java.lang.Object ref = apiName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      apiName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UI_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uiName_ = "";

  /**
   *
   *
   * <pre>
   * This metric's name within the Google Analytics user interface. For example,
   * `Event count`.
   * </pre>
   *
   * <code>string ui_name = 2;</code>
   *
   * @return The uiName.
   */
  @java.lang.Override
  public java.lang.String getUiName() {
    java.lang.Object ref = uiName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uiName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This metric's name within the Google Analytics user interface. For example,
   * `Event count`.
   * </pre>
   *
   * <code>string ui_name = 2;</code>
   *
   * @return The bytes for uiName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUiNameBytes() {
    java.lang.Object ref = uiName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uiName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Description of how this metric is used and calculated.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Description of how this metric is used and calculated.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPRECATED_API_NAMES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList deprecatedApiNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Still usable but deprecated names for this metric. If populated, this
   * metric is available by either `apiName` or one of `deprecatedApiNames`
   * for a period of time. After the deprecation period, the metric will be
   * available only by `apiName`.
   * </pre>
   *
   * <code>repeated string deprecated_api_names = 4;</code>
   *
   * @return A list containing the deprecatedApiNames.
   */
  public com.google.protobuf.ProtocolStringList getDeprecatedApiNamesList() {
    return deprecatedApiNames_;
  }

  /**
   *
   *
   * <pre>
   * Still usable but deprecated names for this metric. If populated, this
   * metric is available by either `apiName` or one of `deprecatedApiNames`
   * for a period of time. After the deprecation period, the metric will be
   * available only by `apiName`.
   * </pre>
   *
   * <code>repeated string deprecated_api_names = 4;</code>
   *
   * @return The count of deprecatedApiNames.
   */
  public int getDeprecatedApiNamesCount() {
    return deprecatedApiNames_.size();
  }

  /**
   *
   *
   * <pre>
   * Still usable but deprecated names for this metric. If populated, this
   * metric is available by either `apiName` or one of `deprecatedApiNames`
   * for a period of time. After the deprecation period, the metric will be
   * available only by `apiName`.
   * </pre>
   *
   * <code>repeated string deprecated_api_names = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The deprecatedApiNames at the given index.
   */
  public java.lang.String getDeprecatedApiNames(int index) {
    return deprecatedApiNames_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Still usable but deprecated names for this metric. If populated, this
   * metric is available by either `apiName` or one of `deprecatedApiNames`
   * for a period of time. After the deprecation period, the metric will be
   * available only by `apiName`.
   * </pre>
   *
   * <code>repeated string deprecated_api_names = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the deprecatedApiNames at the given index.
   */
  public com.google.protobuf.ByteString getDeprecatedApiNamesBytes(int index) {
    return deprecatedApiNames_.getByteString(index);
  }

  public static final int TYPE_FIELD_NUMBER = 5;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * The type of this metric.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * The type of this metric.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricType getType() {
    com.google.analytics.data.v1beta.MetricType result =
        com.google.analytics.data.v1beta.MetricType.forNumber(type_);
    return result == null ? com.google.analytics.data.v1beta.MetricType.UNRECOGNIZED : result;
  }

  public static final int EXPRESSION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expression_ = "";

  /**
   *
   *
   * <pre>
   * The mathematical expression for this derived metric. Can be used in
   * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
   * are not expressions, and for non-expressions, this field is empty.
   * </pre>
   *
   * <code>string expression = 6;</code>
   *
   * @return The expression.
   */
  @java.lang.Override
  public java.lang.String getExpression() {
    java.lang.Object ref = expression_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expression_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The mathematical expression for this derived metric. Can be used in
   * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
   * are not expressions, and for non-expressions, this field is empty.
   * </pre>
   *
   * <code>string expression = 6;</code>
   *
   * @return The bytes for expression.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpressionBytes() {
    java.lang.Object ref = expression_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expression_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_DEFINITION_FIELD_NUMBER = 7;
  private boolean customDefinition_ = false;

  /**
   *
   *
   * <pre>
   * True if the metric is a custom metric for this property.
   * </pre>
   *
   * <code>bool custom_definition = 7;</code>
   *
   * @return The customDefinition.
   */
  @java.lang.Override
  public boolean getCustomDefinition() {
    return customDefinition_;
  }

  public static final int BLOCKED_REASONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> blockedReasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>
      blockedReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>() {
            public com.google.analytics.data.v1beta.MetricMetadata.BlockedReason convert(
                java.lang.Integer from) {
              com.google.analytics.data.v1beta.MetricMetadata.BlockedReason result =
                  com.google.analytics.data.v1beta.MetricMetadata.BlockedReason.forNumber(from);
              return result == null
                  ? com.google.analytics.data.v1beta.MetricMetadata.BlockedReason.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * If reasons are specified, your access is blocked to this metric for this
   * property. API requests from you to this property for this metric will
   * succeed; however, the report will contain only zeros for this metric. API
   * requests with metric filters on blocked metrics will fail. If reasons are
   * empty, you have access to this metric.
   *
   * To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
   * </code>
   *
   * @return A list containing the blockedReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>
      getBlockedReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>(
        blockedReasons_, blockedReasons_converter_);
  }

  /**
   *
   *
   * <pre>
   * If reasons are specified, your access is blocked to this metric for this
   * property. API requests from you to this property for this metric will
   * succeed; however, the report will contain only zeros for this metric. API
   * requests with metric filters on blocked metrics will fail. If reasons are
   * empty, you have access to this metric.
   *
   * To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
   * </code>
   *
   * @return The count of blockedReasons.
   */
  @java.lang.Override
  public int getBlockedReasonsCount() {
    return blockedReasons_.size();
  }

  /**
   *
   *
   * <pre>
   * If reasons are specified, your access is blocked to this metric for this
   * property. API requests from you to this property for this metric will
   * succeed; however, the report will contain only zeros for this metric. API
   * requests with metric filters on blocked metrics will fail. If reasons are
   * empty, you have access to this metric.
   *
   * To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The blockedReasons at the given index.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricMetadata.BlockedReason getBlockedReasons(
      int index) {
    return blockedReasons_converter_.convert(blockedReasons_.get(index));
  }

  /**
   *
   *
   * <pre>
   * If reasons are specified, your access is blocked to this metric for this
   * property. API requests from you to this property for this metric will
   * succeed; however, the report will contain only zeros for this metric. API
   * requests with metric filters on blocked metrics will fail. If reasons are
   * empty, you have access to this metric.
   *
   * To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for blockedReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getBlockedReasonsValueList() {
    return blockedReasons_;
  }

  /**
   *
   *
   * <pre>
   * If reasons are specified, your access is blocked to this metric for this
   * property. API requests from you to this property for this metric will
   * succeed; however, the report will contain only zeros for this metric. API
   * requests with metric filters on blocked metrics will fail. If reasons are
   * empty, you have access to this metric.
   *
   * To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of blockedReasons at the given index.
   */
  @java.lang.Override
  public int getBlockedReasonsValue(int index) {
    return blockedReasons_.get(index);
  }

  private int blockedReasonsMemoizedSerializedSize;

  public static final int CATEGORY_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object category_ = "";

  /**
   *
   *
   * <pre>
   * The display name of the category that this metrics belongs to. Similar
   * dimensions and metrics are categorized together.
   * </pre>
   *
   * <code>string category = 10;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public java.lang.String getCategory() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      category_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The display name of the category that this metrics belongs to. Similar
   * dimensions and metrics are categorized together.
   * </pre>
   *
   * <code>string category = 10;</code>
   *
   * @return The bytes for category.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCategoryBytes() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      category_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, apiName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uiName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uiName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < deprecatedApiNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, deprecatedApiNames_.getRaw(i));
    }
    if (type_ != com.google.analytics.data.v1beta.MetricType.METRIC_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expression_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, expression_);
    }
    if (customDefinition_ != false) {
      output.writeBool(7, customDefinition_);
    }
    if (getBlockedReasonsList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(blockedReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < blockedReasons_.size(); i++) {
      output.writeEnumNoTag(blockedReasons_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, category_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, apiName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uiName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uiName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < deprecatedApiNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(deprecatedApiNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDeprecatedApiNamesList().size();
    }
    if (type_ != com.google.analytics.data.v1beta.MetricType.METRIC_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expression_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, expression_);
    }
    if (customDefinition_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, customDefinition_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blockedReasons_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(blockedReasons_.get(i));
      }
      size += dataSize;
      if (!getBlockedReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      blockedReasonsMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, category_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.MetricMetadata)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.MetricMetadata other =
        (com.google.analytics.data.v1beta.MetricMetadata) obj;

    if (!getApiName().equals(other.getApiName())) return false;
    if (!getUiName().equals(other.getUiName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDeprecatedApiNamesList().equals(other.getDeprecatedApiNamesList())) return false;
    if (type_ != other.type_) return false;
    if (!getExpression().equals(other.getExpression())) return false;
    if (getCustomDefinition() != other.getCustomDefinition()) return false;
    if (!blockedReasons_.equals(other.blockedReasons_)) return false;
    if (!getCategory().equals(other.getCategory())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + API_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getApiName().hashCode();
    hash = (37 * hash) + UI_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getUiName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getDeprecatedApiNamesCount() > 0) {
      hash = (37 * hash) + DEPRECATED_API_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getDeprecatedApiNamesList().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + EXPRESSION_FIELD_NUMBER;
    hash = (53 * hash) + getExpression().hashCode();
    hash = (37 * hash) + CUSTOM_DEFINITION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCustomDefinition());
    if (getBlockedReasonsCount() > 0) {
      hash = (37 * hash) + BLOCKED_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + blockedReasons_.hashCode();
    }
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getCategory().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.MetricMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1beta.MetricMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Explains a metric.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.MetricMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.MetricMetadata)
      com.google.analytics.data.v1beta.MetricMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_MetricMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_MetricMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.MetricMetadata.class,
              com.google.analytics.data.v1beta.MetricMetadata.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.MetricMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      apiName_ = "";
      uiName_ = "";
      description_ = "";
      deprecatedApiNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      type_ = 0;
      expression_ = "";
      customDefinition_ = false;
      blockedReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      category_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_MetricMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.MetricMetadata getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.MetricMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.MetricMetadata build() {
      com.google.analytics.data.v1beta.MetricMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.MetricMetadata buildPartial() {
      com.google.analytics.data.v1beta.MetricMetadata result =
          new com.google.analytics.data.v1beta.MetricMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.analytics.data.v1beta.MetricMetadata result) {
      if (((bitField0_ & 0x00000080) != 0)) {
        blockedReasons_ = java.util.Collections.unmodifiableList(blockedReasons_);
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.blockedReasons_ = blockedReasons_;
    }

    private void buildPartial0(com.google.analytics.data.v1beta.MetricMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.apiName_ = apiName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uiName_ = uiName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        deprecatedApiNames_.makeImmutable();
        result.deprecatedApiNames_ = deprecatedApiNames_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.expression_ = expression_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.customDefinition_ = customDefinition_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.category_ = category_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.MetricMetadata) {
        return mergeFrom((com.google.analytics.data.v1beta.MetricMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.MetricMetadata other) {
      if (other == com.google.analytics.data.v1beta.MetricMetadata.getDefaultInstance())
        return this;
      if (!other.getApiName().isEmpty()) {
        apiName_ = other.apiName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUiName().isEmpty()) {
        uiName_ = other.uiName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.deprecatedApiNames_.isEmpty()) {
        if (deprecatedApiNames_.isEmpty()) {
          deprecatedApiNames_ = other.deprecatedApiNames_;
          bitField0_ |= 0x00000008;
        } else {
          ensureDeprecatedApiNamesIsMutable();
          deprecatedApiNames_.addAll(other.deprecatedApiNames_);
        }
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getExpression().isEmpty()) {
        expression_ = other.expression_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getCustomDefinition() != false) {
        setCustomDefinition(other.getCustomDefinition());
      }
      if (!other.blockedReasons_.isEmpty()) {
        if (blockedReasons_.isEmpty()) {
          blockedReasons_ = other.blockedReasons_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureBlockedReasonsIsMutable();
          blockedReasons_.addAll(other.blockedReasons_);
        }
        onChanged();
      }
      if (!other.getCategory().isEmpty()) {
        category_ = other.category_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                apiName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uiName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDeprecatedApiNamesIsMutable();
                deprecatedApiNames_.add(s);
                break;
              } // case 34
            case 40:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                expression_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                customDefinition_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureBlockedReasonsIsMutable();
                blockedReasons_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureBlockedReasonsIsMutable();
                  blockedReasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 82:
              {
                category_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object apiName_ = "";

    /**
     *
     *
     * <pre>
     * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
     * `eventCount`.
     * </pre>
     *
     * <code>string api_name = 1;</code>
     *
     * @return The apiName.
     */
    public java.lang.String getApiName() {
      java.lang.Object ref = apiName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
     * `eventCount`.
     * </pre>
     *
     * <code>string api_name = 1;</code>
     *
     * @return The bytes for apiName.
     */
    public com.google.protobuf.ByteString getApiNameBytes() {
      java.lang.Object ref = apiName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
     * `eventCount`.
     * </pre>
     *
     * <code>string api_name = 1;</code>
     *
     * @param value The apiName to set.
     * @return This builder for chaining.
     */
    public Builder setApiName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      apiName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
     * `eventCount`.
     * </pre>
     *
     * <code>string api_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiName() {
      apiName_ = getDefaultInstance().getApiName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A metric name. Useable in [Metric](#Metric)'s `name`. For example,
     * `eventCount`.
     * </pre>
     *
     * <code>string api_name = 1;</code>
     *
     * @param value The bytes for apiName to set.
     * @return This builder for chaining.
     */
    public Builder setApiNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      apiName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uiName_ = "";

    /**
     *
     *
     * <pre>
     * This metric's name within the Google Analytics user interface. For example,
     * `Event count`.
     * </pre>
     *
     * <code>string ui_name = 2;</code>
     *
     * @return The uiName.
     */
    public java.lang.String getUiName() {
      java.lang.Object ref = uiName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uiName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This metric's name within the Google Analytics user interface. For example,
     * `Event count`.
     * </pre>
     *
     * <code>string ui_name = 2;</code>
     *
     * @return The bytes for uiName.
     */
    public com.google.protobuf.ByteString getUiNameBytes() {
      java.lang.Object ref = uiName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uiName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This metric's name within the Google Analytics user interface. For example,
     * `Event count`.
     * </pre>
     *
     * <code>string ui_name = 2;</code>
     *
     * @param value The uiName to set.
     * @return This builder for chaining.
     */
    public Builder setUiName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uiName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This metric's name within the Google Analytics user interface. For example,
     * `Event count`.
     * </pre>
     *
     * <code>string ui_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUiName() {
      uiName_ = getDefaultInstance().getUiName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This metric's name within the Google Analytics user interface. For example,
     * `Event count`.
     * </pre>
     *
     * <code>string ui_name = 2;</code>
     *
     * @param value The bytes for uiName to set.
     * @return This builder for chaining.
     */
    public Builder setUiNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uiName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Description of how this metric is used and calculated.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description of how this metric is used and calculated.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description of how this metric is used and calculated.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description of how this metric is used and calculated.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description of how this metric is used and calculated.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList deprecatedApiNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDeprecatedApiNamesIsMutable() {
      if (!deprecatedApiNames_.isModifiable()) {
        deprecatedApiNames_ = new com.google.protobuf.LazyStringArrayList(deprecatedApiNames_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @return A list containing the deprecatedApiNames.
     */
    public com.google.protobuf.ProtocolStringList getDeprecatedApiNamesList() {
      deprecatedApiNames_.makeImmutable();
      return deprecatedApiNames_;
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @return The count of deprecatedApiNames.
     */
    public int getDeprecatedApiNamesCount() {
      return deprecatedApiNames_.size();
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The deprecatedApiNames at the given index.
     */
    public java.lang.String getDeprecatedApiNames(int index) {
      return deprecatedApiNames_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the deprecatedApiNames at the given index.
     */
    public com.google.protobuf.ByteString getDeprecatedApiNamesBytes(int index) {
      return deprecatedApiNames_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The deprecatedApiNames to set.
     * @return This builder for chaining.
     */
    public Builder setDeprecatedApiNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDeprecatedApiNamesIsMutable();
      deprecatedApiNames_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @param value The deprecatedApiNames to add.
     * @return This builder for chaining.
     */
    public Builder addDeprecatedApiNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDeprecatedApiNamesIsMutable();
      deprecatedApiNames_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @param values The deprecatedApiNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllDeprecatedApiNames(java.lang.Iterable<java.lang.String> values) {
      ensureDeprecatedApiNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deprecatedApiNames_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeprecatedApiNames() {
      deprecatedApiNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Still usable but deprecated names for this metric. If populated, this
     * metric is available by either `apiName` or one of `deprecatedApiNames`
     * for a period of time. After the deprecation period, the metric will be
     * available only by `apiName`.
     * </pre>
     *
     * <code>repeated string deprecated_api_names = 4;</code>
     *
     * @param value The bytes of the deprecatedApiNames to add.
     * @return This builder for chaining.
     */
    public Builder addDeprecatedApiNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDeprecatedApiNamesIsMutable();
      deprecatedApiNames_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of this metric.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of this metric.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of this metric.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.analytics.data.v1beta.MetricType getType() {
      com.google.analytics.data.v1beta.MetricType result =
          com.google.analytics.data.v1beta.MetricType.forNumber(type_);
      return result == null ? com.google.analytics.data.v1beta.MetricType.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The type of this metric.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.analytics.data.v1beta.MetricType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of this metric.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.MetricType type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object expression_ = "";

    /**
     *
     *
     * <pre>
     * The mathematical expression for this derived metric. Can be used in
     * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
     * are not expressions, and for non-expressions, this field is empty.
     * </pre>
     *
     * <code>string expression = 6;</code>
     *
     * @return The expression.
     */
    public java.lang.String getExpression() {
      java.lang.Object ref = expression_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expression_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The mathematical expression for this derived metric. Can be used in
     * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
     * are not expressions, and for non-expressions, this field is empty.
     * </pre>
     *
     * <code>string expression = 6;</code>
     *
     * @return The bytes for expression.
     */
    public com.google.protobuf.ByteString getExpressionBytes() {
      java.lang.Object ref = expression_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expression_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The mathematical expression for this derived metric. Can be used in
     * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
     * are not expressions, and for non-expressions, this field is empty.
     * </pre>
     *
     * <code>string expression = 6;</code>
     *
     * @param value The expression to set.
     * @return This builder for chaining.
     */
    public Builder setExpression(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expression_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mathematical expression for this derived metric. Can be used in
     * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
     * are not expressions, and for non-expressions, this field is empty.
     * </pre>
     *
     * <code>string expression = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpression() {
      expression_ = getDefaultInstance().getExpression();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mathematical expression for this derived metric. Can be used in
     * [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
     * are not expressions, and for non-expressions, this field is empty.
     * </pre>
     *
     * <code>string expression = 6;</code>
     *
     * @param value The bytes for expression to set.
     * @return This builder for chaining.
     */
    public Builder setExpressionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expression_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean customDefinition_;

    /**
     *
     *
     * <pre>
     * True if the metric is a custom metric for this property.
     * </pre>
     *
     * <code>bool custom_definition = 7;</code>
     *
     * @return The customDefinition.
     */
    @java.lang.Override
    public boolean getCustomDefinition() {
      return customDefinition_;
    }

    /**
     *
     *
     * <pre>
     * True if the metric is a custom metric for this property.
     * </pre>
     *
     * <code>bool custom_definition = 7;</code>
     *
     * @param value The customDefinition to set.
     * @return This builder for chaining.
     */
    public Builder setCustomDefinition(boolean value) {

      customDefinition_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * True if the metric is a custom metric for this property.
     * </pre>
     *
     * <code>bool custom_definition = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomDefinition() {
      bitField0_ = (bitField0_ & ~0x00000040);
      customDefinition_ = false;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> blockedReasons_ = java.util.Collections.emptyList();

    private void ensureBlockedReasonsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        blockedReasons_ = new java.util.ArrayList<java.lang.Integer>(blockedReasons_);
        bitField0_ |= 0x00000080;
      }
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @return A list containing the blockedReasons.
     */
    public java.util.List<com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>
        getBlockedReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>(
          blockedReasons_, blockedReasons_converter_);
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @return The count of blockedReasons.
     */
    public int getBlockedReasonsCount() {
      return blockedReasons_.size();
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The blockedReasons at the given index.
     */
    public com.google.analytics.data.v1beta.MetricMetadata.BlockedReason getBlockedReasons(
        int index) {
      return blockedReasons_converter_.convert(blockedReasons_.get(index));
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The blockedReasons to set.
     * @return This builder for chaining.
     */
    public Builder setBlockedReasons(
        int index, com.google.analytics.data.v1beta.MetricMetadata.BlockedReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockedReasonsIsMutable();
      blockedReasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param value The blockedReasons to add.
     * @return This builder for chaining.
     */
    public Builder addBlockedReasons(
        com.google.analytics.data.v1beta.MetricMetadata.BlockedReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockedReasonsIsMutable();
      blockedReasons_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param values The blockedReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockedReasons(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.MetricMetadata.BlockedReason>
            values) {
      ensureBlockedReasonsIsMutable();
      for (com.google.analytics.data.v1beta.MetricMetadata.BlockedReason value : values) {
        blockedReasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockedReasons() {
      blockedReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for blockedReasons.
     */
    public java.util.List<java.lang.Integer> getBlockedReasonsValueList() {
      return java.util.Collections.unmodifiableList(blockedReasons_);
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of blockedReasons at the given index.
     */
    public int getBlockedReasonsValue(int index) {
      return blockedReasons_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for blockedReasons to set.
     * @return This builder for chaining.
     */
    public Builder setBlockedReasonsValue(int index, int value) {
      ensureBlockedReasonsIsMutable();
      blockedReasons_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param value The enum numeric value on the wire for blockedReasons to add.
     * @return This builder for chaining.
     */
    public Builder addBlockedReasonsValue(int value) {
      ensureBlockedReasonsIsMutable();
      blockedReasons_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If reasons are specified, your access is blocked to this metric for this
     * property. API requests from you to this property for this metric will
     * succeed; however, the report will contain only zeros for this metric. API
     * requests with metric filters on blocked metrics will fail. If reasons are
     * empty, you have access to this metric.
     *
     * To learn more, see [Access and data-restriction
     * management](https://support.google.com/analytics/answer/10851388).
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1beta.MetricMetadata.BlockedReason blocked_reasons = 8;
     * </code>
     *
     * @param values The enum numeric values on the wire for blockedReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockedReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureBlockedReasonsIsMutable();
      for (int value : values) {
        blockedReasons_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object category_ = "";

    /**
     *
     *
     * <pre>
     * The display name of the category that this metrics belongs to. Similar
     * dimensions and metrics are categorized together.
     * </pre>
     *
     * <code>string category = 10;</code>
     *
     * @return The category.
     */
    public java.lang.String getCategory() {
      java.lang.Object ref = category_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        category_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the category that this metrics belongs to. Similar
     * dimensions and metrics are categorized together.
     * </pre>
     *
     * <code>string category = 10;</code>
     *
     * @return The bytes for category.
     */
    public com.google.protobuf.ByteString getCategoryBytes() {
      java.lang.Object ref = category_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        category_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the category that this metrics belongs to. Similar
     * dimensions and metrics are categorized together.
     * </pre>
     *
     * <code>string category = 10;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      category_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the category that this metrics belongs to. Similar
     * dimensions and metrics are categorized together.
     * </pre>
     *
     * <code>string category = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {
      category_ = getDefaultInstance().getCategory();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the category that this metrics belongs to. Similar
     * dimensions and metrics are categorized together.
     * </pre>
     *
     * <code>string category = 10;</code>
     *
     * @param value The bytes for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      category_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.MetricMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.MetricMetadata)
  private static final com.google.analytics.data.v1beta.MetricMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.MetricMetadata();
  }

  public static com.google.analytics.data.v1beta.MetricMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MetricMetadata> PARSER =
      new com.google.protobuf.AbstractParser<MetricMetadata>() {
        @java.lang.Override
        public MetricMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MetricMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MetricMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
