/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversionEventName
implements ResourceName {
    private static final PathTemplate PROPERTY_CONVERSION_EVENT = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/conversionEvents/{conversion_event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String conversionEvent;

    @Deprecated
    protected ConversionEventName() {
        this.property = null;
        this.conversionEvent = null;
    }

    private ConversionEventName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.conversionEvent = (String)Preconditions.checkNotNull((Object)builder.getConversionEvent());
    }

    public String getProperty() {
        return this.property;
    }

    public String getConversionEvent() {
        return this.conversionEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionEventName of(String property, String conversionEvent) {
        return ConversionEventName.newBuilder().setProperty(property).setConversionEvent(conversionEvent).build();
    }

    public static String format(String property, String conversionEvent) {
        return ConversionEventName.newBuilder().setProperty(property).setConversionEvent(conversionEvent).build().toString();
    }

    public static ConversionEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_CONVERSION_EVENT.validatedMatch(formattedString, "ConversionEventName.parse: formattedString not in valid format");
        return ConversionEventName.of((String)matchMap.get("property"), (String)matchMap.get("conversion_event"));
    }

    public static List<ConversionEventName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionEventName> list = new ArrayList<ConversionEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_CONVERSION_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionEventName conversionEventName = this;
            synchronized (conversionEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.conversionEvent != null) {
                        fieldMapBuilder.put((Object)"conversion_event", (Object)this.conversionEvent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_CONVERSION_EVENT.instantiate(new String[]{"property", this.property, "conversion_event", this.conversionEvent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversionEventName that = (ConversionEventName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.conversionEvent, that.conversionEvent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversionEvent);
    }

    public static class Builder {
        private String property;
        private String conversionEvent;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getConversionEvent() {
            return this.conversionEvent;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setConversionEvent(String conversionEvent) {
            this.conversionEvent = conversionEvent;
            return this;
        }

        private Builder(ConversionEventName conversionEventName) {
            this.property = conversionEventName.property;
            this.conversionEvent = conversionEventName.conversionEvent;
        }

        public ConversionEventName build() {
            return new ConversionEventName(this);
        }
    }
}

