/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SubpropertyEventFilterName
implements ResourceName {
    private static final PathTemplate PROPERTY_SUB_PROPERTY_EVENT_FILTER = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/subpropertyEventFilters/{sub_property_event_filter}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String subPropertyEventFilter;

    @Deprecated
    protected SubpropertyEventFilterName() {
        this.property = null;
        this.subPropertyEventFilter = null;
    }

    private SubpropertyEventFilterName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.subPropertyEventFilter = (String)Preconditions.checkNotNull((Object)builder.getSubPropertyEventFilter());
    }

    public String getProperty() {
        return this.property;
    }

    public String getSubPropertyEventFilter() {
        return this.subPropertyEventFilter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SubpropertyEventFilterName of(String property, String subPropertyEventFilter) {
        return SubpropertyEventFilterName.newBuilder().setProperty(property).setSubPropertyEventFilter(subPropertyEventFilter).build();
    }

    public static String format(String property, String subPropertyEventFilter) {
        return SubpropertyEventFilterName.newBuilder().setProperty(property).setSubPropertyEventFilter(subPropertyEventFilter).build().toString();
    }

    public static SubpropertyEventFilterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_SUB_PROPERTY_EVENT_FILTER.validatedMatch(formattedString, "SubpropertyEventFilterName.parse: formattedString not in valid format");
        return SubpropertyEventFilterName.of((String)matchMap.get("property"), (String)matchMap.get("sub_property_event_filter"));
    }

    public static List<SubpropertyEventFilterName> parseList(List<String> formattedStrings) {
        ArrayList<SubpropertyEventFilterName> list = new ArrayList<SubpropertyEventFilterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SubpropertyEventFilterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SubpropertyEventFilterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SubpropertyEventFilterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_SUB_PROPERTY_EVENT_FILTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SubpropertyEventFilterName subpropertyEventFilterName = this;
            synchronized (subpropertyEventFilterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.subPropertyEventFilter != null) {
                        fieldMapBuilder.put((Object)"sub_property_event_filter", (Object)this.subPropertyEventFilter);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_SUB_PROPERTY_EVENT_FILTER.instantiate(new String[]{"property", this.property, "sub_property_event_filter", this.subPropertyEventFilter});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SubpropertyEventFilterName that = (SubpropertyEventFilterName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.subPropertyEventFilter, that.subPropertyEventFilter);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.subPropertyEventFilter);
    }

    public static class Builder {
        private String property;
        private String subPropertyEventFilter;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getSubPropertyEventFilter() {
            return this.subPropertyEventFilter;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setSubPropertyEventFilter(String subPropertyEventFilter) {
            this.subPropertyEventFilter = subPropertyEventFilter;
            return this;
        }

        private Builder(SubpropertyEventFilterName subpropertyEventFilterName) {
            this.property = subpropertyEventFilterName.property;
            this.subPropertyEventFilter = subpropertyEventFilterName.subPropertyEventFilter;
        }

        public SubpropertyEventFilterName build() {
            return new SubpropertyEventFilterName(this);
        }
    }
}

