/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChannelGroupName
implements ResourceName {
    private static final PathTemplate PROPERTY_CHANNEL_GROUP = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/channelGroups/{channel_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String channelGroup;

    @Deprecated
    protected ChannelGroupName() {
        this.property = null;
        this.channelGroup = null;
    }

    private ChannelGroupName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.channelGroup = (String)Preconditions.checkNotNull((Object)builder.getChannelGroup());
    }

    public String getProperty() {
        return this.property;
    }

    public String getChannelGroup() {
        return this.channelGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChannelGroupName of(String property, String channelGroup) {
        return ChannelGroupName.newBuilder().setProperty(property).setChannelGroup(channelGroup).build();
    }

    public static String format(String property, String channelGroup) {
        return ChannelGroupName.newBuilder().setProperty(property).setChannelGroup(channelGroup).build().toString();
    }

    public static ChannelGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_CHANNEL_GROUP.validatedMatch(formattedString, "ChannelGroupName.parse: formattedString not in valid format");
        return ChannelGroupName.of((String)matchMap.get("property"), (String)matchMap.get("channel_group"));
    }

    public static List<ChannelGroupName> parseList(List<String> formattedStrings) {
        ArrayList<ChannelGroupName> list = new ArrayList<ChannelGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChannelGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChannelGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChannelGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_CHANNEL_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChannelGroupName channelGroupName = this;
            synchronized (channelGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.channelGroup != null) {
                        fieldMapBuilder.put((Object)"channel_group", (Object)this.channelGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_CHANNEL_GROUP.instantiate(new String[]{"property", this.property, "channel_group", this.channelGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ChannelGroupName that = (ChannelGroupName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.channelGroup, that.channelGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.channelGroup);
    }

    public static class Builder {
        private String property;
        private String channelGroup;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getChannelGroup() {
            return this.channelGroup;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setChannelGroup(String channelGroup) {
            this.channelGroup = channelGroup;
            return this;
        }

        private Builder(ChannelGroupName channelGroupName) {
            this.property = channelGroupName.property;
            this.channelGroup = channelGroupName.channelGroup;
        }

        public ChannelGroupName build() {
            return new ChannelGroupName(this);
        }
    }
}

