/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdSenseLinkName
implements ResourceName {
    private static final PathTemplate PROPERTY_ADSENSE_LINK = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/adSenseLinks/{adsense_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String adsenseLink;

    @Deprecated
    protected AdSenseLinkName() {
        this.property = null;
        this.adsenseLink = null;
    }

    private AdSenseLinkName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.adsenseLink = (String)Preconditions.checkNotNull((Object)builder.getAdsenseLink());
    }

    public String getProperty() {
        return this.property;
    }

    public String getAdsenseLink() {
        return this.adsenseLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdSenseLinkName of(String property, String adsenseLink) {
        return AdSenseLinkName.newBuilder().setProperty(property).setAdsenseLink(adsenseLink).build();
    }

    public static String format(String property, String adsenseLink) {
        return AdSenseLinkName.newBuilder().setProperty(property).setAdsenseLink(adsenseLink).build().toString();
    }

    public static AdSenseLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_ADSENSE_LINK.validatedMatch(formattedString, "AdSenseLinkName.parse: formattedString not in valid format");
        return AdSenseLinkName.of((String)matchMap.get("property"), (String)matchMap.get("adsense_link"));
    }

    public static List<AdSenseLinkName> parseList(List<String> formattedStrings) {
        ArrayList<AdSenseLinkName> list = new ArrayList<AdSenseLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdSenseLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdSenseLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdSenseLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_ADSENSE_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdSenseLinkName adSenseLinkName = this;
            synchronized (adSenseLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.adsenseLink != null) {
                        fieldMapBuilder.put((Object)"adsense_link", (Object)this.adsenseLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_ADSENSE_LINK.instantiate(new String[]{"property", this.property, "adsense_link", this.adsenseLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdSenseLinkName that = (AdSenseLinkName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.adsenseLink, that.adsenseLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adsenseLink);
    }

    public static class Builder {
        private String property;
        private String adsenseLink;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getAdsenseLink() {
            return this.adsenseLink;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setAdsenseLink(String adsenseLink) {
            this.adsenseLink = adsenseLink;
            return this;
        }

        private Builder(AdSenseLinkName adSenseLinkName) {
            this.property = adSenseLinkName.property;
            this.adsenseLink = adSenseLinkName.adsenseLink;
        }

        public AdSenseLinkName build() {
            return new AdSenseLinkName(this);
        }
    }
}

