/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BigQueryLinkName
implements ResourceName {
    private static final PathTemplate PROPERTY_BIGQUERY_LINK = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/bigQueryLinks/{bigquery_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String bigqueryLink;

    @Deprecated
    protected BigQueryLinkName() {
        this.property = null;
        this.bigqueryLink = null;
    }

    private BigQueryLinkName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.bigqueryLink = (String)Preconditions.checkNotNull((Object)builder.getBigqueryLink());
    }

    public String getProperty() {
        return this.property;
    }

    public String getBigqueryLink() {
        return this.bigqueryLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BigQueryLinkName of(String property, String bigqueryLink) {
        return BigQueryLinkName.newBuilder().setProperty(property).setBigqueryLink(bigqueryLink).build();
    }

    public static String format(String property, String bigqueryLink) {
        return BigQueryLinkName.newBuilder().setProperty(property).setBigqueryLink(bigqueryLink).build().toString();
    }

    public static BigQueryLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_BIGQUERY_LINK.validatedMatch(formattedString, "BigQueryLinkName.parse: formattedString not in valid format");
        return BigQueryLinkName.of((String)matchMap.get("property"), (String)matchMap.get("bigquery_link"));
    }

    public static List<BigQueryLinkName> parseList(List<String> formattedStrings) {
        ArrayList<BigQueryLinkName> list = new ArrayList<BigQueryLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BigQueryLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BigQueryLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BigQueryLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_BIGQUERY_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BigQueryLinkName bigQueryLinkName = this;
            synchronized (bigQueryLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.bigqueryLink != null) {
                        fieldMapBuilder.put((Object)"bigquery_link", (Object)this.bigqueryLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_BIGQUERY_LINK.instantiate(new String[]{"property", this.property, "bigquery_link", this.bigqueryLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BigQueryLinkName that = (BigQueryLinkName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.bigqueryLink, that.bigqueryLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.bigqueryLink);
    }

    public static class Builder {
        private String property;
        private String bigqueryLink;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getBigqueryLink() {
            return this.bigqueryLink;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setBigqueryLink(String bigqueryLink) {
            this.bigqueryLink = bigqueryLink;
            return this;
        }

        private Builder(BigQueryLinkName bigQueryLinkName) {
            this.property = bigQueryLinkName.property;
            this.bigqueryLink = bigQueryLinkName.bigqueryLink;
        }

        public BigQueryLinkName build() {
            return new BigQueryLinkName(this);
        }
    }
}

