/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataSharingSettingsName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/dataSharingSettings");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;

    public String getAccount() {
        return this.account;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DataSharingSettingsName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
    }

    public static DataSharingSettingsName of(String account) {
        return DataSharingSettingsName.newBuilder().setAccount(account).build();
    }

    public static String format(String account) {
        return DataSharingSettingsName.newBuilder().setAccount(account).build().toString();
    }

    public static DataSharingSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DataSharingSettingsName.parse: formattedString not in valid format");
        return DataSharingSettingsName.of((String)matchMap.get("account"));
    }

    public static List<DataSharingSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<DataSharingSettingsName> list = new ArrayList<DataSharingSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataSharingSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataSharingSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataSharingSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataSharingSettingsName dataSharingSettingsName = this;
            synchronized (dataSharingSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"account", (Object)this.account);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"account", this.account});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataSharingSettingsName) {
            DataSharingSettingsName that = (DataSharingSettingsName)o;
            return this.account.equals(that.account);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.account.hashCode();
    }

    public static class Builder {
        private String account;

        public String getAccount() {
            return this.account;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        private Builder() {
        }

        private Builder(DataSharingSettingsName dataSharingSettingsName) {
            this.account = dataSharingSettingsName.account;
        }

        public DataSharingSettingsName build() {
            return new DataSharingSettingsName(this);
        }
    }
}

