/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccountSummaryName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"accountSummaries/{account_summary}");
    private volatile Map<String, String> fieldValuesMap;
    private final String accountSummary;

    public String getAccountSummary() {
        return this.accountSummary;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AccountSummaryName(Builder builder) {
        this.accountSummary = (String)Preconditions.checkNotNull((Object)builder.getAccountSummary());
    }

    public static AccountSummaryName of(String accountSummary) {
        return AccountSummaryName.newBuilder().setAccountSummary(accountSummary).build();
    }

    public static String format(String accountSummary) {
        return AccountSummaryName.newBuilder().setAccountSummary(accountSummary).build().toString();
    }

    public static AccountSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AccountSummaryName.parse: formattedString not in valid format");
        return AccountSummaryName.of((String)matchMap.get("account_summary"));
    }

    public static List<AccountSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<AccountSummaryName> list = new ArrayList<AccountSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountSummaryName accountSummaryName = this;
            synchronized (accountSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"accountSummary", (Object)this.accountSummary);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"account_summary", this.accountSummary});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccountSummaryName) {
            AccountSummaryName that = (AccountSummaryName)o;
            return this.accountSummary.equals(that.accountSummary);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.accountSummary.hashCode();
    }

    public static class Builder {
        private String accountSummary;

        public String getAccountSummary() {
            return this.accountSummary;
        }

        public Builder setAccountSummary(String accountSummary) {
            this.accountSummary = accountSummary;
            return this;
        }

        private Builder() {
        }

        private Builder(AccountSummaryName accountSummaryName) {
            this.accountSummary = accountSummaryName.accountSummary;
        }

        public AccountSummaryName build() {
            return new AccountSummaryName(this);
        }
    }
}

