/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.TraceManager;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;

@BetaApi
@InternalApi
public class OpenTelemetryTraceManager
implements TraceManager {
    private final Tracer tracer;

    public OpenTelemetryTraceManager(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("gax-java");
    }

    @Override
    public TraceManager.Span createSpan(String name, Map<String, String> attributes) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(name);
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        if (attributes != null) {
            attributes.forEach((k, v) -> spanBuilder.setAttribute(k, v));
        }
        Span span = spanBuilder.startSpan();
        return new OtelSpan(span);
    }

    private static class OtelSpan
    implements TraceManager.Span {
        private final Span span;

        private OtelSpan(Span span) {
            this.span = span;
        }

        @Override
        public void end() {
            this.span.end();
        }
    }
}

