package com.google.api.gax.batching;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FlowControlSettings extends FlowControlSettings {

  @Nullable
  private final Long maxOutstandingElementCount;

  @Nullable
  private final Long maxOutstandingRequestBytes;

  private final FlowController.LimitExceededBehavior limitExceededBehavior;

  private AutoValue_FlowControlSettings(
      @Nullable Long maxOutstandingElementCount,
      @Nullable Long maxOutstandingRequestBytes,
      FlowController.LimitExceededBehavior limitExceededBehavior) {
    this.maxOutstandingElementCount = maxOutstandingElementCount;
    this.maxOutstandingRequestBytes = maxOutstandingRequestBytes;
    this.limitExceededBehavior = limitExceededBehavior;
  }

  @Nullable
  @Override
  public Long getMaxOutstandingElementCount() {
    return maxOutstandingElementCount;
  }

  @Nullable
  @Override
  public Long getMaxOutstandingRequestBytes() {
    return maxOutstandingRequestBytes;
  }

  @Override
  public FlowController.LimitExceededBehavior getLimitExceededBehavior() {
    return limitExceededBehavior;
  }

  @Override
  public String toString() {
    return "FlowControlSettings{"
        + "maxOutstandingElementCount=" + maxOutstandingElementCount + ", "
        + "maxOutstandingRequestBytes=" + maxOutstandingRequestBytes + ", "
        + "limitExceededBehavior=" + limitExceededBehavior
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FlowControlSettings) {
      FlowControlSettings that = (FlowControlSettings) o;
      return (this.maxOutstandingElementCount == null ? that.getMaxOutstandingElementCount() == null : this.maxOutstandingElementCount.equals(that.getMaxOutstandingElementCount()))
          && (this.maxOutstandingRequestBytes == null ? that.getMaxOutstandingRequestBytes() == null : this.maxOutstandingRequestBytes.equals(that.getMaxOutstandingRequestBytes()))
          && this.limitExceededBehavior.equals(that.getLimitExceededBehavior());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (maxOutstandingElementCount == null) ? 0 : maxOutstandingElementCount.hashCode();
    h$ *= 1000003;
    h$ ^= (maxOutstandingRequestBytes == null) ? 0 : maxOutstandingRequestBytes.hashCode();
    h$ *= 1000003;
    h$ ^= limitExceededBehavior.hashCode();
    return h$;
  }

  @Override
  public FlowControlSettings.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends FlowControlSettings.Builder {
    private Long maxOutstandingElementCount;
    private Long maxOutstandingRequestBytes;
    private FlowController.LimitExceededBehavior limitExceededBehavior;
    Builder() {
    }
    private Builder(FlowControlSettings source) {
      this.maxOutstandingElementCount = source.getMaxOutstandingElementCount();
      this.maxOutstandingRequestBytes = source.getMaxOutstandingRequestBytes();
      this.limitExceededBehavior = source.getLimitExceededBehavior();
    }
    @Override
    public FlowControlSettings.Builder setMaxOutstandingElementCount(Long maxOutstandingElementCount) {
      this.maxOutstandingElementCount = maxOutstandingElementCount;
      return this;
    }
    @Override
    public FlowControlSettings.Builder setMaxOutstandingRequestBytes(Long maxOutstandingRequestBytes) {
      this.maxOutstandingRequestBytes = maxOutstandingRequestBytes;
      return this;
    }
    @Override
    public FlowControlSettings.Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) {
      if (limitExceededBehavior == null) {
        throw new NullPointerException("Null limitExceededBehavior");
      }
      this.limitExceededBehavior = limitExceededBehavior;
      return this;
    }
    @Override
    FlowControlSettings autoBuild() {
      if (this.limitExceededBehavior == null) {
        String missing = " limitExceededBehavior";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FlowControlSettings(
          this.maxOutstandingElementCount,
          this.maxOutstandingRequestBytes,
          this.limitExceededBehavior);
    }
  }

}
