/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@BetaApi
public final class OperationCallSettings<RequestT, ResponseT, MetadataT, OperationT> {
    private final SimpleCallSettings<RequestT, OperationT> initialCallSettings;
    private final TimedRetryAlgorithm pollingAlgorithm;
    private final Class<ResponseT> responseClass;
    private final Class<MetadataT> metadataClass;

    public final SimpleCallSettings<RequestT, OperationT> getInitialCallSettings() {
        return this.initialCallSettings;
    }

    public final TimedRetryAlgorithm getPollingAlgorithm() {
        return this.pollingAlgorithm;
    }

    public Class<ResponseT> getResponseClass() {
        return this.responseClass;
    }

    @Nullable
    public Class<MetadataT> getMetadataClass() {
        return this.metadataClass;
    }

    private OperationCallSettings(SimpleCallSettings<RequestT, OperationT> initialCallSettings, TimedRetryAlgorithm pollingAlgorithm, Class<ResponseT> responseClass, Class<MetadataT> metadataClass) {
        this.initialCallSettings = (SimpleCallSettings)Preconditions.checkNotNull(initialCallSettings);
        this.pollingAlgorithm = (TimedRetryAlgorithm)Preconditions.checkNotNull((Object)pollingAlgorithm);
        this.responseClass = (Class)Preconditions.checkNotNull(responseClass);
        this.metadataClass = metadataClass;
    }

    public static <RequestT, ResponseT, MetadataT, OperationT> Builder<RequestT, ResponseT, MetadataT, OperationT> newBuilder() {
        return new Builder();
    }

    public final Builder<RequestT, ResponseT, MetadataT, OperationT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT, MetadataT, OperationT> {
        private SimpleCallSettings<RequestT, OperationT> initialCallSettings;
        private TimedRetryAlgorithm pollingAlgorithm;
        private Class<ResponseT> responseClass;
        private Class<MetadataT> metadataClass;

        public Builder() {
        }

        public Builder(OperationCallSettings<RequestT, ResponseT, MetadataT, OperationT> settings) {
            this.initialCallSettings = ((SimpleCallSettings.Builder)((OperationCallSettings)settings).initialCallSettings.toBuilder()).build();
            this.pollingAlgorithm = ((OperationCallSettings)settings).pollingAlgorithm;
            this.responseClass = ((OperationCallSettings)settings).responseClass;
            this.metadataClass = ((OperationCallSettings)settings).metadataClass;
        }

        public Builder<RequestT, ResponseT, MetadataT, OperationT> setPollingAlgorithm(TimedRetryAlgorithm pollingAlgorithm) {
            this.pollingAlgorithm = pollingAlgorithm;
            return this;
        }

        public TimedRetryAlgorithm getPollingAlgorithm() {
            return this.pollingAlgorithm;
        }

        public Builder<RequestT, ResponseT, MetadataT, OperationT> setInitialCallSettings(SimpleCallSettings<RequestT, OperationT> initialCallSettings) {
            this.initialCallSettings = initialCallSettings;
            return this;
        }

        public SimpleCallSettings<RequestT, OperationT> getInitialCallSettings() {
            return this.initialCallSettings;
        }

        public Class<ResponseT> getResponseClass() {
            return this.responseClass;
        }

        public Builder<RequestT, ResponseT, MetadataT, OperationT> setResponseClass(Class<ResponseT> responseClass) {
            this.responseClass = responseClass;
            return this;
        }

        public Class<MetadataT> getMetadataClass() {
            return this.metadataClass;
        }

        public Builder<RequestT, ResponseT, MetadataT, OperationT> setMetadataClass(Class<MetadataT> metadataClass) {
            this.metadataClass = metadataClass;
            return this;
        }

        public OperationCallSettings<RequestT, ResponseT, MetadataT, OperationT> build() {
            return new OperationCallSettings(this.initialCallSettings, this.pollingAlgorithm, this.responseClass, this.metadataClass);
        }
    }
}

