/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.Transport;
import com.google.api.gax.rpc.TransportProvider;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class FixedContextTransportProvider
implements TransportProvider {
    private final Transport transport;

    private FixedContextTransportProvider(Transport transport) {
        this.transport = (Transport)Preconditions.checkNotNull((Object)transport);
    }

    @Override
    public boolean needsExecutor() {
        return false;
    }

    @Override
    public Transport getTransport() throws IOException {
        return this.transport;
    }

    @Override
    public Transport getTransport(ScheduledExecutorService executor) throws IOException {
        throw new UnsupportedOperationException("FixedContextTransportProvider doesn't need an executor");
    }

    @Override
    public String getTransportName() {
        return this.transport.getTransportName();
    }

    public static FixedContextTransportProvider create(Transport transport) {
        return new FixedContextTransportProvider(transport);
    }
}

