/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedContextTransportProvider;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;

@BetaApi
public abstract class ClientSettings {
    private final ExecutorProvider executorProvider;
    private final CredentialsProvider credentialsProvider;
    private final TransportProvider transportProvider;
    private final ApiClock clock;

    protected ClientSettings(ExecutorProvider executorProvider, TransportProvider transportProvider, CredentialsProvider credentialsProvider, ApiClock clock) {
        this.executorProvider = executorProvider;
        this.transportProvider = transportProvider;
        this.credentialsProvider = credentialsProvider;
        this.clock = clock;
    }

    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public final TransportProvider getTransportProvider() {
        return this.transportProvider;
    }

    public final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public final ApiClock getClock() {
        return this.clock;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportProvider", (Object)this.transportProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("clock", (Object)this.clock).toString();
    }

    public static abstract class Builder {
        private ExecutorProvider executorProvider;
        private CredentialsProvider credentialsProvider;
        private TransportProvider transportProvider;
        private ApiClock clock;

        protected Builder(ClientSettings settings) {
            this.executorProvider = settings.executorProvider;
            this.transportProvider = settings.transportProvider;
            this.credentialsProvider = settings.credentialsProvider;
            this.clock = settings.clock;
        }

        protected Builder(ClientContext clientContext) {
            if (clientContext == null) {
                this.executorProvider = InstantiatingExecutorProvider.newBuilder().build();
                this.transportProvider = null;
                this.credentialsProvider = new NoCredentialsProvider();
                this.clock = NanoClock.getDefaultClock();
            } else {
                this.executorProvider = FixedExecutorProvider.create(clientContext.getExecutor());
                this.transportProvider = FixedContextTransportProvider.create(clientContext.getTransportContext());
                this.credentialsProvider = FixedCredentialsProvider.create(clientContext.getCredentials());
                this.clock = clientContext.getClock();
            }
        }

        protected Builder() {
            this((ClientContext)null);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            this.transportProvider = transportProvider;
            return this;
        }

        public Builder setClock(ApiClock clock) {
            this.clock = clock;
            return this;
        }

        public ExecutorProvider getExecutorProvider() {
            return this.executorProvider;
        }

        public TransportProvider getTransportProvider() {
            return this.transportProvider;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public ApiClock getClock() {
            return this.clock;
        }

        protected Builder applyToAllUnaryMethods(Iterable<UnaryCallSettings.Builder> methodSettingsBuilders, ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            for (UnaryCallSettings.Builder settingsBuilder : methodSettingsBuilders) {
                settingsUpdater.apply((Object)settingsBuilder);
            }
            return this;
        }

        public abstract ClientSettings build() throws IOException;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("executorProvider", (Object)this.executorProvider).add("transportProvider", (Object)this.transportProvider).add("credentialsProvider", (Object)this.credentialsProvider).add("clock", (Object)this.clock).toString();
        }
    }
}

