/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiCallContextEnhancer;
import com.google.common.base.Preconditions;
import java.util.List;

@BetaApi
public class ApiCallContextEnhancers {
    private ApiCallContextEnhancers() {
    }

    public static ApiCallContext applyEnhancers(ApiCallContext defaultCallContext, ApiCallContext thisCallContext, List<ApiCallContextEnhancer> callContextEnhancers) {
        Preconditions.checkNotNull((Object)defaultCallContext);
        ApiCallContext returnContext = thisCallContext;
        if (returnContext == null) {
            returnContext = defaultCallContext;
        }
        for (ApiCallContextEnhancer enhancer : callContextEnhancers) {
            returnContext = enhancer.enhance(returnContext);
        }
        return returnContext;
    }
}

