/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingAttemptCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.testing.FakeApiException;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.MockStreamingApi;
import com.google.common.collect.Queues;
import com.google.common.truth.Truth;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class ServerStreamingAttemptCallableTest {
    private MockStreamingApi.MockServerStreamingCallable<String, String> innerCallable;
    private AccumulatingObserver observer;
    private FakeRetryingFuture fakeRetryingFuture;
    private StreamResumptionStrategy<String, String> resumptionStrategy;

    @Before
    public void setUp() {
        this.innerCallable = new MockStreamingApi.MockServerStreamingCallable();
        this.observer = new AccumulatingObserver(true);
        this.resumptionStrategy = new MyStreamResumptionStrategy();
    }

    private ServerStreamingAttemptCallable<String, String> createCallable() {
        ServerStreamingAttemptCallable callable = new ServerStreamingAttemptCallable(this.innerCallable, this.resumptionStrategy, (Object)"request", (ApiCallContext)FakeCallContext.createDefault(), (ResponseObserver)this.observer);
        this.fakeRetryingFuture = new FakeRetryingFuture((ServerStreamingAttemptCallable<String, String>)callable);
        callable.setExternalFuture((RetryingFuture)this.fakeRetryingFuture);
        return callable;
    }

    @Test
    public void testNoErrorsAutoFlow() {
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        Truth.assertThat((Object)this.observer.controller).isNotNull();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isTrue();
        Truth.assertThat((String)call.getRequest()).isEqualTo((Object)"request");
        call.getController().getObserver().onResponse((Object)"response1");
        call.getController().getObserver().onResponse((Object)"response2");
        call.getController().getObserver().onComplete();
        Truth.assertThat(this.observer.responses).containsExactly(new Object[]{"response1", "response2"}).inOrder();
        this.fakeRetryingFuture.assertSuccess();
    }

    @Test
    public void testNoErrorsManualFlow() {
        this.observer = new AccumulatingObserver(false);
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        Truth.assertThat((Object)this.observer.controller).isNotNull();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        Truth.assertThat((String)call.getRequest()).isEqualTo((Object)"request");
        this.observer.controller.request(1);
        Truth.assertThat((Integer)call.getController().popLastPull()).isEqualTo((Object)1);
        call.getController().getObserver().onResponse((Object)"response1");
        this.observer.controller.request(1);
        Truth.assertThat((Integer)call.getController().popLastPull()).isEqualTo((Object)1);
        call.getController().getObserver().onResponse((Object)"response2");
        call.getController().getObserver().onComplete();
        Truth.assertThat(this.observer.responses).containsExactly(new Object[]{"response1", "response2"}).inOrder();
        this.fakeRetryingFuture.assertSuccess();
    }

    @Test
    public void testInitialRetry() {
        this.resumptionStrategy = new MyStreamResumptionStrategy();
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        FakeApiException initialError = new FakeApiException(null, StatusCode.Code.UNAVAILABLE, true);
        call.getController().getObserver().onError((Throwable)((Object)initialError));
        Throwable outerError = null;
        try {
            this.fakeRetryingFuture.getAttemptResult().get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            outerError = e.getCause();
        }
        catch (Throwable e) {
            outerError = e;
        }
        Truth.assertThat((Throwable)outerError).isInstanceOf(ServerStreamingAttemptException.class);
        Truth.assertThat((Boolean)((ServerStreamingAttemptException)outerError).hasSeenResponses()).isFalse();
        Truth.assertThat((Boolean)((ServerStreamingAttemptException)outerError).canResume()).isTrue();
        Truth.assertThat((Throwable)outerError.getCause()).isEqualTo((Object)initialError);
        callable.call();
        call = this.innerCallable.popLastCall();
        Truth.assertThat((String)call.getRequest()).isEqualTo((Object)"request > 0");
    }

    @Test
    public void testMidRetry() {
        this.resumptionStrategy = new MyStreamResumptionStrategy();
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        Truth.assertThat((String)call.getRequest()).isEqualTo((Object)"request");
        call.getController().getObserver().onResponse((Object)"response1");
        call.getController().getObserver().onResponse((Object)"response2");
        FakeApiException innerError = new FakeApiException(null, StatusCode.Code.UNAVAILABLE, true);
        call.getController().getObserver().onError((Throwable)((Object)innerError));
        Throwable outerError = null;
        try {
            this.fakeRetryingFuture.getAttemptResult().get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            outerError = e.getCause();
        }
        catch (Throwable e) {
            outerError = e;
        }
        Truth.assertThat((Throwable)outerError).isInstanceOf(ServerStreamingAttemptException.class);
        Truth.assertThat((Boolean)((ServerStreamingAttemptException)outerError).hasSeenResponses()).isTrue();
        Truth.assertThat((Boolean)((ServerStreamingAttemptException)outerError).canResume()).isTrue();
        Truth.assertThat((Throwable)outerError.getCause()).isEqualTo((Object)innerError);
        callable.call();
        call = this.innerCallable.popLastCall();
        Truth.assertThat((String)call.getRequest()).isEqualTo((Object)"request > 2");
        call.getController().getObserver().onResponse((Object)"response3");
        Truth.assertThat(this.observer.responses).containsExactly(new Object[]{"response1", "response2", "response3"}).inOrder();
    }

    @Test
    public void testRequestCountIsPreserved() {
        this.observer = new AccumulatingObserver(false);
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        this.observer.controller.request(5);
        Truth.assertThat((Object)this.observer.controller).isNotNull();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        Truth.assertThat(call).isNotNull();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        Truth.assertThat((Integer)call.getController().popLastPull()).isEqualTo((Object)5);
        call.getController().getObserver().onResponse((Object)"response");
        call.getController().getObserver().onError((Throwable)((Object)new FakeApiException(null, StatusCode.Code.UNAUTHENTICATED, true)));
        callable.call();
        call = this.innerCallable.popLastCall();
        Truth.assertThat((Integer)call.getController().popLastPull()).isEqualTo((Object)4);
    }

    @Test
    public void testCancel() {
        this.observer = new AccumulatingObserver(false);
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        this.observer.controller.request(1);
        Truth.assertThat((Object)this.observer.controller).isNotNull();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        Truth.assertThat(call).isNotNull();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        this.observer.controller.cancel();
        Truth.assertThat((Boolean)call.getController().isCancelled()).isTrue();
        RuntimeException innerException = new RuntimeException("Some internal representation of cancel");
        call.getController().getObserver().onError((Throwable)innerException);
        Throwable outerError = null;
        try {
            this.fakeRetryingFuture.getAttemptResult().get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            outerError = e.getCause();
        }
        catch (Throwable e) {
            outerError = e;
        }
        Truth.assertThat((Throwable)outerError).isInstanceOf(ServerStreamingAttemptException.class);
        Truth.assertThat((Throwable)outerError.getCause()).isInstanceOf(CancellationException.class);
        boolean includesMeInStackTrace = false;
        for (StackTraceElement e : outerError.getCause().getStackTrace()) {
            if (!ServerStreamingAttemptCallableTest.class.getName().equals(e.getClassName())) continue;
            includesMeInStackTrace = true;
            break;
        }
        Truth.assertWithMessage((String)"Cancel caller included in stack trace").that(Boolean.valueOf(includesMeInStackTrace)).isTrue();
    }

    @Test
    public void testResponseSubstitution() {
        this.resumptionStrategy = new MyStreamResumptionStrategy(){

            @Override
            public String processResponse(String response) {
                return super.processResponse(response) + "+suffix";
            }
        };
        this.observer = new AccumulatingObserver(false);
        ServerStreamingAttemptCallable<String, String> callable = this.createCallable();
        callable.start();
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.innerCallable.popLastCall();
        call.getController().getObserver().onResponse((Object)"first");
        call.getController().getObserver().onError((Throwable)((Object)new FakeApiException(null, StatusCode.Code.UNAVAILABLE, true)));
        callable.call();
        call = this.innerCallable.popLastCall();
        call.getController().getObserver().onResponse((Object)"second");
        call.getController().getObserver().onResponse((Object)"third");
        call.getController().getObserver().onComplete();
        Truth.assertThat(this.observer.responses).containsExactly(new Object[]{"first+suffix", "second+suffix", "third+suffix"});
    }

    private static class FakeRetryingFuture
    extends AbstractApiFuture<Void>
    implements RetryingFuture<Void> {
        private final ServerStreamingAttemptCallable<String, String> attemptCallable;
        private ApiFuture<Void> attemptFuture;
        private TimedAttemptSettings attemptSettings;

        FakeRetryingFuture(ServerStreamingAttemptCallable<String, String> attemptCallable) {
            this.attemptCallable = attemptCallable;
            this.attemptSettings = TimedAttemptSettings.newBuilder().setGlobalSettings(RetrySettings.newBuilder().setTotalTimeout(Duration.ofHours((long)1L)).build()).setFirstAttemptStartTimeNanos(0L).setAttemptCount(0).setOverallAttemptCount(0).setRandomizedRetryDelay(Duration.ofMillis((long)1L)).setRetryDelay(Duration.ofMillis((long)1L)).setRpcTimeout(Duration.ofMinutes((long)1L)).build();
        }

        public void setAttemptFuture(ApiFuture<Void> attemptFuture) {
            this.attemptFuture = attemptFuture;
        }

        public ServerStreamingAttemptCallable<String, String> getCallable() {
            return this.attemptCallable;
        }

        public TimedAttemptSettings getAttemptSettings() {
            return this.attemptSettings;
        }

        public ApiFuture<Void> peekAttemptResult() {
            throw new UnsupportedOperationException();
        }

        public ApiFuture<Void> getAttemptResult() {
            return this.attemptFuture;
        }

        void assertSuccess() {
            Throwable actualError = null;
            try {
                this.attemptFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                actualError = t;
            }
            Truth.assertThat((Throwable)actualError).isNull();
        }
    }

    static class AccumulatingObserver
    implements ResponseObserver<String> {
        final boolean autoFlow;
        StreamController controller;
        final BlockingDeque<String> responses = Queues.newLinkedBlockingDeque();
        private Throwable error;
        private boolean complete;

        AccumulatingObserver(boolean autoFlow) {
            this.autoFlow = autoFlow;
        }

        public void onStart(StreamController controller) {
            this.controller = controller;
            if (!this.autoFlow) {
                controller.disableAutoInboundFlowControl();
            }
        }

        public void onResponse(String response) {
            this.responses.add(response);
        }

        public void onError(Throwable t) {
            this.error = t;
        }

        public void onComplete() {
            this.complete = true;
        }
    }

    static class MyStreamResumptionStrategy
    implements StreamResumptionStrategy<String, String> {
        private int responseCount;

        MyStreamResumptionStrategy() {
        }

        public StreamResumptionStrategy<String, String> createNew() {
            return new MyStreamResumptionStrategy();
        }

        public String processResponse(String response) {
            ++this.responseCount;
            return response;
        }

        public String getResumeRequest(String originalRequest) {
            return originalRequest + " > " + this.responseCount;
        }

        public boolean canResume() {
            return true;
        }
    }
}

